/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.debug.Tester;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Library {
    private Class[] staticLib;
    private Class[] dynamicLib;
    private Hashtable names;
    private Hashtable dynIDs;
    private Hashtable stateless;

    public Library(Class[] classArray, Class[] classArray2) {
        this.staticLib = classArray;
        this.dynamicLib = classArray2;
        this.rehash();
    }

    private void rehash() {
        Object object;
        int n;
        this.names = new Hashtable();
        this.dynIDs = new Hashtable();
        this.stateless = new Hashtable();
        if (this.staticLib != null) {
            n = 0;
            while (n < this.staticLib.length) {
                object = this.staticLib[n].getMethods();
                int n2 = 0;
                while (n2 < ((Method[])object).length) {
                    if (Modifier.isStatic(object[n2].getModifiers()) && this.rehash(object[n2])) {
                        this.stateless.put(object[n2], Boolean.TRUE);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        if (this.dynamicLib != null) {
            n = 0;
            while (n < this.dynamicLib.length) {
                object = new Integer(n);
                Method[] methodArray = this.dynamicLib[n].getMethods();
                int n3 = 0;
                while (n3 < methodArray.length) {
                    if (!Modifier.isStatic(methodArray[n3].getModifiers()) && this.rehash(methodArray[n3])) {
                        this.dynIDs.put(methodArray[n3], object);
                    }
                    ++n3;
                }
                ++n;
            }
        }
    }

    private boolean rehash(Method method) {
        String string = method.getName();
        String string2 = ExpressionImage.getSignature(method);
        Hashtable hashtable = (Hashtable)this.names.get(string);
        if (hashtable == null) {
            Hashtable<String, Method> hashtable2 = new Hashtable<String, Method>();
            hashtable2.put(string2, method);
            this.names.put(string, hashtable2);
            return true;
        }
        Method method2 = (Method)hashtable.get(string2);
        if (method2 == null) {
            hashtable.put(string2, method);
            return true;
        }
        return false;
    }

    public void markStateDependent(String string, Class[] classArray) throws NoSuchMethodException {
        Method method = this.getMethod(string, classArray);
        Object v = this.stateless.remove(method);
    }

    public boolean isStateless(Method method) {
        return this.stateless.containsKey(method);
    }

    Method getMethod(String string, Class[] classArray) throws NoSuchMethodException {
        Object object;
        Object object2;
        Hashtable hashtable = (Hashtable)this.names.get(string);
        if (hashtable == null) {
            throw new NoSuchMethodException("There is no function \"" + string + "\" defined.");
        }
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Method)enumeration.nextElement();
            object = ((Method)object2).getParameterTypes();
            boolean bl = false;
            if (classArray != null) {
                if (((Class<?>[])object).length == classArray.length) {
                    bl = true;
                    int n = 0;
                    while (n < ((Object)object).length && bl) {
                        bl = ExpressionImage.canConvertByWidening(classArray[n], (Class)object[n]);
                        ++n;
                    }
                }
            } else {
                boolean bl2 = bl = ((Class<?>[])object).length == 0;
            }
            if (!bl) continue;
            vector.addElement(object2);
        }
        if (vector.size() == 0) {
            throw new NoSuchMethodException("Function \"" + string + "\" exists," + " but parameters " + this.describe(string, classArray) + " can not be accepted by it.");
        }
        if (vector.size() == 1) {
            return (Method)vector.firstElement();
        }
        object2 = vector.elements();
        object = (Method)object2.nextElement();
        Class[] classArray2 = ((Method)object).getParameterTypes();
        while (object2.hasMoreElements()) {
            Method method = (Method)object2.nextElement();
            Class[] classArray3 = method.getParameterTypes();
            boolean bl = true;
            boolean bl3 = true;
            int n = 0;
            while (n < classArray3.length) {
                bl = bl && ExpressionImage.canConvertByWidening(classArray3[n], classArray2[n]);
                bl3 = bl3 && ExpressionImage.canConvertByWidening(classArray2[n], classArray3[n]);
                ++n;
            }
            if (bl && !bl3) {
                object = method;
                classArray2 = classArray3;
            }
            if (bl ^ bl3) continue;
            throw new NoSuchMethodException("Ambiguity detected between \"" + this.describe(string, classArray2) + "\" and \"" + this.describe(string, classArray3) + "\" on invocation \"" + this.describe(string, classArray) + "\" .");
        }
        return object;
    }

    private String describe(String string, Class[] classArray) {
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('(');
        if (classArray != null) {
            int n = 0;
            while (n < classArray.length) {
                if (n != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(classArray[n].toString());
                ++n;
            }
        }
        stringBuffer.append(')');
        string2 = stringBuffer.toString();
        return string2;
    }

    int getDynamicMethodClassID(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return -1;
        }
        Integer n = (Integer)this.dynIDs.get(method);
        return n;
    }

    public static void main(String[] stringArray) {
        Tester tester = new Tester(System.out);
        Library.test(tester);
        tester.summarize();
    }

    public static void test(Tester tester) {
        Class[] classArray;
        Object object;
        Class[] classArray2;
        Library library = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.Math");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        tester.startTest("Creating the library of java.lang.Math");
        try {
            classArray2 = new Class[]{clazz};
            object = new Library(classArray2, null);
            library = object;
            tester.testOK();
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(double)");
        try {
            classArray2 = new Class[]{Double.TYPE};
            object = library.getMethod("round", classArray2);
            if (object != null && ((Method)object).equals(clazz.getMethod("round", classArray2))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(float)");
        try {
            classArray2 = new Class[]{Float.TYPE};
            object = library.getMethod("round", classArray2);
            if (object != null && ((Method)object).equals(clazz.getMethod("round", classArray2))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(int) best is round(float)");
        try {
            classArray2 = new Class[]{Integer.TYPE};
            object = library.getMethod("round", classArray2);
            classArray = new Class[]{Float.TYPE};
            if (object != null && ((Method)object).equals(clazz.getMethod("round", classArray))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(int) best is abs(int)");
        try {
            classArray2 = new Class[]{Integer.TYPE};
            object = library.getMethod("abs", classArray2);
            classArray = new Class[]{Integer.TYPE};
            if (object != null && ((Method)object).equals(clazz.getMethod("abs", classArray))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(byte) best is abs(int)");
        try {
            classArray2 = new Class[]{Byte.TYPE};
            object = library.getMethod("abs", classArray2);
            classArray = new Class[]{Integer.TYPE};
            if (object != null && ((Method)object).equals(clazz.getMethod("abs", classArray))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(char) best is abs(int)");
        try {
            classArray2 = new Class[]{Character.TYPE};
            object = library.getMethod("abs", classArray2);
            classArray = new Class[]{Integer.TYPE};
            if (object != null && ((Method)object).equals(clazz.getMethod("abs", classArray))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation min(char,float) best is min(float,float)");
        try {
            classArray2 = new Class[]{Character.TYPE, Float.TYPE};
            object = library.getMethod("min", classArray2);
            classArray = new Class[]{Float.TYPE, Float.TYPE};
            if (object != null && ((Method)object).equals(clazz.getMethod("min", classArray))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Checking assignment of state dependence ");
        try {
            library.markStateDependent("random", null);
            if (!library.isStateless(library.getMethod("random", null))) {
                tester.testOK();
                return;
            }
            tester.testFail();
            return;
        }
        catch (Throwable throwable) {
            tester.testFail();
            return;
        }
    }
}

