;; Copyright (C) 2006 Free Software Foundation, Inc.
;;
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2 of
;; the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public
;; License along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

(load "tests.scm")
(or (getenv "DISPLAY")
    (begin
      (display "Cannot run gtk tests without an X display\n")
      (exit 77)))

(use-modules (gtk-1.2 dynlink))
(merge-compiled-code "sgtk_init_gtk_gdk_pixbuf_glue" "libguilegdkpixbuf-1.2")


;;
;; gdk-pixbuf-new
;;

(malloced-steady
 (lambda ()
   (let* ((args '(rgb #f 8 1 1))
	  (want #t)
	  (got  (->bool (apply gdk-pixbuf-new args))))
     (test "gdk-pixbuf-new" args want got))))


;;
;; gdk-pixbuf-get-colorspace
;;

(malloced-steady
 (lambda ()
   (let* ((args   '(rgb #f 8 1 1))
	  (pixbuf (apply gdk-pixbuf-new args))
	  (want   'rgb)
	  (got    (gdk-pixbuf-get-colorspace pixbuf)))
     (test "gdk-pixbuf-get-colorspace" args want got))))

;;
;; gdk-pixbuf-get-rowstride
;;

(malloced-steady
 (lambda ()
   (let* ((args   '(rgb #f 8 1 1))
	  (pixbuf (apply gdk-pixbuf-new args))
	  (want   4)
	  (got    (gdk-pixbuf-get-rowstride pixbuf)))
     (test "gdk-pixbuf-get-rowstride" args want got))))

(malloced-steady
 (lambda ()
   (let* ((args   '(rgb #t 8 1 1))
	  (pixbuf (apply gdk-pixbuf-new args))
	  (want   4)
	  (got    (gdk-pixbuf-get-rowstride pixbuf)))
     (test "gdk-pixbuf-get-rowstride" args want got))))



(tests-end)
