#ifndef FILTER_H
#define FILTER_H

#include <config.h>
#include "sample.h"

#define FILTER_QUERY_CHANNELS 1
#define FILTER_QUERY_FORMAT   2

struct filter {
    struct filter *producer;

    struct filter *consumer;

    long long producer_pos;

    enum sample_type format;

    int channels;

    long long (*read)(struct filter *f, void *buf[], int channels, long long *count);

    long long (*write)(struct filter *f, void *buf[], int channels, long long *count);

    long long (*seek)(struct filter *f, long long *count, int whence);
    
    void (*destroy)(struct filter *f);

    int (*query)(struct filter *f, int query, void *ptr);

};

struct filter *
filter_new(struct filter *src,
           size_t sz);

void
filter_destroy(struct filter *f);

long long 
filter_read(struct filter *f, 
            void *buf[], 
            long long *count);

long long 
filter_write(struct filter *f, 
             void *buf[], 
             int channels,
             long long *count);

long long 
filter_seek(struct filter *f, 
            long long *count,
            int whence);

int
filter_query(struct filter *f,
             int query,
             void *ptr);

#endif /* ! FILTER_H */
