/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

// @WARNING@

#include <@NAME@.h>
#include <algorithm>
#include <gr_io_signature.h>


@NAME@::@NAME@ (const std::vector<@TYPE@> &data, bool repeat)
  : gr_sync_block ("@BASE_NAME@",
	       gr_make_io_signature (0, 0, 0),
	       gr_make_io_signature (1, 1, sizeof (@TYPE@))),
    d_data (data),
    d_repeat (repeat),
    d_offset (0)
{
}

int
@NAME@::work (int noutput_items,
		    gr_vector_const_void_star &input_items,
		    gr_vector_void_star &output_items)
{
  if (d_offset >= d_data.size ()){
    if (d_repeat)
      d_offset = 0;
    else
      return -1;			// Done!
  }

  @TYPE@ *optr = (@TYPE@ *) output_items[0];
  unsigned n = std::min ((unsigned) d_data.size () - d_offset, (unsigned) noutput_items);
  for (unsigned i = 0; i < n; i++)
    optr[i] = d_data[d_offset + i];

  d_offset += n;
  return n;
}

@NAME@_sptr
gr_make_@BASE_NAME@ (const std::vector<@TYPE@> &data, bool repeat)
{
  return @NAME@_sptr (new @NAME@ (data, repeat));
}

