/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _GRZOH_H_
#define _GRZOH_H_

#include <VrSigProc.h>
#include <VrComplex.h>
#include <VrInterpolatingSigProc.h>

template<class iType,class oType> 
class GrZOH : public VrInterpolatingSigProc<iType,oType> {
public: 
  virtual const char *name() { return "GrZOH"; }
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);
  GrZOH(int interp_factor):
    VrInterpolatingSigProc<iType,oType>(1,interp_factor){}
};

template<class iType,class oType> int
GrZOH<iType,oType>::work(VrSampleRange output, void *ao[],
			      VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  oType **o = (oType **)ao;
  int size = output.size;
  iType input_symbol;
  
  for (int insamp = 0; insamp < size/interp; insamp++){
    input_symbol = i[0][insamp];
    for (int outsamp = 0; outsamp < interp; outsamp++){
      *o[0]++ = input_symbol;
    }
  }
  return output.size;
}

#endif
