.TH PTHREAD_DETACH 3 LinuxThreads

.SH NAME
pthread_detach \- put a running thread in the detached state

.SH SYNOPSIS
#include <pthread.h>

int pthread_detach(pthread_t th);

.SH DESCRIPTION
!pthread_detach! put the thread |th| in the detached state. This
guarantees that the memory resources consumed by |th| will be freed
immediately when |th| terminates. However, this prevents other threads
from synchronizing on the termination of |th| using !pthread_join!.

A thread can be created initially in the detached state, using the
!detachstate! attribute to !pthread_create!(3). In contrast,
!pthread_detach! applies to threads created in the joinable state, and
which need to be put in the detached state later.

After !pthread_detach! completes, subsequent attempts to perform
!pthread_join! on |th| will fail. If another thread is already joining
the thread |th| at the time !pthread_detach! is called,
!pthread_detach! does nothing and leaves |th| in the joinable state.

.SH "RETURN VALUE"
On success, 0 is returned. On error, a non-zero error code is returned.

.SH ERRORS
.TP
!EINVAL!
the thread |th| is already in the detached state

.SH AUTHOR
Xavier Leroy <Xavier.Leroy@inria.fr>

.SH "SEE ALSO"
!pthread_create!(3),
!pthread_join!(3),
!pthread_attr_setdetachstate!(3).