/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMA_C_IMP_BUILDER
    Description : Builds C implementation Skeleton from
                  a CLASS_METADATA object
    Author      : David Martnez Oliveira
    Date        : 26/02/2000
-----------------------------------------------------
  REVISIONS :
  * 15/11/2001
  * Added support to manage new method modifications (abstract, static)
  * Now, we don't write out typedef if no property has been defined
  -----------------------------------------------------------------
  September, 5th, 2005
  Added factory function for local use of generated class implementation
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>
/*
*********************************************************
Support Data
*********************************************************
 */
 
#define NTYPES 16

EPChar   type[NTYPES]={ "EUint32","ESint32",
			"EUint16","ESint16",
			"EUint8","ESint8",
			"EByte","EWord","EDWord",
			"EChar","EBool",
			"EReal32","EReal64",
			"EPChar","EDMAT_BUFFER","OBJID"};
EPChar   typeid[NTYPES]={ "EUINT32","ESINT32",
			  "EUINT16","ESINT16",
			  "EUINT8","ESINT8",
			  "EBYTE","EWORD","EDWORD",
			  "ECHAR","EBOOL",
			  "EREAL32","EREAL64",
			  "EZSTRING","EBUFFER","EOBJECT"};


/*
***************************************************
  Private Data Struct for class EDMA_C_IMP_BUILDER
***************************************************
*/
 
typedef struct
  {
     EPChar		FileName;
     EUint32		h;
}DtEDMA_C_IMP_BUILDER;

/*
***************************************************
  Method Declaration for class EDMA_C_IMP_BUILDER
***************************************************
*/
 
ESint32 EDMAPROC 
EDMA_C_IMP_BUILDERbuildU32Z (OBJID IdObj,OBJID id,EPChar filename)
{
  DtEDMA_C_IMP_BUILDER	*m;
  FILE                  *f;
  EUint32               i, j, n, k, n_prop;
  ESint32               major_version, minor_version;
  EUint32               m_virtual, m_abstract, m_static;
  EChar                 temp[256], temp1[256], temp2[256], ClassName[256], namespace[256];
  EChar                 aux[1024];
  
  m = (DtEDMA_C_IMP_BUILDER*) edma_get_data_ref (IdObj);

  if ((f=fopen(filename,"wt")) == NULL)
    {
      edma_printf_obj(IdObj,"Can't open file %s for writting",filename);
      return -11;
    }

  /* FIXME: Before beginning to generate the file, 
     we'd test if our class is pure abstract
     In that case, code generation has no sense*/
  
  edma_rprop3 (id, "ClassName", ClassName);
  edma_rprop3 (id, "NameSpace", namespace);
  edma_rprop3 (id, "MajorVersion", &major_version);
  edma_rprop3 (id, "MinorVersion", &minor_version);

  /* Write GPL Notice on source file*/
  fprintf (f, "/*\n");
  fprintf (f,"*  EDMA Advanced Class %s\n", ClassName);
  fprintf (f, "* EDMA: Entorno de Desarrollo Modular y Abierto\n");
  fprintf (f, "* Object Oriented and Componetware Framework\n");
  fprintf (f, "* Copyright (C) __DATE__\n");
  fprintf (f, "*    __AUTHOR__\n");
  fprintf (f, "*\n");
  fprintf (f, "* This file is part of __PACKAGE__\n");
  fprintf (f, "*\n");
  fprintf (f, "* This program is free software: you can redistribute "
	   "it and/or modify\n");
  fprintf (f, "* it under the terms of the GNU Lesser General Public License "
	   "as published by\n");
  fprintf (f, "* the Free Software Foundation, either version 3 "
	   "of the License, or\n");
  fprintf (f, "* (at your option) any later version.\n");
  fprintf (f, "*\n");
  fprintf (f, "* This program is distributed in the hope that "
	   "it will be useful,\n");
  fprintf (f, "* but WITHOUT ANY WARRANTY; without even the "
	   "implied warranty of\n");
  fprintf (f, "* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  "
	   "See the\n");
  fprintf (f, "* GNU Lesser General Public License for more details.\n");
  fprintf (f, "*\n");
  fprintf (f, "* You should have received a copy of the "
	   "GNU Lesser General Public License\n");
  fprintf (f, "* along with program.  "
	   "If not, see <http://www.gnu.org/licenses/>.\n");
  fprintf (f, "*/\n");


  /* Generate Class Record */
  fprintf (f, "\n/*\n**************************************************");
  fprintf (f, "\n    Entorno de Desarrollo Modular y Abierto (EDMA)");
  fprintf (f, "\n    (c) David Martnez Oliveira");
  fprintf (f, "\n    File generated by : EDMA C Implementation Builder class");
  fprintf (f, "\n------------------------------------------------------");
  fprintf (f, "\n    Module Type : CLASS IMPLEMENTATION");
  fprintf (f, "\n    Class List  : %s",ClassName);
  fprintf (f, "\n    Description :");
  fprintf (f, "\n    Author      :");
  fprintf (f, "\n    Date        :");
  fprintf (f, "\n    Version     : %ld.%ld", major_version, minor_version);
  fprintf (f, "\n-----------------------------------------------------");
  fprintf (f, "\n  REVISIONS :");
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n ");

  /* Generate include files */
  fprintf (f, "\n/*\n***************************************************");  
  fprintf (f, "\n  General Header Files");
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n "); 

  fprintf (f, "\n/* Add here the includes you need for your class*/");
  fprintf (f, "\n");

  fprintf (f, "\n/*\n***************************************************");  
  fprintf (f, "\n  EDMA Header Files");
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n "); 
  fprintf (f,"\n#include <edma.h>");
  fprintf (f,"\n");

  /* Generate class data struct */
  edma_rprop3 (id, "nProp", &n); 
  fprintf (f, "\n/*\n***************************************************");  
  fprintf (f, "\n  Private Data Struct for class %s",ClassName);
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n ");   
 

  /* Write properties to file */
  n_prop = n;
  if (n) { /* We only write DtStruct if we have any prop */
    fprintf (f,"\ntypedef struct");
    fprintf (f,"\n{");
    for (i = 0; i < n; i++)
      {
	edma_met3 (id, "GetProp", i, temp, temp1, temp2, &k);
	for (j = 0; j < NTYPES; j++)
	  if (strcmp (temp1, typeid[j]) == 0)
	    break;
	if (j == NTYPES)
	  fprintf (f, "\n\tUNKNOW (%s)", temp1);
	else
	  fprintf (f, "\n\t%s", type[j]);
	fprintf (f, "\t\t%s", temp);
	/* Check for array properties */
	if (k > 0)
	  fprintf (f, "[%ld]", k);
	fprintf (f, ";");
      }
    fprintf (f, "\n}Dt%s;", ClassName);
  } else { /* Just write an commented skel to adding props in future*/
    fprintf (f, "\n/*\ntypedef struct {\n Put your field here\n} Dt%s;\n*/\n",
	     ClassName);
  }


  /* Generate Method declaration */
  fprintf (f, "\n/*\n***************************************************");  
  fprintf (f, "\n  Method Declaration for class %s", ClassName);
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n ");   

  /* Write methods to file */
  edma_rprop3 (id, "nMet", &n);
  for (i = 0; i < n; i++)
    {
      edma_met3 (id, "GetMet", i, temp, temp1, &m_virtual
		 , &m_abstract, &m_static);
      /* If abstract don't write down a function definition*/
      if (m_abstract)
	continue; 
      if (m_static) {
	fprintf (f, "\n/* Static Method %s*/\n", temp);
	fprintf (f, "\nESint32 EDMAPROC\n%s%s%s(CLASSID id)\n{"
		 , ClassName, temp, temp1);
	fprintf (f, "\n}\n");
      }
      else 
	{
	  fprintf (f, "\nESint32 EDMAPROC\n%s%s%s(OBJID IdObj)",
		   ClassName, temp, temp1);
	  
	  fprintf (f, "\n{");
	  if (n_prop)
	    {
	      fprintf (f, "\nDt%s\t*m;", ClassName);
	      fprintf (f, "\n\nm = (Dt%s *) edma_get_data_ref (IdObj);", ClassName);
	    }
	  fprintf (f, "\n}\n\n");
	}
    }

  /* Generate class factory method */
  fprintf (f, "\nESint32\n%s_class_factory ()\n", ClassName);
  fprintf (f, "{\nCLASSID    cid;\n\ncid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);\n\n");
  fprintf (f, "edma_idf_set_class_name (cid, \"%s\");\n", ClassName);
  fprintf (f, "\n");
  fprintf (f, "edma_idf_set_class_namespace (cid, \"%s\");\n", namespace);
  fprintf (f, "edma_idf_set_class_version (cid, %ld, %ld);\n\n", major_version, minor_version);

  /* Register properties */

  /* Write properties to file */
  n_prop = n;
  if (n) { /* We only write DtStruct if we have any prop */
    for (i = 0; i < n; i++)
      {
	edma_met3 (id, "GetProp", i, temp, temp1, temp2, &k);
	for (j = 0; j < NTYPES; j++)
	  if (strcmp (temp1, typeid[j]) == 0)
	    break;
	if (j == NTYPES)
	  fprintf (f, "\n\t/*UNKNOW (%s)*/", temp1);
	else
	  /* FIXME: Process temp2 to generate proper constant */
	  fprintf (f, "edma_add_local_class_property (cid, \"%s\", DT_%s, %s, %ld);\n", 
		   temp, typeid[j], strstr (temp2, "WRITE") ? "E_L": "L", k);
      }
  }


  fprintf (f, "\n /* Method registration */\n");

  /* Write methods to file */
  edma_rprop3 (id, "nMet", &n);
  for (i = 0; i < n; i++)
    {
      edma_met3 (id, "GetMet", i, temp, temp1, &m_virtual
		 , &m_abstract, &m_static);
      snprintf (aux, 1024, "(PPROC)%s%s%s", ClassName, temp, temp1);
      fprintf (f, "edma_add_local_class_method (cid, \"%s\", \"%s\", %s, %ld, %ld, %ld);\n",
	       temp, temp1, aux, m_virtual, m_abstract, m_static);
    }




  fprintf (f, "\nedma_idf_set_class_id (cid);\n\n");

  fprintf (f, "return 0;\n");
  fprintf (f, "}\n");

  fprintf (f, "\n\n/********** END C IMPLEMENTATION SKELETON ******************/");
  fclose (f);
  
  return 0;
}
