/* ANSI-C code produced by gperf version 2.7.2 */
/* Command-line: gperf -t -L ANSI-C -H aliases_hash -N aliases_lookup -7 -C -k '1,3-11,$' -i 1 lib/aliases.gperf  */
struct alias { const char* name; unsigned int encoding_index; };

#define TOTAL_KEYWORDS 304
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 45
#define MIN_HASH_VALUE 8
#define MAX_HASH_VALUE 2534
/* maximum key range = 2527, duplicates = 0 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
aliases_hash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535,
      2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535,
      2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535,
      2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535,
      2535, 2535, 2535, 2535, 2535,    1,   31, 2535,   11,  236,
        16,  131,  116,  166,  336,  281,    1,  136,   56, 2535,
      2535, 2535, 2535, 2535, 2535,  275,   31,  379,   81,    1,
       131,  209,  116,    1,    1,    1,  431,  111,    6,    1,
       171, 2535,   26,    1,    1,  221,   56,  206,  131,    6,
         1, 2535, 2535, 2535, 2535,   21, 2535, 2535, 2535, 2535,
      2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535,
      2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535,
      2535, 2535, 2535, 2535, 2535, 2535, 2535, 2535
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 11:
        hval += asso_values[(unsigned char) str[10]];
      case 10:
        hval += asso_values[(unsigned char) str[9]];
      case 9:
        hval += asso_values[(unsigned char) str[8]];
      case 8:
        hval += asso_values[(unsigned char) str[7]];
      case 7:
        hval += asso_values[(unsigned char) str[6]];
      case 6:
        hval += asso_values[(unsigned char) str[5]];
      case 5:
        hval += asso_values[(unsigned char) str[4]];
      case 4:
        hval += asso_values[(unsigned char) str[3]];
      case 3:
        hval += asso_values[(unsigned char) str[2]];
      case 2:
      case 1:
        hval += asso_values[(unsigned char) str[0]];
        break;
    }
  return hval + asso_values[(unsigned char) str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
const struct alias *
aliases_lookup (register const char *str, register unsigned int len)
{
  static const struct alias wordlist[] =
    {
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"SJIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"850", ei_cp850},
      {""}, {""},
      {"R8", ei_hp_roman8},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"862", ei_cp862},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"JIS0208", ei_jisx0208},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"KOI8-R", ei_koi8_r},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"TCVN", ei_tcvn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"HZ", ei_hz},
      {"MS-EE", ei_cp1250},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-2022-KR", ei_iso2022_kr},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"SHIFT-JIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"X0208", ei_jisx0208},
      {""}, {""},
      {"SHIFT_JIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""},
      {"JP", ei_iso646_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"ELOT_928", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"JIS_X0208", ei_jisx0208},
      {""}, {""}, {""}, {""},
      {"ISO-IR-58", ei_gb2312},
      {""}, {""}, {""}, {""}, {""},
      {"GBK", ei_ces_gbk},
      {""}, {""}, {""},
      {"GREEK", ei_iso8859_7},
      {""},
      {"GREEK8", ei_iso8859_7},
      {""}, {""}, {""},
      {"US", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UCS-2", ei_ucs2},
      {""}, {""}, {""},
      {"ISO-2022-JP-2", ei_iso2022_jp2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"UCS-2BE", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"IBM850", ei_cp850},
      {""}, {""},
      {"ISO-IR-100", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MS-HEBR", ei_cp1255},
      {"ISO-8859-8", ei_iso8859_8},
      {"KOREAN", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-203", ei_iso8859_15},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-8", ei_iso8859_8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-2", ei_iso8859_2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MS-GREEK", ei_cp1253},
      {"UTF-8", ei_utf8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MS-TURK", ei_cp1254},
      {"ISO_8859-2", ei_iso8859_2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UCS-4BE", ei_ucs4be},
      {""}, {""},
      {"TIS620", ei_tis620},
      {""},
      {"TIS-620", ei_tis620},
      {""}, {""},
      {"CN", ei_iso646_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-148", ei_iso8859_9},
      {"TIS620-0", ei_tis620},
      {"CHINESE", ei_gb2312},
      {""}, {""}, {""},
      {"ISO_8859-8:1988", ei_iso8859_8},
      {""},
      {"MS-ANSI", ei_cp1252},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-138", ei_iso8859_8},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-2022-JP", ei_iso2022_jp},
      {""}, {""},
      {"X0212", ei_jisx0212},
      {""}, {""}, {""}, {""},
      {"MS_KANJI", ei_sjis},
      {"ROMAN8", ei_hp_roman8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"L8", ei_iso8859_14},
      {""}, {""},
      {"BIGFIVE", ei_ces_big5},
      {"EUCKR", ei_euc_kr},
      {"BIG-FIVE", ei_ces_big5},
      {"EUC-KR", ei_euc_kr},
      {""},
      {"CSKOI8R", ei_koi8_r},
      {""}, {""},
      {"VISCII", ei_viscii},
      {""},
      {"LATIN8", ei_iso8859_14},
      {""},
      {"L2", ei_iso8859_2},
      {""}, {""},
      {"KOI8-U", ei_koi8_u},
      {""}, {""},
      {"JIS_X0208-1990", ei_jisx0208},
      {""}, {""},
      {"JIS_X0212", ei_jisx0212},
      {"JOHAB", ei_johab},
      {"UCS-4", ei_ucs4},
      {""}, {""}, {""},
      {"ISO-2022-CN-EXT", ei_iso2022_cn_ext},
      {"ISO-2022-CN", ei_iso2022_cn},
      {"EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", ei_euc_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"LATIN2", ei_iso8859_2},
      {""},
      {"KOI8-RU", ei_koi8_ru},
      {""}, {""}, {""}, {""},
      {"ISO-2022-JP-1", ei_iso2022_jp1},
      {""}, {""},
      {"IBM862", ei_cp862},
      {""}, {""}, {""},
      {"NEXTSTEP", ei_nextstep},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CSISO2022KR", ei_iso2022_kr},
      {""}, {""},
      {"ISO-IR-14", ei_iso646_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-4:1988", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""},
      {"UTF-32", ei_utf32},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-3:1988", ei_iso8859_3},
      {""}, {""}, {""},
      {"ISO-IR-110", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""},
      {"UTF-32BE", ei_utf32be},
      {""}, {""}, {""}, {""}, {""},
      {"HP-ROMAN8", ei_hp_roman8},
      {""},
      {"L4", ei_iso8859_4},
      {"ISO-8859-4", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-109", ei_iso8859_3},
      {""}, {""}, {""},
      {"L3", ei_iso8859_3},
      {""},
      {"ISO_8859-5:1988", ei_iso8859_5},
      {""}, {""}, {""},
      {"ISO_8859-4", ei_iso8859_4},
      {""}, {""},
      {"CP850", ei_cp850},
      {""},
      {"JIS_X0208-1983", ei_jisx0208},
      {"BIG5", ei_ces_big5},
      {"ISO-8859-10", ei_iso8859_10},
      {"BIG-5", ei_ces_big5},
      {""},
      {"ISO-8859-3", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-9", ei_iso8859_9},
      {""},
      {"HEBREW", ei_iso8859_8},
      {""}, {""}, {""}, {""},
      {"ISO_8859-10", ei_iso8859_10},
      {""},
      {"L5", ei_iso8859_9},
      {"ISO_8859-3", ei_iso8859_3},
      {""}, {""},
      {"ISO-IR-87", ei_jisx0208},
      {""}, {""}, {""},
      {"ISO_8859-10:1992", ei_iso8859_10},
      {""}, {""},
      {"ISO_8859-9", ei_iso8859_9},
      {"JAVA", ei_java},
      {""}, {""}, {""}, {""}, {""},
      {"GB18030", ei_gb18030},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-144", ei_iso8859_5},
      {""},
      {"IBM819", ei_iso8859_1},
      {""}, {""},
      {"GB2312", ei_euc_cn},
      {""}, {""}, {""}, {""},
      {"X0201", ei_jisx0201},
      {""}, {""},
      {"GB_1988-80", ei_iso646_cn},
      {""}, {""},
      {"CSISO2022JP2", ei_iso2022_jp2},
      {""},
      {"CSSHIFTJIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-5", ei_iso8859_5},
      {""}, {""},
      {"WCHAR_T", ei_local_wchar_t},
      {""}, {""},
      {"CN-GB", ei_euc_cn},
      {""}, {""}, {""}, {""}, {""},
      {"ASCII", ei_ascii},
      {"GB_2312-80", ei_gb2312},
      {""},
      {"ISO-IR-149", ei_ksc5601},
      {""}, {""}, {""},
      {"L1", ei_iso8859_1},
      {"ISO_8859-5", ei_iso8859_5},
      {"ISO_8859-9:1989", ei_iso8859_9},
      {""},
      {"JIS_X0201", ei_jisx0201},
      {""}, {""},
      {"866", ei_cp866},
      {"LATIN4", ei_iso8859_4},
      {""},
      {"UCS-2LE", ei_ucs2le},
      {""}, {""}, {""},
      {"CP932", ei_cp932},
      {""},
      {"ISO-IR-199", ei_iso8859_14},
      {""}, {""}, {""}, {""},
      {"ASMO-708", ei_iso8859_6},
      {""}, {""}, {""}, {""},
      {"JIS_X0212-1990", ei_jisx0212},
      {"ISO_8859-2:1987", ei_iso8859_2},
      {"ISO_8859-14:1998", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"LATIN3", ei_iso8859_3},
      {"CP950", ei_cp950},
      {""},
      {"CHAR", ei_local_char},
      {"ISO-IR-6", ei_ascii},
      {""}, {""},
      {"L7", ei_iso8859_13},
      {"ISO-IR-159", ei_jisx0212},
      {""}, {""}, {""}, {""},
      {"UCS-2-INTERNAL", ei_ucs2internal},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"JIS_X0212.1990-0", ei_jisx0212},
      {"EUCJP", ei_euc_jp},
      {""},
      {"EUC-JP", ei_euc_jp},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"MACGREEK", ei_mac_greek},
      {""}, {""}, {""},
      {"MACINTOSH", ei_mac_roman},
      {""}, {""}, {""},
      {"ISO-IR-226", ei_iso8859_16},
      {""},
      {"ISO_8859-15:1998", ei_iso8859_15},
      {""}, {""}, {""}, {""}, {""},
      {"CP862", ei_cp862},
      {""}, {""}, {""},
      {"MS-ARAB", ei_cp1256},
      {""}, {""},
      {"ISO-IR-101", ei_iso8859_2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-57", ei_iso646_cn},
      {"L6", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"EUCCN", ei_euc_cn},
      {"LATIN5", ei_iso8859_9},
      {"EUC-CN", ei_euc_cn},
      {"UCS-4LE", ei_ucs4le},
      {"ARMSCII-8", ei_armscii_8},
      {""}, {""},
      {"HZ-GB-2312", ei_hz},
      {""}, {""}, {""},
      {"ISO-8859-14", ei_iso8859_14},
      {"TCVN-5712", ei_tcvn},
      {""},
      {"ISO-8859-1", ei_iso8859_1},
      {""}, {""}, {""}, {""},
      {"CSISO2022JP", ei_iso2022_jp},
      {""}, {""},
      {"EUCTW", ei_euc_tw},
      {""},
      {"EUC-TW", ei_euc_tw},
      {""}, {""}, {""}, {""},
      {"CP1258", ei_cp1258},
      {""},
      {"ISO_8859-14", ei_iso8859_14},
      {""}, {""},
      {"ISO_8859-1", ei_iso8859_1},
      {""}, {""}, {""},
      {"CSISO87JISX0208", ei_jisx0208},
      {""}, {""},
      {"ISO-8859-13", ei_iso8859_13},
      {""}, {""},
      {"UCS-4-INTERNAL", ei_ucs4internal},
      {""}, {""}, {""}, {""},
      {"CP1250", ei_cp1250},
      {""},
      {"CSVISCII", ei_viscii},
      {""}, {""},
      {"ISO-IR-179", ei_iso8859_13},
      {"CN-GB-ISOIR165", ei_isoir165},
      {""}, {""}, {""},
      {"CP1252", ei_cp1252},
      {""},
      {"ISO_8859-13", ei_iso8859_13},
      {""}, {""}, {""}, {""}, {""},
      {"CSISO2022CN", ei_iso2022_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"ISO-IR-127", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"TIS620.2533-0", ei_tis620},
      {""}, {""}, {""}, {""}, {""},
      {"ECMA-118", ei_iso8859_7},
      {""},
      {"MAC", ei_mac_roman},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-7", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-15", ei_iso8859_15},
      {"US-ASCII", ei_ascii},
      {""}, {""},
      {"MACTHAI", ei_mac_thai},
      {""},
      {"CP819", ei_iso8859_1},
      {""}, {""}, {""}, {""},
      {"CP874", ei_cp874},
      {""},
      {"ISO_8859-7", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-15", ei_iso8859_15},
      {"CP949", ei_cp949},
      {""}, {""}, {""},
      {"GEORGIAN-PS", ei_georgian_ps},
      {""},
      {"BIG5HKSCS", ei_big5hkscs},
      {""},
      {"ISO_8859-1:1987", ei_iso8859_1},
      {"LATIN1", ei_iso8859_1},
      {""}, {""},
      {"UTF-7", ei_utf7},
      {""}, {""},
      {"MACROMAN", ei_mac_roman},
      {""}, {""}, {""},
      {"ISO_8859-16:2000", ei_iso8859_16},
      {""}, {""}, {""}, {""}, {""},
      {"WINDOWS-1258", ei_cp1258},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UTF-32LE", ei_utf32le},
      {""},
      {"WINDOWS-1250", ei_cp1250},
      {""},
      {"ISO-IR-165", ei_isoir165},
      {""}, {""},
      {"WINDOWS-1252", ei_cp1252},
      {""}, {""}, {""}, {""}, {""},
      {"CSISO159JISX02121990", ei_jisx0212},
      {""}, {""}, {""},
      {"CSBIG5", ei_ces_big5},
      {"ANSI_X3.4-1968", ei_ascii},
      {"CN-BIG5", ei_ces_big5},
      {"ISO_8859-7:1987", ei_iso8859_7},
      {"CSISO58GB231280", ei_gb2312},
      {""}, {""},
      {"ISO-IR-126", ei_iso8859_7},
      {"UTF-16BE", ei_utf16be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"TIS620.2529-1", ei_tis620},
      {""}, {""},
      {"UHC", ei_cp949},
      {"MACTURKISH", ei_mac_turkish},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-6", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-157", ei_iso8859_10},
      {""},
      {"LATIN7", ei_iso8859_13},
      {""}, {""},
      {"ISO_8859-6", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-6:1987", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO646-US", ei_ascii},
      {""}, {""}, {""},
      {"WINDOWS-874", ei_cp874},
      {""}, {""}, {""}, {""},
      {"MACUKRAINE", ei_mac_ukraine},
      {""}, {""},
      {"CP1254", ei_cp1254},
      {"JIS_C6220-1969-RO", ei_iso646_jp},
      {""}, {""}, {""},
      {"CSEUCKR", ei_euc_kr},
      {""},
      {"CSGB2312", ei_euc_cn},
      {""},
      {"CSASCII", ei_ascii},
      {""}, {""}, {""},
      {"WINDOWS-1254", ei_cp1254},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"WINDOWS-1253", ei_cp1253},
      {""},
      {"CP1253", ei_cp1253},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CSUNICODE", ei_ucs2},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"MACHEBREW", ei_mac_hebrew},
      {""}, {""},
      {"TIS620.2533-1", ei_tis620},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSHPROMAN8", ei_hp_roman8},
      {"WINDOWS-1255", ei_cp1255},
      {""},
      {"ECMA-114", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"LATIN6", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"IBM866", ei_cp866},
      {""},
      {"JISX0201-1976", ei_jisx0201},
      {""}, {""},
      {"UNICODELITTLE", ei_ucs2le},
      {""},
      {"CSISO14JISC6220RO", ei_iso646_jp},
      {"CP1255", ei_cp1255},
      {""}, {""}, {""},
      {"CSISOLATIN2", ei_iso8859_2},
      {""}, {""}, {""},
      {"ISO646-JP", ei_iso646_jp},
      {"UNICODEBIG", ei_ucs2be},
      {""}, {""},
      {"IBM367", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"UCS-2-SWAPPED", ei_ucs2swapped},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"WINDOWS-1251", ei_cp1251},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_646.IRV:1991", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"ISO646-CN", ei_iso646_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"TCVN5712-1:1993", ei_tcvn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"WINBALTRIM", ei_cp1257},
      {""}, {""}, {""},
      {"WINDOWS-1257", ei_cp1257},
      {""}, {""}, {""}, {""},
      {"CSUCS4", ei_ucs4},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-16", ei_iso8859_16},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"TCVN5712-1", ei_tcvn},
      {""},
      {"ISO_8859-16", ei_iso8859_16},
      {""}, {""},
      {"CP1133", ei_cp1133},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UCS-4-SWAPPED", ei_ucs4swapped},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UTF-16", ei_utf16},
      {"WINDOWS-1256", ei_cp1256},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CP1251", ei_cp1251},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-166", ei_tis620},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-10646-UCS-2", ei_ucs2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"CSISOLATINGREEK", ei_iso8859_7},
      {""},
      {"CP936", ei_ces_gbk},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATIN4", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ARABIC", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP1257", ei_cp1257},
      {"UTF-16LE", ei_utf16le},
      {""}, {""},
      {"CSISOLATIN3", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"ISO-10646-UCS-4", ei_ucs4},
      {"MS-CYRL", ei_cp1251},
      {"CP866", ei_cp866},
      {"KSC_5601", ei_ksc5601},
      {""}, {""},
      {"CSMACINTOSH", ei_mac_roman},
      {""}, {""},
      {"CSEUCTW", ei_euc_tw},
      {""}, {""}, {""},
      {"GEORGIAN-ACADEMY", ei_georgian_academy},
      {"UNICODE-1-1", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP367", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"VISCII1.1-1", ei_viscii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATINHEBREW", ei_iso8859_8},
      {""}, {""}, {""}, {""},
      {"CSISOLATIN5", ei_iso8859_9},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISO57GB1988", ei_iso646_cn},
      {"UNICODE-1-1-UTF-7", ei_utf7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"MACROMANIA", ei_mac_romania},
      {"MACCROATIAN", ei_mac_croatian},
      {""}, {""}, {""},
      {"CP1256", ei_cp1256},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"CSEUCPKDFMTJAPANESE", ei_euc_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"IBM-CP1133", ei_cp1133},
      {"CSIBM866", ei_cp866},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"KS_C_5601-1989", ei_ksc5601},
      {""},
      {"CP1361", ei_johab},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATIN1", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"MACCENTRALEUROPE", ei_mac_centraleurope},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"KS_C_5601-1987", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"MULELAO-1", ei_mulelao},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"MACICELAND", ei_mac_iceland},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CSISOLATINARABIC", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"CSISOLATIN6", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSUNICODE11", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"CSUNICODE11UTF7", ei_utf7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACARABIC", ei_mac_arabic},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATINCYRILLIC", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"CSHALFWIDTHKATAKANA", ei_jisx0201},
      {""}, {""}, {""},
      {"CYRILLIC", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CSKSC56011987", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"CSPC862LATINHEBREW", ei_cp862},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSPC850MULTILINGUAL", ei_cp850},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"MACCYRILLIC", ei_mac_cyrillic}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = aliases_hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
