;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: Layouter Examples
;;;                       (Version 1.0)
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/examples/layouter-examples.lisp
;;; File Creation Date: 6/23/89 10:31:37
;;; Last Modification Time: 05/22/92 14:23:26
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

;_______________________________________________________________________________

(proclaim '(special icon-menu layouter-window
		    layouter-1 layouted-window-1
		    layouter-2 layouted-window-2
		    layouter-3 layouted-window-3
		    layouter-4 layouted-window-4
		    layouter-5 layouted-window-5
		    *display*))


(setq layouter-window
      (make-gio 'intel-example-window
		   :name :layouter-examples
		   :x 200 :y 20 :width 500 :height 650
		   :window-icon `(intel-example-icon :parent ,icon-menu
						     :text "Layouters")
		   :title "Layouters"))


(setq layouter-1 (make-gio 'distance-layouter
				:distance 10))

(setq layouted-window-1
      (make-gio 'layouter-example-window
		   :parent layouter-window
		   :x 50 :y 50
		   :title "distance"
		   :layouter layouter-1
		   :parts '((:class text-dispel
			     :border-width 1
			     :text "first")
			    (:class text-dispel
			     :border-width 1
			     :text "the second")
			    (:class text-dispel
			     :border-width 1
			     :text "third")
			    (:class text-dispel
			     :border-width 1
			     :text "last one"))))


(setq layouter-2 (make-gio 'indent-distance-layouter
				:distance 10
				:indent 20))

(setq layouted-window-2
      (make-gio 'layouter-example-window
		   :parent layouter-window
		   :x 50 :y 220
		   :title "indent-distance"
		   :layouter layouter-2
		   :parts '((:class text-dispel
			     :border-width 1
			     :text "first")
			    (:class text-dispel
			     :border-width 1
			     :text "the second")
			    (:class text-dispel
			     :border-width 1
			     :text "third")
			    (:class text-dispel
			     :border-width 1
			     :text "last one"))))
			  

(setq layouter-3 (make-gio 'single-indent-distance-layouter
				:distance 10
				:indent 20))

(setq layouted-window-3
      (make-gio 'layouter-example-window
		   :parent layouter-window
		   :x 50 :y 390
		   :title "single-indent-distance"
		   :layouter layouter-3
		   :parts '((:class text-dispel
			     :border-width 1
			     :text "first")
			    (:class text-dispel
			     :border-width 1
			     :text "the second")
			    (:class text-dispel
			     :border-width 1
			     :text "third")
			    (:class text-dispel
			     :border-width 1
			     :text "last one"))))
			  

(setq layouter-4 (make-gio 'offset-layouter
				:offset (point 10 20)))

(setq layouted-window-4
      (make-gio 'layouter-example-window
		   :parent layouter-window
		   :x 250 :y 300
		   :title "offset"
		   :layouter layouter-4
		   :parts '((:class bitmap-dispel
			     :bitmap "refresh")
			    (:class bitmap-dispel
			     :bitmap "move")
			    (:class bitmap-dispel
			     :bitmap "newsize")
			    (:class bitmap-dispel
			     :bitmap "shrink")
			    (:class bitmap-dispel
			     :bitmap "close"))))
			    
			  
(setq layouter-5 (make-gio 'aligning-multiline-distance-layouter
		                :orientation :right   ; order items rowwise
				:items-per-line 3     ; 3 items per row
				:line-offset 10       ; inter-row-spacing
				:distance 15          ; inter-column-spacing
				:alignment :center    ; row cell alignment
				))

(setq layouted-window-5
      (make-gio 'layouter-example-window
		   :parent layouter-window
		   :x 250 :y 50
		   :title "aligning-multiline-distance"
		   :layouter layouter-5
		   :parts '((:class text-dispel
			     :border-width 1
			     :text "first")
			    (:class text-dispel
			     :border-width 1
			     :font (:size :larger)
			     :text "second")
			    (:class text-dispel
			     :border-width 1
			     :text "third")
			    (:class text-dispel
			     :border-width 1
			     :font (:size :smaller)
			     :text "forth")
			    (:class text-dispel
			     :border-width 1
			     :text "fifth")
			    (:class text-dispel
			     :border-width 1
			     :font (:size :smaller)
			     :text "sixth")
			    (:class text-dispel
			     :border-width 1
			     :font (:size :larger)
			     :text "seventh")
			    (:class text-dispel
			     :border-width 1
			     :text "eighth")
			    (:class text-dispel
			     :border-width 1
			     :font (:size :larger)
			     :text "ninth")
			    (:class text-dispel
			     :border-width 1
			     :text "tenth"))))



(update-state *display*)
(process-all-events *display*)

(shrink layouter-window)

(update-state *display*)
(process-all-events *display*)
