dnl Copyright (C) 1999-2001 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_ACULAB,[
	ost_cv_aculab_driver=false
	ACULAB_LIBS=""
	ACULAB_FLAGS=""
	AC_CHECK_HEADERS(mvcldrvr.h,[
		AC_DEFINE(HAVE_ACULAB_MVCLDRVR_H, [1], [aculab control driver])
		ost_cv_aculab_driver=true
		ACULAB_LIBS="$ACULAB_LIBS -lmvcl"])
	AC_CHECK_HEADERS(mvswdrvr.h,[
		AC_DEFINE(HAVE_ACULAB_MVSWDRVR_H, [1], [aculab switch driver])
		ost_cv_aculab_driver=true
		ACULAB_LIBS="$ACULAB_LIBS -lmvsw"])
	AC_CHECK_HEADERS(smdrvr.h,[
		AC_DEFINE(HAVE_ACULAB_SMDRVR_H, [1], [aculab support])
		ost_cv_aculab_driver=true
		ACULAB_LIBS="$ACULAB_LIBS -lmvsm"])

	if test $ost_cv_aculab_driver = false ; then
		if test ! -z "$aculab_prefix" ; then 
			acudir=$aculab_prefix
		elif test -d $prefix/$target ; then
			acudir=$prefix/$target/dtk111
		elif test -d $prefix/dtk111 ; then
			acudir=$prefix/dtk111
		else
			acudir=/usr/src/aculab/dtk111
		fi
		AC_MSG_CHECKING([for Aculab api ($acudir)])
		if test -d $acudir/tools/common ; then
			AC_DEFINE(HAVE_ACULAB_MVCLDRVR_H)
			AC_DEFINE(HAVE_ACULAB_MVSWDRVR_H)
			AC_DEFINE(HAVE_ACULAB_SMDRVR_H)
			ACULAB_LIBS="$ACULAB_LIBS -L$acudir/call/lib -L$acudir/speech/lib -L$acudir/switch/lib -lmvcl -lmvsw -lmvsm"
			ACULAB_FLAGS="-I$acudir/call/include -I$acudir/speech/include -I$acudir/switch/include"
			ost_cv_aculab_driver=true
		fi
		if test $ost_cv_aculab_driver = true ; then
			AC_MSG_RESULT(found)
		else
			AC_MSG_RESULT(missing)
		fi
	fi
	AC_SUBST(ACULAB_LIBS)
	AC_SUBST(ACULAB_FLAGS)
])



