#! /bin/sh
# Copyright (C) 2011-2012 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Test the '--destdir' option of the 'py-compile' script,

required=python
. ./defs || exit 1

cp "$am_scriptdir/py-compile" . \
  || fatal_ "failed to fetch auxiliary script py-compile"

# Should not give false positives when grepping for it, so use
# an "uncommon" string (with ugly CamelCase).
destdir=TheDestDir

mkdir sub $destdir $destdir/sub
echo 'def foo (): return "foo"' > $destdir/foo.py
echo 'def bar (): return "bar"' > $destdir/sub/bar.py

./py-compile --destdir $destdir foo.py sub/bar.py
ls -l $destdir $destdir/sub # For debugging.
ls . sub | grep '\.py[co]$' && exit 1
test -f $destdir/foo.pyc
test -f $destdir/foo.pyo
test -f $destdir/sub/bar.pyc
test -f $destdir/sub/bar.pyo
strings $destdir/*.py[co] $destdir/sub/*.py[co] || : # For debugging.
$FGREP $destdir $destdir/*.py[co] $destdir/sub/*.py[co] && exit 1

:
