/* argmatch.c -- find a match for a string in an array
   Copyright (C) 1990, 1998 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* Written by David MacKenzie <djm@ai.mit.edu>
   Modified by Akim Demaille <demaille@inf.enst.fr> */

#ifndef _ARGMATCH_H_
#define _ARGMATCH_H_ 1

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <sys/types.h>

#ifndef PARAMS
# if defined (__GNUC__) || (defined (__STDC__) && __STDC__)
#  define PARAMS(args) args
# else
#  define PARAMS(args) ()
# endif  /* GCC.  */
#endif  /* Not PARAMS.  */

/*
 * Return matches or errors
 */
int argmatch 
	PARAMS ((const char *arg, const char *const *optlist));
int argcasematch 
	PARAMS ((const char *arg, const char *const *optlist));

/*
 * Prints on stderr a message error explaining a failed argmatch
 */
void argmatch_invalid 
	PARAMS ((const char *kind, const char *value, int problem));

/* Left for compatibility with the old name invalid_arg */
#define invalid_arg(KIND,VALUE,PROBLEM) \
	argmatch_invalid (KIND, VALUE, PROBLEM)

/*
 * Prints on stderr the list of possible arguments
 */
void argmatch_valid
	PARAMS ((const char *const *optlist, 
		 const char *vallist, size_t valsize));

#define ARGMATCH_VALID(OPTLIST,VALLIST) \
  valid_args (OPTLIST, (const char *) VALLIST, sizeof (*VALLIST))

/*
 * Returns matches, or, upon error, report explanatory message
 * and exit.
 */
int __xargmatch_internal 
	PARAMS ((const char *kind, const char *arg, const char *const *optlist,
		 const char *vallist, size_t valsize, int sensitive));

#define XARGMATCH(KIND,ARG,OPTLIST,VALLIST) \
  VALLIST [__xargmatch_internal (KIND, ARG, OPTLIST, \
                        (const char *) VALLIST, sizeof (*VALLIST), 1)]

#define XARGCASEMATCH(KIND,ARG,OPTLIST,VALLIST) \
  VALLIST [__xargmatch_internal (KIND, ARG, OPTLIST, \
                        (const char *) VALLIST, sizeof (*VALLIST), 0)]

/*
 * Convert a value into a corresponding argument
 */
const char * argmatch_to_argument
	PARAMS ((char * value, const char *const *optlist,
		 const char *vallist, size_t valsize));

#define ARGMATCH_TO_ARGUMENT(VALUE,OPTLIST,VALLIST) 	\
   argmatch_to_argument ((char *) &VALUE, OPTLIST, 	\
			 (const char *) VALLIST, sizeof (*VALLIST))

#endif /* _ARGMATCH_H_ */
