'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH pack n 4.0 Tk "Tk Built-In Commands"
.so man.macros
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
pack \- Geometry manager that packs around edges of cavity
.SH SYNOPSIS
\fBpack \fIoption arg \fR?\fIarg ...\fR?
.BE
.SH DESCRIPTION
.PP
The \fBpack\fR command is used to communicate with the packer,
a geometry manager that arranges the children of a parent by
packing them in order around the edges of the parent.
The \fBpack\fR command can have any of several forms, depending
on the \fIoption\fR argument:
.TP
\fBpack \fIwindow \fR?\fIwindow ...\fR? ?\fIoptions\fR?
If the first argument to \fBpack\fR is a window name (any value
starting with
.QW . ),
then the command is processed in the same way as \fBpack configure\fR.
.TP
\fBpack configure \fIwindow \fR?\fIwindow ...\fR? ?\fIoptions\fR?
The arguments consist of the names of one or more content windows
followed by pairs of arguments that specify how
to manage the content.
See \fBTHE PACKER ALGORITHM\fR below for details on how the options
are used by the packer.
The following options are supported:
.RS
.TP
\fB\-after \fIother\fR
\fIOther\fR must the name of another window.
Use its container as the container for the content, and insert
the content just after \fIother\fR in the packing order.
.TP
\fB\-anchor \fIanchor\fR
\fIAnchor\fR must be a valid anchor position such as \fBn\fR
or \fBsw\fR; it specifies where to position each content in its
parcel.
Defaults to \fBcenter\fR.
.TP
\fB\-before \fIother\fR
\fIOther\fR must the name of another window.
Use its container as the container for the content, and insert
the content just before \fIother\fR in the packing order.
.TP
\fB\-expand \fIboolean\fR
Specifies whether the content should be expanded to consume
extra space in their container.
\fIBoolean\fR may have any proper boolean value, such as \fB1\fR
or \fBno\fR.
Defaults to 0.
.TP
\fB\-fill \fIstyle\fR
If a content's parcel is larger than its requested dimensions, this
option may be used to stretch the content.
\fIStyle\fR must have one of the following values:
.RS
.TP
\fBnone\fR
Give the content its requested dimensions plus any internal padding
requested with \fB\-ipadx\fR or \fB\-ipady\fR.  This is the default.
.TP
\fBx\fR
Stretch the content horizontally to fill the entire width of its
parcel (except leave external padding as specified by \fB\-padx\fR).
.TP
\fBy\fR
Stretch the content vertically to fill the entire height of its
parcel (except leave external padding as specified by \fB\-pady\fR).
.TP
\fBboth\fR
Stretch the content both horizontally and vertically.
.RE
.TP
\fB\-in \fIcontainer\fR
Insert the window at the end of the packing order for the container
window given by \fIcontainer\fR.
.TP
\fB\-ipadx \fIamount\fR
\fIAmount\fR specifies how much horizontal internal padding to
leave on each side of the content.
\fIAmount\fR must be a valid screen distance, such as \fB2\fR or \fB.5c\fR.
It defaults to 0.
.TP
\fB\-ipady \fIamount\fR
\fIAmount\fR specifies how much vertical internal padding to
leave on each side of the content.
\fIAmount\fR  defaults to 0.
.TP
\fB\-padx \fIamount\fR
\fIAmount\fR specifies how much horizontal external padding to
leave on each side of the content.  \fIAmount\fR may be a list
of two values to specify padding for left and right separately.
\fIAmount\fR defaults to 0.
.TP
\fB\-pady \fIamount\fR
\fIAmount\fR specifies how much vertical external padding to
leave on each side of the content.  \fIAmount\fR may be a list
of two values to specify padding for top and bottom separately.
\fIAmount\fR defaults to 0.
.TP
\fB\-side \fIside\fR
Specifies which side of the container the content will be packed against.
Must be \fBleft\fR, \fBright\fR, \fBtop\fR, or \fBbottom\fR.
Defaults to \fBtop\fR.
.LP
If no \fB\-in\fR, \fB\-after\fR or \fB\-before\fR option is specified
then each of the content will be inserted at the end of the packing list
for its parent unless it is already managed by the packer (in which
case it will be left where it is).
If one of these options is specified then all the content will be
inserted at the specified point.
If any of the content are already managed by the geometry manager
then any unspecified options for them retain their previous values rather
than receiving default values.
.RE
.TP
\fBpack forget \fIwindow \fR?\fIwindow ...\fR?
Removes each of the \fIwindow\fRs from the packing order for its
container and unmaps their windows.
The content will no longer be managed by the packer.
.TP
\fBpack info \fIwindow\fR
Returns a list whose elements are the current configuration state of
the window given by \fIwindow\fR in the same option-value form that
might be specified to \fBpack configure\fR.
The first two elements of the list are
.QW "\fB\-in \fIcontainer\fR"
where \fIcontainer\fR is the window's container.
.TP
\fBpack propagate \fIcontainer\fR ?\fIboolean\fR?
If \fIboolean\fR has a true boolean value such as \fB1\fR or \fBon\fR
then propagation is enabled for \fIcontainer\fR, which must be a window
name (see \fBGEOMETRY PROPAGATION\fR below).
If \fIboolean\fR has a false boolean value then propagation is
disabled for \fIcontainer\fR.
In either of these cases an empty string is returned.
If \fIboolean\fR is omitted then the command returns \fB0\fR or
\fB1\fR to indicate whether propagation is currently enabled
for \fIcontainer\fR.
Propagation is enabled by default.
.TP
\fBpack slaves \fIwindow\fR
Returns a list of all of the content windows in the packing order for \fIwindow\fR.
The order of the content windows in the list is the same as their order in
the packing order.
If \fIwindow\fR has no content then an empty string is returned.
.VS "TIP 581"
.TP
\fBpack content \fIwindow\fR
.
Synonym for \fBpack slaves \fIwindow\fR.
.VE "TIP 581"
.SH "THE PACKER ALGORITHM"
.PP
For each container the packer maintains an ordered list of content
windows called the \fIpacking list\fR.
The \fB\-in\fR, \fB\-after\fR, and \fB\-before\fR configuration
options are used to specify the container for each content and the content's
position in the packing list.
If none of these options is given for a content then the content
is added to the end of the packing list for its parent.
.PP
The packer arranges the content windows for a container by scanning the
packing list in order.
At the time it processes each content, a rectangular area within
the container is still unallocated.
This area is called the \fIcavity\fR;  for the first content it
is the entire area of the container.
.PP
For each content the packer carries out the following steps:
.IP [1]
The packer allocates a rectangular \fIparcel\fR for the content
along the side of the cavity given by the content's \fB\-side\fR option.
If the side is top or bottom then the width of the parcel is
the width of the cavity and its height is the requested height
of the content plus the \fB\-ipady\fR and \fB\-pady\fR options.
For the left or right side the height of the parcel is
the height of the cavity and the width is the requested width
of the content plus the \fB\-ipadx\fR and \fB\-padx\fR options.
The parcel may be enlarged further because of the \fB\-expand\fR
option (see \fBEXPANSION\fR below)
.IP [2]
The packer chooses the dimensions of the content.
The width will normally be the content's requested width plus
twice its \fB\-ipadx\fR option and the height will normally be
the content's requested height plus twice its \fB\-ipady\fR
option.
However, if the \fB\-fill\fR option is \fBx\fR or \fBboth\fR
then the width of the content is expanded to fill the width of the parcel,
minus twice the \fB\-padx\fR option.
If the \fB\-fill\fR option is \fBy\fR or \fBboth\fR
then the height of the content is expanded to fill the width of the parcel,
minus twice the \fB\-pady\fR option.
.IP [3]
The packer positions the content over its parcel.
If the content is smaller than the parcel then the \fB\-anchor\fR
option determines where in the parcel the content will be placed.
If \fB\-padx\fR or \fB\-pady\fR is non-zero, then the given
amount of external padding will always be left between the
content and the edges of the parcel.
.PP
Once a given content has been packed, the area of its parcel
is subtracted from the cavity, leaving a smaller rectangular
cavity for the next content.
If a content does not use all of its parcel, the unused space
in the parcel will not be used by subsequent content.
If the cavity should become too small to meet the needs of
a content then the content will be given whatever space is
left in the cavity.
If the cavity shrinks to zero size, then all remaining content
on the packing list will be unmapped from the screen until
the container window becomes large enough to hold them again.
.SS "EXPANSION"
.PP
If a container window is so large that there will be extra space
left over after all of its content have been packed, then the
extra space is distributed uniformly among all of the content
for which the \fB\-expand\fR option is set.
Extra horizontal space is distributed among the expandable
content whose \fB\-side\fR is \fBleft\fR or \fBright\fR,
and extra vertical space is distributed among the expandable
content whose \fB\-side\fR is \fBtop\fR or \fBbottom\fR.
.SS "GEOMETRY PROPAGATION"
.PP
The packer normally computes how large a container must be to
just exactly meet the needs of its content, and it sets the
requested width and height of the container to these dimensions.
This causes geometry information to propagate up through a
window hierarchy to a top-level window so that the entire
sub-tree sizes itself to fit the needs of the leaf windows.
However, the \fBpack propagate\fR command may be used to
turn off propagation for one or more containers.
If propagation is disabled then the packer will not set
the requested width and height of the packer.
This may be useful if, for example, you wish for a container
window to have a fixed size that you specify.
.SH "RESTRICTIONS ON CONTAINER WINDOWS"
.PP
The container for each content must either be the content's parent
(the default) or a descendant of the content's parent.
This restriction is necessary to guarantee that the
content can be placed over any part of its container that is
visible without danger of the content being clipped by its parent.
.SH "PACKING ORDER"
.PP
If the container for a content is not its parent then you must make sure
that the content is higher in the stacking order than the container.
Otherwise the container will obscure the content and it will appear as
if the content has not been packed correctly.
The easiest way to make sure the content is higher than the container is
to create the container window first:  the most recently created window
will be highest in the stacking order.
Or, you can use the \fBraise\fR and \fBlower\fR commands to change
the stacking order of either the container or the content.
.SH EXAMPLE
.PP
.CS
# Make the widgets
label .t \-text "This widget is at the top"    \-bg red
label .b \-text "This widget is at the bottom" \-bg green
label .l \-text "Left\enHand\enSide"
label .r \-text "Right\enHand\enSide"
text .mid
\&.mid insert end "This layout is like Java's BorderLayout"
# Lay them out
\fBpack\fR .t   \-side top    \-fill x
\fBpack\fR .b   \-side bottom \-fill x
\fBpack\fR .l   \-side left   \-fill y
\fBpack\fR .r   \-side right  \-fill y
\fBpack\fR .mid \-expand 1    \-fill both
.CE
.SH "SEE ALSO"
grid(n), place(n)
.SH KEYWORDS
geometry manager, location, packer, parcel, propagation, size
'\" Local Variables:
'\" mode: nroff
'\" End:
