# \TimetableApi

All URIs are relative to *https://api.transitous.org*

Method | HTTP request | Description
------------- | ------------- | -------------
[**stoptimes**](TimetableApi.md#stoptimes) | **GET** /api/v5/stoptimes | Get the next N departures or arrivals of a stop sorted by time
[**trip**](TimetableApi.md#trip) | **GET** /api/v5/trip | Get a trip as itinerary



## stoptimes

> models::Stoptimes200Response stoptimes(stop_id, n, time, arrive_by, direction, mode, radius, exact_radius, fetch_stops, page_cursor, with_scheduled_skipped_stops, language)
Get the next N departures or arrivals of a stop sorted by time

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**stop_id** | **String** | stop id of the stop to retrieve departures/arrivals for | [required] |
**n** | **i32** | the number of events | [required] |
**time** | Option<**String**> | Optional. Defaults to the current time.  |  |
**arrive_by** | Option<**bool**> | Optional. Default is `false`.    - `arriveBy=true`: the parameters `date` and `time` refer to the arrival time   - `arriveBy=false`: the parameters `date` and `time` refer to the departure time  |  |[default to false]
**direction** | Option<**String**> | This parameter will be ignored in case `pageCursor` is set.  Optional. Default is   - `LATER` for `arriveBy=false`   - `EARLIER` for `arriveBy=true`  The response will contain the next `n` arrivals / departures in case `EARLIER` is selected and the previous `n` arrivals / departures if `LATER` is selected.  |  |
**mode** | Option<[**Vec<models::Mode>**](models::Mode.md)> | Optional. Default is all transit modes.  Only return arrivals/departures of the given modes.  |  |[default to [TRANSIT]]
**radius** | Option<**i32**> | Optional. Radius in meters.  Default is that only stop times of the parent of the stop itself and all stops with the same name (+ their child stops) are returned.  If set, all stops at parent stations and their child stops in the specified radius are returned.  |  |
**exact_radius** | Option<**bool**> | Optional. Default is `false`.  If set to `true`, only stations that are phyiscally in the radius are considered. If set to `false`, additionally to the stations in the radius, equivalences with the same name and children are considered.  |  |[default to false]
**fetch_stops** | Option<**bool**> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Default is `false`. If set to `true`, the following stops are returned for departures and the previous stops are returned for arrivals.  |  |
**page_cursor** | Option<**String**> | Use the cursor to go to the next \"page\" of stop times. Copy the cursor from the last response and keep the original request as is. This will enable you to search for stop times in the next or previous time-window.  |  |
**with_scheduled_skipped_stops** | Option<**bool**> | Optional. Include stoptimes where passengers can not alight/board according to schedule. |  |[default to false]
**language** | Option<[**Vec<String>**](String.md)> | language tags as used in OpenStreetMap / GTFS (usually BCP-47 / ISO 639-1, or ISO 639-2 if there's no ISO 639-1)  |  |

### Return type

[**models::Stoptimes200Response**](stoptimes_200_response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## trip

> models::Itinerary trip(trip_id, with_scheduled_skipped_stops, join_interlined_legs, language)
Get a trip as itinerary

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**trip_id** | **String** | trip identifier (e.g. from an itinerary leg or stop event) | [required] |
**with_scheduled_skipped_stops** | Option<**bool**> | Optional. Include intermediate stops where passengers can not alight/board according to schedule. |  |[default to false]
**join_interlined_legs** | Option<**bool**> | Optional. Default is `true`.  Controls if a trip with stay-seated transfers is returned: - `joinInterlinedLegs=false`: as several legs (full information about all trip numbers, headsigns, etc.).   Legs that do not require a transfer (stay-seated transfer) are marked with `interlineWithPreviousLeg=true`. - `joinInterlinedLegs=true` (default behavior): as only one joined leg containing all stops  |  |[default to true]
**language** | Option<[**Vec<String>**](String.md)> | language tags as used in OpenStreetMap / GTFS (usually BCP-47 / ISO 639-1, or ISO 639-2 if there's no ISO 639-1)  |  |

### Return type

[**models::Itinerary**](Itinerary.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

