% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-news.R
\name{build_news}
\alias{build_news}
\title{Build news section}
\usage{
build_news(pkg = ".", override = list(), preview = FALSE)
}
\arguments{
\item{pkg}{Path to package.}

\item{override}{An optional named list used to temporarily override
values in \verb{_pkgdown.yml}}

\item{preview}{If \code{TRUE}, or \code{is.na(preview) && interactive()}, will preview
freshly generated section in browser.}
}
\description{
A \code{NEWS.md} will be broken up into versions using level one (\verb{#}) or
level two headings (\verb{##}) that (partially) match one of the following forms
(ignoring case):
\itemize{
\item \verb{\{package name\} 1.3.0}
\item \verb{\{package name\} v1.3.0}
\item \verb{Version 1.3.0}
\item \verb{Changes in 1.3.0}
\item \verb{Changes in v1.3.0}
}
}
\details{
A \href{https://style.tidyverse.org/news.html}{common structure} for news files
is to use a top level heading for each release, and use a second level
heading to break up individual bullets into sections.

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{# foofy 1.0.0

## Major changes

* Can now work with all grooveable grobbles!

## Minor improvements and bug fixes

* Printing scrobbles no longer errors (@githubusername, #100)

* Wibbles are now 55\% less jibbly (#200)
}\if{html}{\out{</div>}}

Issues and contributors will be automatically linked to the corresponding
pages on GitHub if the GitHub repo can be discovered from the \code{DESCRIPTION}
(typically from a \code{URL} entry containing \code{github.com})

If a version is available on CRAN, the release date will automatically
be added to the heading (see below for how to suppress); if not
available on CRAN, "Unreleased" will be added.
}
\section{YAML config}{
To automatically link to release announcements, include a \code{releases}
section.

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{news:
 releases:
 - text: "usethis 1.3.0"
   href: https://www.tidyverse.org/articles/2018/02/usethis-1-3-0/
 - text: "usethis 1.0.0 (and 1.1.0)"
   href: https://www.tidyverse.org/articles/2017/11/usethis-1.0.0/
}\if{html}{\out{</div>}}

Control whether news is present on one page or multiple pages with the
\code{one_page} field. The default is \code{true}.

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{news:
  one_page: false
}\if{html}{\out{</div>}}

Suppress the default addition of CRAN release dates with:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{news:
  cran_dates: false
}\if{html}{\out{</div>}}
}

\seealso{
\href{https://style.tidyverse.org/news.html}{Tidyverse style for News}

Other site components: 
\code{\link{build_articles}()},
\code{\link{build_home}()},
\code{\link{build_reference}()},
\code{\link{build_tutorials}()}
}
\concept{site components}
