# Charter for the VisPy Organization

This is the organizational charter for the VisPy Organization (the "Organization"). By adding their name to
the [Steering Committee.md file](./STEERING-COMMITTEE.md), Steering Committee members agree as follows.

## 1. Mission

The VisPy organization's mission is to provide libraries and tools that allow for high-performance interactive 2D and
3D scientific visualizations.

## 2. Steering Committee

**2.1 Purpose**. The Steering Committee will be responsible for all technical oversight, project approval and oversight,
policy oversight, and trademark management for the Organization.

**2.2 Composition**. The Steering Committee voting members are listed in the steering-committee.md file in the
repository.
Voting members may be added or removed by no less than 3/4 affirmative vote of the Steering Committee.
The Steering Committee will appoint a Chair responsible for organizing Steering Committee activity.

## 3. Voting

**3.1. Decision Making**. The Steering Committee will strive for all decisions to be made by consensus. While explicit
agreement of the entire Steering Committee is preferred, it is not required for consensus. Rather, the Steering Committee
will determine consensus based on their good faith consideration of a number of factors, including the dominant view of
the Steering Committee and nature of support and objections. The Steering Committee will document evidence of consensus
in accordance with these requirements. If consensus cannot be reached, the Steering Committee will make the decision by a
vote.

**3.2. Voting**. The Steering Committee Chair will call a vote with reasonable notice to the Steering Committee, setting
out a discussion period and a separate voting period. Any discussion may be conducted in person or electronically by
text, voice, or video. The discussion will be open to the public. In any vote, each voting representative will have one
vote. Except as specifically noted elsewhere in this Charter, decisions by vote require a simple majority vote of all
voting members.

## 4. Termination of Membership

In addition to the method set out in section 2.2, the membership of a Steering Committee member will terminate if any of
the following occur:

**4.1 Resignation**. Written notice of resignation to the Steering Committee.

**4.2 Unreachable Member**. If a member is unresponsive at its listed handle for more than three months the Steering
Committee may vote to remove the member.

## 5. Trademarks

Any names, trademarks, service marks, logos, mascots, or similar indicators of source or origin and the goodwill
associated with them arising out of the Organization's activities or Organization projects' activities (the "Marks"), are
controlled by the Organization. Steering Committee members may only use the Marks in accordance with the
Organization's [trademark policy](./TRADEMARKS.md). If a Steering Committee member is terminated or removed from the
Steering Committee, any rights the Steering Committee member may have in the Marks revert to the Organization.

## 6. Antitrust Policy

The Steering Committee is bound by the Organization's [antitrust policy](./ANTITRUST.md).

## 7. No Confidentiality

Information disclosed in connection with any of the Organization's activities, including but not limited to meetings,
Contributions, and submissions, is not confidential, regardless of any markings or statements to the contrary.

## 8. Project Criteria

In order to be eligible to be a Organization project, a project must:

* Be approved by the Steering Committee.
* Agree to follow the guidance and direction of the Steering Committee.
* Use only the following outbound licenses or agreements unless otherwise approved:
    - For code, a license on the Open Source Initiative's list of [Popular Licenses](https://opensource.org/licenses).
    - For data, a license on the Open Knowledge Foundation's list
      of [Recommended Conformant Licenses](http://opendefinition.org/licenses/).
    - For specifications, a community developed and maintained specification agreement, such
      the [Open Web Foundation Agreements](https://www.openwebfoundation.org/the-agreements)
      or [Community Specification Agreement](https://github.com/CommunitySpecification/1.0).
* Include and adhere to the Organization's policies, including the [trademark policy](./TRADEMARKS.md),
  the [antitrust policy](./ANTITRUST.md), and the
  [code of conduct](https://github.com/vispy/vispy/blob/main/CODE_OF_CONDUCT.md).

## 9. Amendments

Amendments to this charter, the [antitrust policy](./ANTITRUST.md), the [trademark policy](./TRADEMARKS.md), or
the [code of conduct](https://github.com/vispy/vispy/blob/main/CODE_OF_CONDUCT.md) may only be made with at least a 3/4
affirmative vote of the Steering Committee.

---
Part of MVG-0.1-beta.
Made with love by GitHub. Licensed under the [CC-BY 4.0 License](https://creativecommons.org/licenses/by-sa/4.0/).
