## Breaking changes for library users

- 38f8f917 `glossary_v2.Glossary` class raises `Error` exception if operation failed, instead of `log.critical` and `return None`

  - Applies to these methods: `convert`, `read`, `write`
  - `glossary.Glossary` (and `pyglossary.Glossary`) still behaves the same way (return `None` if failed)

- a5204bb3 Breaking changes in `Glossary.detectInputFormat` and `Glossary.detectOutputFormat` methods:

  - `format` argument is renamed to `formatName`
  - `quiet` argument is removed (must handle `Error` exception instead)

- 9cc2887f `Glossary.wordTitleStr`: rename `_class` argument to `class_`

- Remove `toBytes` and `replaceStringTable` functions from `text_utils.py` and `plugins/formats_common.py`
  Breaking change for plugins outside this repo

## Deprecated API for library users

- `glossary.Glossary` is deprecated, use `glossary_v2.Glossary`
- `format` variable in plugins is deprecated, rename it to `name`
- `info` argument to `Glossary()` is deprecated. Use `glos.setInfo(key, value)`
- `Glossary`: `format` arguments to `read`, `directRead` and `write` methods are deprecated, rename them to `formatName`

## What's changed since last version?

We have a web-based user interface by @glowinthedark, a new plugin [StardictMergeSyns](https://github.com/ilius/pyglossary/blob/master/doc/p/stardict_merge_syns.md), new options in  various plugins/formats, lots of improvements, refactoring and cleanup.

**Full Changelog**: https://github.com/ilius/pyglossary/compare/4.7.1...5.0.0

## New Contributors

- @a1ess made their first contribution in https://github.com/ilius/pyglossary/pull/590

[PyPI package is released](https://pypi.org/project/pyglossary/)
