#ifndef UKERNEL
/* This section for kernel libafs compiles only */

#ifndef AFS_PARAM_H
#define AFS_PARAM_H

#define AFS_ENV                 1
#define AFS_64BIT_CLIENT        1
#define AFS_64BIT_IOPS_ENV	1
#if defined(__ppc__)
#define AFS_PPC_ENV		1
#elif defined(__i386__) || defined(__amd64__)
#define AFS_X86_ENV		1
#else
#error Unsupported architecture
#endif
#define AFS_VFSINCL_ENV		1
#ifdef __amd64__
#define AFS_64BITUSERPOINTER_ENV 1
#endif
#define AFS_64BIT_SIZEOF 1 /* seriously? */
#include <afs/afs_sysnames.h>

#define AFS_DARWIN_ENV
#define AFS_DARWIN70_ENV
#define AFS_DARWIN80_ENV
#define AFS_DARWIN90_ENV
#define AFS_DARWIN100_ENV
#undef  AFS_NONFSTRANS
#define AFS_NONFSTRANS
#define AFS_SYSCALL             230
#define AFS_NAMEI_ENV 1
#define DARWIN_REFBASE 3
#define AFS_WARNUSER_MARINER_ENV 1
#define AFS_CACHE_VNODE_PATH
#define AFS_NEW_BKG 1
#define NEED_IOCTL32

/* Machine / Operating system information */
#if defined(__ppc__)
#define sys_ppc_darwin_12	1
#define sys_ppc_darwin_13	1
#define sys_ppc_darwin_14	1
#define sys_ppc_darwin_60	1
#define sys_ppc_darwin_70	1
#define sys_ppc_darwin_80	1
#define sys_ppc_darwin_90	1
#define sys_ppc_darwin_100	1
#define SYS_NAME		"ppc_darwin_100"
#define SYS_NAME_ID		SYS_NAME_ID_ppc_darwin_100
#define AFSBIG_ENDIAN		1
#elif defined(__ppc64__)
#define sys_ppc_darwin_12	1
#define sys_ppc_darwin_13	1
#define sys_ppc_darwin_14	1
#define sys_ppc_darwin_60	1
#define sys_ppc_darwin_70	1
#define sys_ppc_darwin_80	1
#define sys_ppc_darwin_90	1
#define sys_ppc_darwin_100	1
#define sys_ppc64_darwin_100	1
#define SYS_NAME		"ppc64_darwin_100"
#define SYS_NAME_ID		SYS_NAME_ID_ppc64_darwin_100
#define AFSBIG_ENDIAN		1
#elif defined(__i386__)
#define sys_x86_darwin_12	1
#define sys_x86_darwin_13	1
#define sys_x86_darwin_14	1
#define sys_x86_darwin_60	1
#define sys_x86_darwin_70	1
#define sys_x86_darwin_80	1
#define sys_x86_darwin_90	1
#define sys_x86_darwin_100	1
#define SYS_NAME		"x86_darwin_100"
#define SYS_NAME_ID		SYS_NAME_ID_x86_darwin_100
#define AFSLITTLE_ENDIAN	1
#elif defined(__amd64__)
#define sys_x86_darwin_12	1
#define sys_x86_darwin_13	1
#define sys_x86_darwin_14	1
#define sys_x86_darwin_60	1
#define sys_x86_darwin_70	1
#define sys_x86_darwin_80	1
#define sys_x86_darwin_90	1
#define sys_x86_darwin_100	1
#define sys_amd64_darwin_100	1
#define SYS_NAME		"amd64_darwin_100"
#define SYS_NAME_ID		SYS_NAME_ID_amd64_darwin_100
#define AFSLITTLE_ENDIAN	1
#else
#error Unsupported architecture
#endif
#define AFS_HAVE_FFS    1	/* Use system's ffs. */

#define AFS_GCPAGS               0
#define RXK_UPCALL_ENV         1
#define RXK_TIMEDSLEEP_ENV       1

#ifdef KERNEL
#undef MACRO_BEGIN
#undef MACRO_END
#include <kern/macro_help.h>
#define AFS_GLOBAL_SUNLOCK        1
#define AFS_VFS34       1	/* What is VFS34??? */
#define afsio_iov       uio_iov
#define afsio_iovcnt    uio_iovcnt
#define afsio_offset    uio_offset
#define afsio_seg       uio_segflg
#define afsio_resid     uio_resid
#define AFS_UIOSYS      UIO_SYSSPACE
#define AFS_UIOUSER     UIO_USERSPACE
#define AFS_CLBYTES     CLBYTES
#define AFS_KALLOC(x)   _MALLOC(x, M_TEMP, M_WAITOK)
#define AFS_KFREE(x,y)  _FREE(x,M_TEMP)
#define v_count         v_usecount
#define v_vfsp          v_mount
#define vfs_bsize       mnt_stat.f_bsize
#define vfs_fsid        mnt_stat.f_fsid
#define va_nodeid       va_fileid
#define vfs_vnodecovered mnt_vnodecovered
#define direct          dirent

#define BIND_8_COMPAT

#endif
#endif /* AFS_PARAM_H */

#else /* !defined(UKERNEL) */

/* This section for user space compiles only */

#ifndef AFS_PARAM_H
#define AFS_PARAM_H

#define AFS_VFSINCL_ENV 1	/* NOBODY uses this.... */
#define AFS_ENV                 1
#define AFS_64BIT_CLIENT        1
#define AFS_64BIT_ENV           1	/* Defines afs_int32 as int, not long. */
#if defined(__ppc__)
#define AFS_PPC_ENV		1
#elif defined(__i386__) || defined(__amd64__)
#define AFS_X86_ENV		1
#else
#error Unsupported architecture
#endif
#ifdef __amd64__
#define AFS_64BITUSERPOINTER_ENV 1
#endif

#include <afs/afs_sysnames.h>
#define AFS_USERSPACE_ENV
#define AFS_USR_DARWIN_ENV
#define AFS_USR_DARWIN70_ENV
#define AFS_USR_DARWIN80_ENV
#define AFS_USR_DARWIN90_ENV
#define AFS_USR_DARWIN100_ENV
#undef  AFS_NONFSTRANS
#define AFS_NONFSTRANS
#define AFS_SYSCALL             230
#define DARWIN_REFBASE 0
#define AFS_WARNUSER_MARINER_ENV 1

/* Machine / Operating system information */
#if defined(__ppc__)
#define sys_ppc_darwin_12	1
#define sys_ppc_darwin_13	1
#define sys_ppc_darwin_14	1
#define sys_ppc_darwin_60	1
#define sys_ppc_darwin_70	1
#define sys_ppc_darwin_80	1
#define sys_ppc_darwin_90	1
#define sys_ppc_darwin_100	1
#define SYS_NAME		"ppc_darwin_100"
#define SYS_NAME_ID		SYS_NAME_ID_ppc_darwin_100
#define AFSBIG_ENDIAN		1
#elif defined(__i386__)
#define sys_x86_darwin_12	1
#define sys_x86_darwin_13	1
#define sys_x86_darwin_14	1
#define sys_x86_darwin_60	1
#define sys_x86_darwin_70	1
#define sys_x86_darwin_80	1
#define sys_x86_darwin_100	1
#define SYS_NAME		"x86_darwin_100"
#define SYS_NAME_ID		SYS_NAME_ID_x86_darwin_100
#define AFSLITTLE_ENDIAN	1
#elif defined(__amd64__)
#define sys_x86_darwin_12	1
#define sys_x86_darwin_13	1
#define sys_x86_darwin_14	1
#define sys_x86_darwin_60	1
#define sys_x86_darwin_70	1
#define sys_x86_darwin_80	1
#define sys_x86_darwin_100	1
#define sys_amd64_darwin_100	1
#define SYS_NAME		"amd64_darwin_100"
#define SYS_NAME_ID		SYS_NAME_ID_amd64_darwin_100
#define AFSLITTLE_ENDIAN	1
#else
#error Unsupported architecture
#endif
#define AFS_HAVE_FFS    1	/* Use system's ffs. */

#define AFS_UIOSYS      UIO_SYSSPACE
#define AFS_UIOUSER     UIO_USERSPACE

#define AFS_GCPAGS                0	/* if nonzero, garbage collect PAGs */
#define RXK_LISTENER_ENV          1

#define AFS_VFS34       1	/* What is VFS34??? */
#define afsio_iov       uio_iov
#define afsio_iovcnt    uio_iovcnt
#define afsio_offset    uio_offset
#define afsio_seg       uio_segflg
#define afsio_resid     uio_resid
#define AFS_UIOSYS      UIO_SYSSPACE
#define AFS_UIOUSER     UIO_USERSPACE
#define        VATTR_NULL      usr_vattr_null

#define AFS_DIRENT
#ifndef CMSERVERPREF
#define CMSERVERPREF
#endif

#define BIND_8_COMPAT
#endif /* AFS_PARAM_H */

#endif /* !defined(UKERNEL) */
