# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class VolumeProperty(Object):
    r"""
    VolumeProperty - represents the common properties for rendering a
    volume.
    
    Superclass: Object
    
    VolumeProperty is used to represent common properties associated
    with volume rendering. This includes properties for determining the
    type of interpolation to use when sampling a volume, the color of a
    volume, the scalar opacity of a volume, the gradient opacity of a
    volume, and the shading parameters of a volume.
    
    Color, scalar opacity and gradient magnitude opacity transfer
    functions can be set as either 3 separate 1D functions or as a single
    2D transfer function.
    
    - 1D Transfer functions (vtkvolume_property::TF_1D) Color, scalar
      opacity and gradient magnitude opacity are defined by 1
      ColorTransferFunction and 2 PiecewiseFunctions respectively.
      When the scalar opacity or the gradient opacity of a volume is not
      set, then the function is defined to be a constant value of 1.0.
      When a scalar and gradient opacity are both set simultaneously,
      then the opacity is defined to be the product of the scalar opacity
    and gradient opacity transfer functions. 1D transfer functions is the
    legacy and default behavior.
    
    - 2D Transfer functions (vtkvolume_property::TF_2D) Color and
      scalar/gradient magnitude opacity are defined by a 4-component
      ImageData instance mapping scalar value vs. gradient magnitude
      on its x and y axis respectively. This mode is only available if a
      2D TF has been explicitly set (see set_transfer_function2d).
    
    Most properties can be set per "component" for volume mappers that
    support multiple independent components. If you are using 2 component
    data as LV or 4 component data as RGBV (as specified in the mapper)
    only the first scalar opacity and gradient opacity transfer functions
    will be used (and all color functions will be ignored). Omitting the
    index parameter on the Set/Get methods will access index = 0.
    
    @sa PiecewiseFunction ColorTransferFunction
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVolumeProperty, obj, update, **traits)
    
    disable_gradient_opacity = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable/Disable the gradient opacity function for the given
        component. If set to true, any call to get_gradient_opacity() will
        return a default function for this component. Note that the
        gradient opacity function is still stored, it is not set or reset
        and can be retrieved using get_stored_gradient_opacity().
        """
    )

    def _disable_gradient_opacity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDisableGradientOpacity,
                        self.disable_gradient_opacity_)

    independent_components = tvtk_base.true_bool_trait(desc=\
        r"""
        Does the data have independent components, or do some define
        color only? If independent_components is On (the default) then
        each component will be independently passed through a lookup
        table to determine RGBA, shaded. Some volume Mappers can handle 1
        to 4 component unsigned char or unsigned short data (see each
        mapper header file to determine functionality). If
        independent_components is Off, then you must have either 2 or 4
        component data. For 2 component data, the first is passed through
        the first color transfer function and the second component is
        passed through the first scalar opacity (and gradient opacity)
        transfer function. Normals will be generated off of the second
        component. When using gradient based opacity modulation, the
        gradients are computed off of the second component. For 4
        component data, the first three will directly represent RGB (no
        lookup table). The fourth component will be passed through the
        first scalar opacity transfer function for opacity and first
        gradient opacity transfer function for gradient based opacity
        modulation. Normals will be generated from the fourth component.
        When using gradient based opacity modulation, the gradients are
        computed off of the fourth component.
        """
    )

    def _independent_components_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIndependentComponents,
                        self.independent_components_)

    shade = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get the shading of a volume. If shading is turned off, then
        the mapper for the volume will not perform shading calculations.
        If shading is turned on, the mapper may perform shading
        calculations - in some cases shading does not apply (for example,
        in a maximum intensity projection) and therefore shading will not
        be performed even if this flag is on. For a compositing type of
        mapper, turning shading off is generally the same as setting
        ambient=1, diffuse=0, specular=0. Shading can be independently
        turned on/off per component.
        
        ote Shading is only supported for
        VolumeMapper::COMPOSITE_BLEND. For minimum and maximum
        intensity blend modes, there is not necessarily one unique
        location along the ray through the volume where that minimum or
        maximum occurs. For average and additive blend modes, the value
        being visualized does not represent a location in the volume but
        rather a statistical measurement along the ray traversing through
        the volume, and hence shading is not applicable.
        \sa VolumeMapper::BlendModes
        """
    )

    def _shade_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShade,
                        self.shade_)

    use_clipped_voxel_intensity = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get whether to use a fixed intensity value for voxels in the
        clipped space for gradient calculations. When
        use_clipped_voxel_intensity is enabled, the clipped_voxel_intensity
        value will be used as intensity of clipped voxels. By default,
        this is false.
        
        ote This property is only used by the GPUVolumeRayCastMapper
        for now.
        \sa set_clipped_voxel_intensity
        """
    )

    def _use_clipped_voxel_intensity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseClippedVoxelIntensity,
                        self.use_clipped_voxel_intensity_)

    interpolation_type = tvtk_base.RevPrefixMap({'nearest': 0, 'linear': 1}, default_value='nearest', desc=\
        r"""
        Set the interpolation type for sampling a volume. Initial value
        is VTK_NEAREST_INTERPOLATION.
        """
    )

    def _interpolation_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolationType,
                        self.interpolation_type_)

    ambient = traits.Float(0.1, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the ambient lighting coefficient.
        """
    )

    def _ambient_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAmbient,
                        self.ambient)

    clipped_voxel_intensity = traits.Float(-9.999999680285692e+37, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the intensity value for voxels in the clipped space for
        gradient computations (for shading and gradient based opacity
        modulation). By default, this is set to VTK_DOUBLE_MIN.
        
        ote This value is only used when use_clipped_voxel_intensity is
        true.
        
        ote This property is only used by the GPUVolumeRayCastMapper
        for now.
        \sa set_use_clipped_voxel_intensity
        """
    )

    def _clipped_voxel_intensity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClippedVoxelIntensity,
                        self.clipped_voxel_intensity)

    def get_component_weight(self, *args):
        """
        get_component_weight(self, index:int) -> float
        C++: virtual double get_component_weight(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetComponentWeight, *args)
        return ret

    def set_component_weight(self, *args):
        """
        set_component_weight(self, index:int, value:float) -> None
        C++: virtual void set_component_weight(int index, double value)
        Set/Get the scalar component weights. Clamped between the range
        of (0.0, 1.0)
        """
        ret = self._wrap_call(self._vtk_obj.SetComponentWeight, *args)
        return ret

    diffuse = traits.Float(0.7, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the diffuse lighting coefficient.
        """
    )

    def _diffuse_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDiffuse,
                        self.diffuse)

    def get_gradient_opacity(self, *args):
        """
        get_gradient_opacity(self, index:int) -> PiecewiseFunction
        C++: PiecewiseFunction *get_gradient_opacity(int index)
        get_gradient_opacity(self) -> PiecewiseFunction
        C++: PiecewiseFunction *get_gradient_opacity()
        Get the gradient magnitude opacity transfer function for the
        given component. If no transfer function has been set for this
        component, a default one is created and returned. This default
        function is always returned if disable_gradient_opacity is On for
        that component.
        """
        ret = self._wrap_call(self._vtk_obj.GetGradientOpacity, *args)
        return wrap_vtk(ret)

    def set_gradient_opacity(self, *args):
        """
        set_gradient_opacity(self, index:int, function:PiecewiseFunction)
             -> None
        C++: void set_gradient_opacity(int index,
            PiecewiseFunction *function)
        set_gradient_opacity(self, function:PiecewiseFunction) -> None
        C++: void set_gradient_opacity(PiecewiseFunction *function)
        Set the opacity of a volume to an opacity transfer function based
        on gradient magnitude for the given component.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetGradientOpacity, *my_args)
        return ret

    def get_label_color(self, *args):
        """
        get_label_color(self, label:int) -> ColorTransferFunction
        C++: ColorTransferFunction *get_label_color(int label)"""
        ret = self._wrap_call(self._vtk_obj.GetLabelColor, *args)
        return wrap_vtk(ret)

    def set_label_color(self, *args):
        """
        set_label_color(self, label:int, function:ColorTransferFunction)
            -> None
        C++: void set_label_color(int label,
            ColorTransferFunction *function)
        Set/Get the color transfer function for a label in the label map.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetLabelColor, *my_args)
        return ret

    def get_label_gradient_opacity(self, *args):
        """
        get_label_gradient_opacity(self, label:int) -> PiecewiseFunction
        C++: PiecewiseFunction *get_label_gradient_opacity(int label)"""
        ret = self._wrap_call(self._vtk_obj.GetLabelGradientOpacity, *args)
        return wrap_vtk(ret)

    def set_label_gradient_opacity(self, *args):
        """
        set_label_gradient_opacity(self, label:int,
            function:PiecewiseFunction) -> None
        C++: void set_label_gradient_opacity(int label,
            PiecewiseFunction *function)
        Set/Get the gradient opacity function for a label in the label
        map.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetLabelGradientOpacity, *my_args)
        return ret

    def get_label_scalar_opacity(self, *args):
        """
        get_label_scalar_opacity(self, label:int) -> PiecewiseFunction
        C++: PiecewiseFunction *get_label_scalar_opacity(int label)"""
        ret = self._wrap_call(self._vtk_obj.GetLabelScalarOpacity, *args)
        return wrap_vtk(ret)

    def set_label_scalar_opacity(self, *args):
        """
        set_label_scalar_opacity(self, label:int,
            function:PiecewiseFunction) -> None
        C++: void set_label_scalar_opacity(int label,
            PiecewiseFunction *function)
        Set/Get the opacity transfer function for a label in the label
        map.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetLabelScalarOpacity, *my_args)
        return ret

    def get_scalar_opacity(self, *args):
        """
        get_scalar_opacity(self, index:int) -> PiecewiseFunction
        C++: PiecewiseFunction *get_scalar_opacity(int index)
        get_scalar_opacity(self) -> PiecewiseFunction
        C++: PiecewiseFunction *get_scalar_opacity()
        Get the scalar opacity transfer function for the given component.
        If no transfer function has been set for this component, a
        default one is created and returned.
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarOpacity, *args)
        return wrap_vtk(ret)

    def set_scalar_opacity(self, *args):
        """
        set_scalar_opacity(self, index:int, function:PiecewiseFunction)
            -> None
        C++: void set_scalar_opacity(int index,
            PiecewiseFunction *function)
        set_scalar_opacity(self, function:PiecewiseFunction) -> None
        C++: void set_scalar_opacity(PiecewiseFunction *function)
        Set the opacity of a volume to an opacity transfer function based
        on scalar value for the component indicated by index.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetScalarOpacity, *my_args)
        return ret

    scalar_opacity_unit_distance = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the unit distance on which the scalar opacity transfer
        function is defined. By default this is 1.0, meaning that over a
        distance of 1.0 units, a given opacity (from the transfer
        function) is accumulated. This is adjusted for the actual
        sampling distance during rendering.
        """
    )

    def _scalar_opacity_unit_distance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarOpacityUnitDistance,
                        self.scalar_opacity_unit_distance)

    def _get_slice_function(self):
        return wrap_vtk(self._vtk_obj.GetSliceFunction())
    def _set_slice_function(self, arg):
        old_val = self._get_slice_function()
        self._wrap_call(self._vtk_obj.SetSliceFunction,
                        deref_vtk(arg))
        self.trait_property_changed('slice_function', old_val, arg)
    slice_function = traits.Property(_get_slice_function, _set_slice_function, desc=\
        r"""
        
        """
    )

    specular = traits.Float(0.2, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the specular lighting coefficient.
        """
    )

    def _specular_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpecular,
                        self.specular)

    specular_power = traits.Float(10.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the specular power.
        """
    )

    def _specular_power_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpecularPower,
                        self.specular_power)

    def get_transfer_function2d(self, *args):
        """
        get_transfer_function2d(self, index:int) -> ImageData
        C++: ImageData *get_transfer_function2d(int index)
        get_transfer_function2d(self) -> ImageData
        C++: ImageData *get_transfer_function2d()"""
        ret = self._wrap_call(self._vtk_obj.GetTransferFunction2D, *args)
        return wrap_vtk(ret)

    def set_transfer_function2d(self, *args):
        """
        set_transfer_function2d(self, index:int, function:ImageData)
            -> None
        C++: void set_transfer_function2d(int index, ImageData *function)
        set_transfer_function2d(self, function:ImageData) -> None
        C++: void set_transfer_function2d(ImageData *function)
        Set/Get a 2D transfer function. Volume mappers interpret the
        x-axis of of this transfer function as scalar value and the
        y-axis as gradient magnitude. The value at (X, Y) corresponds to
        the color and opacity for a salar value of X and a gradient
        magnitude of Y.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTransferFunction2D, *my_args)
        return ret

    transfer_function_mode = traits.Trait(0, traits.Range(0, 1, enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _transfer_function_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTransferFunctionMode,
                        self.transfer_function_mode)

    def _get_color_channels(self):
        return self._vtk_obj.GetColorChannels()
    color_channels = traits.Property(_get_color_channels, desc=\
        r"""
        Get the number of color channels in the transfer function for the
        given component.
        """
    )

    def get_color_channels(self, *args):
        """
        get_color_channels(self, index:int) -> int
        C++: int get_color_channels(int index)
        get_color_channels(self) -> int
        C++: int get_color_channels()
        Get the number of color channels in the transfer function for the
        given component.
        """
        ret = self._wrap_call(self._vtk_obj.GetColorChannels, *args)
        return ret

    def _get_gradient_opacity_m_time(self):
        return wrap_vtk(self._vtk_obj.GetGradientOpacityMTime())
    gradient_opacity_m_time = traits.Property(_get_gradient_opacity_m_time, desc=\
        r"""
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Get the
        time that the gradient opacity transfer function was set
        """
    )

    def get_gradient_opacity_m_time(self, *args):
        """
        get_gradient_opacity_m_time(self, index:int) -> TimeStamp
        C++: TimeStamp get_gradient_opacity_m_time(int index)
        get_gradient_opacity_m_time(self) -> TimeStamp
        C++: TimeStamp get_gradient_opacity_m_time()
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Get the
        time that the gradient opacity transfer function was set
        """
        ret = self._wrap_call(self._vtk_obj.GetGradientOpacityMTime, *args)
        return wrap_vtk(ret)

    def _get_gray_transfer_function(self):
        return wrap_vtk(self._vtk_obj.GetGrayTransferFunction())
    gray_transfer_function = traits.Property(_get_gray_transfer_function, desc=\
        r"""
        Get the gray transfer function. If no transfer function has been
        set for this component, a default one is created and returned.
        """
    )

    def get_gray_transfer_function(self, *args):
        """
        get_gray_transfer_function(self, index:int) -> PiecewiseFunction
        C++: PiecewiseFunction *get_gray_transfer_function(int index)
        get_gray_transfer_function(self) -> PiecewiseFunction
        C++: PiecewiseFunction *get_gray_transfer_function()
        Get the gray transfer function. If no transfer function has been
        set for this component, a default one is created and returned.
        """
        ret = self._wrap_call(self._vtk_obj.GetGrayTransferFunction, *args)
        return wrap_vtk(ret)

    def _get_gray_transfer_function_m_time(self):
        return wrap_vtk(self._vtk_obj.GetGrayTransferFunctionMTime())
    gray_transfer_function_m_time = traits.Property(_get_gray_transfer_function_m_time, desc=\
        r"""
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Get the
        time that the gray_transfer_function was set
        """
    )

    def get_gray_transfer_function_m_time(self, *args):
        """
        get_gray_transfer_function_m_time(self, index:int) -> TimeStamp
        C++: TimeStamp get_gray_transfer_function_m_time(int index)
        get_gray_transfer_function_m_time(self) -> TimeStamp
        C++: TimeStamp get_gray_transfer_function_m_time()
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Get the
        time that the gray_transfer_function was set
        """
        ret = self._wrap_call(self._vtk_obj.GetGrayTransferFunctionMTime, *args)
        return wrap_vtk(ret)

    def _get_independent_components_max_value(self):
        return self._vtk_obj.GetIndependentComponentsMaxValue()
    independent_components_max_value = traits.Property(_get_independent_components_max_value, desc=\
        r"""
        
        """
    )

    def _get_independent_components_min_value(self):
        return self._vtk_obj.GetIndependentComponentsMinValue()
    independent_components_min_value = traits.Property(_get_independent_components_min_value, desc=\
        r"""
        
        """
    )

    def _get_iso_surface_values(self):
        return wrap_vtk(self._vtk_obj.GetIsoSurfaceValues())
    iso_surface_values = traits.Property(_get_iso_surface_values, desc=\
        r"""
        Get contour values for isosurface blending mode. Do not affect
        other blending modes.
        """
    )

    def _get_label_color_m_time(self):
        return wrap_vtk(self._vtk_obj.GetLabelColorMTime())
    label_color_m_time = traits.Property(_get_label_color_m_time, desc=\
        r"""
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Get the
        time that label color transfer functions were set
        """
    )

    def _get_label_gradient_opacity_m_time(self):
        return wrap_vtk(self._vtk_obj.GetLabelGradientOpacityMTime())
    label_gradient_opacity_m_time = traits.Property(_get_label_gradient_opacity_m_time, desc=\
        r"""
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Get the
        time that label gradient opacity transfer functions were set
        """
    )

    def _get_label_scalar_opacity_m_time(self):
        return wrap_vtk(self._vtk_obj.GetLabelScalarOpacityMTime())
    label_scalar_opacity_m_time = traits.Property(_get_label_scalar_opacity_m_time, desc=\
        r"""
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Get the
        time that label scalar opacity transfer functions were set
        """
    )

    def _get_number_of_labels(self):
        return self._vtk_obj.GetNumberOfLabels()
    number_of_labels = traits.Property(_get_number_of_labels, desc=\
        r"""
        Get the number of labels that are provided with transfer
        functions using either set_label_color, set_label_scalar_opacity or
        set_label_gradient_opacity.
        """
    )

    def _get_rgb_transfer_function(self):
        return wrap_vtk(self._vtk_obj.GetRGBTransferFunction())
    rgb_transfer_function = traits.Property(_get_rgb_transfer_function, desc=\
        r"""
        Get the RGB transfer function for the given component. If no
        transfer function has been set for this component, a default one
        is created and returned.
        """
    )

    def get_rgb_transfer_function(self, *args):
        """
        get_rgb_transfer_function(self, index:int)
            -> ColorTransferFunction
        C++: ColorTransferFunction *get_rgb_transfer_function(int index)
        get_rgb_transfer_function(self) -> ColorTransferFunction
        C++: ColorTransferFunction *get_rgb_transfer_function()
        Get the RGB transfer function for the given component. If no
        transfer function has been set for this component, a default one
        is created and returned.
        """
        ret = self._wrap_call(self._vtk_obj.GetRGBTransferFunction, *args)
        return wrap_vtk(ret)

    def _get_rgb_transfer_function_m_time(self):
        return wrap_vtk(self._vtk_obj.GetRGBTransferFunctionMTime())
    rgb_transfer_function_m_time = traits.Property(_get_rgb_transfer_function_m_time, desc=\
        r"""
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Get the
        time that the RGBtransfer_function was set
        """
    )

    def get_rgb_transfer_function_m_time(self, *args):
        """
        get_rgb_transfer_function_m_time(self, index:int) -> TimeStamp
        C++: TimeStamp get_rgb_transfer_function_m_time(int index)
        get_rgb_transfer_function_m_time(self) -> TimeStamp
        C++: TimeStamp get_rgb_transfer_function_m_time()
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Get the
        time that the RGBtransfer_function was set
        """
        ret = self._wrap_call(self._vtk_obj.GetRGBTransferFunctionMTime, *args)
        return wrap_vtk(ret)

    def _get_scalar_opacity_m_time(self):
        return wrap_vtk(self._vtk_obj.GetScalarOpacityMTime())
    scalar_opacity_m_time = traits.Property(_get_scalar_opacity_m_time, desc=\
        r"""
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Get the
        time that the scalar opacity transfer function was set.
        """
    )

    def get_scalar_opacity_m_time(self, *args):
        """
        get_scalar_opacity_m_time(self, index:int) -> TimeStamp
        C++: TimeStamp get_scalar_opacity_m_time(int index)
        get_scalar_opacity_m_time(self) -> TimeStamp
        C++: TimeStamp get_scalar_opacity_m_time()
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE Get the
        time that the scalar opacity transfer function was set.
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarOpacityMTime, *args)
        return wrap_vtk(ret)

    def _get_stored_gradient_opacity(self):
        return wrap_vtk(self._vtk_obj.GetStoredGradientOpacity())
    stored_gradient_opacity = traits.Property(_get_stored_gradient_opacity, desc=\
        r"""
        
        """
    )

    def get_stored_gradient_opacity(self, *args):
        """
        get_stored_gradient_opacity(self, index:int) -> PiecewiseFunction
        C++: PiecewiseFunction *get_stored_gradient_opacity(int index)
        get_stored_gradient_opacity(self) -> PiecewiseFunction
        C++: PiecewiseFunction *get_stored_gradient_opacity()"""
        ret = self._wrap_call(self._vtk_obj.GetStoredGradientOpacity, *args)
        return wrap_vtk(ret)

    def deep_copy(self, *args):
        """
        deep_copy(self, p:VolumeProperty) -> None
        C++: void deep_copy(VolumeProperty *p)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def has_gradient_opacity(self, *args):
        """
        has_gradient_opacity(self, index:int=0) -> bool
        C++: bool has_gradient_opacity(int index=0)
        Check whether or not we have the gradient opacity. Checking
        gradient opacity via get_disable_gradient_opacity or
        get_gradient_opacity will not work as in the former case, 
        get_disable_gradient_opacity returns false by default and in the
        later case, a default gradient opacity will be created.
        """
        ret = self._wrap_call(self._vtk_obj.HasGradientOpacity, *args)
        return ret

    def has_label_gradient_opacity(self):
        """
        has_label_gradient_opacity(self) -> bool
        C++: bool has_label_gradient_opacity()"""
        ret = self._vtk_obj.HasLabelGradientOpacity()
        return ret
        

    def set_color(self, *args):
        """
        set_color(self, index:int, function:PiecewiseFunction) -> None
        C++: void set_color(int index, PiecewiseFunction *function)
        set_color(self, function:PiecewiseFunction) -> None
        C++: void set_color(PiecewiseFunction *function)
        set_color(self, index:int, function:ColorTransferFunction)
            -> None
        C++: void set_color(int index, ColorTransferFunction *function)
        set_color(self, function:ColorTransferFunction) -> None
        C++: void set_color(ColorTransferFunction *function)
        Set the color of a volume to a gray level transfer function for
        the component indicated by index. This will set the color
        channels for this component to 1.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetColor, *my_args)
        return ret

    def update_m_times(self):
        """
        update_m_times(self) -> None
        C++: void update_m_times()
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE
        update_m_times performs a Modified() on all time_stamps. This is
        used by Volume when the property is set, so that any other
        object that might have been caching information for the property
        will rebuild.
        """
        ret = self._vtk_obj.UpdateMTimes()
        return ret
        

    _updateable_traits_ = \
    (('disable_gradient_opacity', 'GetDisableGradientOpacity'),
    ('independent_components', 'GetIndependentComponents'), ('shade',
    'GetShade'), ('use_clipped_voxel_intensity',
    'GetUseClippedVoxelIntensity'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('interpolation_type', 'GetInterpolationType'), ('ambient',
    'GetAmbient'), ('clipped_voxel_intensity',
    'GetClippedVoxelIntensity'), ('diffuse', 'GetDiffuse'),
    ('scalar_opacity_unit_distance', 'GetScalarOpacityUnitDistance'),
    ('specular', 'GetSpecular'), ('specular_power', 'GetSpecularPower'),
    ('transfer_function_mode', 'GetTransferFunctionMode'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'disable_gradient_opacity', 'global_warning_display',
    'independent_components', 'shade', 'use_clipped_voxel_intensity',
    'interpolation_type', 'ambient', 'clipped_voxel_intensity', 'diffuse',
    'scalar_opacity_unit_distance', 'specular', 'specular_power',
    'transfer_function_mode'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VolumeProperty, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VolumeProperty properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['disable_gradient_opacity', 'independent_components', 'shade',
            'use_clipped_voxel_intensity'], ['interpolation_type'], ['ambient',
            'clipped_voxel_intensity', 'diffuse', 'scalar_opacity_unit_distance',
            'specular', 'specular_power', 'transfer_function_mode']),
            title='Edit VolumeProperty properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VolumeProperty properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

