# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class Texture(ImageAlgorithm):
    r"""
    Texture - handles properties associated with a texture map
    
    Superclass: ImageAlgorithm
    
    Texture is an image algorithm that handles loading and binding of
    texture maps. It obtains its data from an input image data dataset
    type. Thus you can create visualization pipelines to read, process,
    and construct textures. Note that textures will only work if texture
    coordinates are also defined, and if the rendering system supports
    texture.
    
    Instances of Texture are associated with actors via the actor's
    set_texture() method. Actors can share texture maps (this is
    encouraged to save memory resources.)
    
    @warning
    Currently only 2D texture maps are supported, even though the data
    pipeline supports 1,2, and 3D texture coordinates.
    
    @warning
    Some renderers such as old open_gl require that the texture map
    dimensions are a power of two in each direction. If a non-power of
    two texture map is used, it is automatically resampled to a power of
    two in one or more directions, at the cost of an expensive
    computation. If the open_gl implementation is recent enough
    (open_gl>=2.0 or extension GL_ARB_texture_non_power_of_two exists)
    there is no such restriction and no extra computational cost.
    @sa
    Actor Renderer OpenGLTexture
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTexture, obj, update, **traits)
    
    cube_map = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _cube_map_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCubeMap,
                        self.cube_map_)

    edge_clamp = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _edge_clamp_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeClamp,
                        self.edge_clamp_)

    interpolate = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _interpolate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolate,
                        self.interpolate_)

    mipmap = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _mipmap_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMipmap,
                        self.mipmap_)

    premultiplied_alpha = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _premultiplied_alpha_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPremultipliedAlpha,
                        self.premultiplied_alpha_)

    repeat = tvtk_base.true_bool_trait(desc=\
        r"""
        Convenience functions to maintain backwards compatibility. For
        new code, use the set_wrap API.
        """
    )

    def _repeat_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRepeat,
                        self.repeat_)

    restrict_power_of2_image_smaller = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _restrict_power_of2_image_smaller_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRestrictPowerOf2ImageSmaller,
                        self.restrict_power_of2_image_smaller_)

    use_srgb_color_space = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _use_srgb_color_space_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseSRGBColorSpace,
                        self.use_srgb_color_space_)

    color_mode = tvtk_base.RevPrefixMap({'default': 0, 'direct_scalars': 2, 'map_scalars': 1}, default_value='default', desc=\
        r"""
        Default: color_mode_to_default. unsigned char scalars are treated as
        colors, and NOT mapped through the lookup table (set with
        set_lookup_table), while other kinds of scalars are.
        color_mode_to_direct_scalar extends color_mode_to_default such that all
        integer types are treated as colors with values in the range
        0-255 and floating types are treated as colors with values in the
        range 0.0-1.0. Setting color_mode_to_map_scalars means that all
        scalar data will be mapped through the lookup table.
        """
    )

    def _color_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColorMode,
                        self.color_mode_)

    quality = tvtk_base.RevPrefixMap({'default': 0, '16_bit': 16, '32_bit': 32}, default_value='default', desc=\
        r"""
        Force texture quality to 16-bit or 32-bit. This might not be
        supported on all machines.
        """
    )

    def _quality_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetQuality,
                        self.quality_)

    blending_mode = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _blending_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBlendingMode,
                        self.blending_mode)

    border_color = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.0, 0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Border Color (RGBA). The values can be any valid float value, if
        the gpu supports it. Initial value is (0.0f, 0.0f, 0.0f, 0.0f),
        as in the open_gl spec.
        
        ote This property is ignored for open_gl ES <= 3.2
        """
    )

    def _border_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBorderColor,
                        self.border_color)

    def _get_lookup_table(self):
        return wrap_vtk(self._vtk_obj.GetLookupTable())
    def _set_lookup_table(self, arg):
        old_val = self._get_lookup_table()
        self._wrap_call(self._vtk_obj.SetLookupTable,
                        deref_vtk(arg))
        self.trait_property_changed('lookup_table', old_val, arg)
    lookup_table = traits.Property(_get_lookup_table, _set_lookup_table, desc=\
        r"""
        
        """
    )

    maximum_anisotropic_filtering = traits.Float(4.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the maximum anisotropic filtering to use. 1.0 means use
        no anisotropic filtering. The default value is 4.0 and a high
        value would be 16. This setting is only applied when mipmaps are
        used. This might not be supported on all machines.
        """
    )

    def _maximum_anisotropic_filtering_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumAnisotropicFiltering,
                        self.maximum_anisotropic_filtering)

    def _get_transform(self):
        return wrap_vtk(self._vtk_obj.GetTransform())
    def _set_transform(self, arg):
        old_val = self._get_transform()
        self._wrap_call(self._vtk_obj.SetTransform,
                        deref_vtk(arg))
        self.trait_property_changed('transform', old_val, arg)
    transform = traits.Property(_get_transform, _set_transform, desc=\
        r"""
        
        """
    )

    wrap = traits.Trait(1, traits.Range(0, 3, enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _wrap_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWrap,
                        self.wrap)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input as a ImageData object.  This method is for
        backwards compatibility.
        """
    )

    def _get_mapped_scalars(self):
        return wrap_vtk(self._vtk_obj.GetMappedScalars())
    mapped_scalars = traits.Property(_get_mapped_scalars, desc=\
        r"""
        Get Mapped Scalars
        """
    )

    def _get_texture_unit(self):
        return self._vtk_obj.GetTextureUnit()
    texture_unit = traits.Property(_get_texture_unit, desc=\
        r"""
        Return the texture unit used for this texture
        """
    )

    def is_translucent(self):
        """
        is_translucent(self) -> int
        C++: virtual int is_translucent()
        Is this Texture Translucent? returns false (0) if the texture is
        either fully opaque or has only fully transparent pixels and
        fully opaque pixels and the Interpolate flag is turn off.
        """
        ret = self._vtk_obj.IsTranslucent()
        return ret
        

    def load(self, *args):
        """
        load(self, __a:Renderer) -> None
        C++: virtual void load(Renderer *)
        Abstract interface to renderer. Each concrete subclass of
        Texture will load its data into graphics system in response to
        this method invocation.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Load, *my_args)
        return ret

    def map_scalars_to_colors(self, *args):
        """
        map_scalars_to_colors(self, scalars:DataArray) -> Pointer
        C++: unsigned char *map_scalars_to_colors(DataArray *scalars)
        Map scalar values into color scalars.
        """
        my_args = deref_array(args, [['vtkDataArray']])
        ret = self._wrap_call(self._vtk_obj.MapScalarsToColors, *my_args)
        return ret

    def post_render(self, *args):
        """
        post_render(self, __a:Renderer) -> None
        C++: virtual void post_render(Renderer *)
        Cleans up after the texture rendering to restore the state of the
        graphics context.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PostRender, *my_args)
        return ret

    def release_graphics_resources(self, *args):
        """
        release_graphics_resources(self, __a:Window) -> None
        C++: virtual void release_graphics_resources(Window *)
        Release any graphics resources that are being consumed by this
        texture. The parameter window could be used to determine which
        graphic resources to release.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def render(self, *args):
        """
        render(self, ren:Renderer) -> None
        C++: virtual void render(Renderer *ren)
        Renders a texture map. It first checks the object's modified time
        to make sure the texture maps Input is valid, then it invokes the
        Load() method.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Render, *my_args)
        return ret

    _updateable_traits_ = \
    (('cube_map', 'GetCubeMap'), ('edge_clamp', 'GetEdgeClamp'),
    ('interpolate', 'GetInterpolate'), ('mipmap', 'GetMipmap'),
    ('premultiplied_alpha', 'GetPremultipliedAlpha'), ('repeat',
    'GetRepeat'), ('restrict_power_of2_image_smaller',
    'GetRestrictPowerOf2ImageSmaller'), ('use_srgb_color_space',
    'GetUseSRGBColorSpace'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('color_mode',
    'GetColorMode'), ('quality', 'GetQuality'), ('blending_mode',
    'GetBlendingMode'), ('border_color', 'GetBorderColor'),
    ('maximum_anisotropic_filtering', 'GetMaximumAnisotropicFiltering'),
    ('wrap', 'GetWrap'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'cube_map', 'debug', 'edge_clamp',
    'global_warning_display', 'interpolate', 'mipmap',
    'premultiplied_alpha', 'release_data_flag', 'repeat',
    'restrict_power_of2_image_smaller', 'use_srgb_color_space',
    'color_mode', 'quality', 'blending_mode', 'border_color',
    'maximum_anisotropic_filtering', 'progress_text', 'wrap'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Texture, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Texture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['cube_map', 'edge_clamp', 'interpolate', 'mipmap',
            'premultiplied_alpha', 'repeat', 'restrict_power_of2_image_smaller',
            'use_srgb_color_space'], ['color_mode', 'quality'], ['blending_mode',
            'border_color', 'maximum_anisotropic_filtering', 'wrap']),
            title='Edit Texture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Texture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

