# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.hyper_tree_grid_algorithm import HyperTreeGridAlgorithm


class HyperTreeGridAxisReflection(HyperTreeGridAlgorithm):
    r"""
    HyperTreeGridAxisReflection - Reflect a hyper tree grid
    
    Superclass: HyperTreeGridAlgorithm
    
    This filter reflect the cells of a hyper tree grid with respect to
    one of the planes parallel to the bounding box of the data set.
    
    @sa
    HyperTreeGrid HyperTreeGridAlgorithm ReflectionFilter
    
    @par Thanks: This class was written by Philippe Pebay based on a idea
    of Guenole Harel and Jacques-Bernard Lekien, 2016 This work was
    supported by Commissariat a l'Energie Atomique (CEA/DIF)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridAxisReflection, obj, update, **traits)
    
    plane = tvtk_base.RevPrefixMap({'x_min': 0, 'x': 6, 'x_max': 3, 'y': 7, 'y_max': 4, 'y_min': 1, 'z': 8, 'z_max': 5, 'z_min': 2}, default_value='x_min', desc=\
        r"""
        Set the normal of the plane to use as mirror.
        """
    )

    def _plane_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPlane,
                        self.plane_)

    center = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        If the reflection plane is set to X, Y or Z, this variable is use
        to set the position of the plane.
        """
    )

    def _center_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCenter,
                        self.center)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('plane',
    'GetPlane'), ('center', 'GetCenter'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'plane', 'center', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridAxisReflection, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridAxisReflection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['plane'], ['center']),
            title='Edit HyperTreeGridAxisReflection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridAxisReflection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

