// Copyright 2026 Filippo Rusconi
// Inspired by code in OpenMS, by Lars Nilse

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QList>
#include <QMap>

/////////////////////// pappsomspp includes
#include "pappsomspp/core/trace/trace.h"


/////////////////////// Local includes
#include "pappsomspp/export-import-config.h"

namespace pappso
{


class PMSPP_LIB_DECL HighResPeakPicker
{

  public:
  struct Parameters
  {
    double signalToNoise       = 0.8;
    qsizetype missingPeakCount = 0;
  };

  HighResPeakPicker(Parameters &parameters);
  virtual ~HighResPeakPicker();

  struct PeakRange
  {
    double mz_start;
    double mz_stop;
  };

  void pick(const Trace &trace, Trace &picked_peaks, QList<PeakRange> &peak_ranges);

  protected:
  Parameters m_parameters;
};


} // namespace pappso
