#include "test.h"

#include "config.h"

TEST_CASE("config settings missing") {
	Config* conf = Config::_();
	CHECK(conf->get("key").empty());
}

TEST_CASE("config settings present") {
	Config* conf = Config::_();
	conf->set("key1", "value1");
	conf->set("key2", "value2");
	CHECK(conf->get("key").empty());
	CHECK(conf->get("key1") == "value1");
	CHECK(conf->get("key2") == "value2");
}

TEST_CASE("config boolean") {
	Config* conf = Config::_();
	conf->flag_on("btrue");
	conf->flag_off("bfalse");

	CHECK(conf->flag("btrue"));
	CHECK(!conf->flag("bfalse"));
	CHECK(!conf->flag("bmissing"));
	conf->flag_toggle("btrue");
	conf->flag_toggle("bfalse");
	CHECK(!conf->flag("btrue"));
	CHECK(conf->flag("bfalse"));
	CHECK(!conf->flag("bmissing"));
}
