// License: GPL. For details, see Readme.txt file.
package org.openstreetmap.gui.jmapviewer;

/**
 * A {@link RuntimeException} specific to JMapViewer
 * @since JMapViewer 2.20
 */
public class JMapViewerRuntimeException extends RuntimeException {

    /**
     * Create a new exception without a specified cause or message
     * @see Exception#Exception()
     */
    public JMapViewerRuntimeException() {
        super();
    }

    /**
     * Create a new exception with a message
     * @param message The message for the exception
     * @see Exception#Exception(String)
     */
    public JMapViewerRuntimeException(String message) {
        super(message);
    }

    /**
     * Create a new message with a given message and cause
     * @param message The message for the exception
     * @param cause The cause of the exception
     * @see Exception#Exception(String, Throwable)
     */
    public JMapViewerRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new exception with the specified cause
     *
     * @param cause the cause of the exception
     * @see Exception#Exception(Throwable)
     */
    public JMapViewerRuntimeException(Throwable cause) {
        super(cause);
    }
}
