 /***************************************************************************
 KFReader.h - Implementation of KFReader library for handling ADF binary file
              format, the so-called KF-files. The current version supports only 
              reading KF files. 
              Even though the binary files are system-dependent, they are 
              converted on the fly and the caller routine gets the data in the
              native format.

 Copyright (C) 2006-2023 by Software for Chemistry & Materials B.V.
 For support, contact support at scm . com
 
 This file is part of the ADF software
 For more information, see <http://www.scm.com>
   
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation version 3 of the License.
   
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 SCM owns the intellectual property right for this file and reserves the 
 right to distrbute it under a license other than LGPL
 ****************************************************************************/
#include <ADF_KFc.h>

#include <stdlib.h>
/* JC Only Unix version
#ifdef _MSC_VER
#include <io.h>
#else*/
#include <unistd.h>
//#endif
#include <stdio.h>
#include <fcntl.h>
#include <string.h>

/* (de-)initializers */

/*static KFVariable *createKFVariable (KFSection *sec, const char* name, int lbl, int dex, int len, int fln, int usd, int typ);
static void deleteKFVariable(KFVariable *var);
static KFSection *createKFSection (KFFile *kf, const char *name, int phBlk, int logBlk, int numBlks);
static void deleteKFSection(KFSection *sec);
static KFBlockRun *createKFBlockRun(int phBlk, int logBlk, int numBlks);
static void deleteKFBlockRun(KFBlockRun *br);*/

/* Functions for KFVariable */
/*static int getPhysicalBlockNumber(KFVariable *var);
  static int getPhysicalBlockNumberForLogical(KFVariable *var, int logBlock);*/


// JC add non static declaration
void        ADF_getVariableFromName(const char *complexName, char *varName);
void        ADF_getSectionFromName(const char *complexName, char *secName);
int         ADF_sectionsComparator(const void *secName, const void *sec);
KFSection*  ADF_findSection(KFFile *kf, const char *name);
int         ADF_variablesNamesComparator(const void *varName, const void *var);
KFVariable* ADF_findVariableInSection(const KFSection *sec, const char *name);
KFVariable* ADF_findVariable(KFFile *kf, const char *name);
int         ADF_getKFVariableLength(KFFile *kf, const char *name);
void        ADF_addDataBlockRun (KFSection *sec, int phBlk, int logBlk, int numBlks);
void        ADF_getDataBlockFromSuperEntry(KFFile *kf, void *buf);
void        ADF_parseIndexEntry(KFSection *sec, KFFile *kf, void *buf);
void        ADF_parseIndexBlock(KFSection *sec, KFFile *kf, void *buf);
void        ADF_swapBytes(char *d, int size);
void        ADF_swapNBytes(char *p, int size, int count);
void        ADF_swapBytesIndexBlock(KFFile *kf, char *buf);
void        ADF_addIndexBlockRun (KFSection *sec, int phBlk, int logBlk, int numBlks);
void        ADF_getSectionFromSuperEntry(KFFile *kf, void *buf);
int         ADF_readBlock(int fd, void *buf, int block);
void        ADF_swapBytesSuperIndexBlock(KFFile *kf, char *buf);
void        ADF_initialize(KFFile *kf, void *buf);
int         ADF_guessIntegerSize(void *buf);
int         ADF_guessByteOrder(void *buf, int size);
int         ADF_openKFFile(KFFile *kf, const char *name);
int         ADF_verifySuperIndex(void *buf);
void        ADF_closeKFFile (KFFile *kf);
int         ADF_getKFVariableUsedLength(KFFile *kf, const char *name);
int         ADF_getKFData(KFFile *kf, const char *name, void *buf);
int         ADF_getKFVariableData(KFVariable *var, void *buf);
int         ADF_getKFVariableType(KFFile *kf, const char *name);
int         ADF_calculateDataOffset(KFVariable *var, void* data, int firstBlock) ;
int         ADF_calculateDataSize(KFVariable *var, void *data, int firstBlock);
KFVariable* ADF_createKFVariable (KFSection *sec, const char *name, int lbl, int dex, int len, int fln, int usd, int typ);
void        ADF_deleteKFVariable (KFVariable *var);
int         ADF_getPhysicalBlockNumber(KFVariable *var);
int         ADF_getPhysicalBlockNumberForLogical(KFVariable *var, int logBlock);
KFSection*  ADF_createKFSection (KFFile *kf, const char *name, int phBlk, int logBlk, int numBlks);
void        ADF_deleteKFSection(KFSection *sec);
KFBlockRun* ADF_createKFBlockRun(int phBlk, int logBlk, int numBlks);
void        ADF_deleteKFBlockRun(KFBlockRun *br);
int         ADF_getHostByteOrder();
int         ADF_isValidKFFile(const char* fname);

int         ADF_primtype(int kx, int ky, int kz);
