// Copyright (C) 2000-2007, Luca Padovani <padovani@sti.uniurb.it>.
// 
// This file is part of GtkMathView, a flexible, high-quality rendering
// engine for MathML documents.
// 
// GtkMathView is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "TFM.hh"

static TFM::Font font = {
"CMBX",

  0xf4,
  "TeX text",
  0x00500000,
  0xab2d8c68,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00000000 },
  { 0x02, "space", 0x0008443a },
  { 0x03, "space_stretch", 0x0003ddda },
  { 0x04, "space_shrink", 0x000293e6 },
  { 0x05, "x_height", 0x00071c73 },
  { 0x06, "quad", 0x00184426 },
  { 0x07, "extra_space", 0x000293e6 }
};


static TFM::Kerning C_0b_Kerning[] = {
  { 0x21, 0x000213ea },
  { 0x27, 0x000213ea },
  { 0x29, 0x000213ea },
  { 0x3f, 0x000213ea },
  { 0x5d, 0x000213ea }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x4c, 0xfff81c7d },
  { 0x6c, 0xfff905ba }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x21, 0x000293e6 },
  { 0x3f, 0x000293e6 }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x43, 0xffff5b06 },
  { 0x47, 0xffff5b06 },
  { 0x4f, 0xffff5b06 },
  { 0x51, 0xffff5b06 },
  { 0x54, 0xfffe1113 },
  { 0x55, 0xffff5b06 },
  { 0x56, 0xfffd6c1a },
  { 0x57, 0xfffd6c1a },
  { 0x59, 0xfffe1113 },
  { 0x74, 0xffff5b06 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x41, 0xffff5b06 },
  { 0x56, 0xffff5b06 },
  { 0x57, 0xffff5b06 },
  { 0x58, 0xffff5b06 },
  { 0x59, 0xffff5b06 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x41, 0xfffd6c1a },
  { 0x43, 0xffff5b06 },
  { 0x47, 0xffff5b06 },
  { 0x4f, 0xffff5b06 },
  { 0x51, 0xffff5b06 },
  { 0x61, 0xfffe1113 },
  { 0x65, 0xfffe1113 },
  { 0x6f, 0xfffe1113 },
  { 0x72, 0xfffe1113 },
  { 0x75, 0xfffe1113 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x49, 0x0000a4fa }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x43, 0xffff5b06 },
  { 0x47, 0xffff5b06 },
  { 0x4f, 0xffff5b06 },
  { 0x51, 0xffff5b06 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x54, 0xfffe1113 },
  { 0x56, 0xfffd6c1a },
  { 0x57, 0xfffd6c1a },
  { 0x59, 0xfffe1113 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x41, 0xffff5b06 },
  { 0x56, 0xffff5b06 },
  { 0x57, 0xffff5b06 },
  { 0x58, 0xffff5b06 },
  { 0x59, 0xffff5b06 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x2c, 0xfffe1113 },
  { 0x2e, 0xfffe1113 },
  { 0x41, 0xfffe1113 },
  { 0x61, 0xffff5b06 },
  { 0x65, 0xffff5b06 },
  { 0x6f, 0xffff5b06 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x43, 0xffff5b06 },
  { 0x47, 0xffff5b06 },
  { 0x4f, 0xffff5b06 },
  { 0x51, 0xffff5b06 },
  { 0x54, 0xfffe1113 },
  { 0x55, 0xffff5b06 },
  { 0x56, 0xfffd6c1a },
  { 0x57, 0xfffd6c1a },
  { 0x59, 0xfffe1113 },
  { 0x74, 0xffff5b06 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x41, 0xfffe1113 },
  { 0x61, 0xfffe1113 },
  { 0x65, 0xfffe1113 },
  { 0x6f, 0xfffe1113 },
  { 0x72, 0xfffe1113 },
  { 0x75, 0xfffe1113 },
  { 0x79, 0xffff5b06 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x41, 0xfffd6c1a },
  { 0x43, 0xffff5b06 },
  { 0x47, 0xffff5b06 },
  { 0x4f, 0xffff5b06 },
  { 0x51, 0xffff5b06 },
  { 0x61, 0xfffe1113 },
  { 0x65, 0xfffe1113 },
  { 0x6f, 0xfffe1113 },
  { 0x72, 0xfffe1113 },
  { 0x75, 0xfffe1113 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x41, 0xfffd6c1a },
  { 0x43, 0xffff5b06 },
  { 0x47, 0xffff5b06 },
  { 0x4f, 0xffff5b06 },
  { 0x51, 0xffff5b06 },
  { 0x61, 0xfffe1113 },
  { 0x65, 0xfffe1113 },
  { 0x6f, 0xfffe1113 },
  { 0x72, 0xfffe1113 },
  { 0x75, 0xfffe1113 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x43, 0xffff5b06 },
  { 0x47, 0xffff5b06 },
  { 0x4f, 0xffff5b06 },
  { 0x51, 0xffff5b06 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x41, 0xfffe1113 },
  { 0x61, 0xfffe1113 },
  { 0x65, 0xfffe1113 },
  { 0x6f, 0xfffe1113 },
  { 0x72, 0xfffe1113 },
  { 0x75, 0xfffe1113 }
};

static TFM::Kerning C_61_Kerning[] = {
  { 0x6a, 0x000149f3 },
  { 0x76, 0xffff5b06 },
  { 0x77, 0xffff5b06 },
  { 0x79, 0xffff5b06 }
};

static TFM::Kerning C_62_Kerning[] = {
  { 0x63, 0x0000a4fa },
  { 0x64, 0x0000a4fa },
  { 0x65, 0x0000a4fa },
  { 0x6a, 0x000149f3 },
  { 0x6f, 0x0000a4fa },
  { 0x71, 0x0000a4fa },
  { 0x76, 0xffff5b06 },
  { 0x77, 0xffff5b06 },
  { 0x78, 0xffff5b06 },
  { 0x79, 0xffff5b06 }
};

static TFM::Kerning C_63_Kerning[] = {
  { 0x68, 0xffff5b06 },
  { 0x6b, 0xffff5b06 }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x21, 0x000213ea },
  { 0x27, 0x000213ea },
  { 0x29, 0x000213ea },
  { 0x3f, 0x000213ea },
  { 0x5d, 0x000213ea }
};

static TFM::Kerning C_67_Kerning[] = {
  { 0x6a, 0x0000a4fa }
};

static TFM::Kerning C_68_Kerning[] = {
  { 0x62, 0xffff5b06 },
  { 0x74, 0xffff5b06 },
  { 0x75, 0xffff5b06 },
  { 0x76, 0xffff5b06 },
  { 0x77, 0xffff5b06 },
  { 0x79, 0xffff5b06 }
};

static TFM::Kerning C_6b_Kerning[] = {
  { 0x61, 0xfffeb60d },
  { 0x61, 0xffff5b06 },
  { 0x63, 0xffff5b06 },
  { 0x65, 0xffff5b06 },
  { 0x6f, 0xffff5b06 }
};

static TFM::Kerning C_6d_Kerning[] = {
  { 0x62, 0xffff5b06 },
  { 0x74, 0xffff5b06 },
  { 0x75, 0xffff5b06 },
  { 0x76, 0xffff5b06 },
  { 0x77, 0xffff5b06 },
  { 0x79, 0xffff5b06 }
};

static TFM::Kerning C_6e_Kerning[] = {
  { 0x62, 0xffff5b06 },
  { 0x74, 0xffff5b06 },
  { 0x75, 0xffff5b06 },
  { 0x76, 0xffff5b06 },
  { 0x77, 0xffff5b06 },
  { 0x79, 0xffff5b06 }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x63, 0x0000a4fa },
  { 0x64, 0x0000a4fa },
  { 0x65, 0x0000a4fa },
  { 0x6a, 0x000149f3 },
  { 0x6f, 0x0000a4fa },
  { 0x71, 0x0000a4fa },
  { 0x76, 0xffff5b06 },
  { 0x77, 0xffff5b06 },
  { 0x78, 0xffff5b06 },
  { 0x79, 0xffff5b06 }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x63, 0x0000a4fa },
  { 0x64, 0x0000a4fa },
  { 0x65, 0x0000a4fa },
  { 0x6a, 0x000149f3 },
  { 0x6f, 0x0000a4fa },
  { 0x71, 0x0000a4fa },
  { 0x76, 0xffff5b06 },
  { 0x77, 0xffff5b06 },
  { 0x78, 0xffff5b06 },
  { 0x79, 0xffff5b06 }
};

static TFM::Kerning C_74_Kerning[] = {
  { 0x77, 0xffff5b06 },
  { 0x79, 0xffff5b06 }
};

static TFM::Kerning C_75_Kerning[] = {
  { 0x77, 0xffff5b06 }
};

static TFM::Kerning C_76_Kerning[] = {
  { 0x61, 0xfffeb60d },
  { 0x61, 0xffff5b06 },
  { 0x63, 0xffff5b06 },
  { 0x65, 0xffff5b06 },
  { 0x6f, 0xffff5b06 }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x61, 0xffff5b06 },
  { 0x63, 0xffff5b06 },
  { 0x65, 0xffff5b06 },
  { 0x6f, 0xffff5b06 }
};

static TFM::Kerning C_79_Kerning[] = {
  { 0x2c, 0xfffe1113 },
  { 0x2e, 0xfffe1113 },
  { 0x61, 0xffff5b06 },
  { 0x65, 0xffff5b06 },
  { 0x6f, 0xffff5b06 }
};

static TFM::Ligature C_0b_Ligature[] = {
  { 0x69, 0x00, 0x0e },
  { 0x6c, 0x00, 0x0f }
};

static TFM::Ligature C_21_Ligature[] = {
  { 0x60, 0x00, 0x3c }
};

static TFM::Ligature C_27_Ligature[] = {
  { 0x27, 0x00, 0x22 }
};

static TFM::Ligature C_2d_Ligature[] = {
  { 0x2d, 0x00, 0x7b }
};

static TFM::Ligature C_3f_Ligature[] = {
  { 0x60, 0x00, 0x3e }
};

static TFM::Ligature C_60_Ligature[] = {
  { 0x60, 0x00, 0x5c }
};

static TFM::Ligature C_66_Ligature[] = {
  { 0x66, 0x00, 0x0b },
  { 0x69, 0x00, 0x0c },
  { 0x6c, 0x00, 0x0d }
};

static TFM::Ligature C_7b_Ligature[] = {
  { 0x2d, 0x00, 0x7c }
};


static TFM::Character character[] = {
  { 0x00, 0x000e5af3, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x0013ddc6, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x001293d3, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x00108873, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000fffed, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x001271b0, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x001149e0, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x001293d3, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x001149e0, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x001293d3, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x001149e0, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x000e9986, 0x000b1c73, 0x00000000, 0x000213ea, 5, C_0b_Kerning, 2, C_0b_Ligature },
  { 0x0c, 0x000df48d, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x000df48d, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x0014eed3, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x0014eed3, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x0006fa46, 0x00071c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x00079f40, 0x00071c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x000c2213, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x000c2213, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x000c2213, 0x000a1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x000c2213, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x000c2213, 0x0009d950, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x0011d266, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x000ad820, 0x00000000, 0x0002b8e6, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x000c332d, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x001149e0, 0x00071c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x001293d3, 0x00071c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x000c2213, 0x0008aaad, 0x00018e3a, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x00156bfd, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x0017ffe3, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x001293d3, 0x000bc16d, 0x0000c71d, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x0006fa46, 0x00071c73, 0x00000000, 0x00000000, 2, C_20_Kerning, 0, 0 },
  { 0x21, 0x00079990, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 1, C_21_Ligature },
  { 0x22, 0x000c4f9a, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x0013ddc6, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x000c2213, 0x000c0000, 0x0000e38d, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x0013ddc6, 0x000c0000, 0x0000e38d, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x001293d3, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x0006fa46, 0x000b1c73, 0x00000000, 0x00000000, 2, C_27_Kerning, 1, C_27_Ligature },
  { 0x28, 0x00098e2d, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x00098e2d, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x000c2213, 0x000c0000, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x001293d3, 0x000bbbb3, 0x0003bbb3, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x0006fa46, 0x0002c16d, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x0008443a, 0x00071c73, 0x00000000, 0x00000000, 0, 0, 1, C_2d_Ligature },
  { 0x2e, 0x0006fa46, 0x0002c16d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x000c2213, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x000c2213, 0x000a4fa6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x000c2213, 0x000a4fa6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x000c2213, 0x000a4fa6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x000c2213, 0x000a4fa6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x000c2213, 0x000a4fa6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x000c2213, 0x000a4fa6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x000c2213, 0x000a4fa6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x000c2213, 0x000a4fa6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x000c2213, 0x000a4fa6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x000c2213, 0x000a4fa6, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x0006fa46, 0x00071c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x0006fa46, 0x00071c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x00079990, 0x00080000, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x001293d3, 0x0006d243, 0xfffed243, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x000b7d1a, 0x00080000, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x000b7d1a, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 1, C_3f_Ligature },
  { 0x40, 0x001293d3, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x0011d266, 0x000afa50, 0x00000000, 0x00000000, 10, C_41_Kerning, 0, 0 },
  { 0x42, 0x0010e92a, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x43, 0x001149e0, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x44, 0x0012331d, 0x000afa50, 0x00000000, 0x00000000, 5, C_44_Kerning, 0, 0 },
  { 0x45, 0x000fa4e6, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x46, 0x000effed, 0x000afa50, 0x00000000, 0x00000000, 10, C_46_Kerning, 0, 0 },
  { 0x47, 0x0012b5f6, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x48, 0x001271b0, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x49, 0x0008ccc0, 0x000afa50, 0x00000000, 0x00000000, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x000c6656, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4b, 0x00127760, 0x000afa50, 0x00000000, 0x00000000, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000e5af3, 0x000afa50, 0x00000000, 0x00000000, 4, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x00164f8a, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4e, 0x001271b0, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4f, 0x0011f48a, 0x000afa50, 0x00000000, 0x00000000, 5, C_4f_Kerning, 0, 0 },
  { 0x50, 0x00104430, 0x000afa50, 0x00000000, 0x00000000, 6, C_50_Kerning, 0, 0 },
  { 0x51, 0x0011f48a, 0x000afa50, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x52, 0x0011a4e6, 0x000afa50, 0x00000000, 0x00000000, 10, C_52_Kerning, 0, 0 },
  { 0x53, 0x000d6c06, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x54, 0x0010aa96, 0x000afa50, 0x00000000, 0x00000000, 7, C_54_Kerning, 0, 0 },
  { 0x55, 0x0012220d, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x56, 0x0011d266, 0x000afa50, 0x00000000, 0x0000527d, 10, C_56_Kerning, 0, 0 },
  { 0x57, 0x00184426, 0x000afa50, 0x00000000, 0x0000527d, 10, C_57_Kerning, 0, 0 },
  { 0x58, 0x0011d266, 0x000afa50, 0x00000000, 0x00000000, 4, C_58_Kerning, 0, 0 },
  { 0x59, 0x0011d266, 0x000afa50, 0x00000000, 0x0000947a, 6, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000eb5fa, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5b, 0x0007056d, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x000c4f9a, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x0007056d, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x000c2213, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x0006fa46, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x0006fa46, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 1, C_60_Ligature },
  { 0x61, 0x000bcf96, 0x00071c73, 0x00000000, 0x00000000, 4, C_61_Kerning, 0, 0 },
  { 0x62, 0x000d6c06, 0x000b1c73, 0x00000000, 0x00000000, 10, C_62_Kerning, 0, 0 },
  { 0x63, 0x000ad820, 0x00071c73, 0x00000000, 0x00000000, 2, C_63_Kerning, 0, 0 },
  { 0x64, 0x000d6c06, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x000b13dd, 0x00071c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x00079f40, 0x000b1c73, 0x00000000, 0x000213ea, 5, C_66_Kerning, 3, C_66_Ligature },
  { 0x67, 0x000c2213, 0x00071c73, 0x00031c73, 0x0000527d, 1, C_67_Kerning, 0, 0 },
  { 0x68, 0x000d6c06, 0x000b1c73, 0x00000000, 0x00000000, 6, C_68_Kerning, 0, 0 },
  { 0x69, 0x0006fa46, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x00079f40, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x000cc70d, 0x000b1c73, 0x00000000, 0x00000000, 5, C_6b_Kerning, 0, 0 },
  { 0x6c, 0x0006fa46, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x0013ddc6, 0x00071c73, 0x00000000, 0x00000000, 6, C_6d_Kerning, 0, 0 },
  { 0x6e, 0x000d6c06, 0x00071c73, 0x00000000, 0x00000000, 6, C_6e_Kerning, 0, 0 },
  { 0x6f, 0x000c2213, 0x00071c73, 0x00000000, 0x00000000, 10, C_6f_Kerning, 0, 0 },
  { 0x70, 0x000d6c06, 0x00071c73, 0x00031c73, 0x00000000, 10, C_70_Kerning, 0, 0 },
  { 0x71, 0x000cc70d, 0x00071c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x0009f496, 0x00071c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x0009af2d, 0x00071c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x74, 0x00098e2d, 0x000a28a6, 0x00000000, 0x00000000, 2, C_74_Kerning, 0, 0 },
  { 0x75, 0x000d6c06, 0x00071c73, 0x00000000, 0x00000000, 1, C_75_Kerning, 0, 0 },
  { 0x76, 0x000cc70d, 0x00071c73, 0x00000000, 0x0000527d, 5, C_76_Kerning, 0, 0 },
  { 0x77, 0x001149e0, 0x00071c73, 0x00000000, 0x0000527d, 4, C_77_Kerning, 0, 0 },
  { 0x78, 0x000cc70d, 0x00071c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x000cc70d, 0x00071c73, 0x00031c73, 0x0000527d, 5, C_79_Kerning, 0, 0 },
  { 0x7a, 0x000ad820, 0x00071c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000c2213, 0x00071c73, 0x00000000, 0x0000a4fa, 0, 0, 1, C_7b_Ligature },
  { 0x7c, 0x00184426, 0x00071c73, 0x00000000, 0x0000a4fa, 0, 0, 0, 0 },
  { 0x7d, 0x000c2213, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x000c2213, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x000c2213, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 }
};

void
cmbx5_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
