// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelsv2

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilBotAliasAvailable uses the Lex Models V2 API operation
// DescribeBotAlias to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *LexModelsV2) WaitUntilBotAliasAvailable(input *DescribeBotAliasInput) error {
	return c.WaitUntilBotAliasAvailableWithContext(aws.BackgroundContext(), input)
}

// WaitUntilBotAliasAvailableWithContext is an extended version of WaitUntilBotAliasAvailable.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) WaitUntilBotAliasAvailableWithContext(ctx aws.Context, input *DescribeBotAliasInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilBotAliasAvailable",
		MaxAttempts: 35,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botAliasStatus",
				Expected: "Available",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botAliasStatus",
				Expected: "Failed",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botAliasStatus",
				Expected: "Deleting",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeBotAliasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBotAliasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilBotAvailable uses the Lex Models V2 API operation
// DescribeBot to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *LexModelsV2) WaitUntilBotAvailable(input *DescribeBotInput) error {
	return c.WaitUntilBotAvailableWithContext(aws.BackgroundContext(), input)
}

// WaitUntilBotAvailableWithContext is an extended version of WaitUntilBotAvailable.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) WaitUntilBotAvailableWithContext(ctx aws.Context, input *DescribeBotInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilBotAvailable",
		MaxAttempts: 35,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botStatus",
				Expected: "Available",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botStatus",
				Expected: "Deleting",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botStatus",
				Expected: "Failed",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botStatus",
				Expected: "Inactive",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeBotInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBotRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilBotExportCompleted uses the Lex Models V2 API operation
// DescribeExport to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *LexModelsV2) WaitUntilBotExportCompleted(input *DescribeExportInput) error {
	return c.WaitUntilBotExportCompletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilBotExportCompletedWithContext is an extended version of WaitUntilBotExportCompleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) WaitUntilBotExportCompletedWithContext(ctx aws.Context, input *DescribeExportInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilBotExportCompleted",
		MaxAttempts: 35,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "exportStatus",
				Expected: "Completed",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "exportStatus",
				Expected: "Deleting",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "exportStatus",
				Expected: "Failed",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeExportInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeExportRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilBotImportCompleted uses the Lex Models V2 API operation
// DescribeImport to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *LexModelsV2) WaitUntilBotImportCompleted(input *DescribeImportInput) error {
	return c.WaitUntilBotImportCompletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilBotImportCompletedWithContext is an extended version of WaitUntilBotImportCompleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) WaitUntilBotImportCompletedWithContext(ctx aws.Context, input *DescribeImportInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilBotImportCompleted",
		MaxAttempts: 35,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "importStatus",
				Expected: "Completed",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "importStatus",
				Expected: "Deleting",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "importStatus",
				Expected: "Failed",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeImportInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeImportRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilBotLocaleBuilt uses the Lex Models V2 API operation
// DescribeBotLocale to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *LexModelsV2) WaitUntilBotLocaleBuilt(input *DescribeBotLocaleInput) error {
	return c.WaitUntilBotLocaleBuiltWithContext(aws.BackgroundContext(), input)
}

// WaitUntilBotLocaleBuiltWithContext is an extended version of WaitUntilBotLocaleBuilt.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) WaitUntilBotLocaleBuiltWithContext(ctx aws.Context, input *DescribeBotLocaleInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilBotLocaleBuilt",
		MaxAttempts: 35,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "Built",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "Deleting",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "Failed",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "NotBuilt",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeBotLocaleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBotLocaleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilBotLocaleCreated uses the Lex Models V2 API operation
// DescribeBotLocale to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *LexModelsV2) WaitUntilBotLocaleCreated(input *DescribeBotLocaleInput) error {
	return c.WaitUntilBotLocaleCreatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilBotLocaleCreatedWithContext is an extended version of WaitUntilBotLocaleCreated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) WaitUntilBotLocaleCreatedWithContext(ctx aws.Context, input *DescribeBotLocaleInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilBotLocaleCreated",
		MaxAttempts: 35,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "Built",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "ReadyExpressTesting",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "NotBuilt",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "Deleting",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "Failed",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeBotLocaleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBotLocaleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilBotLocaleExpressTestingAvailable uses the Lex Models V2 API operation
// DescribeBotLocale to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *LexModelsV2) WaitUntilBotLocaleExpressTestingAvailable(input *DescribeBotLocaleInput) error {
	return c.WaitUntilBotLocaleExpressTestingAvailableWithContext(aws.BackgroundContext(), input)
}

// WaitUntilBotLocaleExpressTestingAvailableWithContext is an extended version of WaitUntilBotLocaleExpressTestingAvailable.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) WaitUntilBotLocaleExpressTestingAvailableWithContext(ctx aws.Context, input *DescribeBotLocaleInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilBotLocaleExpressTestingAvailable",
		MaxAttempts: 35,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "Built",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "ReadyExpressTesting",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "Deleting",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "Failed",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botLocaleStatus",
				Expected: "NotBuilt",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeBotLocaleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBotLocaleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilBotVersionAvailable uses the Lex Models V2 API operation
// DescribeBotVersion to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *LexModelsV2) WaitUntilBotVersionAvailable(input *DescribeBotVersionInput) error {
	return c.WaitUntilBotVersionAvailableWithContext(aws.BackgroundContext(), input)
}

// WaitUntilBotVersionAvailableWithContext is an extended version of WaitUntilBotVersionAvailable.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) WaitUntilBotVersionAvailableWithContext(ctx aws.Context, input *DescribeBotVersionInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilBotVersionAvailable",
		MaxAttempts: 35,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botStatus",
				Expected: "Available",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botStatus",
				Expected: "Deleting",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "botStatus",
				Expected: "Failed",
			},
			{
				State:    request.RetryWaiterState,
				Matcher:  request.StatusWaiterMatch,
				Expected: 404,
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeBotVersionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBotVersionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
