// Code generated by smithy-go-codegen DO NOT EDIT.

package ssoadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssoadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of the IAM Identity Center associated Amazon Web Services
// accounts that the principal has access to. This action must be called from the
// management account containing your organization instance of IAM Identity Center.
// This action is not valid for account instances of IAM Identity Center.
func (c *Client) ListAccountAssignmentsForPrincipal(ctx context.Context, params *ListAccountAssignmentsForPrincipalInput, optFns ...func(*Options)) (*ListAccountAssignmentsForPrincipalOutput, error) {
	if params == nil {
		params = &ListAccountAssignmentsForPrincipalInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAccountAssignmentsForPrincipal", params, optFns, c.addOperationListAccountAssignmentsForPrincipalMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAccountAssignmentsForPrincipalOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAccountAssignmentsForPrincipalInput struct {

	// Specifies the ARN of the instance of IAM Identity Center that contains the
	// principal.
	//
	// This member is required.
	InstanceArn *string

	// Specifies the principal for which you want to retrieve the list of account
	// assignments.
	//
	// This member is required.
	PrincipalId *string

	// Specifies the type of the principal.
	//
	// This member is required.
	PrincipalType types.PrincipalType

	// Specifies an Amazon Web Services account ID number. Results are filtered to
	// only those that match this ID number.
	Filter *types.ListAccountAssignmentsFilter

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value as the
	// NextToken request parameter in the next call to the operation to get the next
	// set of results. Note that the service might return fewer results than the
	// maximum even when there are more results available. You should check NextToken
	// after every operation to ensure that you receive all of the results.
	MaxResults *int32

	// Specifies that you want to receive the next page of results. Valid only if you
	// received a NextToken response in the previous request. If you did, it indicates
	// that more output is available. Set this parameter to the value provided by the
	// previous call's NextToken response to request the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAccountAssignmentsForPrincipalOutput struct {

	// An array list of the account assignments for the principal.
	AccountAssignments []types.AccountAssignmentForPrincipal

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You should
	// repeat this until the NextToken response element comes back as null . This
	// indicates that this is the last page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAccountAssignmentsForPrincipalMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListAccountAssignmentsForPrincipal{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListAccountAssignmentsForPrincipal{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAccountAssignmentsForPrincipal"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAccountAssignmentsForPrincipalValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAccountAssignmentsForPrincipal(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAccountAssignmentsForPrincipalPaginatorOptions is the paginator options for
// ListAccountAssignmentsForPrincipal
type ListAccountAssignmentsForPrincipalPaginatorOptions struct {
	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value as the
	// NextToken request parameter in the next call to the operation to get the next
	// set of results. Note that the service might return fewer results than the
	// maximum even when there are more results available. You should check NextToken
	// after every operation to ensure that you receive all of the results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAccountAssignmentsForPrincipalPaginator is a paginator for
// ListAccountAssignmentsForPrincipal
type ListAccountAssignmentsForPrincipalPaginator struct {
	options   ListAccountAssignmentsForPrincipalPaginatorOptions
	client    ListAccountAssignmentsForPrincipalAPIClient
	params    *ListAccountAssignmentsForPrincipalInput
	nextToken *string
	firstPage bool
}

// NewListAccountAssignmentsForPrincipalPaginator returns a new
// ListAccountAssignmentsForPrincipalPaginator
func NewListAccountAssignmentsForPrincipalPaginator(client ListAccountAssignmentsForPrincipalAPIClient, params *ListAccountAssignmentsForPrincipalInput, optFns ...func(*ListAccountAssignmentsForPrincipalPaginatorOptions)) *ListAccountAssignmentsForPrincipalPaginator {
	if params == nil {
		params = &ListAccountAssignmentsForPrincipalInput{}
	}

	options := ListAccountAssignmentsForPrincipalPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAccountAssignmentsForPrincipalPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAccountAssignmentsForPrincipalPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAccountAssignmentsForPrincipal page.
func (p *ListAccountAssignmentsForPrincipalPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAccountAssignmentsForPrincipalOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAccountAssignmentsForPrincipal(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAccountAssignmentsForPrincipalAPIClient is a client that implements the
// ListAccountAssignmentsForPrincipal operation.
type ListAccountAssignmentsForPrincipalAPIClient interface {
	ListAccountAssignmentsForPrincipal(context.Context, *ListAccountAssignmentsForPrincipalInput, ...func(*Options)) (*ListAccountAssignmentsForPrincipalOutput, error)
}

var _ ListAccountAssignmentsForPrincipalAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAccountAssignmentsForPrincipal(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAccountAssignmentsForPrincipal",
	}
}
