// Code generated by smithy-go-codegen DO NOT EDIT.

package omics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/omics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a private workflow. Before you create a private workflow, you must
// create and configure these required resources:
//
//   - Workflow definition files: Define your workflow in one or more workflow
//     definition files, written in WDL, Nextflow, or CWL. The workflow definition
//     specifies the inputs and outputs for runs that use the workflow. It also
//     includes specifications for the runs and run tasks for your workflow, including
//     compute and memory requirements. The workflow definition file must be in .zip
//     format.
//
//   - (Optional) Parameter template: You can create a parameter template file
//     that defines the run parameters, or Amazon Web Services HealthOmics can generate
//     the parameter template for you.
//
//   - ECR container images: Create container images for the workflow in a private
//     ECR repository, or synchronize images from a supported upstream registry with
//     your Amazon ECR private repository.
//
//   - (Optional) Sentieon licenses: Request a Sentieon license if using the
//     Sentieon software in a private workflow.
//
// For more information, see [Creating or updating a private workflow in Amazon Web Services HealthOmics] in the Amazon Web Services HealthOmics User Guide.
//
// [Creating or updating a private workflow in Amazon Web Services HealthOmics]: https://docs.aws.amazon.com/omics/latest/dev/creating-private-workflows.html
func (c *Client) CreateWorkflow(ctx context.Context, params *CreateWorkflowInput, optFns ...func(*Options)) (*CreateWorkflowOutput, error) {
	if params == nil {
		params = &CreateWorkflowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateWorkflow", params, optFns, c.addOperationCreateWorkflowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateWorkflowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateWorkflowInput struct {

	// An idempotency token to ensure that duplicate workflows are not created when
	// Amazon Web Services HealthOmics submits retry requests.
	//
	// This member is required.
	RequestId *string

	// The computational accelerator specified to run the workflow.
	Accelerators types.Accelerators

	// (Optional) Use a container registry map to specify mappings between the ECR
	// private repository and one or more upstream registries. For more information,
	// see [Container images]in the Amazon Web Services HealthOmics User Guide.
	//
	// [Container images]: https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html
	ContainerRegistryMap *types.ContainerRegistryMap

	// (Optional) URI of the S3 location for the registry mapping file.
	ContainerRegistryMapUri *string

	// The repository information for the workflow definition. This allows you to
	// source your workflow definition directly from a code repository.
	DefinitionRepository *types.DefinitionRepository

	// The S3 URI of a definition for the workflow. The S3 bucket must be in the same
	// region as the workflow.
	DefinitionUri *string

	// A ZIP archive containing the main workflow definition file and dependencies
	// that it imports for the workflow. You can use a file with a ://fileb prefix
	// instead of the Base64 string. For more information, see [Workflow definition requirements]in the Amazon Web
	// Services HealthOmics User Guide.
	//
	// [Workflow definition requirements]: https://docs.aws.amazon.com/omics/latest/dev/workflow-defn-requirements.html
	DefinitionZip []byte

	// A description for the workflow.
	Description *string

	// The workflow engine for the workflow. This is only required if you have
	// workflow definition files from more than one engine in your zip file. Otherwise,
	// the service can detect the engine automatically from your workflow definition.
	Engine types.WorkflowEngine

	// The path of the main definition file for the workflow. This parameter is not
	// required if the ZIP archive contains only one workflow definition file, or if
	// the main definition file is named “main”. An example path is:
	// workflow-definition/main-file.wdl .
	Main *string

	// Name (optional but highly recommended) for the workflow to locate relevant
	// information in the CloudWatch logs and Amazon Web Services HealthOmics console.
	Name *string

	// A parameter template for the workflow. If this field is blank, Amazon Web
	// Services HealthOmics will automatically parse the parameter template values from
	// your workflow definition file. To override these service generated default
	// values, provide a parameter template. To view an example of a parameter
	// template, see [Parameter template files]in the Amazon Web Services HealthOmics User Guide.
	//
	// [Parameter template files]: https://docs.aws.amazon.com/omics/latest/dev/parameter-templates.html
	ParameterTemplate map[string]types.WorkflowParameter

	// The path to the workflow parameter template JSON file within the repository.
	// This file defines the input parameters for runs that use this workflow. If not
	// specified, the workflow will be created without a parameter template.
	ParameterTemplatePath *string

	// The markdown content for the workflow's README file. This provides
	// documentation and usage information for users of the workflow.
	//
	// This value conforms to the media type: text/markdown
	ReadmeMarkdown *string

	// The path to the workflow README markdown file within the repository. This file
	// provides documentation and usage information for the workflow. If not specified,
	// the README.md file from the root directory of the repository will be used.
	ReadmePath *string

	// The S3 URI of the README file for the workflow. This file provides
	// documentation and usage information for the workflow. Requirements include:
	//
	//   - The S3 URI must begin with s3://USER-OWNED-BUCKET/
	//
	//   - The requester must have access to the S3 bucket and object.
	//
	//   - The max README content length is 500 KiB.
	ReadmeUri *string

	// The default static storage capacity (in gibibytes) for runs that use this
	// workflow or workflow version. The storageCapacity can be overwritten at run
	// time. The storage capacity is not required for runs with a DYNAMIC storage type.
	StorageCapacity *int32

	// The default storage type for runs that use this workflow. The storageType can
	// be overridden at run time. DYNAMIC storage dynamically scales the storage up or
	// down, based on file system utilization. STATIC storage allocates a fixed amount
	// of storage. For more information about dynamic and static storage types, see [Run storage types]in
	// the Amazon Web Services HealthOmics User Guide.
	//
	// [Run storage types]: https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html
	StorageType types.StorageType

	// Tags for the workflow. You can define up to 50 tags for the workflow. For more
	// information, see [Adding a tag]in the Amazon Web Services HealthOmics User Guide.
	//
	// [Adding a tag]: https://docs.aws.amazon.com/omics/latest/dev/add-a-tag.html
	Tags map[string]string

	// The Amazon Web Services account ID of the expected owner of the S3 bucket that
	// contains the workflow definition. If not specified, the service skips the
	// validation.
	WorkflowBucketOwnerId *string

	noSmithyDocumentSerde
}

type CreateWorkflowOutput struct {

	// The workflow's ARN.
	Arn *string

	// The workflow's ID.
	Id *string

	// The workflow's status.
	Status types.WorkflowStatus

	// The workflow's tags.
	Tags map[string]string

	// The universally unique identifier (UUID) value for this workflow.
	Uuid *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateWorkflowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateWorkflow"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreateWorkflowMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateWorkflowMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateWorkflowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateWorkflow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreateWorkflowMiddleware struct {
}

func (*endpointPrefix_opCreateWorkflowMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreateWorkflowMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "workflows-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreateWorkflowMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreateWorkflowMiddleware{}, "ResolveEndpointV2", middleware.After)
}

type idempotencyToken_initializeOpCreateWorkflow struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateWorkflow) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateWorkflow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateWorkflowInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateWorkflowInput ")
	}

	if input.RequestId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.RequestId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateWorkflowMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateWorkflow{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateWorkflow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateWorkflow",
	}
}
