// Code generated by smithy-go-codegen DO NOT EDIT.

package qapps

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new library item for an Amazon Q App, allowing it to be discovered
// and used by other allowed users.
func (c *Client) CreateLibraryItem(ctx context.Context, params *CreateLibraryItemInput, optFns ...func(*Options)) (*CreateLibraryItemOutput, error) {
	if params == nil {
		params = &CreateLibraryItemInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLibraryItem", params, optFns, c.addOperationCreateLibraryItemMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLibraryItemOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateLibraryItemInput struct {

	// The unique identifier of the Amazon Q App to publish to the library.
	//
	// This member is required.
	AppId *string

	// The version of the Amazon Q App to publish to the library.
	//
	// This member is required.
	AppVersion *int32

	// The categories to associate with the library item for easier discovery.
	//
	// This member is required.
	Categories []string

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// This member is required.
	InstanceId *string

	noSmithyDocumentSerde
}

type CreateLibraryItemOutput struct {

	// The date and time the library item was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user who created the library item.
	//
	// This member is required.
	CreatedBy *string

	// The unique identifier of the new library item.
	//
	// This member is required.
	LibraryItemId *string

	// The number of ratings the library item has received from users.
	//
	// This member is required.
	RatingCount *int32

	// The status of the new library item, such as "Published".
	//
	// This member is required.
	Status *string

	// The date and time the library item was last updated.
	UpdatedAt *time.Time

	// The user who last updated the library item.
	UpdatedBy *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLibraryItemMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateLibraryItem{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateLibraryItem{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLibraryItem"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateLibraryItemValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLibraryItem(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateLibraryItem(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLibraryItem",
	}
}
