// Code generated by smithy-go-codegen DO NOT EDIT.

package apprunner

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/apprunner/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Delete an App Runner automatic scaling configuration resource. You can delete a
// specific revision or the latest active revision. You can't delete a
// configuration that's used by one or more App Runner services.
func (c *Client) DeleteAutoScalingConfiguration(ctx context.Context, params *DeleteAutoScalingConfigurationInput, optFns ...func(*Options)) (*DeleteAutoScalingConfigurationOutput, error) {
	if params == nil {
		params = &DeleteAutoScalingConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteAutoScalingConfiguration", params, optFns, c.addOperationDeleteAutoScalingConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteAutoScalingConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteAutoScalingConfigurationInput struct {

	// The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that
	// you want to delete. The ARN can be a full auto scaling configuration ARN, or a
	// partial ARN ending with either .../name  or .../name/revision . If a revision
	// isn't specified, the latest active revision is deleted.
	//
	// This member is required.
	AutoScalingConfigurationArn *string

	noSmithyDocumentSerde
}

type DeleteAutoScalingConfigurationOutput struct {

	// A description of the App Runner auto scaling configuration that this request
	// just deleted.
	//
	// This member is required.
	AutoScalingConfiguration *types.AutoScalingConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteAutoScalingConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDeleteAutoScalingConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDeleteAutoScalingConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDeleteAutoScalingConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteAutoScalingConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteAutoScalingConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "apprunner",
		OperationName: "DeleteAutoScalingConfiguration",
	}
}
