#!/bin/sh

SOURCE_DIR="$1"
OUTPUT="$2"
DEPFILE="$3"

if test -z "$SOURCE_DIR" || ! test -d "$SOURCE_DIR" || test -z "$OUTPUT"
then
	echo >&2 "USAGE: $0 <SOURCE_DIR> <OUTPUT> [<DEPFILE>]"
	exit 1
fi

print_config_list () {
	cat <<EOF
static const char *config_name_list[] = {
EOF
	sed -e '
	/^`*[a-zA-Z].*\..*`*::$/ {
	/deprecated/d;
	s/::$//;
	s/`//g;
	s/^.*$/	"&",/;
	p;};
	d' \
	    "$SOURCE_DIR"/Documentation/*config.adoc \
	    "$SOURCE_DIR"/Documentation/config/*.adoc |
	sort
	cat <<EOF
	NULL,
};
EOF
}

{
	echo "/* Automatically generated by generate-configlist.sh */"
	echo
	echo
	print_config_list
} >"$OUTPUT"

if test -n "$DEPFILE"
then
	QUOTED_OUTPUT="$(printf '%s\n' "$OUTPUT" | sed 's,[&/\],\\&,g')"
	{
		printf '%s\n' "$SOURCE_DIR"/Documentation/*config.adoc \
			"$SOURCE_DIR"/Documentation/config/*.adoc |
			sed -e 's/[# ]/\\&/g' -e "s/^/$QUOTED_OUTPUT: /"
		printf '%s:\n' "$SOURCE_DIR"/Documentation/*config.adoc \
			"$SOURCE_DIR"/Documentation/config/*.adoc |
			sed -e 's/[# ]/\\&/g'
	} >"$DEPFILE"
fi
