/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.PlayerRenderer;
import friendless.games.filler.PlayerWrapper;
import friendless.games.filler.PlayerWrappers;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class ChoosePlayerList
extends JList {
    PlayerRenderer renderer;
    PlayerWrappers players;

    public ChoosePlayerList(PlayerWrappers playerWrappers, int n) {
        this.players = playerWrappers;
        this.renderer = new PlayerRenderer(this.getForeground(), this.getBackground());
        this.setCellRenderer(this.renderer);
        this.setSelectionMode(n);
        this.setModel(playerWrappers.getListModel());
        if (n == 2) {
            this.setSelected();
            this.addListSelectionListener(new ChoosePlayersListSelectionListener(playerWrappers));
        }
    }

    void setSelected() {
        PlayerWrappers playerWrappers = this.players.getSelected();
        int n = 0;
        while (n < this.players.size()) {
            if (playerWrappers.contains(this.players.get(n))) {
                this.getSelectionModel().addSelectionInterval(n, n);
            }
            ++n;
        }
    }

    class ChoosePlayersListSelectionListener
    implements ListSelectionListener {
        PlayerWrappers players;

        public ChoosePlayersListSelectionListener(PlayerWrappers playerWrappers) {
            this.players = playerWrappers;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.sync(((JList)listSelectionEvent.getSource()).getSelectionModel());
        }

        void sync(ListSelectionModel listSelectionModel) {
            int n = 0;
            while (n < this.players.size()) {
                this.players.setSelection((PlayerWrapper)ChoosePlayerList.this.getModel().getElementAt(n), listSelectionModel.isSelectedIndex(n));
                ++n;
            }
        }
    }
}

