#!/bin/sh

srcdir=${srcdir:-.}
. $srcdir/common.inc.sh

prepare 4

chroot=fakechroot
version=`grep '^VERSION = ' "$srcdir/Makefile" | sed 's/.* = //'`

CLEARED=paranoid
export CLEARED

t=`LC_ALL=C $srcdir/$chroot.sh $testtree /bin/sh -c 'CLEARED=something; echo $CLEARED' 2>&1`
test "$t" = "something" || not
ok "$chroot echo \$CLEARED returns" $t

t=`LC_ALL=C $srcdir/$chroot.sh $testtree /bin/sh -c 'CLEARED=something; test-execve-null-envp "echo \\\$CLEARED"' 2>&1`
test -z "$t" || not
ok "$chroot test-execve-null-envp echo \$CLEARED returns" $t

t=`LC_ALL=C $srcdir/$chroot.sh $testtree /bin/sh -c 'test-execve-null-envp "echo \\\$FAKECHROOT"' 2>&1`
test "$t" = "true" || not
ok "$chroot test-execve-null-envp echo \$FAKECHROOT returns" $t

t=`LC_ALL=C $srcdir/$chroot.sh $testtree /bin/sh -c 'test-execve-null-envp "echo \\\$FAKECHROOT_VERSION"' 2>&1`
test "$t" = "$version" || not
ok "$chroot test-execve-null-envp echo \$FAKECHROOT_VERSION returns" $t

cleanup
