/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#include "beat2value.h"
#include "console.h"
#include <fstream>
#include <iostream>
using namespace std;

extern console cons;

beat2value::beat2value (const string& n, const string& c) : name (n), crvname (c), crv (c)  {

  now = 0;
  delta = 0;
  bpm = 45;

  set_bpm (bpm);
  sol(&crv);
  curve_edited ();

  style = "loop";
  xmin = &_loopmin;
  xmax = &_loopmax;

}

beat2value::~beat2value () {
  crv.save (crvname);
}

void beat2value::operator() (float* soln, int n) {
  sol (now, delta, n, soln, *xmin, *xmax);
}

void beat2value::modulate (float* out, float* in, int n, float depth) { // modulate n in by depth and store in out
  sol (now, delta, n, in, *xmin, *xmax);
  for (int i = 0; i < n; ++i) out[i] = (depth * in [i]);
}

void beat2value::curve_edited () {
  sol.update ();
}

float beat2value::set_bpm (float n) { // check and set bpm and return bpm
  if (n >= 0) { // bpm cant be negative
		bpm = n;
		float bps = bpm / 60.0; // beats per sec
		
		// calculate delta for use in solvers
		int sgn = 1; if (delta < 0) sgn = -1;
		extern int SAMPLE_RATE;
		delta = sgn * bps * 1. / SAMPLE_RATE;
	}
	return bpm;
}

float beat2value::get_bpm () { return bpm; }

// globals
//
void tween (float* buf1, float* buf2, int n, float amount) {// interpolate buf2 -> buf1 and store in buf1
	for (int i = 0; i < n; ++i) {
		float b1 = buf1 [i], b2 = buf2[i];
		buf1[i] = amount * b1 + (1 - amount) * b2;
	} 
}

void multiply (float* out, float* mul, int n) { // multiply n muls with n outs and store in outs
  for (int i = 0; i < n; ++i) out[i] *= mul[i];
}
