/*

  Author:  Bob Dean
  Copyright (c) 1999, 2000


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifdef __cplusplus
extern "C"
{
#endif

#include <dbaudiolib.h>
#include <dbchannel.h>
	
	extern local_channel * ch;
	extern int errno;

	/*
	  DBAudio_Set_Volume - sets the volume for the left and right channels for 
	  the channel associated with this instance.
	  left and right should be within the range 0 <= x <= 100
	*/
	int DBAudio_Set_Volume(int left, int right)
	{
		if (ch == NULL)  
		{
			errno = ERROR_NOT_INITIALIZED; 
			return FAILURE;
		}
		
		/* convert to 0-128 point scale */
		left = (left * DBAUDIO_INTERNAL_MAX_VOLUME) / DBAUDIO_MAX_VOLUME;
		right = (right * DBAUDIO_INTERNAL_MAX_VOLUME) / DBAUDIO_MAX_VOLUME;

		if(left < DBAUDIO_MIN_VOLUME) {left = DBAUDIO_MIN_VOLUME;}
		if(left > DBAUDIO_INTERNAL_MAX_VOLUME) {left = DBAUDIO_INTERNAL_MAX_VOLUME;}
		
		if(right < DBAUDIO_MIN_VOLUME) {right = DBAUDIO_MIN_VOLUME;}
		if(right > DBAUDIO_INTERNAL_MAX_VOLUME) {right = DBAUDIO_INTERNAL_MAX_VOLUME;}
		
		ch->left_gain = left;
		ch->right_gain = right;
		
		return SUCCESS;
	}

	/*
	  DBAudio_Get_Volume - returns the volumes associated with the channel
	  for this instance.
	*/
	int DBAudio_Get_Volume(int *left, int *right)
	{
		if (ch == NULL)  
		{
			errno = ERROR_NOT_INITIALIZED; 
			return FAILURE;
		}
		
		/* convert volumes to 0-100 scale*/
		*left = (ch->left_gain * 100) >> 7;
		*right = (ch->right_gain * 100) >> 7;

		return SUCCESS;
	}

#ifdef __cplusplus
}
#endif
