% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbFetchArrow.R
\name{dbFetchArrow}
\alias{dbFetchArrow}
\title{Fetch records from a previously executed query as an Arrow object}
\usage{
dbFetchArrow(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResultArrow}, created by
\code{\link[=dbSendQueryArrow]{dbSendQueryArrow()}}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbFetchArrow()} always returns an object coercible to a \link{data.frame} with
as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Fetch the result set and return it as an Arrow object.
Use \code{\link[=dbFetchArrowChunk]{dbFetchArrowChunk()}} to fetch results in chunks.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbFetchArrow")}
}
\section{The data retrieval flow for Arrow streams}{


This section gives a complete overview over the flow
for the execution of queries that return tabular data as an Arrow stream.

Most of this flow, except repeated calling of \code{\link[=dbBindArrow]{dbBindArrow()}} or \code{\link[=dbBind]{dbBind()}},
is implemented by \code{\link[=dbGetQueryArrow]{dbGetQueryArrow()}},
which should be sufficient
unless you have a parameterized query that you want to reuse.
This flow requires an active connection established by \code{\link[=dbConnect]{dbConnect()}}.
See also \code{vignette("dbi-advanced")} for a walkthrough.
\enumerate{
\item Use \code{\link[=dbSendQueryArrow]{dbSendQueryArrow()}} to create a result set object of class
\linkS4class{DBIResultArrow}.
\item Optionally, bind query parameters with \code{\link[=dbBindArrow]{dbBindArrow()}} or \code{\link[=dbBind]{dbBind()}}.
This is required only if the query contains placeholders
such as \verb{?} or \verb{$1}, depending on the database backend.
\item Use \code{\link[=dbFetchArrow]{dbFetchArrow()}} to get a data stream.
\item Repeat the last two steps as necessary.
\item Use \code{\link[=dbClearResult]{dbClearResult()}} to clean up the result set object.
This step is mandatory even if no rows have been fetched
or if an error has occurred during the processing.
It is good practice to use \code{\link[=on.exit]{on.exit()}} or \code{\link[withr:defer]{withr::defer()}}
to ensure that this step is always executed.
}
}

\section{Failure modes}{


An attempt to fetch from a closed result set raises an error.

}

\section{Specification}{


Fetching multi-row queries with one
or more columns by default returns the entire result.
The object returned by \code{dbFetchArrow()} can also be passed to
\code{\link[nanoarrow:as_nanoarrow_array_stream]{nanoarrow::as_nanoarrow_array_stream()}} to create a nanoarrow
array stream object that can be used to read the result set
in batches.
The chunk size is implementation-specific.

}

\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE) && requireNamespace("nanoarrow", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)

# Fetch all results
rs <- dbSendQueryArrow(con, "SELECT * FROM mtcars WHERE cyl = 4")
as.data.frame(dbFetchArrow(rs))
dbClearResult(rs)

dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
\seealso{
Close the result set with \code{\link[=dbClearResult]{dbClearResult()}} as soon as you
finish retrieving the records you want.

Other DBIResultArrow generics: 
\code{\link{DBIResultArrow-class}},
\code{\link{dbBind}()},
\code{\link{dbClearResult}()},
\code{\link{dbFetchArrowChunk}()},
\code{\link{dbHasCompleted}()},
\code{\link{dbIsValid}()}

Other data retrieval generics: 
\code{\link{dbBind}()},
\code{\link{dbClearResult}()},
\code{\link{dbFetch}()},
\code{\link{dbFetchArrowChunk}()},
\code{\link{dbGetQuery}()},
\code{\link{dbGetQueryArrow}()},
\code{\link{dbHasCompleted}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendQueryArrow}()}
}
\concept{DBIResultArrow generics}
\concept{data retrieval generics}
