/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.pict;

import com.kreative.rsrc.pict.RGBColor;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ColorSpec
implements Paint {
    public int value;
    public RGBColor rgb;

    public static ColorSpec read(DataInputStream in) throws IOException {
        ColorSpec c = new ColorSpec();
        c.value = in.readUnsignedShort();
        c.rgb = RGBColor.read(in);
        return c;
    }

    public ColorSpec() {
        this.value = 0;
        this.rgb = new RGBColor();
    }

    public ColorSpec(int rgb) {
        this.value = 0;
        this.rgb = new RGBColor(rgb);
    }

    public ColorSpec(int r, int g, int b) {
        this.value = 0;
        this.rgb = new RGBColor(r, g, b);
    }

    public ColorSpec(float r, float g, float b) {
        this.value = 0;
        this.rgb = new RGBColor(r, g, b);
    }

    public ColorSpec(Color c) {
        this.value = 0;
        this.rgb = new RGBColor(c);
    }

    public ColorSpec(int value, int rgb) {
        this.value = value;
        this.rgb = new RGBColor(rgb);
    }

    public ColorSpec(int value, int r, int g, int b) {
        this.value = value;
        this.rgb = new RGBColor(r, g, b);
    }

    public ColorSpec(int value, float r, float g, float b) {
        this.value = value;
        this.rgb = new RGBColor(r, g, b);
    }

    public ColorSpec(int value, Color c) {
        this.value = value;
        this.rgb = new RGBColor(c);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.value);
        this.rgb.write(out);
    }

    public Color toColor() {
        return this.rgb.toColor();
    }

    public int toRGB() {
        return this.rgb.toRGB();
    }

    public String toString() {
        return String.valueOf(this.value) + "," + this.rgb.toString();
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return this.rgb.toColor().createContext(cm, deviceBounds, userBounds, xform, hints);
    }

    @Override
    public int getTransparency() {
        return 1;
    }
}

