/*
 *		Unofficial release 1.3.0
 *	        	B I N G
 *
 */

/* $Id: bing_misc.h,v 1.3 1999/10/11 05:25:19 fgouget Exp $ */

#ifndef _bing_misc_h_
#define _bing_misc_h_

#ifdef WIN32

/*
#include "win32/win32.h"
#include <winsock.h>
#include "win32/types.h"
*/

#else

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include "bing_defs.h"

#define SOCKADDR_IN(psockaddr)  ((struct sockaddr_in*)psockaddr)

#define addrcpy(dst,src)        memcpy(dst,src,sizeof(struct sockaddr))

/*
  --------------------------------------------------------------------------
	Compares to network addresses in a network type correct way.
        (!!) with ICMP we don't set the port field thus this function
  ------------+----+-----+--------------------------------------------------
  Parameter   | IN | OUT | Role
  ------------+----+-----+--------------------------------------------------
  addr1       | X  |     | The first address
  addr2       | X  |     | The second address
  ------------+----+-----+--------------------------------------------------
  RETURN      |    |  X  | 0 if equal, non 0 otherwise
  ------------+----+-----+--------------------------------------------------
*/
extern BINGAPI int BINGPROTO(
    addrcmp,
    (
        struct sockaddr* addr1,
        struct sockaddr* addr2
    ));

/*
  --------------------------------------------------------------------------
	Compares to network addresses in a network type correct way.
        (!!) with ICMP we don't set the port field thus this function
  ------------+----+-----+--------------------------------------------------
  Parameter   | IN | OUT | Role
  ------------+----+-----+--------------------------------------------------
  addr1       | X  |     | The first address
  family      | X  |     | The family of the second address
  addr2       | X  |     | The second address proper
  ------------+----+-----+--------------------------------------------------
  RETURN      |    |  X  | 0 if equal, non 0 otherwise
  ------------+----+-----+--------------------------------------------------
*/
extern BINGAPI int BINGPROTO(
    addrcmp2,
    (
        struct sockaddr* addr1,
        unsigned short   family,
        char*            addr2
    ));

extern BINGAPI void BINGPROTO(
    addrset,
    (
        struct sockaddr* addr,
        struct in_addr   ia,
        unsigned short   port
    ));

/*
  --------------------------------------------------------------------------
	Converts a string to an IP address. The address may be specified 
	either as a host name or as the IP address in "dotted" format.
  ------------+----+-----+--------------------------------------------------
  Parameter   | IN | OUT | Role
  ------------+----+-----+--------------------------------------------------
  host_string | X  |     | Host name either symbolic or in dotted format
  host_addr   |    |  X  | Host address
  ------------+----+-----+--------------------------------------------------
  RETURN      |    |  X  | 0 if successful, -1 otherwise
  ------------+----+-----+--------------------------------------------------
*/
extern BINGAPI int BINGPROTO(
    host_name2addr,
    (
	char* host_string,
	struct sockaddr* host_addr
    ));

/*
  --------------------------------------------------------------------------
	Returns a pointer to a string suitable for representing the host's
	address. If the options parameter contains the F_NUMERIC option 
	HostAddr2String will not attempt to get the host name so that the 
	returned string will only contain the host adress.
  ------------+----+-----+--------------------------------------------------
  Parameter   | IN | OUT | Role
  ------------+----+-----+--------------------------------------------------
  host_addr   | X  |     | The host IP address
  resolve     | X  |     | If 1 the address will be conerted to a symbolic 
              |    |     | host name
  ------------+----+-----+--------------------------------------------------
  RETURN      |    |  X  | A pointer to a static area containing the string
              |    |     | to display for that host.
  ------------+----+-----+--------------------------------------------------
*/
extern BINGAPI char* BINGPROTO(
    host_addr2name,
    (
	struct sockaddr* host_addr,
	int resolve
    ));

#endif /* end of file */
