# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
# pylint: skip-file
# flake8: noqa
from msrest.serialization import Model


class SecurityDomainJsonWebKey(Model):
    """
    :param kty: SecurityDomainJsonWebKey Key Type (kty), as defined in
     https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
     Possible values include: 'RSA', 'RSA-HSM'
    """

    _attribute_map = {
        'kid': {'key': 'kid', 'type': 'str'},
        'kty': {'key': 'kty', 'type': 'str'},
        'key_ops': {'key': 'key_ops', 'type': '[str]'},
        'n': {'key': 'n', 'type': 'str'},
        'e': {'key': 'e', 'type': 'str'},
        'x5c': {'key': 'x5c', 'type': '[str]'},
        'use': {'key': 'use', 'type': 'str'},
        'x5t': {'key': 'x5t', 'type': 'str'},
        'x5tS256': {'key': 'x5t#S256', 'type': 'str'},
        'alg': {'key': 'alg', 'type': 'str'}
    }

    def __init__(self, *, kid: str=None, kty=None, key_ops=None, n: str=None, e: str=None, x5c=None, use: str=None, x5t: str=None, x5tS256: str=None, alg: str=None, **kwargs) -> None:
        super(SecurityDomainJsonWebKey, self).__init__(**kwargs)
        self.kid = kid
        self.kty = kty
        self.key_ops = key_ops
        self.n = n
        self.e = e
        self.x5c = x5c
        self.use = use
        self.x5t = x5t
        self.x5tS256 = x5tS256
        self.alg = alg
