/* pam_login_alert module */

/*
 * misc functions: printerr(), safe_strncpy(), getline()
 */

#include <stdarg.h>
#include <syslog.h>
#include <string.h>
#include <stdio.h>
#include "pam_login_alert.h"

/*
 * printerr() - print an error message
 */

extern
int printerr(char *format, ...)
{
	va_list args;

	va_start(args, format);
	openlog("PAM_login_alert", LOG_CONS|LOG_PID, LOG_DAEMON);
	vsyslog(LOG_ERR, format, args);
	closelog();
	va_end(args);

	return 1;
}

/*
 * safe_strncpy() - copy n characters from src to dest
 * necessary because standard strncpy() doesn't add a NUL if 
 * strlen(src) >= n
 */

extern
char *safe_strncpy(char *dest, char *src, int n)
{
	if (n < 1)
		return NULL;

	memmove(dest, src, n);
	if (strlen(src) >= n)
		dest[n-1] = '\0';

	return dest;
}

/*
 * getline() - get a line of text, ignoring comments
 */

extern
int getline(char *buf, int n, FILE *fp)
{
	int flag = 0;

	if (fgets(buf, n, fp) != NULL)
	{
		int i, l = strlen(buf);
	
		/* stop at the first comment character (#) or newline */
		for (i = 0; i < l && (buf[i] != '#' && buf[i] != '\n'); i++);
		buf[i] = '\0';

		flag = 1;
	}

	return flag;
}

