
/* $Header: /home/walid/PAM/pam_dpasswd/RCS/dialup.c,v 1.1 1998/04/23 22:13:11 walid Exp walid $ */

/*
 * by Walid Harmoush <walid@cinenet.net>.
 * pieces of the code borrowed from pam_shells and pam_unix.
 * This is free software. Use at your own risk.
 */
 
/* 
 * $Log: dialup.c,v $
 * Revision 1.1  1998/04/23 22:13:11  walid
 * Initial revision
 *
 */

#ifdef linux
# define _GNU_SOURCE
# include <features.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <limits.h>
#include <sys/stat.h>
#include <sys/types.h>

#ifndef NDEBUG

#include <syslog.h>

#endif	/* NDEBUG */

#define _PAM_EXTERN_FUNCTIONS
#include <security/pam_modules.h>

static const char rcsid[] = "$Id: dialup.c,v 1.1 1998/04/23 22:13:11 walid Exp walid $";

#define DIALUPS	"/etc/dialups"
#define DPASSWD	"/etc/d_passwd"
#define DSHELL1 "/bin/sh"
#define DSHELL2 "/sbin/sh"

#define LSTRIP(s)	for (;isspace(*s);s++)
#define RSTRIP(s)	{ \
			     int i; \
			     for (i=strlen(s)-1;isspace(s[i])||s[i]=='\n';i--);\
			     s[i+1]='\0'; \
			}

extern void
_pam_log(int err, const char *format, ...);

static int
_get_shell_pw(char **pw, char *sh, int len, int line);

int
_is_dialup_term(char *term) 
{
	FILE *fd;
	struct stat s;
	char buf[PATH_MAX], *tty;
	int rval = PAM_SERVICE_ERR;

	if (stat(DIALUPS, &s))
	{
		_pam_log(LOG_ERR, "can't stat " DIALUPS);
        	return PAM_AUTH_ERR;            /* must have /etc/dialups */
	}

	if (s.st_uid)
	{
		_pam_log(LOG_ALERT, DIALUPS " must be owned by root");
        	return PAM_AUTH_ERR;            /* must be owned by root */
	}

	if (!(s.st_mode&S_IFREG)|(s.st_mode&(S_IWGRP|S_IWOTH)))
	{
		_pam_log(LOG_ALERT, DIALUPS " is not a regular file or is"
					" writable by group/other");
        	return PAM_AUTH_ERR;            /* w by grp/other */
	}

	if ((fd = fopen(DIALUPS,"r")) == NULL) {
		_pam_log(LOG_ERR, "can't open" DIALUPS);
        	return PAM_AUTH_ERR;            /* should not happen*/
	}

	while (fgets(buf, PATH_MAX, fd)) {
		tty = buf;	
		/* remove leading/trailing spaces */
		LSTRIP(tty);
		RSTRIP(tty);
		if (!strncmp(tty,"/dev/",5)) tty+=5;
		if (!strcmp(tty,term)) {
			rval = PAM_SUCCESS;
			break;
		}	
	}
	
	fclose(fd);

	return(rval);
}

int
_get_dialup_passwd(char *shell, char **pw)
{
	FILE *fd;
	struct stat s;
	char buf[PATH_MAX], *sh, *pw1=NULL, *pw2=NULL;
	int rval = PAM_AUTH_ERR, len, line=1;

	if (stat(DPASSWD, &s))
	{
		_pam_log(LOG_ERR, "can't stat " DPASSWD);
        	return PAM_AUTH_ERR;            /* must have /etc/d_passwd */
	}

	if (s.st_uid)
	{
		_pam_log(LOG_ALERT, DPASSWD " must be owned by root");
        	return PAM_AUTH_ERR;            /* must be owned by root */
	}

	if (!(s.st_mode&S_IFREG)|(s.st_mode&(S_IWGRP|S_IWOTH)))
	{
		_pam_log(LOG_ALERT, DPASSWD " is not a regular file or is"
					" writable by group/other");
        	return PAM_AUTH_ERR;            /* w by grp/other */
	}

	if ((fd = fopen(DPASSWD,"r")) == NULL) {
		_pam_log(LOG_ERR, "can't open" DPASSWD);
        	return PAM_AUTH_ERR;            /* should not happen*/
	}

	while (fgets(buf, PATH_MAX, fd)) {
		sh = buf;	
		/* remove leading/trailing spaces */
		LSTRIP(sh);
		RSTRIP(sh);
		if (!strncmp(sh,shell,len=strlen(shell))) {
			if (pw2) {free(pw2); pw2=NULL;}
			rval = _get_shell_pw(&pw1,sh,len,line);	
			break;
		}
		else if (!strncmp(sh,DSHELL1,len=strlen(DSHELL1))) {
			if (pw2) free(pw2);
			rval = _get_shell_pw(&pw2,sh,len,line);	
			if (rval != PAM_SUCCESS) break;
		}
		else if (!strncmp(sh,DSHELL2,len=strlen(DSHELL2))) {
			if (pw2) free(pw2);
			rval = _get_shell_pw(&pw2,sh,len,line);	
			if (rval != PAM_SUCCESS) break;
		}
		line++;
	}
	if (rval == PAM_SUCCESS) *pw = pw1?pw1:pw2;
	
	fclose(fd);

	return(rval);
}

static int
_get_shell_pw(char **pw, char *sh, int len, int line)
{
	int rval;

	if (sh[len] != ':') {
		_pam_log(LOG_ERR, "format error in " DPASSWD
				 " line %d", line);
		rval = PAM_AUTH_ERR;
	}
	else {
		sh = &sh[len+1];
		len = strlen(sh);
		if (*pw = (char *)malloc(len+1)) {
			strcpy(*pw,sh);
			if ((*pw)[len-1] = ':') (*pw)[len-1]='\0';
			rval = PAM_SUCCESS;
		}
		else rval = PAM_SERVICE_ERR;
	}
	return rval;
}
