/*
 * $Id: pipe.c,v 1.1 1997/06/11 02:10:46 morgan Exp $
 *
 * This file contains code for message passing between the X-based
 * and PAM-based processes of the application.
 */

#include "pipe.h"

int outmsg(struct pipeio_t *pipeio, enum PIPEIO epipe, const void *data,
	   int len)
{
    D(("Output packet: Type=%d  Length=%d\n", epipe, len));

    write(pipeio->outfd, &epipe, sizeof(epipe));
    write(pipeio->outfd, &len, sizeof(len));
    write(pipeio->outfd, data, len);

    return TRUE;
}

enum PIPEIO inmsg(struct pipeio_t *pipeio, void **data, int *len)
{
    enum PIPEIO epipe;

    /* Read instruction */
    read(pipeio->infd, &epipe, sizeof(epipe));

    /* Read length of text */
    read(pipeio->infd, len, sizeof(*len));

    /* If there is something to read */
    if ( *len ) {
	if ( (*data = (void *) calloc(1, *len)) == NULL ) {
	    D((stderr, "Out of memory\n"));
	    return FATAL_ERROR;
	}
	read(pipeio->infd, *data, *len);
    } else {
	*data = NULL;
    }

    D(("Input packet: Type=%d  Length=%d\n", epipe, *len));
    return epipe;
}
