/* SPDX-License-Identifier: BSD-3-Clause */
/* Copyright (C) 2023 Microchip Technology Inc. and its subsidiaries.
 * Microchip VCAP API
 */

/* This file is autogenerated by cml-utils 2023-03-13 10:16:42 +0100.
 * Commit ID: 259f0efd6d6d91bfbf62858de153cc757b6bffa3 (dirty)
 */

#ifndef __VCAP_AG_API__
#define __VCAP_AG_API__

enum vcap_type {
	VCAP_TYPE_ES0,
	VCAP_TYPE_ES2,
	VCAP_TYPE_IS0,
	VCAP_TYPE_IS1,
	VCAP_TYPE_IS2,
	VCAP_TYPE_MAX
};

/* Keyfieldset names with origin information */
enum vcap_keyfield_set {
	VCAP_KFS_NO_VALUE,          /* initial value */
	VCAP_KFS_5TUPLE_IP4,        /* lan966x is1 X2 */
	VCAP_KFS_5TUPLE_IP6,        /* lan966x is1 X4 */
	VCAP_KFS_7TUPLE,            /* lan966x is1 X4 */
	VCAP_KFS_ARP,               /* sparx5 is2 X6, sparx5 es2 X6, lan966x is2 X2 */
	VCAP_KFS_DBL_VID,           /* lan966x is1 X1 */
	VCAP_KFS_DMAC_VID,          /* lan966x is1 X1 */
	VCAP_KFS_ETAG,              /* sparx5 is0 X2 */
	VCAP_KFS_IP4_OTHER,         /* sparx5 is2 X6, sparx5 es2 X6, lan966x is2 X2 */
	VCAP_KFS_IP4_TCP_UDP,       /* sparx5 is2 X6, sparx5 es2 X6, lan966x is2 X2 */
	VCAP_KFS_IP4_VID,           /* sparx5 es2 X3 */
	VCAP_KFS_IP6_OTHER,         /* lan966x is2 X4 */
	VCAP_KFS_IP6_STD,           /* sparx5 is2 X6, sparx5 es2 X6, lan966x is2 X2 */
	VCAP_KFS_IP6_TCP_UDP,       /* lan966x is2 X4 */
	VCAP_KFS_IP6_VID,           /* sparx5 es2 X6 */
	VCAP_KFS_IP_7TUPLE,         /* sparx5 is2 X12, sparx5 es2 X12 */
	VCAP_KFS_ISDX,              /* sparx5 es0 X1 */
	VCAP_KFS_LL_FULL,           /* sparx5 is0 X6 */
	VCAP_KFS_MAC_ETYPE,         /* sparx5 is2 X6, sparx5 es2 X6, lan966x is2 X2 */
	VCAP_KFS_MAC_LLC,           /* lan966x is2 X2 */
	VCAP_KFS_MAC_SNAP,          /* lan966x is2 X2 */
	VCAP_KFS_NORMAL,            /* lan966x is1 X2 */
	VCAP_KFS_NORMAL_5TUPLE_IP4,  /* sparx5 is0 X6 */
	VCAP_KFS_NORMAL_7TUPLE,     /* sparx5 is0 X12 */
	VCAP_KFS_NORMAL_IP6,        /* lan966x is1 X4 */
	VCAP_KFS_OAM,               /* lan966x is2 X2 */
	VCAP_KFS_PURE_5TUPLE_IP4,   /* sparx5 is0 X3 */
	VCAP_KFS_RT,                /* lan966x is1 X1 */
	VCAP_KFS_SMAC_SIP4,         /* lan966x is2 X1 */
	VCAP_KFS_SMAC_SIP6,         /* lan966x is2 X2 */
	VCAP_KFS_VID,               /* lan966x es0 X1 */
};

/* List of keyfields with description
 *
 * Keys ending in _IS are booleans derived from frame data
 * Keys ending in _CLS are classified frame data
 *
 * VCAP_KF_8021BR_ECID_BASE: W12, sparx5: is0
 *   Used by 802.1BR Bridge Port Extension in an E-Tag
 * VCAP_KF_8021BR_ECID_EXT: W8, sparx5: is0
 *   Used by 802.1BR Bridge Port Extension in an E-Tag
 * VCAP_KF_8021BR_E_TAGGED: W1, sparx5: is0
 *   Set for frames containing an E-TAG (802.1BR Ethertype 893f)
 * VCAP_KF_8021BR_GRP: W2, sparx5: is0
 *   E-Tag group bits in 802.1BR Bridge Port Extension
 * VCAP_KF_8021BR_IGR_ECID_BASE: W12, sparx5: is0
 *   Used by 802.1BR Bridge Port Extension in an E-Tag
 * VCAP_KF_8021BR_IGR_ECID_EXT: W8, sparx5: is0
 *   Used by 802.1BR Bridge Port Extension in an E-Tag
 * VCAP_KF_8021CB_R_TAGGED_IS: W1, lan966x: is1
 *   Set if frame contains an RTAG: IEEE 802.1CB (FRER Redundancy tag, Ethertype
 *   0xf1c1)
 * VCAP_KF_8021Q_DEI0: W1, sparx5: is0, lan966x: is1
 *   First DEI in multiple vlan tags (outer tag or default port tag)
 * VCAP_KF_8021Q_DEI1: W1, sparx5: is0, lan966x: is1
 *   Second DEI in multiple vlan tags (inner tag)
 * VCAP_KF_8021Q_DEI2: W1, sparx5: is0
 *   Third DEI in multiple vlan tags (not always available)
 * VCAP_KF_8021Q_DEI_CLS: W1, sparx5: is2/es2, lan966x: is2/es0
 *   Classified DEI
 * VCAP_KF_8021Q_PCP0: W3, sparx5: is0, lan966x: is1
 *   First PCP in multiple vlan tags (outer tag or default port tag)
 * VCAP_KF_8021Q_PCP1: W3, sparx5: is0, lan966x: is1
 *   Second PCP in multiple vlan tags (inner tag)
 * VCAP_KF_8021Q_PCP2: W3, sparx5: is0
 *   Third PCP in multiple vlan tags (not always available)
 * VCAP_KF_8021Q_PCP_CLS: W3, sparx5: is2/es2, lan966x: is2/es0
 *   Classified PCP
 * VCAP_KF_8021Q_TPID: W3, sparx5: es0
 *   TPID for outer tag: 0: Customer TPID 1: Service TPID (88A8 or programmable)
 * VCAP_KF_8021Q_TPID0: sparx5 is0 W3, lan966x is1 W1
 *   First TPIC in multiple vlan tags (outer tag or default port tag)
 * VCAP_KF_8021Q_TPID1: sparx5 is0 W3, lan966x is1 W1
 *   Second TPID in multiple vlan tags (inner tag)
 * VCAP_KF_8021Q_TPID2: W3, sparx5: is0
 *   Third TPID in multiple vlan tags (not always available)
 * VCAP_KF_8021Q_VID0: W12, sparx5: is0, lan966x: is1
 *   First VID in multiple vlan tags (outer tag or default port tag)
 * VCAP_KF_8021Q_VID1: W12, sparx5: is0, lan966x: is1
 *   Second VID in multiple vlan tags (inner tag)
 * VCAP_KF_8021Q_VID2: W12, sparx5: is0
 *   Third VID in multiple vlan tags (not always available)
 * VCAP_KF_8021Q_VID_CLS: sparx5 is2 W13, sparx5 es0 W13, sparx5 es2 W13,
 *   lan966x is2 W12, lan966x es0 W12
 *   Classified VID
 * VCAP_KF_8021Q_VLAN_DBL_TAGGED_IS: W1, lan966x: is1
 *   Set if frame has two or more Q-tags. Independent of port VLAN awareness
 * VCAP_KF_8021Q_VLAN_TAGGED_IS: W1, sparx5: is2/es2, lan966x: is1/is2
 *   Sparx5: Set if frame was received with a VLAN tag, LAN966x: Set if frame has
 *   one or more Q-tags. Independent of port VLAN awareness
 * VCAP_KF_8021Q_VLAN_TAGS: W3, sparx5: is0
 *   Number of VLAN tags in frame: 0: Untagged, 1: Single tagged, 3: Double
 *   tagged, 7: Triple tagged
 * VCAP_KF_ACL_GRP_ID: W8, sparx5: es2
 *   Used in interface map table
 * VCAP_KF_ARP_ADDR_SPACE_OK_IS: W1, sparx5: is2/es2, lan966x: is2
 *   Set if hardware address is Ethernet
 * VCAP_KF_ARP_LEN_OK_IS: W1, sparx5: is2/es2, lan966x: is2
 *   Set if hardware address length = 6 (Ethernet) and IP address length = 4 (IP).
 * VCAP_KF_ARP_OPCODE: W2, sparx5: is2/es2, lan966x: is2
 *   ARP opcode
 * VCAP_KF_ARP_OPCODE_UNKNOWN_IS: W1, sparx5: is2/es2, lan966x: is2
 *   Set if not one of the codes defined in VCAP_KF_ARP_OPCODE
 * VCAP_KF_ARP_PROTO_SPACE_OK_IS: W1, sparx5: is2/es2, lan966x: is2
 *   Set if protocol address space is 0x0800
 * VCAP_KF_ARP_SENDER_MATCH_IS: W1, sparx5: is2/es2, lan966x: is2
 *   Sender Hardware Address = SMAC (ARP)
 * VCAP_KF_ARP_TGT_MATCH_IS: W1, sparx5: is2/es2, lan966x: is2
 *   Target Hardware Address = SMAC (RARP)
 * VCAP_KF_COSID_CLS: W3, sparx5: es0/es2
 *   Class of service
 * VCAP_KF_ES0_ISDX_KEY_ENA: W1, sparx5: es2
 *   The value taken from the IFH .FWD.ES0_ISDX_KEY_ENA
 * VCAP_KF_ETYPE: W16, sparx5: is0/is2/es2, lan966x: is1/is2
 *   Ethernet type
 * VCAP_KF_ETYPE_LEN_IS: W1, sparx5: is0/is2/es2, lan966x: is1
 *   Set if frame has EtherType >= 0x600
 * VCAP_KF_HOST_MATCH: W1, lan966x: is2
 *   The action from the SMAC_SIP4 or SMAC_SIP6 lookups. Used for IP source
 *   guarding.
 * VCAP_KF_IF_EGR_PORT_MASK: W32, sparx5: es2
 *   Egress port mask, one bit per port
 * VCAP_KF_IF_EGR_PORT_MASK_RNG: W3, sparx5: es2
 *   Select which 32 port group is available in IF_EGR_PORT (or virtual ports or
 *   CPU queue)
 * VCAP_KF_IF_EGR_PORT_NO: sparx5 es0 W7, lan966x es0 W4
 *   Egress port number
 * VCAP_KF_IF_IGR_PORT: sparx5 is0 W7, sparx5 es2 W9, lan966x is1 W3, lan966x
 *   is2 W4, lan966x es0 W4
 *   Sparx5: Logical ingress port number retrieved from
 *   ANA_CL::PORT_ID_CFG.LPORT_NUM or ERLEG, LAN966x: ingress port nunmber
 * VCAP_KF_IF_IGR_PORT_MASK: sparx5 is0 W65, sparx5 is2 W32, sparx5 is2 W65,
 *   lan966x is1 W9, lan966x is2 W9
 *   Ingress port mask, one bit per port/erleg
 * VCAP_KF_IF_IGR_PORT_MASK_L3: W1, sparx5: is2
 *   If set, IF_IGR_PORT_MASK, IF_IGR_PORT_MASK_RNG, and IF_IGR_PORT_MASK_SEL are
 *   used to specify L3 interfaces
 * VCAP_KF_IF_IGR_PORT_MASK_RNG: W4, sparx5: is2
 *   Range selector for IF_IGR_PORT_MASK.  Specifies which group of 32 ports are
 *   available in IF_IGR_PORT_MASK
 * VCAP_KF_IF_IGR_PORT_MASK_SEL: W2, sparx5: is0/is2
 *   Mode selector for IF_IGR_PORT_MASK, applicable when IF_IGR_PORT_MASK_L3 == 0.
 *   Mapping: 0: DEFAULT 1: LOOPBACK 2: MASQUERADE 3: CPU_VD
 * VCAP_KF_IF_IGR_PORT_SEL: W1, sparx5: es2
 *   Selector for IF_IGR_PORT: physical port number or ERLEG
 * VCAP_KF_IP4_IS: W1, sparx5: is0/is2/es2, lan966x: is1/is2
 *   Set if frame has EtherType = 0x800 and IP version = 4
 * VCAP_KF_IP_MC_IS: W1, sparx5: is0, lan966x: is1
 *   Set if frame is IPv4 frame and frame's destination MAC address is an IPv4
 *   multicast address (0x01005E0 /25). Set if frame is IPv6 frame and frame's
 *   destination MAC address is an IPv6 multicast address (0x3333/16).
 * VCAP_KF_IP_PAYLOAD_5TUPLE: W32, sparx5: is0, lan966x: is1
 *   Payload bytes after IP header
 * VCAP_KF_IP_PAYLOAD_S1_IP6: W112, lan966x: is1
 *   Payload after IPv6 header
 * VCAP_KF_IP_SNAP_IS: W1, sparx5: is0, lan966x: is1
 *   Set if frame is IPv4, IPv6, or SNAP frame
 * VCAP_KF_ISDX_CLS: sparx5 is2 W12, sparx5 es0 W12, sparx5 es2 W12, lan966x es0
 *   W8
 *   Classified ISDX
 * VCAP_KF_ISDX_GT0_IS: W1, sparx5: is2/es0/es2, lan966x: is2/es0
 *   Set if classified ISDX > 0
 * VCAP_KF_L2_BC_IS: W1, sparx5: is0/is2/es2, lan966x: is1/is2/es0
 *   Set if frame's destination MAC address is the broadcast address
 *   (FF-FF-FF-FF-FF-FF).
 * VCAP_KF_L2_DMAC: W48, sparx5: is0/is2/es2, lan966x: is1/is2
 *   Destination MAC address
 * VCAP_KF_L2_FRM_TYPE: W4, lan966x: is2
 *   Frame subtype for specific EtherTypes (MRP, DLR)
 * VCAP_KF_L2_FWD_IS: W1, sparx5: is2
 *   Set if the frame is allowed to be forwarded to front ports
 * VCAP_KF_L2_LLC: W40, lan966x: is2
 *   LLC header and data after up to two VLAN tags and the type/length field
 * VCAP_KF_L2_MAC: W48, lan966x: is1
 *   MAC address (FIRST=1: SMAC, FIRST=0: DMAC)
 * VCAP_KF_L2_MC_IS: W1, sparx5: is0/is2/es2, lan966x: is1/is2/es0
 *   Set if frame's destination MAC address is a multicast address (bit 40 = 1).
 * VCAP_KF_L2_PAYLOAD0: W16, lan966x: is2
 *   Payload bytes 0-1 after the frame's EtherType
 * VCAP_KF_L2_PAYLOAD1: W8, lan966x: is2
 *   Payload byte 4 after the frame's EtherType. This is specifically for PTP
 *   frames.
 * VCAP_KF_L2_PAYLOAD2: W3, lan966x: is2
 *   Bits 7, 2, and 1 from payload byte 6 after the frame's EtherType. This is
 *   specifically for PTP frames.
 * VCAP_KF_L2_PAYLOAD_ETYPE: W64, sparx5: is2/es2
 *   Byte 0-7 of L2 payload after Type/Len field and overloading for OAM
 * VCAP_KF_L2_SMAC: W48, sparx5: is0/is2/es2, lan966x: is1/is2
 *   Source MAC address
 * VCAP_KF_L2_SNAP: W40, lan966x: is2
 *   SNAP header after LLC header (AA-AA-03)
 * VCAP_KF_L3_DIP_EQ_SIP_IS: W1, sparx5: is2/es2, lan966x: is2
 *   Set if Src IP matches Dst IP address
 * VCAP_KF_L3_DPL_CLS: W1, sparx5: es0/es2, lan966x: es0
 *   The frames drop precedence level
 * VCAP_KF_L3_DSCP: W6, sparx5: is0, lan966x: is1
 *   Frame's DSCP value
 * VCAP_KF_L3_DST_IS: W1, sparx5: is2
 *   Set if lookup is done for egress router leg
 * VCAP_KF_L3_FRAGMENT: W1, lan966x: is1/is2
 *   Set if IPv4 frame is fragmented
 * VCAP_KF_L3_FRAGMENT_TYPE: W2, sparx5: is0/is2/es2
 *   L3 Fragmentation type (none, initial, suspicious, valid follow up)
 * VCAP_KF_L3_FRAG_INVLD_L4_LEN: W1, sparx5: is0/is2
 *   Set if frame's L4 length is less than ANA_CL:COMMON:CLM_FRAGMENT_CFG.L4_MIN_L
 *   EN
 * VCAP_KF_L3_FRAG_OFS_GT0: W1, lan966x: is1/is2
 *   Set if IPv4 frame is fragmented and it is not the first fragment
 * VCAP_KF_L3_IP4_DIP: W32, sparx5: is0/is2/es2, lan966x: is1/is2
 *   Destination IPv4 Address
 * VCAP_KF_L3_IP4_SIP: W32, sparx5: is0/is2/es2, lan966x: is1/is2
 *   Source IPv4 Address
 * VCAP_KF_L3_IP6_DIP: sparx5 is0 W128, sparx5 is2 W128, sparx5 es2 W128,
 *   lan966x is1 W64, lan966x is1 W128, lan966x is2 W128
 *   Sparx5: Full IPv6 DIP, LAN966x: Either Full IPv6 DIP or a subset depending on
 *   frame type
 * VCAP_KF_L3_IP6_DIP_MSB: W16, lan966x: is1
 *   MS 16bits of IPv6 DIP
 * VCAP_KF_L3_IP6_SIP: sparx5 is0 W128, sparx5 is2 W128, sparx5 es2 W128,
 *   lan966x is1 W128, lan966x is1 W64, lan966x is2 W128
 *   Sparx5: Full IPv6 SIP, LAN966x: Either Full IPv6 SIP or a subset depending on
 *   frame type
 * VCAP_KF_L3_IP6_SIP_MSB: W16, lan966x: is1
 *   MS 16bits of IPv6 DIP
 * VCAP_KF_L3_IP_PROTO: W8, sparx5: is0/is2/es2, lan966x: is1/is2
 *   IPv4 frames: IP protocol. IPv6 frames: Next header, same as for IPV4
 * VCAP_KF_L3_OPTIONS_IS: W1, sparx5: is0/is2/es2, lan966x: is1/is2
 *   Set if IPv4 frame contains options (IP len > 5)
 * VCAP_KF_L3_PAYLOAD: sparx5 is2 W96, sparx5 is2 W40, sparx5 es2 W96, sparx5
 *   es2 W40, lan966x is2 W56
 *   Sparx5: Payload bytes after IP header. IPv4: IPv4 options are not parsed so
 *   payload is always taken 20 bytes after the start of the IPv4 header, LAN966x:
 *   Bytes 0-6 after IP header
 * VCAP_KF_L3_RT_IS: W1, sparx5: is2/es2
 *   Set if frame has hit a router leg
 * VCAP_KF_L3_TOS: W8, sparx5: is2/es2, lan966x: is2
 *   Sparx5: Frame's IPv4/IPv6 DSCP and ECN fields, LAN966x: IP TOS field
 * VCAP_KF_L3_TTL_GT0: W1, sparx5: is2/es2, lan966x: is2
 *   Set if IPv4 TTL / IPv6 hop limit is greater than 0
 * VCAP_KF_L4_1588_DOM: W8, lan966x: is2
 *   PTP over UDP: domainNumber
 * VCAP_KF_L4_1588_VER: W4, lan966x: is2
 *   PTP over UDP: version
 * VCAP_KF_L4_ACK: W1, sparx5: is2/es2, lan966x: is2
 *   Sparx5 and LAN966x: TCP flag ACK, LAN966x only: PTP over UDP: flagField bit 2
 *   (unicastFlag)
 * VCAP_KF_L4_DPORT: W16, sparx5: is2/es2, lan966x: is2
 *   Sparx5: TCP/UDP destination port. Overloading for IP_7TUPLE: Non-TCP/UDP IP
 *   frames: L4_DPORT = L3_IP_PROTO, LAN966x: TCP/UDP destination port
 * VCAP_KF_L4_FIN: W1, sparx5: is2/es2, lan966x: is2
 *   TCP flag FIN, LAN966x: TCP flag FIN, and for PTP over UDP: messageType bit 1
 * VCAP_KF_L4_PAYLOAD: W64, sparx5: is2/es2
 *   Payload bytes after TCP/UDP header Overloading for IP_7TUPLE: Non TCP/UDP
 *   frames: Payload bytes 0-7 after IP header. IPv4 options are not parsed so
 *   payload is always taken 20 bytes after the start of the IPv4 header for non
 *   TCP/UDP IPv4 frames
 * VCAP_KF_L4_PSH: W1, sparx5: is2/es2, lan966x: is2
 *   Sparx5: TCP flag PSH, LAN966x: TCP: TCP flag PSH. PTP over UDP: flagField bit
 *   1 (twoStepFlag)
 * VCAP_KF_L4_RNG: sparx5 is0 W8, sparx5 is2 W16, sparx5 es2 W16, lan966x is1
 *   W8, lan966x is2 W8
 *   Range checker bitmask (one for each range checker). Input into range checkers
 *   is taken from classified results (VID, DSCP) and frame (SPORT, DPORT, ETYPE,
 *   outer VID, inner VID)
 * VCAP_KF_L4_RST: W1, sparx5: is2/es2, lan966x: is2
 *   Sparx5: TCP flag RST , LAN966x: TCP: TCP flag RST. PTP over UDP: messageType
 *   bit 3
 * VCAP_KF_L4_SEQUENCE_EQ0_IS: W1, sparx5: is2/es2, lan966x: is2
 *   Set if TCP sequence number is 0, LAN966x: Overlayed with PTP over UDP:
 *   messageType bit 0
 * VCAP_KF_L4_SPORT: W16, sparx5: is0/is2/es2, lan966x: is1/is2
 *   TCP/UDP source port
 * VCAP_KF_L4_SPORT_EQ_DPORT_IS: W1, sparx5: is2/es2, lan966x: is2
 *   Set if UDP or TCP source port equals UDP or TCP destination port
 * VCAP_KF_L4_SYN: W1, sparx5: is2/es2, lan966x: is2
 *   Sparx5: TCP flag SYN, LAN966x: TCP: TCP flag SYN. PTP over UDP: messageType
 *   bit 2
 * VCAP_KF_L4_URG: W1, sparx5: is2/es2, lan966x: is2
 *   Sparx5: TCP flag URG, LAN966x: TCP: TCP flag URG. PTP over UDP: flagField bit
 *   7 (reserved)
 * VCAP_KF_LOOKUP_FIRST_IS: W1, sparx5: is0/is2/es2, lan966x: is1/is2
 *   Selects between entries relevant for first and second lookup. Set for first
 *   lookup, cleared for second lookup.
 * VCAP_KF_LOOKUP_GEN_IDX: W12, sparx5: is0
 *   Generic index - for chaining CLM instances
 * VCAP_KF_LOOKUP_GEN_IDX_SEL: W2, sparx5: is0
 *   Select the mode of the Generic Index
 * VCAP_KF_LOOKUP_INDEX: W2, lan966x: is1
 *   0: First lookup, 1: Second lookup, 2: Third lookup, Similar to VCAP_KF_FIRST
 *   but with extra info
 * VCAP_KF_LOOKUP_PAG: W8, sparx5: is2, lan966x: is2
 *   Classified Policy Association Group: chains rules from IS1/CLM to IS2
 * VCAP_KF_MIRROR_PROBE: W2, sparx5: es2
 *   Identifies frame copies generated as a result of mirroring
 * VCAP_KF_OAM_CCM_CNTS_EQ0: W1, sparx5: is2/es2, lan966x: is2
 *   Dual-ended loss measurement counters in CCM frames are all zero
 * VCAP_KF_OAM_DETECTED: W1, lan966x: is2
 *   This is missing in the datasheet, but present in the OAM keyset in XML
 * VCAP_KF_OAM_FLAGS: W8, lan966x: is2
 *   Frame's OAM flags
 * VCAP_KF_OAM_MEL_FLAGS: W7, lan966x: is2
 *   Encoding of MD level/MEG level (MEL)
 * VCAP_KF_OAM_MEPID: W16, lan966x: is2
 *   CCM frame's OAM MEP ID
 * VCAP_KF_OAM_OPCODE: W8, lan966x: is2
 *   Frame's OAM opcode
 * VCAP_KF_OAM_VER: W5, lan966x: is2
 *   Frame's OAM version
 * VCAP_KF_OAM_Y1731_IS: W1, sparx5: is2/es2, lan966x: is2
 *   Set if frame's EtherType = 0x8902
 * VCAP_KF_PDU_TYPE: W4, lan966x: es0
 *   PDU type value (none, OAM CCM, MRP, DLR, RTE, IPv4, IPv6, OAM non-CCM)
 * VCAP_KF_PROT_ACTIVE: W1, sparx5: es0/es2
 *   Protection is active
 * VCAP_KF_RTP_ID: W10, lan966x: es0
 *   Classified RTP_ID
 * VCAP_KF_RT_FRMID: W32, lan966x: is1
 *   Profinet or OPC-UA FrameId
 * VCAP_KF_RT_TYPE: W2, lan966x: is1
 *   Encoding of frame's EtherType: 0: Other, 1: Profinet, 2: OPC-UA, 3: Custom
 *   (ANA::RT_CUSTOM)
 * VCAP_KF_RT_VLAN_IDX: W3, lan966x: is1
 *   Real-time VLAN index from ANA::RT_VLAN_PCP
 * VCAP_KF_TCP_IS: W1, sparx5: is0/is2/es2, lan966x: is1/is2
 *   Set if frame is IPv4 TCP frame (IP protocol = 6) or IPv6 TCP frames (Next
 *   header = 6)
 * VCAP_KF_TCP_UDP_IS: W1, sparx5: is0/is2/es2, lan966x: is1
 *   Set if frame is IPv4/IPv6 TCP or UDP frame (IP protocol/next header equals 6
 *   or 17)
 * VCAP_KF_TYPE: sparx5 is0 W2, sparx5 is0 W1, sparx5 is2 W4, sparx5 is2 W2,
 *   sparx5 es0 W1, sparx5 es2 W3, lan966x is1 W1, lan966x is1 W2, lan966x is2 W4,
 *   lan966x is2 W2
 *   Keyset type id - set by the API
 */

/* Keyfield names */
enum vcap_key_field {
	VCAP_KF_NO_VALUE,  /* initial value */
	VCAP_KF_8021BR_ECID_BASE,
	VCAP_KF_8021BR_ECID_EXT,
	VCAP_KF_8021BR_E_TAGGED,
	VCAP_KF_8021BR_GRP,
	VCAP_KF_8021BR_IGR_ECID_BASE,
	VCAP_KF_8021BR_IGR_ECID_EXT,
	VCAP_KF_8021CB_R_TAGGED_IS,
	VCAP_KF_8021Q_DEI0,
	VCAP_KF_8021Q_DEI1,
	VCAP_KF_8021Q_DEI2,
	VCAP_KF_8021Q_DEI_CLS,
	VCAP_KF_8021Q_PCP0,
	VCAP_KF_8021Q_PCP1,
	VCAP_KF_8021Q_PCP2,
	VCAP_KF_8021Q_PCP_CLS,
	VCAP_KF_8021Q_TPID,
	VCAP_KF_8021Q_TPID0,
	VCAP_KF_8021Q_TPID1,
	VCAP_KF_8021Q_TPID2,
	VCAP_KF_8021Q_VID0,
	VCAP_KF_8021Q_VID1,
	VCAP_KF_8021Q_VID2,
	VCAP_KF_8021Q_VID_CLS,
	VCAP_KF_8021Q_VLAN_DBL_TAGGED_IS,
	VCAP_KF_8021Q_VLAN_TAGGED_IS,
	VCAP_KF_8021Q_VLAN_TAGS,
	VCAP_KF_ACL_GRP_ID,
	VCAP_KF_ARP_ADDR_SPACE_OK_IS,
	VCAP_KF_ARP_LEN_OK_IS,
	VCAP_KF_ARP_OPCODE,
	VCAP_KF_ARP_OPCODE_UNKNOWN_IS,
	VCAP_KF_ARP_PROTO_SPACE_OK_IS,
	VCAP_KF_ARP_SENDER_MATCH_IS,
	VCAP_KF_ARP_TGT_MATCH_IS,
	VCAP_KF_COSID_CLS,
	VCAP_KF_ES0_ISDX_KEY_ENA,
	VCAP_KF_ETYPE,
	VCAP_KF_ETYPE_LEN_IS,
	VCAP_KF_HOST_MATCH,
	VCAP_KF_IF_EGR_PORT_MASK,
	VCAP_KF_IF_EGR_PORT_MASK_RNG,
	VCAP_KF_IF_EGR_PORT_NO,
	VCAP_KF_IF_IGR_PORT,
	VCAP_KF_IF_IGR_PORT_MASK,
	VCAP_KF_IF_IGR_PORT_MASK_L3,
	VCAP_KF_IF_IGR_PORT_MASK_RNG,
	VCAP_KF_IF_IGR_PORT_MASK_SEL,
	VCAP_KF_IF_IGR_PORT_SEL,
	VCAP_KF_IP4_IS,
	VCAP_KF_IP_MC_IS,
	VCAP_KF_IP_PAYLOAD_5TUPLE,
	VCAP_KF_IP_PAYLOAD_S1_IP6,
	VCAP_KF_IP_SNAP_IS,
	VCAP_KF_ISDX_CLS,
	VCAP_KF_ISDX_GT0_IS,
	VCAP_KF_L2_BC_IS,
	VCAP_KF_L2_DMAC,
	VCAP_KF_L2_FRM_TYPE,
	VCAP_KF_L2_FWD_IS,
	VCAP_KF_L2_LLC,
	VCAP_KF_L2_MAC,
	VCAP_KF_L2_MC_IS,
	VCAP_KF_L2_PAYLOAD0,
	VCAP_KF_L2_PAYLOAD1,
	VCAP_KF_L2_PAYLOAD2,
	VCAP_KF_L2_PAYLOAD_ETYPE,
	VCAP_KF_L2_SMAC,
	VCAP_KF_L2_SNAP,
	VCAP_KF_L3_DIP_EQ_SIP_IS,
	VCAP_KF_L3_DPL_CLS,
	VCAP_KF_L3_DSCP,
	VCAP_KF_L3_DST_IS,
	VCAP_KF_L3_FRAGMENT,
	VCAP_KF_L3_FRAGMENT_TYPE,
	VCAP_KF_L3_FRAG_INVLD_L4_LEN,
	VCAP_KF_L3_FRAG_OFS_GT0,
	VCAP_KF_L3_IP4_DIP,
	VCAP_KF_L3_IP4_SIP,
	VCAP_KF_L3_IP6_DIP,
	VCAP_KF_L3_IP6_DIP_MSB,
	VCAP_KF_L3_IP6_SIP,
	VCAP_KF_L3_IP6_SIP_MSB,
	VCAP_KF_L3_IP_PROTO,
	VCAP_KF_L3_OPTIONS_IS,
	VCAP_KF_L3_PAYLOAD,
	VCAP_KF_L3_RT_IS,
	VCAP_KF_L3_TOS,
	VCAP_KF_L3_TTL_GT0,
	VCAP_KF_L4_1588_DOM,
	VCAP_KF_L4_1588_VER,
	VCAP_KF_L4_ACK,
	VCAP_KF_L4_DPORT,
	VCAP_KF_L4_FIN,
	VCAP_KF_L4_PAYLOAD,
	VCAP_KF_L4_PSH,
	VCAP_KF_L4_RNG,
	VCAP_KF_L4_RST,
	VCAP_KF_L4_SEQUENCE_EQ0_IS,
	VCAP_KF_L4_SPORT,
	VCAP_KF_L4_SPORT_EQ_DPORT_IS,
	VCAP_KF_L4_SYN,
	VCAP_KF_L4_URG,
	VCAP_KF_LOOKUP_FIRST_IS,
	VCAP_KF_LOOKUP_GEN_IDX,
	VCAP_KF_LOOKUP_GEN_IDX_SEL,
	VCAP_KF_LOOKUP_INDEX,
	VCAP_KF_LOOKUP_PAG,
	VCAP_KF_MIRROR_PROBE,
	VCAP_KF_OAM_CCM_CNTS_EQ0,
	VCAP_KF_OAM_DETECTED,
	VCAP_KF_OAM_FLAGS,
	VCAP_KF_OAM_MEL_FLAGS,
	VCAP_KF_OAM_MEPID,
	VCAP_KF_OAM_OPCODE,
	VCAP_KF_OAM_VER,
	VCAP_KF_OAM_Y1731_IS,
	VCAP_KF_PDU_TYPE,
	VCAP_KF_PROT_ACTIVE,
	VCAP_KF_RTP_ID,
	VCAP_KF_RT_FRMID,
	VCAP_KF_RT_TYPE,
	VCAP_KF_RT_VLAN_IDX,
	VCAP_KF_TCP_IS,
	VCAP_KF_TCP_UDP_IS,
	VCAP_KF_TYPE,
};

/* Actionset names with origin information */
enum vcap_actionfield_set {
	VCAP_AFS_NO_VALUE,          /* initial value */
	VCAP_AFS_BASE_TYPE,         /* sparx5 is2 X3, sparx5 es2 X3, lan966x is2 X2 */
	VCAP_AFS_CLASSIFICATION,    /* sparx5 is0 X2 */
	VCAP_AFS_CLASS_REDUCED,     /* sparx5 is0 X1 */
	VCAP_AFS_ES0,               /* sparx5 es0 X1 */
	VCAP_AFS_FULL,              /* sparx5 is0 X3 */
	VCAP_AFS_S1,                /* lan966x is1 X1 */
	VCAP_AFS_SMAC_SIP,          /* lan966x is2 X1 */
	VCAP_AFS_VID,               /* lan966x es0 X1 */
};

/* List of actionfields with description
 *
 * VCAP_AF_ACL_ID: W6, lan966x: is2
 *   Logical ID for the entry. This ID is extracted together with the frame in the
 *   CPU extraction header. Only applicable to actions with CPU_COPY_ENA or
 *   HIT_ME_ONCE set.
 * VCAP_AF_CLS_VID_SEL: W3, sparx5: is0
 *   Controls the classified VID: 0: VID_NONE: No action. 1: VID_ADD: New VID =
 *   old VID + VID_VAL. 2: VID_REPLACE: New VID = VID_VAL. 3: VID_FIRST_TAG: New
 *   VID = VID from frame's first tag (outer tag) if available, otherwise VID_VAL.
 *   4: VID_SECOND_TAG: New VID = VID from frame's second tag (middle tag) if
 *   available, otherwise VID_VAL. 5: VID_THIRD_TAG: New VID = VID from frame's
 *   third tag (inner tag) if available, otherwise VID_VAL.
 * VCAP_AF_CNT_ID: sparx5 is2 W12, sparx5 es2 W11
 *   Counter ID, used per lookup to index the 4K frame counters (ANA_ACL:CNT_TBL).
 *   Multiple VCAP IS2 entries can use the same counter.
 * VCAP_AF_COPY_PORT_NUM: W7, sparx5: es2
 *   QSYS port number when FWD_MODE is redirect or copy
 * VCAP_AF_COPY_QUEUE_NUM: W16, sparx5: es2
 *   QSYS queue number when FWD_MODE is redirect or copy
 * VCAP_AF_CPU_COPY_ENA: W1, sparx5: is2/es2, lan966x: is2
 *   Setting this bit to 1 causes all frames that hit this action to be copied to
 *   the CPU extraction queue specified in CPU_QUEUE_NUM.
 * VCAP_AF_CPU_QU: W3, sparx5: es0
 *   CPU extraction queue. Used when FWD_SEL >0 and PIPELINE_ACT = XTR.
 * VCAP_AF_CPU_QUEUE_NUM: W3, sparx5: is2/es2, lan966x: is2
 *   CPU queue number. Used when CPU_COPY_ENA is set.
 * VCAP_AF_CUSTOM_ACE_TYPE_ENA: W4, lan966x: is1
 *   Enables use of custom keys in IS2. Bits 3:2 control second lookup in IS2
 *   while bits 1:0 control first lookup. Encoding per lookup: 0: Disabled.  1:
 *   Extract 40 bytes after position corresponding to the location of the IPv4
 *   header and use as key.  2: Extract 40 bytes after SMAC and use as key
 * VCAP_AF_DEI_A_VAL: W1, sparx5: es0, lan966x: es0
 *   DEI used in ES0 tag A. See TAG_A_DEI_SEL.
 * VCAP_AF_DEI_B_VAL: W1, sparx5: es0, lan966x: es0
 *   DEI used in ES0 tag B. See TAG_B_DEI_SEL.
 * VCAP_AF_DEI_C_VAL: W1, sparx5: es0
 *   DEI used in ES0 tag C. See TAG_C_DEI_SEL.
 * VCAP_AF_DEI_ENA: W1, sparx5: is0, lan966x: is1
 *   If set, use DEI_VAL as classified DEI value. Otherwise, DEI from basic
 *   classification is used
 * VCAP_AF_DEI_VAL: W1, sparx5: is0, lan966x: is1
 *   See DEI_ENA
 * VCAP_AF_DLR_SEL: W2, lan966x: is1
 *   0: No changes to port-based selection in ANA:PORT:OAM_CFG.DLR_ENA.  1: Enable
 *   DLR frame processing 2: Disable DLR processing
 * VCAP_AF_DP_ENA: W1, sparx5: is0, lan966x: is1
 *   If set, use DP_VAL as classified drop precedence level. Otherwise, drop
 *   precedence level from basic classification is used.
 * VCAP_AF_DP_VAL: sparx5 is0 W2, lan966x is1 W1
 *   See DP_ENA.
 * VCAP_AF_DSCP_ENA: W1, sparx5: is0, lan966x: is1
 *   If set, use DSCP_VAL as classified DSCP value. Otherwise, DSCP value from
 *   basic classification is used.
 * VCAP_AF_DSCP_SEL: W3, sparx5: es0
 *   Selects source for DSCP. 0: Controlled by port configuration and IFH. 1:
 *   Classified DSCP via IFH. 2: DSCP_VAL. 3: Reserved. 4: Mapped using mapping
 *   table 0, otherwise use DSCP_VAL. 5: Mapped using mapping table 1, otherwise
 *   use mapping table 0. 6: Mapped using mapping table 2, otherwise use DSCP_VAL.
 *   7: Mapped using mapping table 3, otherwise use mapping table 2
 * VCAP_AF_DSCP_VAL: W6, sparx5: is0/es0, lan966x: is1
 *   See DSCP_ENA.
 * VCAP_AF_ES2_REW_CMD: W3, sparx5: es2
 *   Command forwarded to REW: 0: No action. 1: SWAP MAC addresses. 2: Do L2CP
 *   DMAC translation when entering or leaving a tunnel.
 * VCAP_AF_ESDX: sparx5 es0 W13, lan966x es0 W8
 *   Egress counter index. Used to index egress counter set as defined in
 *   REW::STAT_CFG.
 * VCAP_AF_FWD_KILL_ENA: W1, lan966x: is2
 *   Setting this bit to 1 denies forwarding of the frame forwarding to any front
 *   port. The frame can still be copied to the CPU by other actions.
 * VCAP_AF_FWD_MODE: W2, sparx5: es2
 *   Forward selector: 0: Forward. 1: Discard. 2: Redirect. 3: Copy.
 * VCAP_AF_FWD_SEL: W2, sparx5: es0
 *   ES0 Forward selector. 0: No action. 1: Copy to loopback interface. 2:
 *   Redirect to loopback interface. 3: Discard
 * VCAP_AF_HIT_ME_ONCE: W1, sparx5: is2/es2, lan966x: is2
 *   Setting this bit to 1 causes the first frame that hits this action where the
 *   HIT_CNT counter is zero to be copied to the CPU extraction queue specified in
 *   CPU_QUEUE_NUM. The HIT_CNT counter is then incremented and any frames that
 *   hit this action later are not copied to the CPU. To re-enable the HIT_ME_ONCE
 *   functionality, the HIT_CNT counter must be cleared.
 * VCAP_AF_HOST_MATCH: W1, lan966x: is2
 *   Used for IP source guarding. If set, it signals that the host is a valid (for
 *   instance a valid combination of source MAC address and source IP address).
 *   HOST_MATCH is input to the IS2 keys.
 * VCAP_AF_IGNORE_PIPELINE_CTRL: W1, sparx5: is2/es2
 *   Ignore ingress pipeline control. This enforces the use of the VCAP IS2 action
 *   even when the pipeline control has terminated the frame before VCAP IS2.
 * VCAP_AF_INTR_ENA: W1, sparx5: is2/es2
 *   If set, an interrupt is triggered when this rule is hit
 * VCAP_AF_ISDX_ADD_REPLACE_SEL: W1, sparx5: is0
 *   Controls the classified ISDX. 0: New ISDX = old ISDX + ISDX_VAL. 1: New ISDX
 *   = ISDX_VAL.
 * VCAP_AF_ISDX_ADD_VAL: W8, lan966x: is1
 *   If ISDX_REPLACE_ENA is set, ISDX_ADD_VAL is used directly as the new ISDX.
 *   Encoding: ISDX_REPLACE_ENA=0, ISDX_ADD_VAL=0: Disabled ISDX_EPLACE_ENA=0,
 *   ISDX_ADD_VAL>0: Add value to classified ISDX. ISDX_REPLACE_ENA=1: Replace
 *   with ISDX_ADD_VAL value.
 * VCAP_AF_ISDX_ENA: W1, lan966x: is2
 *   Setting this bit to 1 causes the classified ISDX to be set to the value of
 *   POLICE_IDX[8:0].
 * VCAP_AF_ISDX_REPLACE_ENA: W1, lan966x: is1
 *   If set, classified ISDX is set to ISDX_ADD_VAL.
 * VCAP_AF_ISDX_VAL: W12, sparx5: is0
 *   See isdx_add_replace_sel
 * VCAP_AF_LOOP_ENA: W1, sparx5: es0
 *   0: Forward based on PIPELINE_PT and FWD_SEL
 * VCAP_AF_LRN_DIS: W1, sparx5: is2, lan966x: is2
 *   Setting this bit to 1 disables learning of frames hitting this action.
 * VCAP_AF_MAP_IDX: W9, sparx5: is0
 *   Index for QoS mapping table lookup
 * VCAP_AF_MAP_KEY: W3, sparx5: is0
 *   Key type for QoS mapping table lookup. 0: DEI0, PCP0 (outer tag). 1: DEI1,
 *   PCP1 (middle tag). 2: DEI2, PCP2 (inner tag). 3: MPLS TC. 4: PCP0 (outer
 *   tag). 5: E-DEI, E-PCP (E-TAG). 6: DSCP if available, otherwise none. 7: DSCP
 *   if available, otherwise DEI0, PCP0 (outer tag) if available using MAP_IDX+8,
 *   otherwise none
 * VCAP_AF_MAP_LOOKUP_SEL: W2, sparx5: is0
 *   Selects which of the two QoS Mapping Table lookups that MAP_KEY and MAP_IDX
 *   are applied to. 0: No changes to the QoS Mapping Table lookup. 1: Update key
 *   type and index for QoS Mapping Table lookup #0. 2: Update key type and index
 *   for QoS Mapping Table lookup #1. 3: Reserved.
 * VCAP_AF_MASK_MODE: sparx5 is0 W3, sparx5 is2 W3, lan966x is2 W2
 *   Controls the PORT_MASK use. Sparx5: 0: OR_DSTMASK, 1: AND_VLANMASK, 2:
 *   REPLACE_PGID, 3: REPLACE_ALL, 4: REDIR_PGID, 5: OR_PGID_MASK, 6: VSTAX, 7:
 *   Not applicable. LAN966X: 0: No action, 1: Permit/deny (AND), 2: Policy
 *   forwarding (DMAC lookup), 3: Redirect. The CPU port is untouched by
 *   MASK_MODE.
 * VCAP_AF_MATCH_ID: W16, sparx5: is2
 *   Logical ID for the entry. The MATCH_ID is extracted together with the frame
 *   if the frame is forwarded to the CPU (CPU_COPY_ENA). The result is placed in
 *   IFH.CL_RSLT.
 * VCAP_AF_MATCH_ID_MASK: W16, sparx5: is2
 *   Mask used by MATCH_ID.
 * VCAP_AF_MIRROR_ENA: W1, lan966x: is2
 *   Setting this bit to 1 causes frames to be mirrored to the mirror target port
 *   (ANA::MIRRPORPORTS).
 * VCAP_AF_MIRROR_PROBE: W2, sparx5: is2
 *   Mirroring performed according to configuration of a mirror probe. 0: No
 *   mirroring. 1: Mirror probe 0. 2: Mirror probe 1. 3: Mirror probe 2
 * VCAP_AF_MIRROR_PROBE_ID: W2, sparx5: es2
 *   Signals a mirror probe to be placed in the IFH. Only possible when FWD_MODE
 *   is copy. 0: No mirroring. 1-3: Use mirror probe 0-2.
 * VCAP_AF_MRP_SEL: W2, lan966x: is1
 *   0: No changes to port-based selection in ANA:PORT:OAM_CFG.MRP_ENA.  1: Enable
 *   MRP frame processing 2: Disable MRP processing
 * VCAP_AF_NXT_IDX: W12, sparx5: is0
 *   Index used as part of key (field G_IDX) in the next lookup.
 * VCAP_AF_NXT_IDX_CTRL: W3, sparx5: is0
 *   Controls the generation of the G_IDX used in the VCAP CLM next lookup
 * VCAP_AF_OAM_SEL: W3, lan966x: is1
 *   0: No changes to port-based selection in ANA:PORT:OAM_CFG.OAM_CFG 1: Enable
 *   OAM frame processing for untagged frames 2: Enable OAM frame processing for
 *   single frames 3: Enable OAM frame processing for double frames 4: Disable OAM
 *   frame processing
 * VCAP_AF_PAG_OVERRIDE_MASK: W8, sparx5: is0, lan966x: is1
 *   Bits set in this mask will override PAG_VAL from port profile. New PAG = (PAG
 *   (input) AND ~PAG_OVERRIDE_MASK) OR (PAG_VAL AND PAG_OVERRIDE_MASK)
 * VCAP_AF_PAG_VAL: W8, sparx5: is0, lan966x: is1
 *   See PAG_OVERRIDE_MASK.
 * VCAP_AF_PCP_A_VAL: W3, sparx5: es0, lan966x: es0
 *   PCP used in ES0 tag A. See TAG_A_PCP_SEL.
 * VCAP_AF_PCP_B_VAL: W3, sparx5: es0, lan966x: es0
 *   PCP used in ES0 tag B. See TAG_B_PCP_SEL.
 * VCAP_AF_PCP_C_VAL: W3, sparx5: es0
 *   PCP used in ES0 tag C. See TAG_C_PCP_SEL.
 * VCAP_AF_PCP_ENA: W1, sparx5: is0, lan966x: is1
 *   If set, use PCP_VAL as classified PCP value. Otherwise, PCP from basic
 *   classification is used.
 * VCAP_AF_PCP_VAL: W3, sparx5: is0, lan966x: is1
 *   See PCP_ENA.
 * VCAP_AF_PIPELINE_ACT: W1, sparx5: es0
 *   Pipeline action when FWD_SEL > 0. 0: XTR. CPU_QU selects CPU extraction queue
 *   1: LBK_ASM.
 * VCAP_AF_PIPELINE_FORCE_ENA: W1, sparx5: is2
 *   If set, use PIPELINE_PT unconditionally and set PIPELINE_ACT = NONE if
 *   PIPELINE_PT == NONE. Overrules previous settings of pipeline point.
 * VCAP_AF_PIPELINE_PT: sparx5 is2 W5, sparx5 es0 W2
 *   Pipeline point used if PIPELINE_FORCE_ENA is set
 * VCAP_AF_POLICE_ENA: W1, sparx5: is2/es2, lan966x: is1/is2
 *   If set, POLICE_IDX is used to lookup ANA::POL.
 * VCAP_AF_POLICE_IDX: sparx5 is2 W6, sparx5 es2 W6, lan966x is1 W9, lan966x is2
 *   W9
 *   Policer index.
 * VCAP_AF_POLICE_REMARK: W1, sparx5: es2
 *   If set, frames exceeding policer rates are marked as yellow but not
 *   discarded.
 * VCAP_AF_POLICE_VCAP_ONLY: W1, lan966x: is2
 *   Disable policing from QoS, and port policers. Only the VCAP policer selected
 *   by POLICE_IDX is active. Only applies to the second lookup.
 * VCAP_AF_POP_VAL: W2, sparx5: es0
 *   Controls popping of Q-tags. The final number of Q-tags popped is calculated
 *   as shown in section 4.28.7.2 VLAN Pop Decision.
 * VCAP_AF_PORT_MASK: sparx5 is0 W65, sparx5 is2 W68, lan966x is2 W8
 *   Port mask applied to the forwarding decision based on MASK_MODE.
 * VCAP_AF_PUSH_CUSTOMER_TAG: W2, sparx5: es0
 *   Selects tag C mode: 0: Do not push tag C. 1: Push tag C if
 *   IFH.VSTAX.TAG.WAS_TAGGED = 1. 2: Push tag C if IFH.VSTAX.TAG.WAS_TAGGED = 0.
 *   3: Push tag C if UNTAG_VID_ENA = 0 or (C-TAG.VID ! = VID_C_VAL).
 * VCAP_AF_PUSH_INNER_TAG: W1, sparx5: es0, lan966x: es0
 *   Controls inner tagging. 0: Do not push ES0 tag B as inner tag. 1: Push ES0
 *   tag B as inner tag.
 * VCAP_AF_PUSH_OUTER_TAG: W2, sparx5: es0, lan966x: es0
 *   Controls outer tagging. 0: No ES0 tag A: Port tag is allowed if enabled on
 *   port. 1: ES0 tag A: Push ES0 tag A. No port tag. 2: Force port tag: Always
 *   push port tag. No ES0 tag A. 3: Force untag: Never push port tag or ES0 tag
 *   A.
 * VCAP_AF_QOS_ENA: W1, sparx5: is0, lan966x: is1
 *   If set, use QOS_VAL as classified QoS class. Otherwise, QoS class from basic
 *   classification is used.
 * VCAP_AF_QOS_VAL: W3, sparx5: is0, lan966x: is1
 *   See QOS_ENA.
 * VCAP_AF_REW_OP: W16, lan966x: is2
 *   Rewriter operation command.
 * VCAP_AF_RT_DIS: W1, sparx5: is2
 *   If set, routing is disallowed. Only applies when IS_INNER_ACL is 0. See also
 *   IGR_ACL_ENA, EGR_ACL_ENA, and RLEG_STAT_IDX.
 * VCAP_AF_SFID_ENA: W1, lan966x: is1
 *   If set, SFID_VAL is used to lookup ANA::SFID.
 * VCAP_AF_SFID_VAL: W8, lan966x: is1
 *   Stream filter identifier.
 * VCAP_AF_SGID_ENA: W1, lan966x: is1
 *   If set, SGID_VAL is used to lookup ANA::SGID.
 * VCAP_AF_SGID_VAL: W8, lan966x: is1
 *   Stream gate identifier.
 * VCAP_AF_SWAP_MACS_ENA: W1, sparx5: es0
 *   This setting is only active when FWD_SEL = 1 or FWD_SEL = 2 and PIPELINE_ACT
 *   = LBK_ASM. 0: No action. 1: Swap MACs and clear bit 40 in new SMAC.
 * VCAP_AF_TAG_A_DEI_SEL: sparx5 es0 W3, lan966x es0 W2
 *   Selects PCP for ES0 tag A. 0: Classified DEI. 1: DEI_A_VAL. 2: DP and QoS
 *   mapped to PCP (per port table). 3: DP.
 * VCAP_AF_TAG_A_PCP_SEL: sparx5 es0 W3, lan966x es0 W2
 *   Selects PCP for ES0 tag A. 0: Classified PCP. 1: PCP_A_VAL. 2: DP and QoS
 *   mapped to PCP (per port table). 3: QoS class.
 * VCAP_AF_TAG_A_TPID_SEL: sparx5 es0 W3, lan966x es0 W2
 *   Selects TPID for ES0 tag A: 0: 0x8100. 1: 0x88A8. 2: Custom
 *   (REW:PORT:PORT_VLAN_CFG.PORT_TPID). 3: If IFH.TAG_TYPE = 0 then 0x8100 else
 *   custom.
 * VCAP_AF_TAG_A_VID_SEL: sparx5 es0 W2, lan966x es0 W1
 *   Selects VID for ES0 tag A. 0: Classified VID + VID_A_VAL. 1: VID_A_VAL.
 * VCAP_AF_TAG_B_DEI_SEL: sparx5 es0 W3, lan966x es0 W2
 *   Selects PCP for ES0 tag B. 0: Classified DEI. 1: DEI_B_VAL. 2: DP and QoS
 *   mapped to PCP (per port table). 3: DP.
 * VCAP_AF_TAG_B_PCP_SEL: sparx5 es0 W3, lan966x es0 W2
 *   Selects PCP for ES0 tag B. 0: Classified PCP. 1: PCP_B_VAL. 2: DP and QoS
 *   mapped to PCP (per port table). 3: QoS class.
 * VCAP_AF_TAG_B_TPID_SEL: sparx5 es0 W3, lan966x es0 W2
 *   Selects TPID for ES0 tag B. 0: 0x8100. 1: 0x88A8. 2: Custom
 *   (REW:PORT:PORT_VLAN_CFG.PORT_TPID). 3: If IFH.TAG_TYPE = 0 then 0x8100 else
 *   custom.
 * VCAP_AF_TAG_B_VID_SEL: sparx5 es0 W2, lan966x es0 W1
 *   Selects VID for ES0 tag B. 0: Classified VID + VID_B_VAL. 1: VID_B_VAL.
 * VCAP_AF_TAG_C_DEI_SEL: W3, sparx5: es0
 *   Selects DEI source for ES0 tag C. 0: Classified DEI. 1: DEI_C_VAL. 2:
 *   REW::DP_MAP.DP [IFH.VSTAX.QOS.DP]. 3: DEI of popped VLAN tag if available
 *   (IFH.VSTAX.TAG.WAS_TAGGED = 1 and tot_pop_cnt>0) else DEI_C_VAL. 4: Mapped
 *   using mapping table 0, otherwise use DEI_C_VAL. 5: Mapped using mapping table
 *   1, otherwise use mapping table 0. 6: Mapped using mapping table 2, otherwise
 *   use DEI_C_VAL. 7: Mapped using mapping table 3, otherwise use mapping table
 *   2.
 * VCAP_AF_TAG_C_PCP_SEL: W3, sparx5: es0
 *   Selects PCP source for ES0 tag C. 0: Classified PCP. 1: PCP_C_VAL. 2:
 *   Reserved. 3: PCP of popped VLAN tag if available (IFH.VSTAX.TAG.WAS_TAGGED=1
 *   and tot_pop_cnt>0) else PCP_C_VAL. 4: Mapped using mapping table 0, otherwise
 *   use PCP_C_VAL. 5: Mapped using mapping table 1, otherwise use mapping table
 *   0. 6: Mapped using mapping table 2, otherwise use PCP_C_VAL. 7: Mapped using
 *   mapping table 3, otherwise use mapping table 2.
 * VCAP_AF_TAG_C_TPID_SEL: W3, sparx5: es0
 *   Selects TPID for ES0 tag C. 0: 0x8100. 1: 0x88A8. 2: Custom 1. 3: Custom 2.
 *   4: Custom 3. 5: See TAG_A_TPID_SEL.
 * VCAP_AF_TAG_C_VID_SEL: W2, sparx5: es0
 *   Selects VID for ES0 tag C. The resulting VID is termed C-TAG.VID. 0:
 *   Classified VID. 1: VID_C_VAL. 2: IFH.ENCAP.GVID. 3: Reserved.
 * VCAP_AF_TYPE: W1, sparx5: is0, lan966x: is1
 *   Actionset type id - Set by the API
 * VCAP_AF_UNTAG_VID_ENA: W1, sparx5: es0
 *   Controls insertion of tag C. Untag or insert mode can be selected. See
 *   PUSH_CUSTOMER_TAG.
 * VCAP_AF_VID_A_VAL: W12, sparx5: es0, lan966x: es0
 *   VID used in ES0 tag A. See TAG_A_VID_SEL.
 * VCAP_AF_VID_B_VAL: W12, sparx5: es0, lan966x: es0
 *   VID used in ES0 tag B. See TAG_B_VID_SEL.
 * VCAP_AF_VID_C_VAL: W12, sparx5: es0
 *   VID used in ES0 tag C. See TAG_C_VID_SEL.
 * VCAP_AF_VID_REPLACE_ENA: W1, lan966x: is1
 *   Controls the classified VID: VID_REPLACE_ENA=0: Add VID_ADD_VAL to basic
 *   classified VID and use result as new classified VID. VID_REPLACE_ENA = 1:
 *   Replace basic classified VID with VID_VAL value and use as new classified
 *   VID.
 * VCAP_AF_VID_VAL: sparx5 is0 W13, lan966x is1 W12
 *   New VID Value
 * VCAP_AF_VLAN_POP_CNT: W2, lan966x: is1
 *   See VLAN_POP_CNT_ENA
 * VCAP_AF_VLAN_POP_CNT_ENA: W1, lan966x: is1
 *   If set, use VLAN_POP_CNT as the number of VLAN tags to pop from the incoming
 *   frame. This number is used by the Rewriter. Otherwise, VLAN_POP_CNT from
 *   ANA:PORT:VLAN_CFG.VLAN_POP_CNT is used
 */

/* Actionfield names */
enum vcap_action_field {
	VCAP_AF_NO_VALUE,  /* initial value */
	VCAP_AF_ACL_ID,
	VCAP_AF_CLS_VID_SEL,
	VCAP_AF_CNT_ID,
	VCAP_AF_COPY_PORT_NUM,
	VCAP_AF_COPY_QUEUE_NUM,
	VCAP_AF_CPU_COPY_ENA,
	VCAP_AF_CPU_QU,
	VCAP_AF_CPU_QUEUE_NUM,
	VCAP_AF_CUSTOM_ACE_TYPE_ENA,
	VCAP_AF_DEI_A_VAL,
	VCAP_AF_DEI_B_VAL,
	VCAP_AF_DEI_C_VAL,
	VCAP_AF_DEI_ENA,
	VCAP_AF_DEI_VAL,
	VCAP_AF_DLR_SEL,
	VCAP_AF_DP_ENA,
	VCAP_AF_DP_VAL,
	VCAP_AF_DSCP_ENA,
	VCAP_AF_DSCP_SEL,
	VCAP_AF_DSCP_VAL,
	VCAP_AF_ES2_REW_CMD,
	VCAP_AF_ESDX,
	VCAP_AF_FWD_KILL_ENA,
	VCAP_AF_FWD_MODE,
	VCAP_AF_FWD_SEL,
	VCAP_AF_HIT_ME_ONCE,
	VCAP_AF_HOST_MATCH,
	VCAP_AF_IGNORE_PIPELINE_CTRL,
	VCAP_AF_INTR_ENA,
	VCAP_AF_ISDX_ADD_REPLACE_SEL,
	VCAP_AF_ISDX_ADD_VAL,
	VCAP_AF_ISDX_ENA,
	VCAP_AF_ISDX_REPLACE_ENA,
	VCAP_AF_ISDX_VAL,
	VCAP_AF_LOOP_ENA,
	VCAP_AF_LRN_DIS,
	VCAP_AF_MAP_IDX,
	VCAP_AF_MAP_KEY,
	VCAP_AF_MAP_LOOKUP_SEL,
	VCAP_AF_MASK_MODE,
	VCAP_AF_MATCH_ID,
	VCAP_AF_MATCH_ID_MASK,
	VCAP_AF_MIRROR_ENA,
	VCAP_AF_MIRROR_PROBE,
	VCAP_AF_MIRROR_PROBE_ID,
	VCAP_AF_MRP_SEL,
	VCAP_AF_NXT_IDX,
	VCAP_AF_NXT_IDX_CTRL,
	VCAP_AF_OAM_SEL,
	VCAP_AF_PAG_OVERRIDE_MASK,
	VCAP_AF_PAG_VAL,
	VCAP_AF_PCP_A_VAL,
	VCAP_AF_PCP_B_VAL,
	VCAP_AF_PCP_C_VAL,
	VCAP_AF_PCP_ENA,
	VCAP_AF_PCP_VAL,
	VCAP_AF_PIPELINE_ACT,
	VCAP_AF_PIPELINE_FORCE_ENA,
	VCAP_AF_PIPELINE_PT,
	VCAP_AF_POLICE_ENA,
	VCAP_AF_POLICE_IDX,
	VCAP_AF_POLICE_REMARK,
	VCAP_AF_POLICE_VCAP_ONLY,
	VCAP_AF_POP_VAL,
	VCAP_AF_PORT_MASK,
	VCAP_AF_PUSH_CUSTOMER_TAG,
	VCAP_AF_PUSH_INNER_TAG,
	VCAP_AF_PUSH_OUTER_TAG,
	VCAP_AF_QOS_ENA,
	VCAP_AF_QOS_VAL,
	VCAP_AF_REW_OP,
	VCAP_AF_RT_DIS,
	VCAP_AF_SFID_ENA,
	VCAP_AF_SFID_VAL,
	VCAP_AF_SGID_ENA,
	VCAP_AF_SGID_VAL,
	VCAP_AF_SWAP_MACS_ENA,
	VCAP_AF_TAG_A_DEI_SEL,
	VCAP_AF_TAG_A_PCP_SEL,
	VCAP_AF_TAG_A_TPID_SEL,
	VCAP_AF_TAG_A_VID_SEL,
	VCAP_AF_TAG_B_DEI_SEL,
	VCAP_AF_TAG_B_PCP_SEL,
	VCAP_AF_TAG_B_TPID_SEL,
	VCAP_AF_TAG_B_VID_SEL,
	VCAP_AF_TAG_C_DEI_SEL,
	VCAP_AF_TAG_C_PCP_SEL,
	VCAP_AF_TAG_C_TPID_SEL,
	VCAP_AF_TAG_C_VID_SEL,
	VCAP_AF_TYPE,
	VCAP_AF_UNTAG_VID_ENA,
	VCAP_AF_VID_A_VAL,
	VCAP_AF_VID_B_VAL,
	VCAP_AF_VID_C_VAL,
	VCAP_AF_VID_REPLACE_ENA,
	VCAP_AF_VID_VAL,
	VCAP_AF_VLAN_POP_CNT,
	VCAP_AF_VLAN_POP_CNT_ENA,
};

#endif /* __VCAP_AG_API__ */
