// SPDX-License-Identifier: GPL-2.0-only
/*
 * Hardware modules present on the OMAP54xx chips
 *
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com
 *
 * Paul Walmsley
 * Benoit Cousson
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 */

#include <linux/io.h>
#include <linux/power/smartreflex.h>

#include "omap_hwmod.h"
#include "omap_hwmod_common_data.h"
#include "cm1_54xx.h"
#include "cm2_54xx.h"
#include "prm54xx.h"

/* Base offset for all OMAP5 interrupts external to MPUSS */
#define OMAP54XX_IRQ_GIC_START	32

/*
 * IP blocks
 */

/*
 * 'dmm' class
 * instance(s): dmm
 */
static struct omap_hwmod_class omap54xx_dmm_hwmod_class = {
	.name	= "dmm",
};

/* dmm */
static struct omap_hwmod omap54xx_dmm_hwmod = {
	.name		= "dmm",
	.class		= &omap54xx_dmm_hwmod_class,
	.clkdm_name	= "emif_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_EMIF_DMM_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_EMIF_DMM_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'l3' class
 * instance(s): l3_instr, l3_main_1, l3_main_2, l3_main_3
 */
static struct omap_hwmod_class omap54xx_l3_hwmod_class = {
	.name	= "l3",
};

/* l3_instr */
static struct omap_hwmod omap54xx_l3_instr_hwmod = {
	.name		= "l3_instr",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INSTR_L3_INSTR_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INSTR_L3_INSTR_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* l3_main_1 */
static struct omap_hwmod omap54xx_l3_main_1_hwmod = {
	.name		= "l3_main_1",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3MAIN1_L3_MAIN_1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3MAIN1_L3_MAIN_1_CONTEXT_OFFSET,
		},
	},
};

/* l3_main_2 */
static struct omap_hwmod omap54xx_l3_main_2_hwmod = {
	.name		= "l3_main_2",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3main2_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3MAIN2_L3_MAIN_2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3MAIN2_L3_MAIN_2_CONTEXT_OFFSET,
		},
	},
};

/* l3_main_3 */
static struct omap_hwmod omap54xx_l3_main_3_hwmod = {
	.name		= "l3_main_3",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INSTR_L3_MAIN_3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INSTR_L3_MAIN_3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'l4' class
 * instance(s): l4_abe, l4_cfg, l4_per, l4_wkup
 */
static struct omap_hwmod_class omap54xx_l4_hwmod_class = {
	.name	= "l4",
};

/* l4_abe */
static struct omap_hwmod omap54xx_l4_abe_hwmod = {
	.name		= "l4_abe",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_L4_ABE_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/* l4_cfg */
static struct omap_hwmod omap54xx_l4_cfg_hwmod = {
	.name		= "l4_cfg",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4CFG_L4_CFG_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4CFG_L4_CFG_CONTEXT_OFFSET,
		},
	},
};

/* l4_per */
static struct omap_hwmod omap54xx_l4_per_hwmod = {
	.name		= "l4_per",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_L4_PER_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_L4_PER_CONTEXT_OFFSET,
		},
	},
};

/* l4_wkup */
static struct omap_hwmod omap54xx_l4_wkup_hwmod = {
	.name		= "l4_wkup",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_WKUPAON_L4_WKUP_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_WKUPAON_L4_WKUP_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'mpu_bus' class
 * instance(s): mpu_private
 */
static struct omap_hwmod_class omap54xx_mpu_bus_hwmod_class = {
	.name	= "mpu_bus",
};

/* mpu_private */
static struct omap_hwmod omap54xx_mpu_private_hwmod = {
	.name		= "mpu_private",
	.class		= &omap54xx_mpu_bus_hwmod_class,
	.clkdm_name	= "mpu_clkdm",
	.prcm = {
		.omap4 = {
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/*
 * 'emif' class
 * external memory interface no1 (wrapper)
 */

static struct omap_hwmod_class_sysconfig omap54xx_emif_sysc = {
	.rev_offs	= 0x0000,
};

static struct omap_hwmod_class omap54xx_emif_hwmod_class = {
	.name	= "emif",
	.sysc	= &omap54xx_emif_sysc,
};

/* emif1 */
static struct omap_hwmod omap54xx_emif1_hwmod = {
	.name		= "emif1",
	.class		= &omap54xx_emif_hwmod_class,
	.clkdm_name	= "emif_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE,
	.main_clk	= "dpll_core_h11x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_EMIF_EMIF1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_EMIF_EMIF1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* emif2 */
static struct omap_hwmod omap54xx_emif2_hwmod = {
	.name		= "emif2",
	.class		= &omap54xx_emif_hwmod_class,
	.clkdm_name	= "emif_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE,
	.main_clk	= "dpll_core_h11x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_EMIF_EMIF2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_EMIF_EMIF2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};




/*
 * 'mpu' class
 * mpu sub-system
 */

static struct omap_hwmod_class omap54xx_mpu_hwmod_class = {
	.name	= "mpu",
};

/* mpu */
static struct omap_hwmod omap54xx_mpu_hwmod = {
	.name		= "mpu",
	.class		= &omap54xx_mpu_hwmod_class,
	.clkdm_name	= "mpu_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE,
	.main_clk	= "dpll_mpu_m2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_MPU_MPU_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_MPU_MPU_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'sata' class
 * sata:  serial ata interface  gen2 compliant   ( 1 rx/ 1 tx)
 */

static struct omap_hwmod_class_sysconfig omap54xx_sata_sysc = {
	.rev_offs	= 0x00fc,
	.sysc_offs	= 0x0000,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_sata_hwmod_class = {
	.name	= "sata",
	.sysc	= &omap54xx_sata_sysc,
};

/* sata */
static struct omap_hwmod omap54xx_sata_hwmod = {
	.name		= "sata",
	.class		= &omap54xx_sata_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY,
	.main_clk	= "func_48m_fclk",
	.mpu_rt_idx	= 1,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_SATA_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_SATA_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* l4_cfg -> sata */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__sata = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_sata_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/*
 * Interfaces
 */

/* l3_main_1 -> dmm */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__dmm = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_dmm_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_SDMA,
};

/* l3_main_3 -> l3_instr */
static struct omap_hwmod_ocp_if omap54xx_l3_main_3__l3_instr = {
	.master		= &omap54xx_l3_main_3_hwmod,
	.slave		= &omap54xx_l3_instr_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_2 -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__l3_main_1 = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__l3_main_1 = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_mpu__l3_main_1 = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l3_main_1 -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l3_main_2 = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l4_cfg -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__l3_main_2 = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l3_main_3 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l3_main_3 = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l3_main_3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l3_main_2 -> l3_main_3 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__l3_main_3 = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_l3_main_3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_3 */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__l3_main_3 = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_l3_main_3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_abe */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l4_abe = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l4_abe_hwmod,
	.clk		= "abe_iclk",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> l4_abe */
static struct omap_hwmod_ocp_if omap54xx_mpu__l4_abe = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_l4_abe_hwmod,
	.clk		= "abe_iclk",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_cfg */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l4_cfg = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l4_cfg_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_2 -> l4_per */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__l4_per = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_l4_per_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_wkup */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l4_wkup = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l4_wkup_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> mpu_private */
static struct omap_hwmod_ocp_if omap54xx_mpu__mpu_private = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_mpu_private_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> emif1 */
static struct omap_hwmod_ocp_if omap54xx_mpu__emif1 = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_emif1_hwmod,
	.clk		= "dpll_core_h11x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> emif2 */
static struct omap_hwmod_ocp_if omap54xx_mpu__emif2 = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_emif2_hwmod,
	.clk		= "dpll_core_h11x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> mpu */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__mpu = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_mpu_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_ocp_if *omap54xx_hwmod_ocp_ifs[] __initdata = {
	&omap54xx_l3_main_1__dmm,
	&omap54xx_l3_main_3__l3_instr,
	&omap54xx_l3_main_2__l3_main_1,
	&omap54xx_l4_cfg__l3_main_1,
	&omap54xx_mpu__l3_main_1,
	&omap54xx_l3_main_1__l3_main_2,
	&omap54xx_l4_cfg__l3_main_2,
	&omap54xx_l3_main_1__l3_main_3,
	&omap54xx_l3_main_2__l3_main_3,
	&omap54xx_l4_cfg__l3_main_3,
	&omap54xx_l3_main_1__l4_abe,
	&omap54xx_mpu__l4_abe,
	&omap54xx_l3_main_1__l4_cfg,
	&omap54xx_l3_main_2__l4_per,
	&omap54xx_l3_main_1__l4_wkup,
	&omap54xx_mpu__mpu_private,
	&omap54xx_mpu__emif1,
	&omap54xx_mpu__emif2,
	&omap54xx_l4_cfg__mpu,
	&omap54xx_l4_cfg__sata,
	NULL,
};

int __init omap54xx_hwmod_init(void)
{
	omap_hwmod_init();
	return omap_hwmod_register_links(omap54xx_hwmod_ocp_ifs);
}
