/*
 * GPL HEADER START
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 only,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License version 2 for more details (a copy is included
 * in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License
 * version 2 along with this program; If not, see
 * http://www.sun.com/software/products/lustre/docs/GPLv2.pdf
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 *
 * GPL HEADER END
 */
/*
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 * Use is subject to license terms.
 *
 * Copyright (c) 2011, 2015, Intel Corporation.
 */
/*
 * This file is part of Lustre, http://www.lustre.org/
 * Lustre is a trademark of Sun Microsystems, Inc.
 */

#define DEBUG_SUBSYSTEM S_RPC

#include <linux/fs.h>
#include <linux/posix_acl_xattr.h>

#include "../include/obd_support.h"
#include "../include/obd_class.h"
#include "../include/lustre_net.h"
#include "../include/lustre_disk.h"
#include "ptlrpc_internal.h"

void lustre_assert_wire_constants(void)
{
	 /* Wire protocol assertions generated by 'wirecheck'
	  * (make -C lustre/utils newwiretest)
	  * running on Linux centos6-bis 2.6.32-358.0.1.el6-head
	  * #3 SMP Wed Apr 17 17:37:43 CEST 2013
	  * with gcc version 4.4.6 20110731 (Red Hat 4.4.6-3) (GCC)
	  */

	/* Constants... */
	LASSERTF(PTL_RPC_MSG_REQUEST == 4711, "found %lld\n",
		 (long long)PTL_RPC_MSG_REQUEST);
	LASSERTF(PTL_RPC_MSG_ERR == 4712, "found %lld\n",
		 (long long)PTL_RPC_MSG_ERR);
	LASSERTF(PTL_RPC_MSG_REPLY == 4713, "found %lld\n",
		 (long long)PTL_RPC_MSG_REPLY);
	LASSERTF(MDS_DIR_END_OFF == 0xfffffffffffffffeULL, "found 0x%.16llxULL\n",
		 MDS_DIR_END_OFF);
	LASSERTF(DEAD_HANDLE_MAGIC == 0xdeadbeefcafebabeULL, "found 0x%.16llxULL\n",
		 DEAD_HANDLE_MAGIC);
	CLASSERT(MTI_NAME_MAXLEN == 64);
	LASSERTF(OST_REPLY == 0, "found %lld\n",
		 (long long)OST_REPLY);
	LASSERTF(OST_GETATTR == 1, "found %lld\n",
		 (long long)OST_GETATTR);
	LASSERTF(OST_SETATTR == 2, "found %lld\n",
		 (long long)OST_SETATTR);
	LASSERTF(OST_READ == 3, "found %lld\n",
		 (long long)OST_READ);
	LASSERTF(OST_WRITE == 4, "found %lld\n",
		 (long long)OST_WRITE);
	LASSERTF(OST_CREATE == 5, "found %lld\n",
		 (long long)OST_CREATE);
	LASSERTF(OST_DESTROY == 6, "found %lld\n",
		 (long long)OST_DESTROY);
	LASSERTF(OST_GET_INFO == 7, "found %lld\n",
		 (long long)OST_GET_INFO);
	LASSERTF(OST_CONNECT == 8, "found %lld\n",
		 (long long)OST_CONNECT);
	LASSERTF(OST_DISCONNECT == 9, "found %lld\n",
		 (long long)OST_DISCONNECT);
	LASSERTF(OST_PUNCH == 10, "found %lld\n",
		 (long long)OST_PUNCH);
	LASSERTF(OST_OPEN == 11, "found %lld\n",
		 (long long)OST_OPEN);
	LASSERTF(OST_CLOSE == 12, "found %lld\n",
		 (long long)OST_CLOSE);
	LASSERTF(OST_STATFS == 13, "found %lld\n",
		 (long long)OST_STATFS);
	LASSERTF(OST_SYNC == 16, "found %lld\n",
		 (long long)OST_SYNC);
	LASSERTF(OST_SET_INFO == 17, "found %lld\n",
		 (long long)OST_SET_INFO);
	LASSERTF(OST_QUOTACHECK == 18, "found %lld\n",
		 (long long)OST_QUOTACHECK);
	LASSERTF(OST_QUOTACTL == 19, "found %lld\n",
		 (long long)OST_QUOTACTL);
	LASSERTF(OST_QUOTA_ADJUST_QUNIT == 20, "found %lld\n",
		 (long long)OST_QUOTA_ADJUST_QUNIT);
	LASSERTF(OST_LAST_OPC == 21, "found %lld\n",
		 (long long)OST_LAST_OPC);
	LASSERTF(OBD_OBJECT_EOF == 0xffffffffffffffffULL, "found 0x%.16llxULL\n",
		 OBD_OBJECT_EOF);
	LASSERTF(OST_MIN_PRECREATE == 32, "found %lld\n",
		 (long long)OST_MIN_PRECREATE);
	LASSERTF(OST_MAX_PRECREATE == 20000, "found %lld\n",
		 (long long)OST_MAX_PRECREATE);
	LASSERTF(OST_LVB_ERR_INIT == 0xffbadbad80000000ULL, "found 0x%.16llxULL\n",
		 OST_LVB_ERR_INIT);
	LASSERTF(OST_LVB_ERR_MASK == 0xffbadbad00000000ULL, "found 0x%.16llxULL\n",
		 OST_LVB_ERR_MASK);
	LASSERTF(MDS_FIRST_OPC == 33, "found %lld\n",
		 (long long)MDS_FIRST_OPC);
	LASSERTF(MDS_GETATTR == 33, "found %lld\n",
		 (long long)MDS_GETATTR);
	LASSERTF(MDS_GETATTR_NAME == 34, "found %lld\n",
		 (long long)MDS_GETATTR_NAME);
	LASSERTF(MDS_CLOSE == 35, "found %lld\n",
		 (long long)MDS_CLOSE);
	LASSERTF(MDS_REINT == 36, "found %lld\n",
		 (long long)MDS_REINT);
	LASSERTF(MDS_READPAGE == 37, "found %lld\n",
		 (long long)MDS_READPAGE);
	LASSERTF(MDS_CONNECT == 38, "found %lld\n",
		 (long long)MDS_CONNECT);
	LASSERTF(MDS_DISCONNECT == 39, "found %lld\n",
		 (long long)MDS_DISCONNECT);
	LASSERTF(MDS_GETSTATUS == 40, "found %lld\n",
		 (long long)MDS_GETSTATUS);
	LASSERTF(MDS_STATFS == 41, "found %lld\n",
		 (long long)MDS_STATFS);
	LASSERTF(MDS_PIN == 42, "found %lld\n",
		 (long long)MDS_PIN);
	LASSERTF(MDS_UNPIN == 43, "found %lld\n",
		 (long long)MDS_UNPIN);
	LASSERTF(MDS_SYNC == 44, "found %lld\n",
		 (long long)MDS_SYNC);
	LASSERTF(MDS_DONE_WRITING == 45, "found %lld\n",
		 (long long)MDS_DONE_WRITING);
	LASSERTF(MDS_SET_INFO == 46, "found %lld\n",
		 (long long)MDS_SET_INFO);
	LASSERTF(MDS_QUOTACHECK == 47, "found %lld\n",
		 (long long)MDS_QUOTACHECK);
	LASSERTF(MDS_QUOTACTL == 48, "found %lld\n",
		 (long long)MDS_QUOTACTL);
	LASSERTF(MDS_GETXATTR == 49, "found %lld\n",
		 (long long)MDS_GETXATTR);
	LASSERTF(MDS_SETXATTR == 50, "found %lld\n",
		 (long long)MDS_SETXATTR);
	LASSERTF(MDS_WRITEPAGE == 51, "found %lld\n",
		 (long long)MDS_WRITEPAGE);
	LASSERTF(MDS_IS_SUBDIR == 52, "found %lld\n",
		 (long long)MDS_IS_SUBDIR);
	LASSERTF(MDS_GET_INFO == 53, "found %lld\n",
		 (long long)MDS_GET_INFO);
	LASSERTF(MDS_HSM_STATE_GET == 54, "found %lld\n",
		 (long long)MDS_HSM_STATE_GET);
	LASSERTF(MDS_HSM_STATE_SET == 55, "found %lld\n",
		 (long long)MDS_HSM_STATE_SET);
	LASSERTF(MDS_HSM_ACTION == 56, "found %lld\n",
		 (long long)MDS_HSM_ACTION);
	LASSERTF(MDS_HSM_PROGRESS == 57, "found %lld\n",
		 (long long)MDS_HSM_PROGRESS);
	LASSERTF(MDS_HSM_REQUEST == 58, "found %lld\n",
		 (long long)MDS_HSM_REQUEST);
	LASSERTF(MDS_HSM_CT_REGISTER == 59, "found %lld\n",
		 (long long)MDS_HSM_CT_REGISTER);
	LASSERTF(MDS_HSM_CT_UNREGISTER == 60, "found %lld\n",
		 (long long)MDS_HSM_CT_UNREGISTER);
	LASSERTF(MDS_SWAP_LAYOUTS == 61, "found %lld\n",
		 (long long)MDS_SWAP_LAYOUTS);
	LASSERTF(MDS_LAST_OPC == 62, "found %lld\n",
		 (long long)MDS_LAST_OPC);
	LASSERTF(REINT_SETATTR == 1, "found %lld\n",
		 (long long)REINT_SETATTR);
	LASSERTF(REINT_CREATE == 2, "found %lld\n",
		 (long long)REINT_CREATE);
	LASSERTF(REINT_LINK == 3, "found %lld\n",
		 (long long)REINT_LINK);
	LASSERTF(REINT_UNLINK == 4, "found %lld\n",
		 (long long)REINT_UNLINK);
	LASSERTF(REINT_RENAME == 5, "found %lld\n",
		 (long long)REINT_RENAME);
	LASSERTF(REINT_OPEN == 6, "found %lld\n",
		 (long long)REINT_OPEN);
	LASSERTF(REINT_SETXATTR == 7, "found %lld\n",
		 (long long)REINT_SETXATTR);
	LASSERTF(REINT_RMENTRY == 8, "found %lld\n",
		 (long long)REINT_RMENTRY);
	LASSERTF(REINT_MAX == 9, "found %lld\n",
		 (long long)REINT_MAX);
	LASSERTF(DISP_IT_EXECD == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)DISP_IT_EXECD);
	LASSERTF(DISP_LOOKUP_EXECD == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)DISP_LOOKUP_EXECD);
	LASSERTF(DISP_LOOKUP_NEG == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)DISP_LOOKUP_NEG);
	LASSERTF(DISP_LOOKUP_POS == 0x00000008UL, "found 0x%.8xUL\n",
		(unsigned)DISP_LOOKUP_POS);
	LASSERTF(DISP_OPEN_CREATE == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)DISP_OPEN_CREATE);
	LASSERTF(DISP_OPEN_OPEN == 0x00000020UL, "found 0x%.8xUL\n",
		(unsigned)DISP_OPEN_OPEN);
	LASSERTF(DISP_ENQ_COMPLETE == 0x00400000UL, "found 0x%.8xUL\n",
		(unsigned)DISP_ENQ_COMPLETE);
	LASSERTF(DISP_ENQ_OPEN_REF == 0x00800000UL, "found 0x%.8xUL\n",
		(unsigned)DISP_ENQ_OPEN_REF);
	LASSERTF(DISP_ENQ_CREATE_REF == 0x01000000UL, "found 0x%.8xUL\n",
		(unsigned)DISP_ENQ_CREATE_REF);
	LASSERTF(DISP_OPEN_LOCK == 0x02000000UL, "found 0x%.8xUL\n",
		(unsigned)DISP_OPEN_LOCK);
	LASSERTF(MDS_STATUS_CONN == 1, "found %lld\n",
		 (long long)MDS_STATUS_CONN);
	LASSERTF(MDS_STATUS_LOV == 2, "found %lld\n",
		 (long long)MDS_STATUS_LOV);
	LASSERTF(LUSTRE_BFLAG_UNCOMMITTED_WRITES == 1, "found %lld\n",
		 (long long)LUSTRE_BFLAG_UNCOMMITTED_WRITES);
	LASSERTF(MF_SOM_CHANGE == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)MF_SOM_CHANGE);
	LASSERTF(MF_EPOCH_OPEN == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)MF_EPOCH_OPEN);
	LASSERTF(MF_EPOCH_CLOSE == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)MF_EPOCH_CLOSE);
	LASSERTF(MF_MDC_CANCEL_FID1 == 0x00000008UL, "found 0x%.8xUL\n",
		(unsigned)MF_MDC_CANCEL_FID1);
	LASSERTF(MF_MDC_CANCEL_FID2 == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)MF_MDC_CANCEL_FID2);
	LASSERTF(MF_MDC_CANCEL_FID3 == 0x00000020UL, "found 0x%.8xUL\n",
		(unsigned)MF_MDC_CANCEL_FID3);
	LASSERTF(MF_MDC_CANCEL_FID4 == 0x00000040UL, "found 0x%.8xUL\n",
		(unsigned)MF_MDC_CANCEL_FID4);
	LASSERTF(MF_SOM_AU == 0x00000080UL, "found 0x%.8xUL\n",
		(unsigned)MF_SOM_AU);
	LASSERTF(MF_GETATTR_LOCK == 0x00000100UL, "found 0x%.8xUL\n",
		(unsigned)MF_GETATTR_LOCK);
	LASSERTF(MDS_ATTR_MODE == 0x0000000000000001ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_MODE);
	LASSERTF(MDS_ATTR_UID == 0x0000000000000002ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_UID);
	LASSERTF(MDS_ATTR_GID == 0x0000000000000004ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_GID);
	LASSERTF(MDS_ATTR_SIZE == 0x0000000000000008ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_SIZE);
	LASSERTF(MDS_ATTR_ATIME == 0x0000000000000010ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_ATIME);
	LASSERTF(MDS_ATTR_MTIME == 0x0000000000000020ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_MTIME);
	LASSERTF(MDS_ATTR_CTIME == 0x0000000000000040ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_CTIME);
	LASSERTF(MDS_ATTR_ATIME_SET == 0x0000000000000080ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_ATIME_SET);
	LASSERTF(MDS_ATTR_MTIME_SET == 0x0000000000000100ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_MTIME_SET);
	LASSERTF(MDS_ATTR_FORCE == 0x0000000000000200ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_FORCE);
	LASSERTF(MDS_ATTR_ATTR_FLAG == 0x0000000000000400ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_ATTR_FLAG);
	LASSERTF(MDS_ATTR_KILL_SUID == 0x0000000000000800ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_KILL_SUID);
	LASSERTF(MDS_ATTR_KILL_SGID == 0x0000000000001000ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_KILL_SGID);
	LASSERTF(MDS_ATTR_CTIME_SET == 0x0000000000002000ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_CTIME_SET);
	LASSERTF(MDS_ATTR_FROM_OPEN == 0x0000000000004000ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_FROM_OPEN);
	LASSERTF(MDS_ATTR_BLOCKS == 0x0000000000008000ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_BLOCKS);
	LASSERTF(FLD_QUERY == 900, "found %lld\n",
		 (long long)FLD_QUERY);
	LASSERTF(FLD_FIRST_OPC == 900, "found %lld\n",
		 (long long)FLD_FIRST_OPC);
	LASSERTF(FLD_READ == 901, "found %lld\n",
		 (long long)FLD_READ);
	LASSERTF(FLD_LAST_OPC == 902, "found %lld\n",
		 (long long)FLD_LAST_OPC);
	LASSERTF(SEQ_QUERY == 700, "found %lld\n",
		 (long long)SEQ_QUERY);
	LASSERTF(SEQ_FIRST_OPC == 700, "found %lld\n",
		 (long long)SEQ_FIRST_OPC);
	LASSERTF(SEQ_LAST_OPC == 701, "found %lld\n",
		 (long long)SEQ_LAST_OPC);
	LASSERTF(SEQ_ALLOC_SUPER == 0, "found %lld\n",
		 (long long)SEQ_ALLOC_SUPER);
	LASSERTF(SEQ_ALLOC_META == 1, "found %lld\n",
		 (long long)SEQ_ALLOC_META);
	LASSERTF(LDLM_ENQUEUE == 101, "found %lld\n",
		 (long long)LDLM_ENQUEUE);
	LASSERTF(LDLM_CONVERT == 102, "found %lld\n",
		 (long long)LDLM_CONVERT);
	LASSERTF(LDLM_CANCEL == 103, "found %lld\n",
		 (long long)LDLM_CANCEL);
	LASSERTF(LDLM_BL_CALLBACK == 104, "found %lld\n",
		 (long long)LDLM_BL_CALLBACK);
	LASSERTF(LDLM_CP_CALLBACK == 105, "found %lld\n",
		 (long long)LDLM_CP_CALLBACK);
	LASSERTF(LDLM_GL_CALLBACK == 106, "found %lld\n",
		 (long long)LDLM_GL_CALLBACK);
	LASSERTF(LDLM_SET_INFO == 107, "found %lld\n",
		 (long long)LDLM_SET_INFO);
	LASSERTF(LDLM_LAST_OPC == 108, "found %lld\n",
		 (long long)LDLM_LAST_OPC);
	LASSERTF(LCK_MINMODE == 0, "found %lld\n",
		 (long long)LCK_MINMODE);
	LASSERTF(LCK_EX == 1, "found %lld\n",
		 (long long)LCK_EX);
	LASSERTF(LCK_PW == 2, "found %lld\n",
		 (long long)LCK_PW);
	LASSERTF(LCK_PR == 4, "found %lld\n",
		 (long long)LCK_PR);
	LASSERTF(LCK_CW == 8, "found %lld\n",
		 (long long)LCK_CW);
	LASSERTF(LCK_CR == 16, "found %lld\n",
		 (long long)LCK_CR);
	LASSERTF(LCK_NL == 32, "found %lld\n",
		 (long long)LCK_NL);
	LASSERTF(LCK_GROUP == 64, "found %lld\n",
		 (long long)LCK_GROUP);
	LASSERTF(LCK_COS == 128, "found %lld\n",
		 (long long)LCK_COS);
	LASSERTF(LCK_MAXMODE == 129, "found %lld\n",
		 (long long)LCK_MAXMODE);
	LASSERTF(LCK_MODE_NUM == 8, "found %lld\n",
		 (long long)LCK_MODE_NUM);
	CLASSERT(LDLM_PLAIN == 10);
	CLASSERT(LDLM_EXTENT == 11);
	CLASSERT(LDLM_FLOCK == 12);
	CLASSERT(LDLM_IBITS == 13);
	CLASSERT(LDLM_MAX_TYPE == 14);
	CLASSERT(LUSTRE_RES_ID_SEQ_OFF == 0);
	CLASSERT(LUSTRE_RES_ID_VER_OID_OFF == 1);
	CLASSERT(LUSTRE_RES_ID_QUOTA_SEQ_OFF == 2);
	CLASSERT(LUSTRE_RES_ID_QUOTA_VER_OID_OFF == 3);
	CLASSERT(LUSTRE_RES_ID_HSH_OFF == 3);
	LASSERTF(OBD_PING == 400, "found %lld\n",
		 (long long)OBD_PING);
	LASSERTF(OBD_LOG_CANCEL == 401, "found %lld\n",
		 (long long)OBD_LOG_CANCEL);
	LASSERTF(OBD_QC_CALLBACK == 402, "found %lld\n",
		 (long long)OBD_QC_CALLBACK);
	LASSERTF(OBD_IDX_READ == 403, "found %lld\n",
		 (long long)OBD_IDX_READ);
	LASSERTF(OBD_LAST_OPC == 404, "found %lld\n",
		 (long long)OBD_LAST_OPC);
	LASSERTF(QUOTA_DQACQ == 601, "found %lld\n",
		 (long long)QUOTA_DQACQ);
	LASSERTF(QUOTA_DQREL == 602, "found %lld\n",
		 (long long)QUOTA_DQREL);
	LASSERTF(QUOTA_LAST_OPC == 603, "found %lld\n",
		 (long long)QUOTA_LAST_OPC);
	LASSERTF(MGS_CONNECT == 250, "found %lld\n",
		 (long long)MGS_CONNECT);
	LASSERTF(MGS_DISCONNECT == 251, "found %lld\n",
		 (long long)MGS_DISCONNECT);
	LASSERTF(MGS_EXCEPTION == 252, "found %lld\n",
		 (long long)MGS_EXCEPTION);
	LASSERTF(MGS_TARGET_REG == 253, "found %lld\n",
		 (long long)MGS_TARGET_REG);
	LASSERTF(MGS_TARGET_DEL == 254, "found %lld\n",
		 (long long)MGS_TARGET_DEL);
	LASSERTF(MGS_SET_INFO == 255, "found %lld\n",
		 (long long)MGS_SET_INFO);
	LASSERTF(MGS_LAST_OPC == 257, "found %lld\n",
		 (long long)MGS_LAST_OPC);
	LASSERTF(SEC_CTX_INIT == 801, "found %lld\n",
		 (long long)SEC_CTX_INIT);
	LASSERTF(SEC_CTX_INIT_CONT == 802, "found %lld\n",
		 (long long)SEC_CTX_INIT_CONT);
	LASSERTF(SEC_CTX_FINI == 803, "found %lld\n",
		 (long long)SEC_CTX_FINI);
	LASSERTF(SEC_LAST_OPC == 804, "found %lld\n",
		 (long long)SEC_LAST_OPC);
	/* Sizes and Offsets */

	/* Checks for struct obd_uuid */
	LASSERTF((int)sizeof(struct obd_uuid) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct obd_uuid));

	/* Checks for struct lu_seq_range */
	LASSERTF((int)sizeof(struct lu_seq_range) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct lu_seq_range));
	LASSERTF((int)offsetof(struct lu_seq_range, lsr_start) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lu_seq_range, lsr_start));
	LASSERTF((int)sizeof(((struct lu_seq_range *)0)->lsr_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_seq_range *)0)->lsr_start));
	LASSERTF((int)offsetof(struct lu_seq_range, lsr_end) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lu_seq_range, lsr_end));
	LASSERTF((int)sizeof(((struct lu_seq_range *)0)->lsr_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_seq_range *)0)->lsr_end));
	LASSERTF((int)offsetof(struct lu_seq_range, lsr_index) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lu_seq_range, lsr_index));
	LASSERTF((int)sizeof(((struct lu_seq_range *)0)->lsr_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_seq_range *)0)->lsr_index));
	LASSERTF((int)offsetof(struct lu_seq_range, lsr_flags) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct lu_seq_range, lsr_flags));
	LASSERTF((int)sizeof(((struct lu_seq_range *)0)->lsr_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_seq_range *)0)->lsr_flags));
	LASSERTF(LU_SEQ_RANGE_MDT == 0, "found %lld\n",
		 (long long)LU_SEQ_RANGE_MDT);
	LASSERTF(LU_SEQ_RANGE_OST == 1, "found %lld\n",
		 (long long)LU_SEQ_RANGE_OST);

	/* Checks for struct lustre_mdt_attrs */
	LASSERTF((int)sizeof(struct lustre_mdt_attrs) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct lustre_mdt_attrs));
	LASSERTF((int)offsetof(struct lustre_mdt_attrs, lma_compat) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_mdt_attrs, lma_compat));
	LASSERTF((int)sizeof(((struct lustre_mdt_attrs *)0)->lma_compat) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_mdt_attrs *)0)->lma_compat));
	LASSERTF((int)offsetof(struct lustre_mdt_attrs, lma_incompat) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_mdt_attrs, lma_incompat));
	LASSERTF((int)sizeof(((struct lustre_mdt_attrs *)0)->lma_incompat) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_mdt_attrs *)0)->lma_incompat));
	LASSERTF((int)offsetof(struct lustre_mdt_attrs, lma_self_fid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_mdt_attrs, lma_self_fid));
	LASSERTF((int)sizeof(((struct lustre_mdt_attrs *)0)->lma_self_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_mdt_attrs *)0)->lma_self_fid));
	LASSERTF(LMAI_RELEASED == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)LMAI_RELEASED);
	LASSERTF(LMAC_HSM == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)LMAC_HSM);
	LASSERTF(LMAC_SOM == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)LMAC_SOM);
	LASSERTF(LMAC_NOT_IN_OI == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)LMAC_NOT_IN_OI);
	LASSERTF(LMAC_FID_ON_OST == 0x00000008UL, "found 0x%.8xUL\n",
		(unsigned)LMAC_FID_ON_OST);

	/* Checks for struct ost_id */
	LASSERTF((int)sizeof(struct ost_id) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct ost_id));
	LASSERTF((int)offsetof(struct ost_id, oi) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ost_id, oi));
	LASSERTF((int)sizeof(((struct ost_id *)0)->oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_id *)0)->oi));
	LASSERTF(LUSTRE_FID_INIT_OID == 1, "found %lld\n",
		 (long long)LUSTRE_FID_INIT_OID);
	LASSERTF(FID_SEQ_OST_MDT0 == 0, "found %lld\n",
		 (long long)FID_SEQ_OST_MDT0);
	LASSERTF(FID_SEQ_LLOG == 1, "found %lld\n",
		 (long long)FID_SEQ_LLOG);
	LASSERTF(FID_SEQ_ECHO == 2, "found %lld\n",
		 (long long)FID_SEQ_ECHO);
	LASSERTF(FID_SEQ_OST_MDT1 == 3, "found %lld\n",
		 (long long)FID_SEQ_OST_MDT1);
	LASSERTF(FID_SEQ_OST_MAX == 9, "found %lld\n",
		 (long long)FID_SEQ_OST_MAX);
	LASSERTF(FID_SEQ_RSVD == 11, "found %lld\n",
		 (long long)FID_SEQ_RSVD);
	LASSERTF(FID_SEQ_IGIF == 12, "found %lld\n",
		 (long long)FID_SEQ_IGIF);
	LASSERTF(FID_SEQ_IGIF_MAX == 0x00000000ffffffffULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_IGIF_MAX);
	LASSERTF(FID_SEQ_IDIF == 0x0000000100000000ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_IDIF);
	LASSERTF(FID_SEQ_IDIF_MAX == 0x00000001ffffffffULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_IDIF_MAX);
	LASSERTF(FID_SEQ_START == 0x0000000200000000ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_START);
	LASSERTF(FID_SEQ_LOCAL_FILE == 0x0000000200000001ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_LOCAL_FILE);
	LASSERTF(FID_SEQ_DOT_LUSTRE == 0x0000000200000002ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_DOT_LUSTRE);
	LASSERTF(FID_SEQ_SPECIAL == 0x0000000200000004ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_SPECIAL);
	LASSERTF(FID_SEQ_QUOTA == 0x0000000200000005ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_QUOTA);
	LASSERTF(FID_SEQ_QUOTA_GLB == 0x0000000200000006ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_QUOTA_GLB);
	LASSERTF(FID_SEQ_ROOT == 0x0000000200000007ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_ROOT);
	LASSERTF(FID_SEQ_NORMAL == 0x0000000200000400ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_NORMAL);
	LASSERTF(FID_SEQ_LOV_DEFAULT == 0xffffffffffffffffULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_LOV_DEFAULT);
	LASSERTF(FID_OID_SPECIAL_BFL == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)FID_OID_SPECIAL_BFL);
	LASSERTF(FID_OID_DOT_LUSTRE == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)FID_OID_DOT_LUSTRE);
	LASSERTF(FID_OID_DOT_LUSTRE_OBF == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)FID_OID_DOT_LUSTRE_OBF);

	/* Checks for struct lu_dirent */
	LASSERTF((int)sizeof(struct lu_dirent) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct lu_dirent));
	LASSERTF((int)offsetof(struct lu_dirent, lde_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_fid));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_fid));
	LASSERTF((int)offsetof(struct lu_dirent, lde_hash) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_hash));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_hash) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_hash));
	LASSERTF((int)offsetof(struct lu_dirent, lde_reclen) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_reclen));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_reclen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_reclen));
	LASSERTF((int)offsetof(struct lu_dirent, lde_namelen) == 26, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_namelen));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_namelen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_namelen));
	LASSERTF((int)offsetof(struct lu_dirent, lde_attrs) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_attrs));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_attrs) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_attrs));
	LASSERTF((int)offsetof(struct lu_dirent, lde_name[0]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_name[0]));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_name[0]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_name[0]));
	LASSERTF(LUDA_FID == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)LUDA_FID);
	LASSERTF(LUDA_TYPE == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)LUDA_TYPE);
	LASSERTF(LUDA_64BITHASH == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)LUDA_64BITHASH);

	/* Checks for struct luda_type */
	LASSERTF((int)sizeof(struct luda_type) == 2, "found %lld\n",
		 (long long)(int)sizeof(struct luda_type));
	LASSERTF((int)offsetof(struct luda_type, lt_type) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct luda_type, lt_type));
	LASSERTF((int)sizeof(((struct luda_type *)0)->lt_type) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct luda_type *)0)->lt_type));

	/* Checks for struct lu_dirpage */
	LASSERTF((int)sizeof(struct lu_dirpage) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct lu_dirpage));
	LASSERTF((int)offsetof(struct lu_dirpage, ldp_hash_start) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirpage, ldp_hash_start));
	LASSERTF((int)sizeof(((struct lu_dirpage *)0)->ldp_hash_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirpage *)0)->ldp_hash_start));
	LASSERTF((int)offsetof(struct lu_dirpage, ldp_hash_end) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirpage, ldp_hash_end));
	LASSERTF((int)sizeof(((struct lu_dirpage *)0)->ldp_hash_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirpage *)0)->ldp_hash_end));
	LASSERTF((int)offsetof(struct lu_dirpage, ldp_flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirpage, ldp_flags));
	LASSERTF((int)sizeof(((struct lu_dirpage *)0)->ldp_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirpage *)0)->ldp_flags));
	LASSERTF((int)offsetof(struct lu_dirpage, ldp_pad0) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirpage, ldp_pad0));
	LASSERTF((int)sizeof(((struct lu_dirpage *)0)->ldp_pad0) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirpage *)0)->ldp_pad0));
	LASSERTF((int)offsetof(struct lu_dirpage, ldp_entries[0]) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirpage, ldp_entries[0]));
	LASSERTF((int)sizeof(((struct lu_dirpage *)0)->ldp_entries[0]) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirpage *)0)->ldp_entries[0]));
	LASSERTF(LDF_EMPTY == 1, "found %lld\n",
		 (long long)LDF_EMPTY);
	LASSERTF(LDF_COLLIDE == 2, "found %lld\n",
		 (long long)LDF_COLLIDE);
	LASSERTF(LU_PAGE_SIZE == 4096, "found %lld\n",
		 (long long)LU_PAGE_SIZE);

	/* Checks for struct lustre_handle */
	LASSERTF((int)sizeof(struct lustre_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct lustre_handle));
	LASSERTF((int)offsetof(struct lustre_handle, cookie) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_handle, cookie));
	LASSERTF((int)sizeof(((struct lustre_handle *)0)->cookie) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_handle *)0)->cookie));

	/* Checks for struct lustre_msg_v2 */
	LASSERTF((int)sizeof(struct lustre_msg_v2) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct lustre_msg_v2));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_bufcount) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_bufcount));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_bufcount) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_bufcount));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_secflvr) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_secflvr));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_secflvr) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_secflvr));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_magic) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_magic));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_magic));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_repsize) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_repsize));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_repsize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_repsize));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_cksum) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_cksum));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_cksum) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_cksum));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_flags) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_flags));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_flags));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_padding_2) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_padding_2));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_2));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_padding_3) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_padding_3));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_3));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_buflens[0]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_buflens[0]));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_buflens[0]) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_buflens[0]));
	LASSERTF(LUSTRE_MSG_MAGIC_V2 == 0x0BD00BD3, "found 0x%.8x\n",
		LUSTRE_MSG_MAGIC_V2);
	LASSERTF(LUSTRE_MSG_MAGIC_V2_SWABBED == 0xD30BD00B, "found 0x%.8x\n",
		LUSTRE_MSG_MAGIC_V2_SWABBED);

	/* Checks for struct ptlrpc_body */
	LASSERTF((int)sizeof(struct ptlrpc_body_v3) == 184, "found %lld\n",
		 (long long)(int)sizeof(struct ptlrpc_body_v3));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_handle) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_handle));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_handle));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_type) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_type));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_type));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_version) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_version));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_version) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_version));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_opc) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_opc));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_opc) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_opc));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_status) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_status));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_status) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_status));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_last_xid) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_last_xid));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_xid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_xid));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_last_seen) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_last_seen));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_seen) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_seen));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_last_committed) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_last_committed));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_committed) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_committed));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_transno) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_transno));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_transno) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_transno));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_flags) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_flags));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_flags));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_op_flags) == 60, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_op_flags));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_op_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_op_flags));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_conn_cnt) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_conn_cnt));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_conn_cnt) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_conn_cnt));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_timeout) == 68, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_timeout));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_timeout) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_timeout));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_service_time) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_service_time));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_service_time) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_service_time));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_limit) == 76, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_limit));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_limit) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_limit));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_slv) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_slv));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_slv) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_slv));
	CLASSERT(PTLRPC_NUM_VERSIONS == 4);
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_pre_versions) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_pre_versions));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_pre_versions) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_pre_versions));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_padding));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding));
	CLASSERT(JOBSTATS_JOBID_SIZE == 32);
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_jobid) == 152, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_jobid));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_jobid) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_jobid));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_handle) == (int)offsetof(struct ptlrpc_body_v2, pb_handle), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_handle), (int)offsetof(struct ptlrpc_body_v2, pb_handle));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_handle) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_handle), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_handle), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_handle));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_type) == (int)offsetof(struct ptlrpc_body_v2, pb_type), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_type), (int)offsetof(struct ptlrpc_body_v2, pb_type));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_type) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_type), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_type), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_type));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_version) == (int)offsetof(struct ptlrpc_body_v2, pb_version), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_version), (int)offsetof(struct ptlrpc_body_v2, pb_version));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_version) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_version), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_version), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_version));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_opc) == (int)offsetof(struct ptlrpc_body_v2, pb_opc), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_opc), (int)offsetof(struct ptlrpc_body_v2, pb_opc));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_opc) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_opc), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_opc), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_opc));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_status) == (int)offsetof(struct ptlrpc_body_v2, pb_status), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_status), (int)offsetof(struct ptlrpc_body_v2, pb_status));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_status) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_status), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_status), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_status));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_last_xid) == (int)offsetof(struct ptlrpc_body_v2, pb_last_xid), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_last_xid), (int)offsetof(struct ptlrpc_body_v2, pb_last_xid));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_xid) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_last_xid), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_xid), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_last_xid));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_last_seen) == (int)offsetof(struct ptlrpc_body_v2, pb_last_seen), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_last_seen), (int)offsetof(struct ptlrpc_body_v2, pb_last_seen));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_seen) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_last_seen), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_seen), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_last_seen));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_last_committed) == (int)offsetof(struct ptlrpc_body_v2, pb_last_committed), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_last_committed), (int)offsetof(struct ptlrpc_body_v2, pb_last_committed));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_committed) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_last_committed), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_committed), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_last_committed));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_transno) == (int)offsetof(struct ptlrpc_body_v2, pb_transno), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_transno), (int)offsetof(struct ptlrpc_body_v2, pb_transno));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_transno) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_transno), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_transno), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_transno));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_flags) == (int)offsetof(struct ptlrpc_body_v2, pb_flags), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_flags), (int)offsetof(struct ptlrpc_body_v2, pb_flags));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_flags) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_flags), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_flags), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_flags));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_op_flags) == (int)offsetof(struct ptlrpc_body_v2, pb_op_flags), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_op_flags), (int)offsetof(struct ptlrpc_body_v2, pb_op_flags));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_op_flags) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_op_flags), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_op_flags), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_op_flags));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_conn_cnt) == (int)offsetof(struct ptlrpc_body_v2, pb_conn_cnt), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_conn_cnt), (int)offsetof(struct ptlrpc_body_v2, pb_conn_cnt));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_conn_cnt) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_conn_cnt), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_conn_cnt), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_conn_cnt));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_timeout) == (int)offsetof(struct ptlrpc_body_v2, pb_timeout), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_timeout), (int)offsetof(struct ptlrpc_body_v2, pb_timeout));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_timeout) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_timeout), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_timeout), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_timeout));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_service_time) == (int)offsetof(struct ptlrpc_body_v2, pb_service_time), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_service_time), (int)offsetof(struct ptlrpc_body_v2, pb_service_time));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_service_time) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_service_time), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_service_time), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_service_time));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_limit) == (int)offsetof(struct ptlrpc_body_v2, pb_limit), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_limit), (int)offsetof(struct ptlrpc_body_v2, pb_limit));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_limit) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_limit), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_limit), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_limit));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_slv) == (int)offsetof(struct ptlrpc_body_v2, pb_slv), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_slv), (int)offsetof(struct ptlrpc_body_v2, pb_slv));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_slv) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_slv), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_slv), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_slv));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_pre_versions) == (int)offsetof(struct ptlrpc_body_v2, pb_pre_versions), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_pre_versions), (int)offsetof(struct ptlrpc_body_v2, pb_pre_versions));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_pre_versions) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_pre_versions), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_pre_versions), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_pre_versions));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding) == (int)offsetof(struct ptlrpc_body_v2, pb_padding), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_padding), (int)offsetof(struct ptlrpc_body_v2, pb_padding));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding));
	LASSERTF(MSG_PTLRPC_BODY_OFF == 0, "found %lld\n",
		 (long long)MSG_PTLRPC_BODY_OFF);
	LASSERTF(REQ_REC_OFF == 1, "found %lld\n",
		 (long long)REQ_REC_OFF);
	LASSERTF(REPLY_REC_OFF == 1, "found %lld\n",
		 (long long)REPLY_REC_OFF);
	LASSERTF(DLM_LOCKREQ_OFF == 1, "found %lld\n",
		 (long long)DLM_LOCKREQ_OFF);
	LASSERTF(DLM_REQ_REC_OFF == 2, "found %lld\n",
		 (long long)DLM_REQ_REC_OFF);
	LASSERTF(DLM_INTENT_IT_OFF == 2, "found %lld\n",
		 (long long)DLM_INTENT_IT_OFF);
	LASSERTF(DLM_INTENT_REC_OFF == 3, "found %lld\n",
		 (long long)DLM_INTENT_REC_OFF);
	LASSERTF(DLM_LOCKREPLY_OFF == 1, "found %lld\n",
		 (long long)DLM_LOCKREPLY_OFF);
	LASSERTF(DLM_REPLY_REC_OFF == 2, "found %lld\n",
		 (long long)DLM_REPLY_REC_OFF);
	LASSERTF(MSG_PTLRPC_HEADER_OFF == 31, "found %lld\n",
		 (long long)MSG_PTLRPC_HEADER_OFF);
	LASSERTF(PTLRPC_MSG_VERSION == 0x00000003, "found 0x%.8x\n",
		PTLRPC_MSG_VERSION);
	LASSERTF(LUSTRE_VERSION_MASK == 0xffff0000, "found 0x%.8x\n",
		LUSTRE_VERSION_MASK);
	LASSERTF(LUSTRE_OBD_VERSION == 0x00010000, "found 0x%.8x\n",
		LUSTRE_OBD_VERSION);
	LASSERTF(LUSTRE_MDS_VERSION == 0x00020000, "found 0x%.8x\n",
		LUSTRE_MDS_VERSION);
	LASSERTF(LUSTRE_OST_VERSION == 0x00030000, "found 0x%.8x\n",
		LUSTRE_OST_VERSION);
	LASSERTF(LUSTRE_DLM_VERSION == 0x00040000, "found 0x%.8x\n",
		LUSTRE_DLM_VERSION);
	LASSERTF(LUSTRE_LOG_VERSION == 0x00050000, "found 0x%.8x\n",
		LUSTRE_LOG_VERSION);
	LASSERTF(LUSTRE_MGS_VERSION == 0x00060000, "found 0x%.8x\n",
		LUSTRE_MGS_VERSION);
	LASSERTF(MSGHDR_AT_SUPPORT == 1, "found %lld\n",
		 (long long)MSGHDR_AT_SUPPORT);
	LASSERTF(MSGHDR_CKSUM_INCOMPAT18 == 2, "found %lld\n",
		 (long long)MSGHDR_CKSUM_INCOMPAT18);
	LASSERTF(MSG_OP_FLAG_MASK == 0xffff0000UL, "found 0x%.8xUL\n",
		(unsigned)MSG_OP_FLAG_MASK);
	LASSERTF(MSG_OP_FLAG_SHIFT == 16, "found %lld\n",
		 (long long)MSG_OP_FLAG_SHIFT);
	LASSERTF(MSG_GEN_FLAG_MASK == 0x0000ffffUL, "found 0x%.8xUL\n",
		(unsigned)MSG_GEN_FLAG_MASK);
	LASSERTF(MSG_LAST_REPLAY == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)MSG_LAST_REPLAY);
	LASSERTF(MSG_RESENT == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)MSG_RESENT);
	LASSERTF(MSG_REPLAY == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)MSG_REPLAY);
	LASSERTF(MSG_DELAY_REPLAY == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)MSG_DELAY_REPLAY);
	LASSERTF(MSG_VERSION_REPLAY == 0x00000020UL, "found 0x%.8xUL\n",
		(unsigned)MSG_VERSION_REPLAY);
	LASSERTF(MSG_REQ_REPLAY_DONE == 0x00000040UL, "found 0x%.8xUL\n",
		(unsigned)MSG_REQ_REPLAY_DONE);
	LASSERTF(MSG_LOCK_REPLAY_DONE == 0x00000080UL, "found 0x%.8xUL\n",
		(unsigned)MSG_LOCK_REPLAY_DONE);
	LASSERTF(MSG_CONNECT_RECOVERING == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_RECOVERING);
	LASSERTF(MSG_CONNECT_RECONNECT == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_RECONNECT);
	LASSERTF(MSG_CONNECT_REPLAYABLE == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_REPLAYABLE);
	LASSERTF(MSG_CONNECT_LIBCLIENT == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_LIBCLIENT);
	LASSERTF(MSG_CONNECT_INITIAL == 0x00000020UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_INITIAL);
	LASSERTF(MSG_CONNECT_ASYNC == 0x00000040UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_ASYNC);
	LASSERTF(MSG_CONNECT_NEXT_VER == 0x00000080UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_NEXT_VER);
	LASSERTF(MSG_CONNECT_TRANSNO == 0x00000100UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_TRANSNO);

	/* Checks for struct obd_connect_data */
	LASSERTF((int)sizeof(struct obd_connect_data) == 192, "found %lld\n",
		 (long long)(int)sizeof(struct obd_connect_data));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_connect_flags) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_connect_flags));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_connect_flags) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_connect_flags));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_version) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_version));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_version) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_version));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_grant) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_grant));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_grant) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_grant));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_index) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_index));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_index));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_brw_size) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_brw_size));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_brw_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_brw_size));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_ibits_known) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_ibits_known));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_ibits_known) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_ibits_known));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_blocksize) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_blocksize));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_blocksize) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_blocksize));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_inodespace) == 33, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_inodespace));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_inodespace) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_inodespace));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_grant_extent) == 34, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_grant_extent));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_grant_extent) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_grant_extent));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_unused) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_unused));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_unused) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_unused));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_transno) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_transno));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_transno) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_transno));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_group) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_group));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_group) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_group));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_cksum_types) == 52, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_cksum_types));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_cksum_types) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_cksum_types));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_max_easize) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_max_easize));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_max_easize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_max_easize));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_instance) == 60, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_instance));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_instance) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_instance));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_maxbytes) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_maxbytes));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_maxbytes) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_maxbytes));
	LASSERTF((int)offsetof(struct obd_connect_data, padding1) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding1));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding1));
	LASSERTF((int)offsetof(struct obd_connect_data, padding2) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding2));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding2));
	LASSERTF((int)offsetof(struct obd_connect_data, padding3) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding3));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding3));
	LASSERTF((int)offsetof(struct obd_connect_data, padding4) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding4));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding4) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding4));
	LASSERTF((int)offsetof(struct obd_connect_data, padding5) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding5));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding5) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding5));
	LASSERTF((int)offsetof(struct obd_connect_data, padding6) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding6));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding6) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding6));
	LASSERTF((int)offsetof(struct obd_connect_data, padding7) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding7));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding7) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding7));
	LASSERTF((int)offsetof(struct obd_connect_data, padding8) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding8));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding8) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding8));
	LASSERTF((int)offsetof(struct obd_connect_data, padding9) == 136, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding9));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding9) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding9));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingA) == 144, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingA));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingA) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingA));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingB) == 152, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingB));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingB) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingB));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingC) == 160, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingC));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingC) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingC));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingD) == 168, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingD));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingD) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingD));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingE) == 176, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingE));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingE) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingE));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingF) == 184, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingF));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingF) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingF));
	LASSERTF(OBD_CONNECT_RDONLY == 0x1ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_RDONLY);
	LASSERTF(OBD_CONNECT_INDEX == 0x2ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_INDEX);
	LASSERTF(OBD_CONNECT_MDS == 0x4ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_MDS);
	LASSERTF(OBD_CONNECT_GRANT == 0x8ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_GRANT);
	LASSERTF(OBD_CONNECT_SRVLOCK == 0x10ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_SRVLOCK);
	LASSERTF(OBD_CONNECT_VERSION == 0x20ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_VERSION);
	LASSERTF(OBD_CONNECT_REQPORTAL == 0x40ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_REQPORTAL);
	LASSERTF(OBD_CONNECT_ACL == 0x80ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_ACL);
	LASSERTF(OBD_CONNECT_XATTR == 0x100ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_XATTR);
	LASSERTF(OBD_CONNECT_CROW == 0x200ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_CROW);
	LASSERTF(OBD_CONNECT_TRUNCLOCK == 0x400ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_TRUNCLOCK);
	LASSERTF(OBD_CONNECT_TRANSNO == 0x800ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_TRANSNO);
	LASSERTF(OBD_CONNECT_IBITS == 0x1000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_IBITS);
	LASSERTF(OBD_CONNECT_JOIN == 0x2000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_JOIN);
	LASSERTF(OBD_CONNECT_ATTRFID == 0x4000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_ATTRFID);
	LASSERTF(OBD_CONNECT_NODEVOH == 0x8000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_NODEVOH);
	LASSERTF(OBD_CONNECT_RMT_CLIENT == 0x10000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_RMT_CLIENT);
	LASSERTF(OBD_CONNECT_RMT_CLIENT_FORCE == 0x20000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_RMT_CLIENT_FORCE);
	LASSERTF(OBD_CONNECT_BRW_SIZE == 0x40000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_BRW_SIZE);
	LASSERTF(OBD_CONNECT_QUOTA64 == 0x80000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_QUOTA64);
	LASSERTF(OBD_CONNECT_MDS_CAPA == 0x100000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_MDS_CAPA);
	LASSERTF(OBD_CONNECT_OSS_CAPA == 0x200000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_OSS_CAPA);
	LASSERTF(OBD_CONNECT_CANCELSET == 0x400000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_CANCELSET);
	LASSERTF(OBD_CONNECT_SOM == 0x800000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_SOM);
	LASSERTF(OBD_CONNECT_AT == 0x1000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_AT);
	LASSERTF(OBD_CONNECT_LRU_RESIZE == 0x2000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LRU_RESIZE);
	LASSERTF(OBD_CONNECT_MDS_MDS == 0x4000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_MDS_MDS);
	LASSERTF(OBD_CONNECT_REAL == 0x8000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_REAL);
	LASSERTF(OBD_CONNECT_CHANGE_QS == 0x10000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_CHANGE_QS);
	LASSERTF(OBD_CONNECT_CKSUM == 0x20000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_CKSUM);
	LASSERTF(OBD_CONNECT_FID == 0x40000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_FID);
	LASSERTF(OBD_CONNECT_VBR == 0x80000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_VBR);
	LASSERTF(OBD_CONNECT_LOV_V3 == 0x100000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LOV_V3);
	LASSERTF(OBD_CONNECT_GRANT_SHRINK == 0x200000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_GRANT_SHRINK);
	LASSERTF(OBD_CONNECT_SKIP_ORPHAN == 0x400000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_SKIP_ORPHAN);
	LASSERTF(OBD_CONNECT_MAX_EASIZE == 0x800000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_MAX_EASIZE);
	LASSERTF(OBD_CONNECT_FULL20 == 0x1000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_FULL20);
	LASSERTF(OBD_CONNECT_LAYOUTLOCK == 0x2000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LAYOUTLOCK);
	LASSERTF(OBD_CONNECT_64BITHASH == 0x4000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_64BITHASH);
	LASSERTF(OBD_CONNECT_MAXBYTES == 0x8000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_MAXBYTES);
	LASSERTF(OBD_CONNECT_IMP_RECOV == 0x10000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_IMP_RECOV);
	LASSERTF(OBD_CONNECT_JOBSTATS == 0x20000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_JOBSTATS);
	LASSERTF(OBD_CONNECT_UMASK == 0x40000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_UMASK);
	LASSERTF(OBD_CONNECT_EINPROGRESS == 0x80000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_EINPROGRESS);
	LASSERTF(OBD_CONNECT_GRANT_PARAM == 0x100000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_GRANT_PARAM);
	LASSERTF(OBD_CONNECT_FLOCK_OWNER == 0x200000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_FLOCK_OWNER);
	LASSERTF(OBD_CONNECT_LVB_TYPE == 0x400000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LVB_TYPE);
	LASSERTF(OBD_CONNECT_NANOSEC_TIME == 0x800000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_NANOSEC_TIME);
	LASSERTF(OBD_CONNECT_LIGHTWEIGHT == 0x1000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LIGHTWEIGHT);
	LASSERTF(OBD_CONNECT_SHORTIO == 0x2000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_SHORTIO);
	LASSERTF(OBD_CONNECT_PINGLESS == 0x4000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_PINGLESS);
	LASSERTF(OBD_CONNECT_FLOCK_DEAD == 0x8000000000000ULL,
		 "found 0x%.16llxULL\n", OBD_CONNECT_FLOCK_DEAD);
	LASSERTF(OBD_CONNECT_OPEN_BY_FID == 0x20000000000000ULL,
		 "found 0x%.16llxULL\n", OBD_CONNECT_OPEN_BY_FID);
	LASSERTF(OBD_CKSUM_CRC32 == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)OBD_CKSUM_CRC32);
	LASSERTF(OBD_CKSUM_ADLER == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)OBD_CKSUM_ADLER);
	LASSERTF(OBD_CKSUM_CRC32C == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)OBD_CKSUM_CRC32C);

	/* Checks for struct obdo */
	LASSERTF((int)sizeof(struct obdo) == 208, "found %lld\n",
		 (long long)(int)sizeof(struct obdo));
	LASSERTF((int)offsetof(struct obdo, o_valid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_valid));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_valid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_valid));
	LASSERTF((int)offsetof(struct obdo, o_oi) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_oi));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_oi));
	LASSERTF((int)offsetof(struct obdo, o_parent_seq) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_parent_seq));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_parent_seq) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_parent_seq));
	LASSERTF((int)offsetof(struct obdo, o_size) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_size));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_size));
	LASSERTF((int)offsetof(struct obdo, o_mtime) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_mtime));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_mtime));
	LASSERTF((int)offsetof(struct obdo, o_atime) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_atime));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_atime));
	LASSERTF((int)offsetof(struct obdo, o_ctime) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_ctime));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_ctime));
	LASSERTF((int)offsetof(struct obdo, o_blocks) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_blocks));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_blocks));
	LASSERTF((int)offsetof(struct obdo, o_grant) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_grant));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_grant) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_grant));
	LASSERTF((int)offsetof(struct obdo, o_blksize) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_blksize));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_blksize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_blksize));
	LASSERTF((int)offsetof(struct obdo, o_mode) == 84, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_mode));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_mode));
	LASSERTF((int)offsetof(struct obdo, o_uid) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_uid));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_uid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_uid));
	LASSERTF((int)offsetof(struct obdo, o_gid) == 92, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_gid));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_gid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_gid));
	LASSERTF((int)offsetof(struct obdo, o_flags) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_flags));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_flags));
	LASSERTF((int)offsetof(struct obdo, o_nlink) == 100, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_nlink));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_nlink) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_nlink));
	LASSERTF((int)offsetof(struct obdo, o_parent_oid) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_parent_oid));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_parent_oid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_parent_oid));
	LASSERTF((int)offsetof(struct obdo, o_misc) == 108, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_misc));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_misc) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_misc));
	LASSERTF((int)offsetof(struct obdo, o_ioepoch) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_ioepoch));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_ioepoch) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_ioepoch));
	LASSERTF((int)offsetof(struct obdo, o_stripe_idx) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_stripe_idx));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_stripe_idx) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_stripe_idx));
	LASSERTF((int)offsetof(struct obdo, o_parent_ver) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_parent_ver));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_parent_ver) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_parent_ver));
	LASSERTF((int)offsetof(struct obdo, o_handle) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_handle));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_handle));
	LASSERTF((int)offsetof(struct obdo, o_lcookie) == 136, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_lcookie));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_lcookie) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_lcookie));
	LASSERTF((int)offsetof(struct obdo, o_uid_h) == 168, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_uid_h));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_uid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_uid_h));
	LASSERTF((int)offsetof(struct obdo, o_gid_h) == 172, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_gid_h));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_gid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_gid_h));
	LASSERTF((int)offsetof(struct obdo, o_data_version) == 176, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_data_version));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_data_version) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_data_version));
	LASSERTF((int)offsetof(struct obdo, o_padding_4) == 184, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_padding_4));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_4) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_padding_4));
	LASSERTF((int)offsetof(struct obdo, o_padding_5) == 192, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_padding_5));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_5) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_padding_5));
	LASSERTF((int)offsetof(struct obdo, o_padding_6) == 200, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_padding_6));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_6) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_padding_6));
	LASSERTF(OBD_MD_FLID == (0x00000001ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLID);
	LASSERTF(OBD_MD_FLATIME == (0x00000002ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLATIME);
	LASSERTF(OBD_MD_FLMTIME == (0x00000004ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLMTIME);
	LASSERTF(OBD_MD_FLCTIME == (0x00000008ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLCTIME);
	LASSERTF(OBD_MD_FLSIZE == (0x00000010ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLSIZE);
	LASSERTF(OBD_MD_FLBLOCKS == (0x00000020ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLBLOCKS);
	LASSERTF(OBD_MD_FLBLKSZ == (0x00000040ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLBLKSZ);
	LASSERTF(OBD_MD_FLMODE == (0x00000080ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLMODE);
	LASSERTF(OBD_MD_FLTYPE == (0x00000100ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLTYPE);
	LASSERTF(OBD_MD_FLUID == (0x00000200ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLUID);
	LASSERTF(OBD_MD_FLGID == (0x00000400ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGID);
	LASSERTF(OBD_MD_FLFLAGS == (0x00000800ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLFLAGS);
	LASSERTF(OBD_MD_FLNLINK == (0x00002000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLNLINK);
	LASSERTF(OBD_MD_FLGENER == (0x00004000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGENER);
	LASSERTF(OBD_MD_FLRDEV == (0x00010000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLRDEV);
	LASSERTF(OBD_MD_FLEASIZE == (0x00020000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLEASIZE);
	LASSERTF(OBD_MD_LINKNAME == (0x00040000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_LINKNAME);
	LASSERTF(OBD_MD_FLHANDLE == (0x00080000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLHANDLE);
	LASSERTF(OBD_MD_FLCKSUM == (0x00100000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLCKSUM);
	LASSERTF(OBD_MD_FLQOS == (0x00200000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLQOS);
	LASSERTF(OBD_MD_FLCOOKIE == (0x00800000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLCOOKIE);
	LASSERTF(OBD_MD_FLGROUP == (0x01000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGROUP);
	LASSERTF(OBD_MD_FLFID == (0x02000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLFID);
	LASSERTF(OBD_MD_FLEPOCH == (0x04000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLEPOCH);
	LASSERTF(OBD_MD_FLGRANT == (0x08000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGRANT);
	LASSERTF(OBD_MD_FLDIREA == (0x10000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLDIREA);
	LASSERTF(OBD_MD_FLUSRQUOTA == (0x20000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLUSRQUOTA);
	LASSERTF(OBD_MD_FLGRPQUOTA == (0x40000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGRPQUOTA);
	LASSERTF(OBD_MD_FLMODEASIZE == (0x80000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLMODEASIZE);
	LASSERTF(OBD_MD_MDS == (0x0000000100000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_MDS);
	LASSERTF(OBD_MD_REINT == (0x0000000200000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_REINT);
	LASSERTF(OBD_MD_MEA == (0x0000000400000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_MEA);
	LASSERTF(OBD_MD_TSTATE == (0x0000000800000000ULL),
		 "found 0x%.16llxULL\n", OBD_MD_TSTATE);
	LASSERTF(OBD_MD_FLXATTR == (0x0000001000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLXATTR);
	LASSERTF(OBD_MD_FLXATTRLS == (0x0000002000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLXATTRLS);
	LASSERTF(OBD_MD_FLXATTRRM == (0x0000004000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLXATTRRM);
	LASSERTF(OBD_MD_FLACL == (0x0000008000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLACL);
	LASSERTF(OBD_MD_FLRMTPERM == (0x0000010000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLRMTPERM);
	LASSERTF(OBD_MD_FLMDSCAPA == (0x0000020000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLMDSCAPA);
	LASSERTF(OBD_MD_FLOSSCAPA == (0x0000040000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLOSSCAPA);
	LASSERTF(OBD_MD_FLCKSPLIT == (0x0000080000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLCKSPLIT);
	LASSERTF(OBD_MD_FLCROSSREF == (0x0000100000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLCROSSREF);
	LASSERTF(OBD_MD_FLGETATTRLOCK == (0x0000200000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGETATTRLOCK);
	LASSERTF(OBD_MD_FLRMTLSETFACL == (0x0001000000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLRMTLSETFACL);
	LASSERTF(OBD_MD_FLRMTLGETFACL == (0x0002000000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLRMTLGETFACL);
	LASSERTF(OBD_MD_FLRMTRSETFACL == (0x0004000000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLRMTRSETFACL);
	LASSERTF(OBD_MD_FLRMTRGETFACL == (0x0008000000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLRMTRGETFACL);
	LASSERTF(OBD_MD_FLDATAVERSION == (0x0010000000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLDATAVERSION);
	CLASSERT(OBD_FL_INLINEDATA == 0x00000001);
	CLASSERT(OBD_FL_OBDMDEXISTS == 0x00000002);
	CLASSERT(OBD_FL_DELORPHAN == 0x00000004);
	CLASSERT(OBD_FL_NORPC == 0x00000008);
	CLASSERT(OBD_FL_IDONLY == 0x00000010);
	CLASSERT(OBD_FL_RECREATE_OBJS == 0x00000020);
	CLASSERT(OBD_FL_DEBUG_CHECK == 0x00000040);
	CLASSERT(OBD_FL_NO_USRQUOTA == 0x00000100);
	CLASSERT(OBD_FL_NO_GRPQUOTA == 0x00000200);
	CLASSERT(OBD_FL_CREATE_CROW == 0x00000400);
	CLASSERT(OBD_FL_SRVLOCK == 0x00000800);
	CLASSERT(OBD_FL_CKSUM_CRC32 == 0x00001000);
	CLASSERT(OBD_FL_CKSUM_ADLER == 0x00002000);
	CLASSERT(OBD_FL_CKSUM_CRC32C == 0x00004000);
	CLASSERT(OBD_FL_CKSUM_RSVD2 == 0x00008000);
	CLASSERT(OBD_FL_CKSUM_RSVD3 == 0x00010000);
	CLASSERT(OBD_FL_SHRINK_GRANT == 0x00020000);
	CLASSERT(OBD_FL_MMAP == 0x00040000);
	CLASSERT(OBD_FL_RECOV_RESEND == 0x00080000);
	CLASSERT(OBD_FL_NOSPC_BLK == 0x00100000);
	CLASSERT(OBD_FL_LOCAL_MASK == 0xf0000000);

	/* Checks for struct lov_ost_data_v1 */
	LASSERTF((int)sizeof(struct lov_ost_data_v1) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct lov_ost_data_v1));
	LASSERTF((int)offsetof(struct lov_ost_data_v1, l_ost_oi) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lov_ost_data_v1, l_ost_oi));
	LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_oi));
	LASSERTF((int)offsetof(struct lov_ost_data_v1, l_ost_gen) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lov_ost_data_v1, l_ost_gen));
	LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_gen) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_gen));
	LASSERTF((int)offsetof(struct lov_ost_data_v1, l_ost_idx) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct lov_ost_data_v1, l_ost_idx));
	LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_idx) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_idx));

	/* Checks for struct lov_mds_md_v1 */
	LASSERTF((int)sizeof(struct lov_mds_md_v1) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct lov_mds_md_v1));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_magic));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_magic));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_pattern) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_pattern));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_pattern) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_pattern));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_oi) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_oi));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_oi));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_stripe_size) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_stripe_size));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_size));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_stripe_count) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_stripe_count));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_count) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_count));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_layout_gen) == 30, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_layout_gen));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_layout_gen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_layout_gen));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_objects[0]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_objects[0]));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_objects[0]) == 24, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_objects[0]));
	CLASSERT(LOV_MAGIC_V1 == 0x0BD10BD0);

	/* Checks for struct lov_mds_md_v3 */
	LASSERTF((int)sizeof(struct lov_mds_md_v3) == 48, "found %lld\n",
		 (long long)(int)sizeof(struct lov_mds_md_v3));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_magic));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_magic));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_pattern) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_pattern));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pattern) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pattern));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_oi) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_oi));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_oi));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_stripe_size) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_stripe_size));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_size));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_stripe_count) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_stripe_count));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_count) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_count));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_layout_gen) == 30, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_layout_gen));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_layout_gen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_layout_gen));
	CLASSERT(LOV_MAXPOOLNAME == 16);
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_pool_name[16]) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_pool_name[16]));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pool_name[16]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pool_name[16]));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_objects[0]) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_objects[0]));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_objects[0]) == 24, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_objects[0]));
	CLASSERT(LOV_MAGIC_V3 == 0x0BD30BD0);
	LASSERTF(LOV_PATTERN_RAID0 == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)LOV_PATTERN_RAID0);
	LASSERTF(LOV_PATTERN_RAID1 == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)LOV_PATTERN_RAID1);
	LASSERTF(LOV_PATTERN_FIRST == 0x00000100UL, "found 0x%.8xUL\n",
		(unsigned)LOV_PATTERN_FIRST);
	LASSERTF(LOV_PATTERN_CMOBD == 0x00000200UL, "found 0x%.8xUL\n",
		(unsigned)LOV_PATTERN_CMOBD);

	/* Checks for struct obd_statfs */
	LASSERTF((int)sizeof(struct obd_statfs) == 144, "found %lld\n",
		 (long long)(int)sizeof(struct obd_statfs));
	LASSERTF((int)offsetof(struct obd_statfs, os_type) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_type));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_type) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_type));
	LASSERTF((int)offsetof(struct obd_statfs, os_blocks) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_blocks));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_blocks));
	LASSERTF((int)offsetof(struct obd_statfs, os_bfree) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_bfree));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_bfree) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_bfree));
	LASSERTF((int)offsetof(struct obd_statfs, os_bavail) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_bavail));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_bavail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_bavail));
	LASSERTF((int)offsetof(struct obd_statfs, os_ffree) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_ffree));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_ffree) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_ffree));
	LASSERTF((int)offsetof(struct obd_statfs, os_fsid) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_fsid));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_fsid) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_fsid));
	LASSERTF((int)offsetof(struct obd_statfs, os_bsize) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_bsize));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_bsize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_bsize));
	LASSERTF((int)offsetof(struct obd_statfs, os_namelen) == 92, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_namelen));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_namelen) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_namelen));
	LASSERTF((int)offsetof(struct obd_statfs, os_state) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_state));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_state) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_state));
	LASSERTF((int)offsetof(struct obd_statfs, os_fprecreated) == 108, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_fprecreated));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_fprecreated) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_fprecreated));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare2) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare2));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare2));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare3) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare3));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare3));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare4) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare4));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare4));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare5) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare5));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare5) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare5));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare6) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare6));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare6) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare6));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare7) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare7));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare7) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare7));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare8) == 136, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare8));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare8) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare8));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare9) == 140, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare9));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare9) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare9));

	/* Checks for struct obd_ioobj */
	LASSERTF((int)sizeof(struct obd_ioobj) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct obd_ioobj));
	LASSERTF((int)offsetof(struct obd_ioobj, ioo_oid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_ioobj, ioo_oid));
	LASSERTF((int)sizeof(((struct obd_ioobj *)0)->ioo_oid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_ioobj *)0)->ioo_oid));
	LASSERTF((int)offsetof(struct obd_ioobj, ioo_max_brw) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_ioobj, ioo_max_brw));
	LASSERTF((int)sizeof(((struct obd_ioobj *)0)->ioo_max_brw) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_ioobj *)0)->ioo_max_brw));
	LASSERTF((int)offsetof(struct obd_ioobj, ioo_bufcnt) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct obd_ioobj, ioo_bufcnt));
	LASSERTF((int)sizeof(((struct obd_ioobj *)0)->ioo_bufcnt) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_ioobj *)0)->ioo_bufcnt));

	/* Checks for union lquota_id */
	LASSERTF((int)sizeof(union lquota_id) == 16, "found %lld\n",
		 (long long)(int)sizeof(union lquota_id));

	/* Checks for struct obd_quotactl */
	LASSERTF((int)sizeof(struct obd_quotactl) == 112, "found %lld\n",
		 (long long)(int)sizeof(struct obd_quotactl));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_cmd) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_cmd));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_cmd) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_cmd));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_type) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_type));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_type));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_id) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_id));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_id));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_stat) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_stat));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_stat) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_stat));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_dqinfo) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_dqinfo));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_dqinfo) == 24, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_dqinfo));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_dqblk) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_dqblk));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_dqblk) == 72, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_dqblk));

	/* Checks for struct obd_dqinfo */
	LASSERTF((int)sizeof(struct obd_dqinfo) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct obd_dqinfo));
	LASSERTF((int)offsetof(struct obd_dqinfo, dqi_bgrace) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqinfo, dqi_bgrace));
	LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_bgrace) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_bgrace));
	LASSERTF((int)offsetof(struct obd_dqinfo, dqi_igrace) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqinfo, dqi_igrace));
	LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_igrace) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_igrace));
	LASSERTF((int)offsetof(struct obd_dqinfo, dqi_flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqinfo, dqi_flags));
	LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_flags));
	LASSERTF((int)offsetof(struct obd_dqinfo, dqi_valid) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqinfo, dqi_valid));
	LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_valid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_valid));

	/* Checks for struct obd_dqblk */
	LASSERTF((int)sizeof(struct obd_dqblk) == 72, "found %lld\n",
		 (long long)(int)sizeof(struct obd_dqblk));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_bhardlimit) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_bhardlimit));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_bhardlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_bhardlimit));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_bsoftlimit) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_bsoftlimit));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_bsoftlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_bsoftlimit));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_curspace) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_curspace));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_curspace) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_curspace));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_ihardlimit) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_ihardlimit));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_ihardlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_ihardlimit));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_isoftlimit) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_isoftlimit));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_isoftlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_isoftlimit));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_curinodes) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_curinodes));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_curinodes) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_curinodes));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_btime) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_btime));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_btime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_btime));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_itime) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_itime));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_itime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_itime));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_valid) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_valid));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_valid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_valid));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_padding) == 68, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_padding));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_padding));
	LASSERTF(Q_QUOTACHECK == 0x800100, "found 0x%.8x\n",
		Q_QUOTACHECK);
	LASSERTF(Q_INITQUOTA == 0x800101, "found 0x%.8x\n",
		Q_INITQUOTA);
	LASSERTF(Q_GETOINFO == 0x800102, "found 0x%.8x\n",
		Q_GETOINFO);
	LASSERTF(Q_GETOQUOTA == 0x800103, "found 0x%.8x\n",
		Q_GETOQUOTA);
	LASSERTF(Q_FINVALIDATE == 0x800104, "found 0x%.8x\n",
		Q_FINVALIDATE);

	/* Checks for struct niobuf_remote */
	LASSERTF((int)sizeof(struct niobuf_remote) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct niobuf_remote));
	LASSERTF((int)offsetof(struct niobuf_remote, offset) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct niobuf_remote, offset));
	LASSERTF((int)sizeof(((struct niobuf_remote *)0)->offset) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct niobuf_remote *)0)->offset));
	LASSERTF((int)offsetof(struct niobuf_remote, len) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct niobuf_remote, len));
	LASSERTF((int)sizeof(((struct niobuf_remote *)0)->len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct niobuf_remote *)0)->len));
	LASSERTF((int)offsetof(struct niobuf_remote, flags) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct niobuf_remote, flags));
	LASSERTF((int)sizeof(((struct niobuf_remote *)0)->flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct niobuf_remote *)0)->flags));
	LASSERTF(OBD_BRW_READ == 0x01, "found 0x%.8x\n",
		OBD_BRW_READ);
	LASSERTF(OBD_BRW_WRITE == 0x02, "found 0x%.8x\n",
		OBD_BRW_WRITE);
	LASSERTF(OBD_BRW_SYNC == 0x08, "found 0x%.8x\n",
		OBD_BRW_SYNC);
	LASSERTF(OBD_BRW_CHECK == 0x10, "found 0x%.8x\n",
		OBD_BRW_CHECK);
	LASSERTF(OBD_BRW_FROM_GRANT == 0x20, "found 0x%.8x\n",
		OBD_BRW_FROM_GRANT);
	LASSERTF(OBD_BRW_GRANTED == 0x40, "found 0x%.8x\n",
		OBD_BRW_GRANTED);
	LASSERTF(OBD_BRW_NOCACHE == 0x80, "found 0x%.8x\n",
		OBD_BRW_NOCACHE);
	LASSERTF(OBD_BRW_NOQUOTA == 0x100, "found 0x%.8x\n",
		OBD_BRW_NOQUOTA);
	LASSERTF(OBD_BRW_SRVLOCK == 0x200, "found 0x%.8x\n",
		OBD_BRW_SRVLOCK);
	LASSERTF(OBD_BRW_ASYNC == 0x400, "found 0x%.8x\n",
		OBD_BRW_ASYNC);
	LASSERTF(OBD_BRW_MEMALLOC == 0x800, "found 0x%.8x\n",
		OBD_BRW_MEMALLOC);
	LASSERTF(OBD_BRW_OVER_USRQUOTA == 0x1000, "found 0x%.8x\n",
		 OBD_BRW_OVER_USRQUOTA);
	LASSERTF(OBD_BRW_OVER_GRPQUOTA == 0x2000, "found 0x%.8x\n",
		 OBD_BRW_OVER_GRPQUOTA);
	LASSERTF(OBD_BRW_SOFT_SYNC == 0x4000, "found 0x%.8x\n",
		 OBD_BRW_SOFT_SYNC);

	/* Checks for struct ost_body */
	LASSERTF((int)sizeof(struct ost_body) == 208, "found %lld\n",
		 (long long)(int)sizeof(struct ost_body));
	LASSERTF((int)offsetof(struct ost_body, oa) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ost_body, oa));
	LASSERTF((int)sizeof(((struct ost_body *)0)->oa) == 208, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_body *)0)->oa));

	/* Checks for struct ll_fid */
	LASSERTF((int)sizeof(struct ll_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct ll_fid));
	LASSERTF((int)offsetof(struct ll_fid, id) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fid, id));
	LASSERTF((int)sizeof(((struct ll_fid *)0)->id) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fid *)0)->id));
	LASSERTF((int)offsetof(struct ll_fid, generation) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fid, generation));
	LASSERTF((int)sizeof(((struct ll_fid *)0)->generation) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fid *)0)->generation));
	LASSERTF((int)offsetof(struct ll_fid, f_type) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fid, f_type));
	LASSERTF((int)sizeof(((struct ll_fid *)0)->f_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fid *)0)->f_type));

	/* Checks for struct mdt_body */
	LASSERTF((int)sizeof(struct mdt_body) == 216, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_body));
	LASSERTF((int)offsetof(struct mdt_body, fid1) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, fid1));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->fid1));
	LASSERTF((int)offsetof(struct mdt_body, fid2) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, fid2));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->fid2));
	LASSERTF((int)offsetof(struct mdt_body, handle) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, handle));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->handle));
	LASSERTF((int)offsetof(struct mdt_body, valid) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, valid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->valid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->valid));
	LASSERTF((int)offsetof(struct mdt_body, size) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, size));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->size));
	LASSERTF((int)offsetof(struct mdt_body, mtime) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mtime));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mtime));
	LASSERTF((int)offsetof(struct mdt_body, atime) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, atime));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->atime));
	LASSERTF((int)offsetof(struct mdt_body, ctime) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, ctime));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->ctime));
	LASSERTF((int)offsetof(struct mdt_body, blocks) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, blocks));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->blocks));
	LASSERTF((int)offsetof(struct mdt_body, t_state) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, t_state));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->t_state) == 8,
		 "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->t_state));
	LASSERTF((int)offsetof(struct mdt_body, fsuid) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, fsuid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->fsuid));
	LASSERTF((int)offsetof(struct mdt_body, fsgid) == 108, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, fsgid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->fsgid));
	LASSERTF((int)offsetof(struct mdt_body, capability) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, capability));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->capability) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->capability));
	LASSERTF((int)offsetof(struct mdt_body, mode) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mode));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mode));
	LASSERTF((int)offsetof(struct mdt_body, uid) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, uid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->uid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->uid));
	LASSERTF((int)offsetof(struct mdt_body, gid) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, gid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->gid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->gid));
	LASSERTF((int)offsetof(struct mdt_body, flags) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, flags));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->flags));
	LASSERTF((int)offsetof(struct mdt_body, rdev) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, rdev));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->rdev) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->rdev));
	LASSERTF((int)offsetof(struct mdt_body, nlink) == 136, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, nlink));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->nlink) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->nlink));
	LASSERTF((int)offsetof(struct mdt_body, unused2) == 140, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, unused2));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->unused2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->unused2));
	LASSERTF((int)offsetof(struct mdt_body, suppgid) == 144, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, suppgid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->suppgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->suppgid));
	LASSERTF((int)offsetof(struct mdt_body, eadatasize) == 148, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, eadatasize));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->eadatasize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->eadatasize));
	LASSERTF((int)offsetof(struct mdt_body, aclsize) == 152, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, aclsize));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->aclsize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->aclsize));
	LASSERTF((int)offsetof(struct mdt_body, max_mdsize) == 156, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, max_mdsize));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->max_mdsize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->max_mdsize));
	LASSERTF((int)offsetof(struct mdt_body, max_cookiesize) == 160, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, max_cookiesize));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->max_cookiesize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->max_cookiesize));
	LASSERTF((int)offsetof(struct mdt_body, uid_h) == 164, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, uid_h));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->uid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->uid_h));
	LASSERTF((int)offsetof(struct mdt_body, gid_h) == 168, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, gid_h));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->gid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->gid_h));
	LASSERTF((int)offsetof(struct mdt_body, padding_5) == 172, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, padding_5));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->padding_5) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->padding_5));
	LASSERTF((int)offsetof(struct mdt_body, padding_6) == 176, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, padding_6));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->padding_6) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->padding_6));
	LASSERTF((int)offsetof(struct mdt_body, padding_7) == 184, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, padding_7));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->padding_7) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->padding_7));
	LASSERTF((int)offsetof(struct mdt_body, padding_8) == 192, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, padding_8));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->padding_8) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->padding_8));
	LASSERTF((int)offsetof(struct mdt_body, padding_9) == 200, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, padding_9));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->padding_9) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->padding_9));
	LASSERTF((int)offsetof(struct mdt_body, padding_10) == 208, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, padding_10));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->padding_10) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->padding_10));
	LASSERTF(MDS_FMODE_CLOSED == 000000000000UL, "found 0%.11oUL\n",
		MDS_FMODE_CLOSED);
	LASSERTF(MDS_FMODE_EXEC == 000000000004UL, "found 0%.11oUL\n",
		MDS_FMODE_EXEC);
	LASSERTF(MDS_FMODE_EPOCH == 000001000000UL, "found 0%.11oUL\n",
		MDS_FMODE_EPOCH);
	LASSERTF(MDS_FMODE_TRUNC == 000002000000UL, "found 0%.11oUL\n",
		MDS_FMODE_TRUNC);
	LASSERTF(MDS_FMODE_SOM == 000004000000UL, "found 0%.11oUL\n",
		MDS_FMODE_SOM);
	LASSERTF(MDS_OPEN_CREATED == 000000000010UL, "found 0%.11oUL\n",
		MDS_OPEN_CREATED);
	LASSERTF(MDS_OPEN_CROSS == 000000000020UL, "found 0%.11oUL\n",
		MDS_OPEN_CROSS);
	LASSERTF(MDS_OPEN_CREAT == 000000000100UL, "found 0%.11oUL\n",
		MDS_OPEN_CREAT);
	LASSERTF(MDS_OPEN_EXCL == 000000000200UL, "found 0%.11oUL\n",
		MDS_OPEN_EXCL);
	LASSERTF(MDS_OPEN_TRUNC == 000000001000UL, "found 0%.11oUL\n",
		MDS_OPEN_TRUNC);
	LASSERTF(MDS_OPEN_APPEND == 000000002000UL, "found 0%.11oUL\n",
		MDS_OPEN_APPEND);
	LASSERTF(MDS_OPEN_SYNC == 000000010000UL, "found 0%.11oUL\n",
		MDS_OPEN_SYNC);
	LASSERTF(MDS_OPEN_DIRECTORY == 000000200000UL, "found 0%.11oUL\n",
		MDS_OPEN_DIRECTORY);
	LASSERTF(MDS_OPEN_BY_FID == 000040000000UL, "found 0%.11oUL\n",
		MDS_OPEN_BY_FID);
	LASSERTF(MDS_OPEN_DELAY_CREATE == 000100000000UL, "found 0%.11oUL\n",
		MDS_OPEN_DELAY_CREATE);
	LASSERTF(MDS_OPEN_OWNEROVERRIDE == 000200000000UL, "found 0%.11oUL\n",
		MDS_OPEN_OWNEROVERRIDE);
	LASSERTF(MDS_OPEN_JOIN_FILE == 000400000000UL, "found 0%.11oUL\n",
		MDS_OPEN_JOIN_FILE);
	LASSERTF(MDS_OPEN_LOCK == 004000000000UL, "found 0%.11oUL\n",
		MDS_OPEN_LOCK);
	LASSERTF(MDS_OPEN_HAS_EA == 010000000000UL, "found 0%.11oUL\n",
		MDS_OPEN_HAS_EA);
	LASSERTF(MDS_OPEN_HAS_OBJS == 020000000000UL, "found 0%.11oUL\n",
		MDS_OPEN_HAS_OBJS);
	LASSERTF(MDS_OPEN_NORESTORE == 00000000000100000000000ULL, "found 0%.22lloULL\n",
			(long long)MDS_OPEN_NORESTORE);
	LASSERTF(MDS_OPEN_NEWSTRIPE == 00000000000200000000000ULL, "found 0%.22lloULL\n",
			(long long)MDS_OPEN_NEWSTRIPE);
	LASSERTF(MDS_OPEN_VOLATILE == 00000000000400000000000ULL, "found 0%.22lloULL\n",
			(long long)MDS_OPEN_VOLATILE);
	LASSERTF(LUSTRE_SYNC_FL == 0x00000008, "found 0x%.8x\n",
		LUSTRE_SYNC_FL);
	LASSERTF(LUSTRE_IMMUTABLE_FL == 0x00000010, "found 0x%.8x\n",
		LUSTRE_IMMUTABLE_FL);
	LASSERTF(LUSTRE_APPEND_FL == 0x00000020, "found 0x%.8x\n",
		LUSTRE_APPEND_FL);
	LASSERTF(LUSTRE_NOATIME_FL == 0x00000080, "found 0x%.8x\n",
		LUSTRE_NOATIME_FL);
	LASSERTF(LUSTRE_DIRSYNC_FL == 0x00010000, "found 0x%.8x\n",
		LUSTRE_DIRSYNC_FL);
	LASSERTF(MDS_INODELOCK_LOOKUP == 0x000001, "found 0x%.8x\n",
		MDS_INODELOCK_LOOKUP);
	LASSERTF(MDS_INODELOCK_UPDATE == 0x000002, "found 0x%.8x\n",
		MDS_INODELOCK_UPDATE);
	LASSERTF(MDS_INODELOCK_OPEN == 0x000004, "found 0x%.8x\n",
		MDS_INODELOCK_OPEN);
	LASSERTF(MDS_INODELOCK_LAYOUT == 0x000008, "found 0x%.8x\n",
		MDS_INODELOCK_LAYOUT);

	/* Checks for struct mdt_ioepoch */
	LASSERTF((int)sizeof(struct mdt_ioepoch) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_ioepoch));
	LASSERTF((int)offsetof(struct mdt_ioepoch, handle) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_ioepoch, handle));
	LASSERTF((int)sizeof(((struct mdt_ioepoch *)0)->handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_ioepoch *)0)->handle));
	LASSERTF((int)offsetof(struct mdt_ioepoch, ioepoch) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_ioepoch, ioepoch));
	LASSERTF((int)sizeof(((struct mdt_ioepoch *)0)->ioepoch) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_ioepoch *)0)->ioepoch));
	LASSERTF((int)offsetof(struct mdt_ioepoch, flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_ioepoch, flags));
	LASSERTF((int)sizeof(((struct mdt_ioepoch *)0)->flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_ioepoch *)0)->flags));
	LASSERTF((int)offsetof(struct mdt_ioepoch, padding) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_ioepoch, padding));
	LASSERTF((int)sizeof(((struct mdt_ioepoch *)0)->padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_ioepoch *)0)->padding));

	/* Checks for struct mdt_remote_perm */
	LASSERTF((int)sizeof(struct mdt_remote_perm) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_remote_perm));
	LASSERTF((int)offsetof(struct mdt_remote_perm, rp_uid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_remote_perm, rp_uid));
	LASSERTF((int)sizeof(((struct mdt_remote_perm *)0)->rp_uid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_remote_perm *)0)->rp_uid));
	LASSERTF((int)offsetof(struct mdt_remote_perm, rp_gid) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_remote_perm, rp_gid));
	LASSERTF((int)sizeof(((struct mdt_remote_perm *)0)->rp_gid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_remote_perm *)0)->rp_gid));
	LASSERTF((int)offsetof(struct mdt_remote_perm, rp_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_remote_perm, rp_fsuid));
	LASSERTF((int)sizeof(((struct mdt_remote_perm *)0)->rp_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_remote_perm *)0)->rp_fsuid));
	LASSERTF((int)offsetof(struct mdt_remote_perm, rp_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_remote_perm, rp_fsgid));
	LASSERTF((int)sizeof(((struct mdt_remote_perm *)0)->rp_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_remote_perm *)0)->rp_fsgid));
	LASSERTF((int)offsetof(struct mdt_remote_perm, rp_access_perm) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_remote_perm, rp_access_perm));
	LASSERTF((int)sizeof(((struct mdt_remote_perm *)0)->rp_access_perm) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_remote_perm *)0)->rp_access_perm));
	LASSERTF((int)offsetof(struct mdt_remote_perm, rp_padding) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_remote_perm, rp_padding));
	LASSERTF((int)sizeof(((struct mdt_remote_perm *)0)->rp_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_remote_perm *)0)->rp_padding));
	LASSERTF(CFS_SETUID_PERM == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)CFS_SETUID_PERM);
	LASSERTF(CFS_SETGID_PERM == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)CFS_SETGID_PERM);
	LASSERTF(CFS_SETGRP_PERM == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)CFS_SETGRP_PERM);
	LASSERTF(CFS_RMTACL_PERM == 0x00000008UL, "found 0x%.8xUL\n",
		(unsigned)CFS_RMTACL_PERM);
	LASSERTF(CFS_RMTOWN_PERM == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)CFS_RMTOWN_PERM);

	/* Checks for struct mdt_rec_setattr */
	LASSERTF((int)sizeof(struct mdt_rec_setattr) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_setattr));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_cap));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_suppgid) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_suppgid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_suppgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_suppgid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_suppgid_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_suppgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_suppgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_suppgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_padding_1) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_padding_1));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_1));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_padding_1_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_padding_1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_1_h));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_fid) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_fid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_fid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_valid) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_valid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_valid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_valid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_uid) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_uid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_uid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_uid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_gid) == 68, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_gid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_gid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_gid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_size) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_size));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_size));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_blocks) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_blocks));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_blocks));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_mtime) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_mtime));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_mtime));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_atime) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_atime));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_atime));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_ctime) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_ctime));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_ctime));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_attr_flags) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_attr_flags));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_attr_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_attr_flags));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_mode) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_mode));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_mode));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_bias) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_bias));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_padding_3) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_padding_3));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_3));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_padding_4) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_4));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_padding_5) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_padding_5));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_5) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_5));

	/* Checks for struct mdt_rec_create */
	LASSERTF((int)sizeof(struct mdt_rec_create) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_create));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_cap));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fid1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fid1));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fid1));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fid2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fid2));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fid2));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_old_handle) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_old_handle));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_old_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_old_handle));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_time) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_time));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_time));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_rdev) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_rdev));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_rdev) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_rdev));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_ioepoch) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_ioepoch));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_ioepoch) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_ioepoch));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_padding_1) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_padding_1));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_padding_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_padding_1));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_mode) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_mode));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_mode));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_bias) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_bias));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_flags_l) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_flags_l));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_flags_l) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_flags_l));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_flags_h) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_flags_h));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_flags_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_flags_h));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_umask) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_umask));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_umask) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_umask));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_padding_4) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_padding_4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_padding_4));

	/* Checks for struct mdt_rec_link */
	LASSERTF((int)sizeof(struct mdt_rec_link) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_link));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_cap));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fid1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fid1));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fid1));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fid2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fid2));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fid2));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_time) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_time));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_time));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_1) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_1));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_1));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_2) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_2));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_2));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_3) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_3));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_3));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_4) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_4) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_4));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_bias) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_bias));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_5) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_5));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_5) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_5));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_6) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_6));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_6) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_6));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_7) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_7));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_7) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_7));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_8) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_8));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_8) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_8));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_9) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_9));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_9) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_9));

	/* Checks for struct mdt_rec_unlink */
	LASSERTF((int)sizeof(struct mdt_rec_unlink) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_unlink));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_cap));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fid1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fid1));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fid1));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fid2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fid2));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fid2));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_time) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_time));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_time));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_2) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_2));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_2));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_3) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_3));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_3));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_4) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_4) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_4));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_5) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_5));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_5) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_5));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_bias) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_bias));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_mode) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_mode));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_mode));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_6) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_6));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_6) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_6));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_7) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_7));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_7) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_7));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_8) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_8));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_8) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_8));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_9) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_9));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_9) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_9));

	/* Checks for struct mdt_rec_rename */
	LASSERTF((int)sizeof(struct mdt_rec_rename) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_rename));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_cap));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fid1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fid1));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fid1));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fid2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fid2));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fid2));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_time) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_time));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_time));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_1) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_1));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_1));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_2) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_2));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_2));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_3) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_3));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_3));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_4) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_4) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_4));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_bias) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_bias));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_mode) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_mode));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_mode));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_5) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_5));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_5) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_5));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_6) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_6));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_6) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_6));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_7) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_7));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_7) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_7));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_8) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_8));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_8) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_8));

	/* Checks for struct mdt_rec_setxattr */
	LASSERTF((int)sizeof(struct mdt_rec_setxattr) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_setxattr));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_cap));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_fid) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_fid));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fid));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_1) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_1));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_1));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_2) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_2));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_2));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_3) == 68, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_3));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_3));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_valid) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_valid));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_valid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_valid));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_time) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_time));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_time));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_5) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_5));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_5) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_5));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_6) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_6));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_6) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_6));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_7) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_7));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_7) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_7));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_size) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_size));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_size));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_flags) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_flags));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_flags));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_8) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_8));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_8) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_8));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_9) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_9));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_9) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_9));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_10) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_10));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_10) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_10));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_11) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_11));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_11) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_11));

	/* Checks for struct mdt_rec_reint */
	LASSERTF((int)sizeof(struct mdt_rec_reint) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_reint));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_cap));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fid1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fid1));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fid1));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fid2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fid2));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fid2));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_mtime) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_mtime));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_mtime));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_atime) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_atime));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_atime));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_ctime) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_ctime));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_ctime));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_size) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_size));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_size));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_blocks) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_blocks));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_blocks));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_bias) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_bias));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_mode) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_mode));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_mode));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_flags) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_flags));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_flags));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_flags_h) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_flags_h));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_flags_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_flags_h));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_umask) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_umask));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_umask) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_umask));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_padding_4) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_padding_4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_padding_4));

	/* Checks for struct lmv_desc */
	LASSERTF((int)sizeof(struct lmv_desc) == 88, "found %lld\n",
		 (long long)(int)sizeof(struct lmv_desc));
	LASSERTF((int)offsetof(struct lmv_desc, ld_tgt_count) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_tgt_count));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_tgt_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_tgt_count));
	LASSERTF((int)offsetof(struct lmv_desc, ld_active_tgt_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_active_tgt_count));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_active_tgt_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_active_tgt_count));
	LASSERTF((int)offsetof(struct lmv_desc, ld_default_stripe_count) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_default_stripe_count));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_default_stripe_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_default_stripe_count));
	LASSERTF((int)offsetof(struct lmv_desc, ld_pattern) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_pattern));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_pattern) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_pattern));
	LASSERTF((int)offsetof(struct lmv_desc, ld_default_hash_size) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_default_hash_size));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_default_hash_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_default_hash_size));
	LASSERTF((int)offsetof(struct lmv_desc, ld_padding_1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_padding_1));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_padding_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_padding_1));
	LASSERTF((int)offsetof(struct lmv_desc, ld_padding_2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_padding_2));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_padding_2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_padding_2));
	LASSERTF((int)offsetof(struct lmv_desc, ld_qos_maxage) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_qos_maxage));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_qos_maxage) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_qos_maxage));
	LASSERTF((int)offsetof(struct lmv_desc, ld_padding_3) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_padding_3));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_padding_3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_padding_3));
	LASSERTF((int)offsetof(struct lmv_desc, ld_padding_4) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_padding_4));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_padding_4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_padding_4));
	LASSERTF((int)offsetof(struct lmv_desc, ld_uuid) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_uuid));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_uuid) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_uuid));

	/* Checks for struct lmv_stripe_md */
	LASSERTF((int)sizeof(struct lmv_stripe_md) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct lmv_stripe_md));
	LASSERTF((int)offsetof(struct lmv_stripe_md, mea_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_stripe_md, mea_magic));
	LASSERTF((int)sizeof(((struct lmv_stripe_md *)0)->mea_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_stripe_md *)0)->mea_magic));
	LASSERTF((int)offsetof(struct lmv_stripe_md, mea_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_stripe_md, mea_count));
	LASSERTF((int)sizeof(((struct lmv_stripe_md *)0)->mea_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_stripe_md *)0)->mea_count));
	LASSERTF((int)offsetof(struct lmv_stripe_md, mea_master) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_stripe_md, mea_master));
	LASSERTF((int)sizeof(((struct lmv_stripe_md *)0)->mea_master) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_stripe_md *)0)->mea_master));
	LASSERTF((int)offsetof(struct lmv_stripe_md, mea_padding) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_stripe_md, mea_padding));
	LASSERTF((int)sizeof(((struct lmv_stripe_md *)0)->mea_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_stripe_md *)0)->mea_padding));
	CLASSERT(LOV_MAXPOOLNAME == 16);
	LASSERTF((int)offsetof(struct lmv_stripe_md, mea_pool_name[16]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_stripe_md, mea_pool_name[16]));
	LASSERTF((int)sizeof(((struct lmv_stripe_md *)0)->mea_pool_name[16]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_stripe_md *)0)->mea_pool_name[16]));
	LASSERTF((int)offsetof(struct lmv_stripe_md, mea_ids[0]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_stripe_md, mea_ids[0]));
	LASSERTF((int)sizeof(((struct lmv_stripe_md *)0)->mea_ids[0]) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_stripe_md *)0)->mea_ids[0]));

	/* Checks for struct lov_desc */
	LASSERTF((int)sizeof(struct lov_desc) == 88, "found %lld\n",
		 (long long)(int)sizeof(struct lov_desc));
	LASSERTF((int)offsetof(struct lov_desc, ld_tgt_count) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_tgt_count));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_tgt_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_tgt_count));
	LASSERTF((int)offsetof(struct lov_desc, ld_active_tgt_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_active_tgt_count));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_active_tgt_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_active_tgt_count));
	LASSERTF((int)offsetof(struct lov_desc, ld_default_stripe_count) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_default_stripe_count));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_default_stripe_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_default_stripe_count));
	LASSERTF((int)offsetof(struct lov_desc, ld_pattern) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_pattern));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_pattern) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_pattern));
	LASSERTF((int)offsetof(struct lov_desc, ld_default_stripe_size) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_default_stripe_size));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_default_stripe_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_default_stripe_size));
	LASSERTF((int)offsetof(struct lov_desc, ld_default_stripe_offset) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_default_stripe_offset));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_default_stripe_offset) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_default_stripe_offset));
	LASSERTF((int)offsetof(struct lov_desc, ld_padding_0) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_padding_0));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_padding_0) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_padding_0));
	LASSERTF((int)offsetof(struct lov_desc, ld_qos_maxage) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_qos_maxage));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_qos_maxage) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_qos_maxage));
	LASSERTF((int)offsetof(struct lov_desc, ld_padding_1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_padding_1));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_padding_1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_padding_1));
	LASSERTF((int)offsetof(struct lov_desc, ld_padding_2) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_padding_2));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_padding_2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_padding_2));
	LASSERTF((int)offsetof(struct lov_desc, ld_uuid) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_uuid));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_uuid) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_uuid));
	CLASSERT(LOV_DESC_MAGIC == 0xB0CCDE5C);

	/* Checks for struct ldlm_res_id */
	LASSERTF((int)sizeof(struct ldlm_res_id) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_res_id));
	CLASSERT(RES_NAME_SIZE == 4);
	LASSERTF((int)offsetof(struct ldlm_res_id, name[4]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_res_id, name[4]));
	LASSERTF((int)sizeof(((struct ldlm_res_id *)0)->name[4]) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_res_id *)0)->name[4]));

	/* Checks for struct ldlm_extent */
	LASSERTF((int)sizeof(struct ldlm_extent) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_extent));
	LASSERTF((int)offsetof(struct ldlm_extent, start) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_extent, start));
	LASSERTF((int)sizeof(((struct ldlm_extent *)0)->start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_extent *)0)->start));
	LASSERTF((int)offsetof(struct ldlm_extent, end) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_extent, end));
	LASSERTF((int)sizeof(((struct ldlm_extent *)0)->end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_extent *)0)->end));
	LASSERTF((int)offsetof(struct ldlm_extent, gid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_extent, gid));
	LASSERTF((int)sizeof(((struct ldlm_extent *)0)->gid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_extent *)0)->gid));

	/* Checks for struct ldlm_inodebits */
	LASSERTF((int)sizeof(struct ldlm_inodebits) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_inodebits));
	LASSERTF((int)offsetof(struct ldlm_inodebits, bits) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_inodebits, bits));
	LASSERTF((int)sizeof(((struct ldlm_inodebits *)0)->bits) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_inodebits *)0)->bits));

	/* Checks for struct ldlm_flock_wire */
	LASSERTF((int)sizeof(struct ldlm_flock_wire) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_flock_wire));
	LASSERTF((int)offsetof(struct ldlm_flock_wire, lfw_start) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_flock_wire, lfw_start));
	LASSERTF((int)sizeof(((struct ldlm_flock_wire *)0)->lfw_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_flock_wire *)0)->lfw_start));
	LASSERTF((int)offsetof(struct ldlm_flock_wire, lfw_end) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_flock_wire, lfw_end));
	LASSERTF((int)sizeof(((struct ldlm_flock_wire *)0)->lfw_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_flock_wire *)0)->lfw_end));
	LASSERTF((int)offsetof(struct ldlm_flock_wire, lfw_owner) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_flock_wire, lfw_owner));
	LASSERTF((int)sizeof(((struct ldlm_flock_wire *)0)->lfw_owner) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_flock_wire *)0)->lfw_owner));
	LASSERTF((int)offsetof(struct ldlm_flock_wire, lfw_padding) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_flock_wire, lfw_padding));
	LASSERTF((int)sizeof(((struct ldlm_flock_wire *)0)->lfw_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_flock_wire *)0)->lfw_padding));
	LASSERTF((int)offsetof(struct ldlm_flock_wire, lfw_pid) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_flock_wire, lfw_pid));
	LASSERTF((int)sizeof(((struct ldlm_flock_wire *)0)->lfw_pid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_flock_wire *)0)->lfw_pid));

	/* Checks for struct ldlm_intent */
	LASSERTF((int)sizeof(struct ldlm_intent) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_intent));
	LASSERTF((int)offsetof(struct ldlm_intent, opc) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_intent, opc));
	LASSERTF((int)sizeof(((struct ldlm_intent *)0)->opc) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_intent *)0)->opc));

	/* Checks for struct ldlm_resource_desc */
	LASSERTF((int)sizeof(struct ldlm_resource_desc) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_resource_desc));
	LASSERTF((int)offsetof(struct ldlm_resource_desc, lr_type) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_resource_desc, lr_type));
	LASSERTF((int)sizeof(((struct ldlm_resource_desc *)0)->lr_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_resource_desc *)0)->lr_type));
	LASSERTF((int)offsetof(struct ldlm_resource_desc, lr_padding) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_resource_desc, lr_padding));
	LASSERTF((int)sizeof(((struct ldlm_resource_desc *)0)->lr_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_resource_desc *)0)->lr_padding));
	LASSERTF((int)offsetof(struct ldlm_resource_desc, lr_name) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_resource_desc, lr_name));
	LASSERTF((int)sizeof(((struct ldlm_resource_desc *)0)->lr_name) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_resource_desc *)0)->lr_name));

	/* Checks for struct ldlm_lock_desc */
	LASSERTF((int)sizeof(struct ldlm_lock_desc) == 80, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_lock_desc));
	LASSERTF((int)offsetof(struct ldlm_lock_desc, l_resource) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_lock_desc, l_resource));
	LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_resource) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_resource));
	LASSERTF((int)offsetof(struct ldlm_lock_desc, l_req_mode) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_lock_desc, l_req_mode));
	LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_req_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_req_mode));
	LASSERTF((int)offsetof(struct ldlm_lock_desc, l_granted_mode) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_lock_desc, l_granted_mode));
	LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_granted_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_granted_mode));
	LASSERTF((int)offsetof(struct ldlm_lock_desc, l_policy_data) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_lock_desc, l_policy_data));
	LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_policy_data) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_policy_data));

	/* Checks for struct ldlm_request */
	LASSERTF((int)sizeof(struct ldlm_request) == 104, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_request));
	LASSERTF((int)offsetof(struct ldlm_request, lock_flags) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_request, lock_flags));
	LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_flags));
	LASSERTF((int)offsetof(struct ldlm_request, lock_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_request, lock_count));
	LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_count));
	LASSERTF((int)offsetof(struct ldlm_request, lock_desc) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_request, lock_desc));
	LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_desc) == 80, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_desc));
	LASSERTF((int)offsetof(struct ldlm_request, lock_handle) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_request, lock_handle));
	LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_handle) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_handle));

	/* Checks for struct ldlm_reply */
	LASSERTF((int)sizeof(struct ldlm_reply) == 112, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_reply));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_flags) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_flags));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_flags));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_padding) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_padding));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_padding));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_desc) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_desc));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_desc) == 80, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_desc));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_handle) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_handle));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_handle));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_policy_res1) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_policy_res1));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_policy_res1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_policy_res1));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_policy_res2) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_policy_res2));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_policy_res2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_policy_res2));

	/* Checks for struct ost_lvb_v1 */
	LASSERTF((int)sizeof(struct ost_lvb_v1) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct ost_lvb_v1));
	LASSERTF((int)offsetof(struct ost_lvb_v1, lvb_size) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb_v1, lvb_size));
	LASSERTF((int)sizeof(((struct ost_lvb_v1 *)0)->lvb_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb_v1 *)0)->lvb_size));
	LASSERTF((int)offsetof(struct ost_lvb_v1, lvb_mtime) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb_v1, lvb_mtime));
	LASSERTF((int)sizeof(((struct ost_lvb_v1 *)0)->lvb_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb_v1 *)0)->lvb_mtime));
	LASSERTF((int)offsetof(struct ost_lvb_v1, lvb_atime) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb_v1, lvb_atime));
	LASSERTF((int)sizeof(((struct ost_lvb_v1 *)0)->lvb_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb_v1 *)0)->lvb_atime));
	LASSERTF((int)offsetof(struct ost_lvb_v1, lvb_ctime) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb_v1, lvb_ctime));
	LASSERTF((int)sizeof(((struct ost_lvb_v1 *)0)->lvb_ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb_v1 *)0)->lvb_ctime));
	LASSERTF((int)offsetof(struct ost_lvb_v1, lvb_blocks) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb_v1, lvb_blocks));
	LASSERTF((int)sizeof(((struct ost_lvb_v1 *)0)->lvb_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb_v1 *)0)->lvb_blocks));

	/* Checks for struct ost_lvb */
	LASSERTF((int)sizeof(struct ost_lvb) == 56, "found %lld\n",
		 (long long)(int)sizeof(struct ost_lvb));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_size) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_size));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_size));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_mtime) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_mtime));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_mtime));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_atime) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_atime));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_atime));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_ctime) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_ctime));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_ctime));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_blocks) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_blocks));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_blocks));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_mtime_ns) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_mtime_ns));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_mtime_ns) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_mtime_ns));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_atime_ns) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_atime_ns));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_atime_ns) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_atime_ns));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_ctime_ns) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_ctime_ns));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_ctime_ns) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_ctime_ns));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_padding) == 52, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_padding));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_padding));

	/* Checks for struct lquota_lvb */
	LASSERTF((int)sizeof(struct lquota_lvb) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct lquota_lvb));
	LASSERTF((int)offsetof(struct lquota_lvb, lvb_flags) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_lvb, lvb_flags));
	LASSERTF((int)sizeof(((struct lquota_lvb *)0)->lvb_flags) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_lvb *)0)->lvb_flags));
	LASSERTF((int)offsetof(struct lquota_lvb, lvb_id_may_rel) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_lvb, lvb_id_may_rel));
	LASSERTF((int)sizeof(((struct lquota_lvb *)0)->lvb_id_may_rel) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_lvb *)0)->lvb_id_may_rel));
	LASSERTF((int)offsetof(struct lquota_lvb, lvb_id_rel) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_lvb, lvb_id_rel));
	LASSERTF((int)sizeof(((struct lquota_lvb *)0)->lvb_id_rel) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_lvb *)0)->lvb_id_rel));
	LASSERTF((int)offsetof(struct lquota_lvb, lvb_id_qunit) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_lvb, lvb_id_qunit));
	LASSERTF((int)sizeof(((struct lquota_lvb *)0)->lvb_id_qunit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_lvb *)0)->lvb_id_qunit));
	LASSERTF((int)offsetof(struct lquota_lvb, lvb_pad1) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_lvb, lvb_pad1));
	LASSERTF((int)sizeof(((struct lquota_lvb *)0)->lvb_pad1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_lvb *)0)->lvb_pad1));
	LASSERTF(LQUOTA_FL_EDQUOT == 1, "found %lld\n",
		 (long long)LQUOTA_FL_EDQUOT);

	/* Checks for struct ldlm_gl_lquota_desc */
	LASSERTF((int)sizeof(struct ldlm_gl_lquota_desc) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_gl_lquota_desc));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_id) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_id));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_id) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_id));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_flags));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_flags) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_flags));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_ver) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_ver));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_ver) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_ver));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_hardlimit) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_hardlimit));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_hardlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_hardlimit));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_softlimit) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_softlimit));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_softlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_softlimit));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_time) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_time));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_time));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_pad2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_pad2));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_pad2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_pad2));

	/* Checks for struct mgs_send_param */
	LASSERTF((int)sizeof(struct mgs_send_param) == 1024, "found %lld\n",
		 (long long)(int)sizeof(struct mgs_send_param));
	CLASSERT(MGS_PARAM_MAXLEN == 1024);
	LASSERTF((int)offsetof(struct mgs_send_param, mgs_param[1024]) == 1024, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_send_param, mgs_param[1024]));
	LASSERTF((int)sizeof(((struct mgs_send_param *)0)->mgs_param[1024]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_send_param *)0)->mgs_param[1024]));

	/* Checks for struct cfg_marker */
	LASSERTF((int)sizeof(struct cfg_marker) == 160, "found %lld\n",
		 (long long)(int)sizeof(struct cfg_marker));
	LASSERTF((int)offsetof(struct cfg_marker, cm_step) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_step));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_step) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_step));
	LASSERTF((int)offsetof(struct cfg_marker, cm_flags) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_flags));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_flags));
	LASSERTF((int)offsetof(struct cfg_marker, cm_vers) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_vers));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_vers) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_vers));
	LASSERTF((int)offsetof(struct cfg_marker, cm_padding) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_padding));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_padding));
	LASSERTF((int)offsetof(struct cfg_marker, cm_createtime) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_createtime));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_createtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_createtime));
	LASSERTF((int)offsetof(struct cfg_marker, cm_canceltime) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_canceltime));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_canceltime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_canceltime));
	LASSERTF((int)offsetof(struct cfg_marker, cm_tgtname) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_tgtname));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_tgtname) == 64, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_tgtname));
	LASSERTF((int)offsetof(struct cfg_marker, cm_comment) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_comment));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_comment) == 64, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_comment));

	/* Checks for struct llog_logid */
	LASSERTF((int)sizeof(struct llog_logid) == 20, "found %lld\n",
		 (long long)(int)sizeof(struct llog_logid));
	LASSERTF((int)offsetof(struct llog_logid, lgl_oi) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid, lgl_oi));
	LASSERTF((int)sizeof(((struct llog_logid *)0)->lgl_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid *)0)->lgl_oi));
	LASSERTF((int)offsetof(struct llog_logid, lgl_ogen) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid, lgl_ogen));
	LASSERTF((int)sizeof(((struct llog_logid *)0)->lgl_ogen) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid *)0)->lgl_ogen));
	CLASSERT(OST_SZ_REC == 274730752);
	CLASSERT(MDS_UNLINK_REC == 274801668);
	CLASSERT(MDS_UNLINK64_REC == 275325956);
	CLASSERT(MDS_SETATTR64_REC == 275325953);
	CLASSERT(OBD_CFG_REC == 274857984);
	CLASSERT(LLOG_GEN_REC == 274989056);
	CLASSERT(CHANGELOG_REC == 275120128);
	CLASSERT(CHANGELOG_USER_REC == 275185664);
	CLASSERT(LLOG_HDR_MAGIC == 275010873);
	CLASSERT(LLOG_LOGID_MAGIC == 275010875);

	/* Checks for struct llog_catid */
	LASSERTF((int)sizeof(struct llog_catid) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct llog_catid));
	LASSERTF((int)offsetof(struct llog_catid, lci_logid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_catid, lci_logid));
	LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_logid) == 20, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_catid *)0)->lci_logid));
	LASSERTF((int)offsetof(struct llog_catid, lci_padding1) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct llog_catid, lci_padding1));
	LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_catid *)0)->lci_padding1));
	LASSERTF((int)offsetof(struct llog_catid, lci_padding2) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct llog_catid, lci_padding2));
	LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_padding2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_catid *)0)->lci_padding2));
	LASSERTF((int)offsetof(struct llog_catid, lci_padding3) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct llog_catid, lci_padding3));
	LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_padding3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_catid *)0)->lci_padding3));

	/* Checks for struct llog_rec_hdr */
	LASSERTF((int)sizeof(struct llog_rec_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct llog_rec_hdr));
	LASSERTF((int)offsetof(struct llog_rec_hdr, lrh_len) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_hdr, lrh_len));
	LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->lrh_len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->lrh_len));
	LASSERTF((int)offsetof(struct llog_rec_hdr, lrh_index) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_hdr, lrh_index));
	LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->lrh_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->lrh_index));
	LASSERTF((int)offsetof(struct llog_rec_hdr, lrh_type) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_hdr, lrh_type));
	LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->lrh_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->lrh_type));
	LASSERTF((int)offsetof(struct llog_rec_hdr, lrh_id) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_hdr, lrh_id));
	LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->lrh_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->lrh_id));

	/* Checks for struct llog_rec_tail */
	LASSERTF((int)sizeof(struct llog_rec_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct llog_rec_tail));
	LASSERTF((int)offsetof(struct llog_rec_tail, lrt_len) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_tail, lrt_len));
	LASSERTF((int)sizeof(((struct llog_rec_tail *)0)->lrt_len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_tail *)0)->lrt_len));
	LASSERTF((int)offsetof(struct llog_rec_tail, lrt_index) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_tail, lrt_index));
	LASSERTF((int)sizeof(((struct llog_rec_tail *)0)->lrt_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_tail *)0)->lrt_index));

	/* Checks for struct llog_logid_rec */
	LASSERTF((int)sizeof(struct llog_logid_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct llog_logid_rec));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_hdr));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_hdr));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_id) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_id));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_id) == 20, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_id));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_padding1) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_padding1));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_padding1));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_padding2) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_padding2));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_padding2));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_padding3) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_padding3));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_padding3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_padding3));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_tail) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_tail));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_tail));

	/* Checks for struct llog_unlink_rec */
	LASSERTF((int)sizeof(struct llog_unlink_rec) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct llog_unlink_rec));
	LASSERTF((int)offsetof(struct llog_unlink_rec, lur_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink_rec, lur_hdr));
	LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_hdr));
	LASSERTF((int)offsetof(struct llog_unlink_rec, lur_oid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink_rec, lur_oid));
	LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_oid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_oid));
	LASSERTF((int)offsetof(struct llog_unlink_rec, lur_oseq) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink_rec, lur_oseq));
	LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_oseq) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_oseq));
	LASSERTF((int)offsetof(struct llog_unlink_rec, lur_count) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink_rec, lur_count));
	LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_count));
	LASSERTF((int)offsetof(struct llog_unlink_rec, lur_tail) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink_rec, lur_tail));
	LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_tail));
	/* Checks for struct llog_unlink64_rec */
	LASSERTF((int)sizeof(struct llog_unlink64_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct llog_unlink64_rec));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_hdr));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_hdr));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_fid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_fid));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_fid));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_count) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_count));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_count));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_tail) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_tail));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_tail));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_padding1) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_padding1));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding1));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_padding2) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_padding2));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding2));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_padding3) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_padding3));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding3));

	/* Checks for struct llog_setattr64_rec */
	LASSERTF((int)sizeof(struct llog_setattr64_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct llog_setattr64_rec));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_hdr));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_hdr));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_oi) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_oi));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_oi));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_uid) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_uid));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_uid_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_uid_h));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid_h));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_gid) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_gid));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_gid_h) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_gid_h));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid_h));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_padding) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_padding));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_padding) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_padding));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_tail) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_tail));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_tail));

	/* Checks for struct llog_size_change_rec */
	LASSERTF((int)sizeof(struct llog_size_change_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct llog_size_change_rec));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_hdr));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_hdr));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_fid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_fid));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_fid));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_ioepoch) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_ioepoch));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_ioepoch) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_ioepoch));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_padding1) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_padding1));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding1));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_padding2) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_padding2));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding2));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_padding3) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_padding3));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding3));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_tail) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_tail));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_tail));

	/* Checks for struct changelog_rec */
	LASSERTF((int)sizeof(struct changelog_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct changelog_rec));
	LASSERTF((int)offsetof(struct changelog_rec, cr_namelen) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_namelen));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_namelen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_namelen));
	LASSERTF((int)offsetof(struct changelog_rec, cr_flags) == 2, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_flags));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_flags) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_flags));
	LASSERTF((int)offsetof(struct changelog_rec, cr_type) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_type));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_type));
	LASSERTF((int)offsetof(struct changelog_rec, cr_index) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_index));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_index) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_index));
	LASSERTF((int)offsetof(struct changelog_rec, cr_prev) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_prev));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_prev) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_prev));
	LASSERTF((int)offsetof(struct changelog_rec, cr_time) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_time));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_time));
	LASSERTF((int)offsetof(struct changelog_rec, cr_tfid) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_tfid));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_tfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_tfid));
	LASSERTF((int)offsetof(struct changelog_rec, cr_pfid) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_pfid));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_pfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_pfid));

	/* Checks for struct changelog_ext_rec */
	LASSERTF((int)sizeof(struct changelog_ext_rec) == 96, "found %lld\n",
		 (long long)(int)sizeof(struct changelog_ext_rec));
	LASSERTF((int)offsetof(struct changelog_ext_rec, cr_namelen) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rec, cr_namelen));
	LASSERTF((int)sizeof(((struct changelog_ext_rec *)0)->cr_namelen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rec *)0)->cr_namelen));
	LASSERTF((int)offsetof(struct changelog_ext_rec, cr_flags) == 2, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rec, cr_flags));
	LASSERTF((int)sizeof(((struct changelog_ext_rec *)0)->cr_flags) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rec *)0)->cr_flags));
	LASSERTF((int)offsetof(struct changelog_ext_rec, cr_type) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rec, cr_type));
	LASSERTF((int)sizeof(((struct changelog_ext_rec *)0)->cr_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rec *)0)->cr_type));
	LASSERTF((int)offsetof(struct changelog_ext_rec, cr_index) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rec, cr_index));
	LASSERTF((int)sizeof(((struct changelog_ext_rec *)0)->cr_index) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rec *)0)->cr_index));
	LASSERTF((int)offsetof(struct changelog_ext_rec, cr_prev) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rec, cr_prev));
	LASSERTF((int)sizeof(((struct changelog_ext_rec *)0)->cr_prev) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rec *)0)->cr_prev));
	LASSERTF((int)offsetof(struct changelog_ext_rec, cr_time) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rec, cr_time));
	LASSERTF((int)sizeof(((struct changelog_ext_rec *)0)->cr_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rec *)0)->cr_time));
	LASSERTF((int)offsetof(struct changelog_ext_rec, cr_tfid) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rec, cr_tfid));
	LASSERTF((int)sizeof(((struct changelog_ext_rec *)0)->cr_tfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rec *)0)->cr_tfid));
	LASSERTF((int)offsetof(struct changelog_ext_rec, cr_pfid) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rec, cr_pfid));
	LASSERTF((int)sizeof(((struct changelog_ext_rec *)0)->cr_pfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rec *)0)->cr_pfid));
	LASSERTF((int)offsetof(struct changelog_ext_rec, cr_sfid) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rec, cr_sfid));
	LASSERTF((int)sizeof(((struct changelog_ext_rec *)0)->cr_sfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rec *)0)->cr_sfid));
	LASSERTF((int)offsetof(struct changelog_ext_rec, cr_spfid) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rec, cr_spfid));
	LASSERTF((int)sizeof(((struct changelog_ext_rec *)0)->cr_spfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rec *)0)->cr_spfid));

	/* Checks for struct changelog_setinfo */
	LASSERTF((int)sizeof(struct changelog_setinfo) == 12, "found %lld\n",
		 (long long)(int)sizeof(struct changelog_setinfo));
	LASSERTF((int)offsetof(struct changelog_setinfo, cs_recno) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_setinfo, cs_recno));
	LASSERTF((int)sizeof(((struct changelog_setinfo *)0)->cs_recno) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_setinfo *)0)->cs_recno));
	LASSERTF((int)offsetof(struct changelog_setinfo, cs_id) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_setinfo, cs_id));
	LASSERTF((int)sizeof(((struct changelog_setinfo *)0)->cs_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_setinfo *)0)->cs_id));

	/* Checks for struct llog_changelog_rec */
	LASSERTF((int)sizeof(struct llog_changelog_rec) == 88, "found %lld\n",
		 (long long)(int)sizeof(struct llog_changelog_rec));
	LASSERTF((int)offsetof(struct llog_changelog_rec, cr_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_rec, cr_hdr));
	LASSERTF((int)sizeof(((struct llog_changelog_rec *)0)->cr_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_rec *)0)->cr_hdr));
	LASSERTF((int)offsetof(struct llog_changelog_rec, cr) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_rec, cr));
	LASSERTF((int)sizeof(((struct llog_changelog_rec *)0)->cr) == 64, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_rec *)0)->cr));
	LASSERTF((int)offsetof(struct llog_changelog_rec, cr_tail) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_rec, cr_tail));
	LASSERTF((int)sizeof(((struct llog_changelog_rec *)0)->cr_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_rec *)0)->cr_tail));

	/* Checks for struct llog_changelog_user_rec */
	LASSERTF((int)sizeof(struct llog_changelog_user_rec) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct llog_changelog_user_rec));
	LASSERTF((int)offsetof(struct llog_changelog_user_rec, cur_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_user_rec, cur_hdr));
	LASSERTF((int)sizeof(((struct llog_changelog_user_rec *)0)->cur_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_user_rec *)0)->cur_hdr));
	LASSERTF((int)offsetof(struct llog_changelog_user_rec, cur_id) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_user_rec, cur_id));
	LASSERTF((int)sizeof(((struct llog_changelog_user_rec *)0)->cur_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_user_rec *)0)->cur_id));
	LASSERTF((int)offsetof(struct llog_changelog_user_rec, cur_padding) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_user_rec, cur_padding));
	LASSERTF((int)sizeof(((struct llog_changelog_user_rec *)0)->cur_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_user_rec *)0)->cur_padding));
	LASSERTF((int)offsetof(struct llog_changelog_user_rec, cur_endrec) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_user_rec, cur_endrec));
	LASSERTF((int)sizeof(((struct llog_changelog_user_rec *)0)->cur_endrec) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_user_rec *)0)->cur_endrec));
	LASSERTF((int)offsetof(struct llog_changelog_user_rec, cur_tail) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_user_rec, cur_tail));
	LASSERTF((int)sizeof(((struct llog_changelog_user_rec *)0)->cur_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_user_rec *)0)->cur_tail));

	/* Checks for struct llog_gen */
	LASSERTF((int)sizeof(struct llog_gen) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct llog_gen));
	LASSERTF((int)offsetof(struct llog_gen, mnt_cnt) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_gen, mnt_cnt));
	LASSERTF((int)sizeof(((struct llog_gen *)0)->mnt_cnt) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_gen *)0)->mnt_cnt));
	LASSERTF((int)offsetof(struct llog_gen, conn_cnt) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct llog_gen, conn_cnt));
	LASSERTF((int)sizeof(((struct llog_gen *)0)->conn_cnt) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_gen *)0)->conn_cnt));

	/* Checks for struct llog_gen_rec */
	LASSERTF((int)sizeof(struct llog_gen_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct llog_gen_rec));
	LASSERTF((int)offsetof(struct llog_gen_rec, lgr_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_gen_rec, lgr_hdr));
	LASSERTF((int)sizeof(((struct llog_gen_rec *)0)->lgr_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_gen_rec *)0)->lgr_hdr));
	LASSERTF((int)offsetof(struct llog_gen_rec, lgr_gen) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_gen_rec, lgr_gen));
	LASSERTF((int)sizeof(((struct llog_gen_rec *)0)->lgr_gen) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_gen_rec *)0)->lgr_gen));
	LASSERTF((int)offsetof(struct llog_gen_rec, lgr_tail) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct llog_gen_rec, lgr_tail));
	LASSERTF((int)sizeof(((struct llog_gen_rec *)0)->lgr_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_gen_rec *)0)->lgr_tail));

	/* Checks for struct llog_log_hdr */
	LASSERTF((int)sizeof(struct llog_log_hdr) == 8192, "found %lld\n",
		 (long long)(int)sizeof(struct llog_log_hdr));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_hdr));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_hdr));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_timestamp) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_timestamp));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_timestamp) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_timestamp));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_count) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_count));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_count));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_bitmap_offset) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_bitmap_offset));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_bitmap_offset) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_bitmap_offset));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_size) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_size));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_size));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_flags) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_flags));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_flags));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_cat_idx) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_cat_idx));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_cat_idx) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_cat_idx));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_tgtuuid) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_tgtuuid));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_tgtuuid) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_tgtuuid));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_reserved) == 84, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_reserved));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_reserved) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_reserved));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_bitmap) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_bitmap));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_bitmap) == 8096, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_bitmap));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_tail) == 8184, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_tail));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_tail));

	/* Checks for struct llog_cookie */
	LASSERTF((int)sizeof(struct llog_cookie) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct llog_cookie));
	LASSERTF((int)offsetof(struct llog_cookie, lgc_lgl) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_cookie, lgc_lgl));
	LASSERTF((int)sizeof(((struct llog_cookie *)0)->lgc_lgl) == 20, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_cookie *)0)->lgc_lgl));
	LASSERTF((int)offsetof(struct llog_cookie, lgc_subsys) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct llog_cookie, lgc_subsys));
	LASSERTF((int)sizeof(((struct llog_cookie *)0)->lgc_subsys) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_cookie *)0)->lgc_subsys));
	LASSERTF((int)offsetof(struct llog_cookie, lgc_index) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct llog_cookie, lgc_index));
	LASSERTF((int)sizeof(((struct llog_cookie *)0)->lgc_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_cookie *)0)->lgc_index));
	LASSERTF((int)offsetof(struct llog_cookie, lgc_padding) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct llog_cookie, lgc_padding));
	LASSERTF((int)sizeof(((struct llog_cookie *)0)->lgc_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_cookie *)0)->lgc_padding));

	/* Checks for struct llogd_body */
	LASSERTF((int)sizeof(struct llogd_body) == 48, "found %lld\n",
		 (long long)(int)sizeof(struct llogd_body));
	LASSERTF((int)offsetof(struct llogd_body, lgd_logid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_logid));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_logid) == 20, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_logid));
	LASSERTF((int)offsetof(struct llogd_body, lgd_ctxt_idx) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_ctxt_idx));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_ctxt_idx) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_ctxt_idx));
	LASSERTF((int)offsetof(struct llogd_body, lgd_llh_flags) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_llh_flags));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_llh_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_llh_flags));
	LASSERTF((int)offsetof(struct llogd_body, lgd_index) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_index));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_index));
	LASSERTF((int)offsetof(struct llogd_body, lgd_saved_index) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_saved_index));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_saved_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_saved_index));
	LASSERTF((int)offsetof(struct llogd_body, lgd_len) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_len));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_len));
	LASSERTF((int)offsetof(struct llogd_body, lgd_cur_offset) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_cur_offset));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_cur_offset) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_cur_offset));
	CLASSERT(LLOG_ORIGIN_HANDLE_CREATE == 501);
	CLASSERT(LLOG_ORIGIN_HANDLE_NEXT_BLOCK == 502);
	CLASSERT(LLOG_ORIGIN_HANDLE_READ_HEADER == 503);
	CLASSERT(LLOG_ORIGIN_HANDLE_WRITE_REC == 504);
	CLASSERT(LLOG_ORIGIN_HANDLE_CLOSE == 505);
	CLASSERT(LLOG_ORIGIN_CONNECT == 506);
	CLASSERT(LLOG_CATINFO == 507);
	CLASSERT(LLOG_ORIGIN_HANDLE_PREV_BLOCK == 508);
	CLASSERT(LLOG_ORIGIN_HANDLE_DESTROY == 509);
	CLASSERT(LLOG_FIRST_OPC == 501);
	CLASSERT(LLOG_LAST_OPC == 510);

	/* Checks for struct llogd_conn_body */
	LASSERTF((int)sizeof(struct llogd_conn_body) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct llogd_conn_body));
	LASSERTF((int)offsetof(struct llogd_conn_body, lgdc_gen) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_conn_body, lgdc_gen));
	LASSERTF((int)sizeof(((struct llogd_conn_body *)0)->lgdc_gen) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_conn_body *)0)->lgdc_gen));
	LASSERTF((int)offsetof(struct llogd_conn_body, lgdc_logid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_conn_body, lgdc_logid));
	LASSERTF((int)sizeof(((struct llogd_conn_body *)0)->lgdc_logid) == 20, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_conn_body *)0)->lgdc_logid));
	LASSERTF((int)offsetof(struct llogd_conn_body, lgdc_ctxt_idx) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_conn_body, lgdc_ctxt_idx));
	LASSERTF((int)sizeof(((struct llogd_conn_body *)0)->lgdc_ctxt_idx) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_conn_body *)0)->lgdc_ctxt_idx));

	/* Checks for struct ll_fiemap_info_key */
	LASSERTF((int)sizeof(struct ll_fiemap_info_key) == 248, "found %lld\n",
		 (long long)(int)sizeof(struct ll_fiemap_info_key));
	LASSERTF((int)offsetof(struct ll_fiemap_info_key, name[8]) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fiemap_info_key, name[8]));
	LASSERTF((int)sizeof(((struct ll_fiemap_info_key *)0)->name[8]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fiemap_info_key *)0)->name[8]));
	LASSERTF((int)offsetof(struct ll_fiemap_info_key, oa) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fiemap_info_key, oa));
	LASSERTF((int)sizeof(((struct ll_fiemap_info_key *)0)->oa) == 208, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fiemap_info_key *)0)->oa));
	LASSERTF((int)offsetof(struct ll_fiemap_info_key, fiemap) == 216, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fiemap_info_key, fiemap));
	LASSERTF((int)sizeof(((struct ll_fiemap_info_key *)0)->fiemap) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fiemap_info_key *)0)->fiemap));

	/* Checks for struct mgs_target_info */
	LASSERTF((int)sizeof(struct mgs_target_info) == 4544, "found %lld\n",
		 (long long)(int)sizeof(struct mgs_target_info));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_lustre_ver) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_lustre_ver));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_lustre_ver) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_lustre_ver));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_stripe_index) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_stripe_index));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_stripe_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_stripe_index));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_config_ver) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_config_ver));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_config_ver) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_config_ver));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_flags) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_flags));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_flags));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_nid_count) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_nid_count));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_nid_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_nid_count));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_instance) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_instance));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_instance) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_instance));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_fsname) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_fsname));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_fsname) == 64, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_fsname));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_svname) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_svname));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_svname) == 64, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_svname));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_uuid) == 152, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_uuid));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_uuid) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_uuid));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_nids) == 192, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_nids));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_nids) == 256, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_nids));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_params) == 448, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_params));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_params) == 4096, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_params));

	/* Checks for struct lustre_capa */
	LASSERTF((int)sizeof(struct lustre_capa) == 120, "found %lld\n",
		 (long long)(int)sizeof(struct lustre_capa));
	LASSERTF((int)offsetof(struct lustre_capa, lc_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_fid));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_fid));
	LASSERTF((int)offsetof(struct lustre_capa, lc_opc) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_opc));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_opc) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_opc));
	LASSERTF((int)offsetof(struct lustre_capa, lc_uid) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_uid));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_uid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_uid));
	LASSERTF((int)offsetof(struct lustre_capa, lc_gid) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_gid));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_gid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_gid));
	LASSERTF((int)offsetof(struct lustre_capa, lc_flags) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_flags));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_flags));
	LASSERTF((int)offsetof(struct lustre_capa, lc_keyid) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_keyid));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_keyid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_keyid));
	LASSERTF((int)offsetof(struct lustre_capa, lc_timeout) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_timeout));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_timeout) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_timeout));
	LASSERTF((int)offsetof(struct lustre_capa, lc_expiry) == 52, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_expiry));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_expiry) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_expiry));
	CLASSERT(CAPA_HMAC_MAX_LEN == 64);
	LASSERTF((int)offsetof(struct lustre_capa, lc_hmac[64]) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_hmac[64]));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_hmac[64]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_hmac[64]));

	/* Checks for struct lustre_capa_key */
	LASSERTF((int)sizeof(struct lustre_capa_key) == 72, "found %lld\n",
		 (long long)(int)sizeof(struct lustre_capa_key));
	LASSERTF((int)offsetof(struct lustre_capa_key, lk_seq) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa_key, lk_seq));
	LASSERTF((int)sizeof(((struct lustre_capa_key *)0)->lk_seq) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa_key *)0)->lk_seq));
	LASSERTF((int)offsetof(struct lustre_capa_key, lk_keyid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa_key, lk_keyid));
	LASSERTF((int)sizeof(((struct lustre_capa_key *)0)->lk_keyid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa_key *)0)->lk_keyid));
	LASSERTF((int)offsetof(struct lustre_capa_key, lk_padding) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa_key, lk_padding));
	LASSERTF((int)sizeof(((struct lustre_capa_key *)0)->lk_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa_key *)0)->lk_padding));
	CLASSERT(CAPA_HMAC_KEY_MAX_LEN == 56);
	LASSERTF((int)offsetof(struct lustre_capa_key, lk_key[56]) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa_key, lk_key[56]));
	LASSERTF((int)sizeof(((struct lustre_capa_key *)0)->lk_key[56]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa_key *)0)->lk_key[56]));

	/* Checks for struct getinfo_fid2path */
	LASSERTF((int)sizeof(struct getinfo_fid2path) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct getinfo_fid2path));
	LASSERTF((int)offsetof(struct getinfo_fid2path, gf_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct getinfo_fid2path, gf_fid));
	LASSERTF((int)sizeof(((struct getinfo_fid2path *)0)->gf_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct getinfo_fid2path *)0)->gf_fid));
	LASSERTF((int)offsetof(struct getinfo_fid2path, gf_recno) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct getinfo_fid2path, gf_recno));
	LASSERTF((int)sizeof(((struct getinfo_fid2path *)0)->gf_recno) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct getinfo_fid2path *)0)->gf_recno));
	LASSERTF((int)offsetof(struct getinfo_fid2path, gf_linkno) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct getinfo_fid2path, gf_linkno));
	LASSERTF((int)sizeof(((struct getinfo_fid2path *)0)->gf_linkno) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct getinfo_fid2path *)0)->gf_linkno));
	LASSERTF((int)offsetof(struct getinfo_fid2path, gf_pathlen) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct getinfo_fid2path, gf_pathlen));
	LASSERTF((int)sizeof(((struct getinfo_fid2path *)0)->gf_pathlen) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct getinfo_fid2path *)0)->gf_pathlen));
	LASSERTF((int)offsetof(struct getinfo_fid2path, gf_path[0]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct getinfo_fid2path, gf_path[0]));
	LASSERTF((int)sizeof(((struct getinfo_fid2path *)0)->gf_path[0]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct getinfo_fid2path *)0)->gf_path[0]));

	/* Checks for struct ll_user_fiemap */
	LASSERTF((int)sizeof(struct ll_user_fiemap) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct ll_user_fiemap));
	LASSERTF((int)offsetof(struct ll_user_fiemap, fm_start) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ll_user_fiemap, fm_start));
	LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_start));
	LASSERTF((int)offsetof(struct ll_user_fiemap, fm_length) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ll_user_fiemap, fm_length));
	LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_length) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_length));
	LASSERTF((int)offsetof(struct ll_user_fiemap, fm_flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ll_user_fiemap, fm_flags));
	LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_flags));
	LASSERTF((int)offsetof(struct ll_user_fiemap, fm_mapped_extents) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct ll_user_fiemap, fm_mapped_extents));
	LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_mapped_extents) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_mapped_extents));
	LASSERTF((int)offsetof(struct ll_user_fiemap, fm_extent_count) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ll_user_fiemap, fm_extent_count));
	LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_extent_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_extent_count));
	LASSERTF((int)offsetof(struct ll_user_fiemap, fm_reserved) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct ll_user_fiemap, fm_reserved));
	LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_reserved) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_reserved));
	LASSERTF((int)offsetof(struct ll_user_fiemap, fm_extents) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ll_user_fiemap, fm_extents));
	LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_extents) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_extents));
	CLASSERT(FIEMAP_FLAG_SYNC == 0x00000001);
	CLASSERT(FIEMAP_FLAG_XATTR == 0x00000002);
	CLASSERT(FIEMAP_FLAG_DEVICE_ORDER == 0x40000000);

	/* Checks for struct ll_fiemap_extent */
	LASSERTF((int)sizeof(struct ll_fiemap_extent) == 56, "found %lld\n",
		 (long long)(int)sizeof(struct ll_fiemap_extent));
	LASSERTF((int)offsetof(struct ll_fiemap_extent, fe_logical) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fiemap_extent, fe_logical));
	LASSERTF((int)sizeof(((struct ll_fiemap_extent *)0)->fe_logical) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fiemap_extent *)0)->fe_logical));
	LASSERTF((int)offsetof(struct ll_fiemap_extent, fe_physical) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fiemap_extent, fe_physical));
	LASSERTF((int)sizeof(((struct ll_fiemap_extent *)0)->fe_physical) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fiemap_extent *)0)->fe_physical));
	LASSERTF((int)offsetof(struct ll_fiemap_extent, fe_length) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fiemap_extent, fe_length));
	LASSERTF((int)sizeof(((struct ll_fiemap_extent *)0)->fe_length) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fiemap_extent *)0)->fe_length));
	LASSERTF((int)offsetof(struct ll_fiemap_extent, fe_flags) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fiemap_extent, fe_flags));
	LASSERTF((int)sizeof(((struct ll_fiemap_extent *)0)->fe_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fiemap_extent *)0)->fe_flags));
	LASSERTF((int)offsetof(struct ll_fiemap_extent, fe_device) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fiemap_extent, fe_device));
	LASSERTF((int)sizeof(((struct ll_fiemap_extent *)0)->fe_device) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fiemap_extent *)0)->fe_device));
	CLASSERT(FIEMAP_EXTENT_LAST == 0x00000001);
	CLASSERT(FIEMAP_EXTENT_UNKNOWN == 0x00000002);
	CLASSERT(FIEMAP_EXTENT_DELALLOC == 0x00000004);
	CLASSERT(FIEMAP_EXTENT_ENCODED == 0x00000008);
	CLASSERT(FIEMAP_EXTENT_DATA_ENCRYPTED == 0x00000080);
	CLASSERT(FIEMAP_EXTENT_NOT_ALIGNED == 0x00000100);
	CLASSERT(FIEMAP_EXTENT_DATA_INLINE == 0x00000200);
	CLASSERT(FIEMAP_EXTENT_DATA_TAIL == 0x00000400);
	CLASSERT(FIEMAP_EXTENT_UNWRITTEN == 0x00000800);
	CLASSERT(FIEMAP_EXTENT_MERGED == 0x00001000);
	CLASSERT(FIEMAP_EXTENT_NO_DIRECT == 0x40000000);
	CLASSERT(FIEMAP_EXTENT_NET == 0x80000000);

	/* Checks for type posix_acl_xattr_entry */
	LASSERTF((int)sizeof(posix_acl_xattr_entry) == 8, "found %lld\n",
		 (long long)(int)sizeof(posix_acl_xattr_entry));
	LASSERTF((int)offsetof(posix_acl_xattr_entry, e_tag) == 0, "found %lld\n",
		 (long long)(int)offsetof(posix_acl_xattr_entry, e_tag));
	LASSERTF((int)sizeof(((posix_acl_xattr_entry *)0)->e_tag) == 2, "found %lld\n",
		 (long long)(int)sizeof(((posix_acl_xattr_entry *)0)->e_tag));
	LASSERTF((int)offsetof(posix_acl_xattr_entry, e_perm) == 2, "found %lld\n",
		 (long long)(int)offsetof(posix_acl_xattr_entry, e_perm));
	LASSERTF((int)sizeof(((posix_acl_xattr_entry *)0)->e_perm) == 2, "found %lld\n",
		 (long long)(int)sizeof(((posix_acl_xattr_entry *)0)->e_perm));
	LASSERTF((int)offsetof(posix_acl_xattr_entry, e_id) == 4, "found %lld\n",
		 (long long)(int)offsetof(posix_acl_xattr_entry, e_id));
	LASSERTF((int)sizeof(((posix_acl_xattr_entry *)0)->e_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((posix_acl_xattr_entry *)0)->e_id));

	/* Checks for type posix_acl_xattr_header */
	LASSERTF((int)sizeof(posix_acl_xattr_header) == 4, "found %lld\n",
		 (long long)(int)sizeof(posix_acl_xattr_header));
	LASSERTF((int)offsetof(posix_acl_xattr_header, a_version) == 0, "found %lld\n",
		 (long long)(int)offsetof(posix_acl_xattr_header, a_version));
	LASSERTF((int)sizeof(((posix_acl_xattr_header *)0)->a_version) == 4, "found %lld\n",
		 (long long)(int)sizeof(((posix_acl_xattr_header *)0)->a_version));
	LASSERTF((int)offsetof(posix_acl_xattr_header, a_entries) == 4, "found %lld\n",
		 (long long)(int)offsetof(posix_acl_xattr_header, a_entries));
	LASSERTF((int)sizeof(((posix_acl_xattr_header *)0)->a_entries) == 0, "found %lld\n",
		 (long long)(int)sizeof(((posix_acl_xattr_header *)0)->a_entries));

	/* Checks for struct link_ea_header */
	LASSERTF((int)sizeof(struct link_ea_header) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct link_ea_header));
	LASSERTF((int)offsetof(struct link_ea_header, leh_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_header, leh_magic));
	LASSERTF((int)sizeof(((struct link_ea_header *)0)->leh_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_header *)0)->leh_magic));
	LASSERTF((int)offsetof(struct link_ea_header, leh_reccount) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_header, leh_reccount));
	LASSERTF((int)sizeof(((struct link_ea_header *)0)->leh_reccount) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_header *)0)->leh_reccount));
	LASSERTF((int)offsetof(struct link_ea_header, leh_len) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_header, leh_len));
	LASSERTF((int)sizeof(((struct link_ea_header *)0)->leh_len) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_header *)0)->leh_len));
	LASSERTF((int)offsetof(struct link_ea_header, padding1) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_header, padding1));
	LASSERTF((int)sizeof(((struct link_ea_header *)0)->padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_header *)0)->padding1));
	LASSERTF((int)offsetof(struct link_ea_header, padding2) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_header, padding2));
	LASSERTF((int)sizeof(((struct link_ea_header *)0)->padding2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_header *)0)->padding2));
	CLASSERT(LINK_EA_MAGIC == 0x11EAF1DFUL);

	/* Checks for struct link_ea_entry */
	LASSERTF((int)sizeof(struct link_ea_entry) == 18, "found %lld\n",
		 (long long)(int)sizeof(struct link_ea_entry));
	LASSERTF((int)offsetof(struct link_ea_entry, lee_reclen) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_entry, lee_reclen));
	LASSERTF((int)sizeof(((struct link_ea_entry *)0)->lee_reclen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_entry *)0)->lee_reclen));
	LASSERTF((int)offsetof(struct link_ea_entry, lee_parent_fid) == 2, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_entry, lee_parent_fid));
	LASSERTF((int)sizeof(((struct link_ea_entry *)0)->lee_parent_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_entry *)0)->lee_parent_fid));
	LASSERTF((int)offsetof(struct link_ea_entry, lee_name) == 18, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_entry, lee_name));
	LASSERTF((int)sizeof(((struct link_ea_entry *)0)->lee_name) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_entry *)0)->lee_name));

	/* Checks for struct layout_intent */
	LASSERTF((int)sizeof(struct layout_intent) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct layout_intent));
	LASSERTF((int)offsetof(struct layout_intent, li_opc) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct layout_intent, li_opc));
	LASSERTF((int)sizeof(((struct layout_intent *)0)->li_opc) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct layout_intent *)0)->li_opc));
	LASSERTF((int)offsetof(struct layout_intent, li_flags) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct layout_intent, li_flags));
	LASSERTF((int)sizeof(((struct layout_intent *)0)->li_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct layout_intent *)0)->li_flags));
	LASSERTF((int)offsetof(struct layout_intent, li_start) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct layout_intent, li_start));
	LASSERTF((int)sizeof(((struct layout_intent *)0)->li_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct layout_intent *)0)->li_start));
	LASSERTF((int)offsetof(struct layout_intent, li_end) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct layout_intent, li_end));
	LASSERTF((int)sizeof(((struct layout_intent *)0)->li_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct layout_intent *)0)->li_end));
	LASSERTF(LAYOUT_INTENT_ACCESS == 0, "found %lld\n",
		 (long long)LAYOUT_INTENT_ACCESS);
	LASSERTF(LAYOUT_INTENT_READ == 1, "found %lld\n",
		 (long long)LAYOUT_INTENT_READ);
	LASSERTF(LAYOUT_INTENT_WRITE == 2, "found %lld\n",
		 (long long)LAYOUT_INTENT_WRITE);
	LASSERTF(LAYOUT_INTENT_GLIMPSE == 3, "found %lld\n",
		 (long long)LAYOUT_INTENT_GLIMPSE);
	LASSERTF(LAYOUT_INTENT_TRUNC == 4, "found %lld\n",
		 (long long)LAYOUT_INTENT_TRUNC);
	LASSERTF(LAYOUT_INTENT_RELEASE == 5, "found %lld\n",
		 (long long)LAYOUT_INTENT_RELEASE);
	LASSERTF(LAYOUT_INTENT_RESTORE == 6, "found %lld\n",
		 (long long)LAYOUT_INTENT_RESTORE);

	/* Checks for struct hsm_action_item */
	LASSERTF((int)sizeof(struct hsm_action_item) == 72, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_action_item));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_len) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_len));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_len));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_action) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_action));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_action) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_action));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_fid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_fid));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_fid));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_dfid) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_dfid));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_dfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_dfid));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_extent) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_extent));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_extent) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_extent));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_cookie) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_cookie));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_cookie) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_cookie));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_gid) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_gid));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_gid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_gid));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_data) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_data));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_data) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_data));

	/* Checks for struct hsm_action_list */
	LASSERTF((int)sizeof(struct hsm_action_list) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_action_list));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_version) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_version));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_version) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_version));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_count));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_count));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_compound_id) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_compound_id));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_compound_id) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_compound_id));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_flags));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_flags) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_flags));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_archive_id) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_archive_id));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_archive_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_archive_id));
	LASSERTF((int)offsetof(struct hsm_action_list, padding1) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, padding1));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->padding1));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_fsname) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_fsname));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_fsname) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_fsname));

	/* Checks for struct hsm_progress */
	LASSERTF((int)sizeof(struct hsm_progress) == 48, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_progress));
	LASSERTF((int)offsetof(struct hsm_progress, hp_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, hp_fid));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->hp_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->hp_fid));
	LASSERTF((int)offsetof(struct hsm_progress, hp_cookie) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, hp_cookie));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->hp_cookie) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->hp_cookie));
	LASSERTF((int)offsetof(struct hsm_progress, hp_extent) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, hp_extent));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->hp_extent) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->hp_extent));
	LASSERTF((int)offsetof(struct hsm_progress, hp_flags) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, hp_flags));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->hp_flags) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->hp_flags));
	LASSERTF((int)offsetof(struct hsm_progress, hp_errval) == 42, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, hp_errval));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->hp_errval) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->hp_errval));
	LASSERTF((int)offsetof(struct hsm_progress, padding) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, padding));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->padding));
	LASSERTF(HP_FLAG_COMPLETED == 0x01, "found 0x%.8x\n",
		HP_FLAG_COMPLETED);
	LASSERTF(HP_FLAG_RETRY == 0x02, "found 0x%.8x\n",
		HP_FLAG_RETRY);

	LASSERTF((int)offsetof(struct hsm_copy, hc_data_version) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_copy, hc_data_version));
	LASSERTF((int)sizeof(((struct hsm_copy *)0)->hc_data_version) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_copy *)0)->hc_data_version));
	LASSERTF((int)offsetof(struct hsm_copy, hc_flags) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_copy, hc_flags));
	LASSERTF((int)sizeof(((struct hsm_copy *)0)->hc_flags) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_copy *)0)->hc_flags));
	LASSERTF((int)offsetof(struct hsm_copy, hc_errval) == 10, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_copy, hc_errval));
	LASSERTF((int)sizeof(((struct hsm_copy *)0)->hc_errval) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_copy *)0)->hc_errval));
	LASSERTF((int)offsetof(struct hsm_copy, padding) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_copy, padding));
	LASSERTF((int)sizeof(((struct hsm_copy *)0)->padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_copy *)0)->padding));
	LASSERTF((int)offsetof(struct hsm_copy, hc_hai) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_copy, hc_hai));
	LASSERTF((int)sizeof(((struct hsm_copy *)0)->hc_hai) == 72, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_copy *)0)->hc_hai));

	/* Checks for struct hsm_progress_kernel */
	LASSERTF((int)sizeof(struct hsm_progress_kernel) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_progress_kernel));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_fid));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_fid));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_cookie) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_cookie));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_cookie) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_cookie));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_extent) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_extent));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_extent) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_extent));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_flags) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_flags));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_flags) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_flags));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_errval) == 42, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_errval));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_errval) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_errval));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_padding1) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_padding1));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_padding1));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_data_version) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_data_version));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_data_version) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_data_version));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_padding2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_padding2));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_padding2));

	/* Checks for struct hsm_user_item */
	LASSERTF((int)sizeof(struct hsm_user_item) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_user_item));
	LASSERTF((int)offsetof(struct hsm_user_item, hui_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_item, hui_fid));
	LASSERTF((int)sizeof(((struct hsm_user_item *)0)->hui_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_item *)0)->hui_fid));
	LASSERTF((int)offsetof(struct hsm_user_item, hui_extent) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_item, hui_extent));
	LASSERTF((int)sizeof(((struct hsm_user_item *)0)->hui_extent) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_item *)0)->hui_extent));

	/* Checks for struct hsm_user_state */
	LASSERTF((int)sizeof(struct hsm_user_state) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_user_state));
	LASSERTF((int)offsetof(struct hsm_user_state, hus_states) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_state, hus_states));
	LASSERTF((int)sizeof(((struct hsm_user_state *)0)->hus_states) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_state *)0)->hus_states));
	LASSERTF((int)offsetof(struct hsm_user_state, hus_archive_id) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_state, hus_archive_id));
	LASSERTF((int)sizeof(((struct hsm_user_state *)0)->hus_archive_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_state *)0)->hus_archive_id));
	LASSERTF((int)offsetof(struct hsm_user_state, hus_in_progress_state) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_state, hus_in_progress_state));
	LASSERTF((int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_state) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_state));
	LASSERTF((int)offsetof(struct hsm_user_state, hus_in_progress_action) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_state, hus_in_progress_action));
	LASSERTF((int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_action) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_action));
	LASSERTF((int)offsetof(struct hsm_user_state, hus_in_progress_location) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_state, hus_in_progress_location));
	LASSERTF((int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_location) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_location));

	/* Checks for struct hsm_state_set */
	LASSERTF((int)sizeof(struct hsm_state_set) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_state_set));
	LASSERTF((int)offsetof(struct hsm_state_set, hss_valid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_state_set, hss_valid));
	LASSERTF((int)sizeof(((struct hsm_state_set *)0)->hss_valid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_state_set *)0)->hss_valid));
	LASSERTF((int)offsetof(struct hsm_state_set, hss_archive_id) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_state_set, hss_archive_id));
	LASSERTF((int)sizeof(((struct hsm_state_set *)0)->hss_archive_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_state_set *)0)->hss_archive_id));
	LASSERTF((int)offsetof(struct hsm_state_set, hss_setmask) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_state_set, hss_setmask));
	LASSERTF((int)sizeof(((struct hsm_state_set *)0)->hss_setmask) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_state_set *)0)->hss_setmask));
	LASSERTF((int)offsetof(struct hsm_state_set, hss_clearmask) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_state_set, hss_clearmask));
	LASSERTF((int)sizeof(((struct hsm_state_set *)0)->hss_clearmask) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_state_set *)0)->hss_clearmask));

	/* Checks for struct hsm_current_action */
	LASSERTF((int)sizeof(struct hsm_current_action) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_current_action));
	LASSERTF((int)offsetof(struct hsm_current_action, hca_state) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_current_action, hca_state));
	LASSERTF((int)sizeof(((struct hsm_current_action *)0)->hca_state) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_current_action *)0)->hca_state));
	LASSERTF((int)offsetof(struct hsm_current_action, hca_action) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_current_action, hca_action));
	LASSERTF((int)sizeof(((struct hsm_current_action *)0)->hca_action) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_current_action *)0)->hca_action));
	LASSERTF((int)offsetof(struct hsm_current_action, hca_location) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_current_action, hca_location));
	LASSERTF((int)sizeof(((struct hsm_current_action *)0)->hca_location) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_current_action *)0)->hca_location));

	/* Checks for struct hsm_request */
	LASSERTF((int)sizeof(struct hsm_request) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_request));
	LASSERTF((int)offsetof(struct hsm_request, hr_action) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_request, hr_action));
	LASSERTF((int)sizeof(((struct hsm_request *)0)->hr_action) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_request *)0)->hr_action));
	LASSERTF((int)offsetof(struct hsm_request, hr_archive_id) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_request, hr_archive_id));
	LASSERTF((int)sizeof(((struct hsm_request *)0)->hr_archive_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_request *)0)->hr_archive_id));
	LASSERTF((int)offsetof(struct hsm_request, hr_flags) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_request, hr_flags));
	LASSERTF((int)sizeof(((struct hsm_request *)0)->hr_flags) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_request *)0)->hr_flags));
	LASSERTF((int)offsetof(struct hsm_request, hr_itemcount) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_request, hr_itemcount));
	LASSERTF((int)sizeof(((struct hsm_request *)0)->hr_itemcount) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_request *)0)->hr_itemcount));
	LASSERTF((int)offsetof(struct hsm_request, hr_data_len) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_request, hr_data_len));
	LASSERTF((int)sizeof(((struct hsm_request *)0)->hr_data_len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_request *)0)->hr_data_len));
	LASSERTF(HSM_FORCE_ACTION == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)HSM_FORCE_ACTION);
	LASSERTF(HSM_GHOST_COPY == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)HSM_GHOST_COPY);

	/* Checks for struct hsm_user_request */
	LASSERTF((int)sizeof(struct hsm_user_request) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_user_request));
	LASSERTF((int)offsetof(struct hsm_user_request, hur_request) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_request, hur_request));
	LASSERTF((int)sizeof(((struct hsm_user_request *)0)->hur_request) == 24, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_request *)0)->hur_request));
	LASSERTF((int)offsetof(struct hsm_user_request, hur_user_item) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_request, hur_user_item));
	LASSERTF((int)sizeof(((struct hsm_user_request *)0)->hur_user_item) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_request *)0)->hur_user_item));

	/* Checks for struct hsm_user_import */
	LASSERTF(sizeof(struct hsm_user_import) == 48, "found %lld\n",
		 (long long)sizeof(struct hsm_user_import));
	LASSERTF(offsetof(struct hsm_user_import, hui_size) == 0,
		 "found %lld\n",
		 (long long)offsetof(struct hsm_user_import, hui_size));
	LASSERTF(sizeof(((struct hsm_user_import *)0)->hui_size) == 8,
		 "found %lld\n",
		 (long long)sizeof(((struct hsm_user_import *)0)->hui_size));
	LASSERTF(offsetof(struct hsm_user_import, hui_uid) == 32,
		 "found %lld\n",
		 (long long)offsetof(struct hsm_user_import, hui_uid));
	LASSERTF(sizeof(((struct hsm_user_import *)0)->hui_uid) == 4,
		 "found %lld\n",
		 (long long)sizeof(((struct hsm_user_import *)0)->hui_uid));
	LASSERTF(offsetof(struct hsm_user_import, hui_gid) == 36,
		 "found %lld\n",
		 (long long)offsetof(struct hsm_user_import, hui_gid));
	LASSERTF(sizeof(((struct hsm_user_import *)0)->hui_gid) == 4,
		 "found %lld\n",
		 (long long)sizeof(((struct hsm_user_import *)0)->hui_gid));
	LASSERTF(offsetof(struct hsm_user_import, hui_mode) == 40,
		 "found %lld\n",
		 (long long)offsetof(struct hsm_user_import, hui_mode));
	LASSERTF(sizeof(((struct hsm_user_import *)0)->hui_mode) == 4,
		 "found %lld\n",
		 (long long)sizeof(((struct hsm_user_import *)0)->hui_mode));
	LASSERTF(offsetof(struct hsm_user_import, hui_atime) == 8,
		 "found %lld\n",
		 (long long)offsetof(struct hsm_user_import, hui_atime));
	LASSERTF(sizeof(((struct hsm_user_import *)0)->hui_atime) == 8,
		 "found %lld\n",
		 (long long)sizeof(((struct hsm_user_import *)0)->hui_atime));
	LASSERTF(offsetof(struct hsm_user_import, hui_atime_ns) == 24,
		 "found %lld\n",
		(long long)(int)offsetof(struct hsm_user_import, hui_atime_ns));
	LASSERTF(sizeof(((struct hsm_user_import *)0)->hui_atime_ns) == 4,
		 "found %lld\n",
		(long long)sizeof(((struct hsm_user_import *)0)->hui_atime_ns));
	LASSERTF(offsetof(struct hsm_user_import, hui_mtime) == 16,
		 "found %lld\n",
		 (long long)offsetof(struct hsm_user_import, hui_mtime));
	LASSERTF(sizeof(((struct hsm_user_import *)0)->hui_mtime) == 8,
		 "found %lld\n",
		 (long long)sizeof(((struct hsm_user_import *)0)->hui_mtime));
	LASSERTF(offsetof(struct hsm_user_import, hui_mtime_ns) == 28,
		 "found %lld\n",
		(long long)offsetof(struct hsm_user_import, hui_mtime_ns));
	LASSERTF(sizeof(((struct hsm_user_import *)0)->hui_mtime_ns) == 4,
		 "found %lld\n",
		(long long)sizeof(((struct hsm_user_import *)0)->hui_mtime_ns));
	LASSERTF(offsetof(struct hsm_user_import, hui_archive_id) == 44,
		 "found %lld\n",
		 (long long)offsetof(struct hsm_user_import, hui_archive_id));
	LASSERTF(sizeof(((struct hsm_user_import *)0)->hui_archive_id) == 4,
		 "found %lld\n",
	      (long long)sizeof(((struct hsm_user_import *)0)->hui_archive_id));
}
