/*
 * Copyright (C) 2017 Socionext Inc.
 *   Author: Masahiro Yamada <yamada.masahiro@socionext.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/pinctrl/pinctrl.h>
#include <linux/platform_device.h>

#include "pinctrl-uniphier.h"

static const struct pinctrl_pin_desc uniphier_pxs3_pins[] = {
	UNIPHIER_PINCTRL_PIN(0, "LPST", UNIPHIER_PIN_IECTRL_EXIST,
			     0, UNIPHIER_PIN_DRV_3BIT,
			     0, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(1, "ED0", UNIPHIER_PIN_IECTRL_EXIST,
			     1, UNIPHIER_PIN_DRV_3BIT,
			     1, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(2, "ED1", UNIPHIER_PIN_IECTRL_EXIST,
			     2, UNIPHIER_PIN_DRV_3BIT,
			     2, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(3, "ED2", UNIPHIER_PIN_IECTRL_EXIST,
			     3, UNIPHIER_PIN_DRV_3BIT,
			     3, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(4, "ED3", UNIPHIER_PIN_IECTRL_EXIST,
			     4, UNIPHIER_PIN_DRV_3BIT,
			     4, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(5, "ED4", UNIPHIER_PIN_IECTRL_EXIST,
			     5, UNIPHIER_PIN_DRV_3BIT,
			     5, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(6, "ED5", UNIPHIER_PIN_IECTRL_EXIST,
			     6, UNIPHIER_PIN_DRV_3BIT,
			     6, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(7, "ED6", UNIPHIER_PIN_IECTRL_EXIST,
			     7, UNIPHIER_PIN_DRV_3BIT,
			     7, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(8, "ED7", UNIPHIER_PIN_IECTRL_EXIST,
			     8, UNIPHIER_PIN_DRV_3BIT,
			     8, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(9, "XERWE0", UNIPHIER_PIN_IECTRL_EXIST,
			     9, UNIPHIER_PIN_DRV_3BIT,
			     9, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(10, "XERWE1", UNIPHIER_PIN_IECTRL_EXIST,
			     10, UNIPHIER_PIN_DRV_3BIT,
			     10, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(11, "ERXW", UNIPHIER_PIN_IECTRL_EXIST,
			     11, UNIPHIER_PIN_DRV_3BIT,
			     11, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(12, "ES0", UNIPHIER_PIN_IECTRL_EXIST,
			     12, UNIPHIER_PIN_DRV_3BIT,
			     12, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(13, "ES1", UNIPHIER_PIN_IECTRL_EXIST,
			     13, UNIPHIER_PIN_DRV_3BIT,
			     13, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(14, "ES2", UNIPHIER_PIN_IECTRL_EXIST,
			     14, UNIPHIER_PIN_DRV_3BIT,
			     14, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(15, "XECS1", UNIPHIER_PIN_IECTRL_EXIST,
			     15, UNIPHIER_PIN_DRV_3BIT,
			     15, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(16, "XNFWP", UNIPHIER_PIN_IECTRL_EXIST,
			     16, UNIPHIER_PIN_DRV_3BIT,
			     16, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(17, "XNFCE0", UNIPHIER_PIN_IECTRL_EXIST,
			     17, UNIPHIER_PIN_DRV_3BIT,
			     17, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(18, "NFRYBY0", UNIPHIER_PIN_IECTRL_EXIST,
			     18, UNIPHIER_PIN_DRV_3BIT,
			     18, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(19, "XNFRE", UNIPHIER_PIN_IECTRL_EXIST,
			     19, UNIPHIER_PIN_DRV_3BIT,
			     19, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(20, "XNFWE", UNIPHIER_PIN_IECTRL_EXIST,
			     20, UNIPHIER_PIN_DRV_3BIT,
			     20, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(21, "NFALE", UNIPHIER_PIN_IECTRL_EXIST,
			     21, UNIPHIER_PIN_DRV_3BIT,
			     21, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(22, "NFCLE", UNIPHIER_PIN_IECTRL_EXIST,
			     22, UNIPHIER_PIN_DRV_3BIT,
			     22, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(23, "NFD0", UNIPHIER_PIN_IECTRL_EXIST,
			     23, UNIPHIER_PIN_DRV_3BIT,
			     23, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(24, "NFD1", UNIPHIER_PIN_IECTRL_EXIST,
			     24, UNIPHIER_PIN_DRV_3BIT,
			     24, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(25, "NFD2", UNIPHIER_PIN_IECTRL_EXIST,
			     25, UNIPHIER_PIN_DRV_3BIT,
			     25, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(26, "NFD3", UNIPHIER_PIN_IECTRL_EXIST,
			     26, UNIPHIER_PIN_DRV_3BIT,
			     26, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(27, "NFD4", UNIPHIER_PIN_IECTRL_EXIST,
			     27, UNIPHIER_PIN_DRV_3BIT,
			     27, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(28, "NFD5", UNIPHIER_PIN_IECTRL_EXIST,
			     28, UNIPHIER_PIN_DRV_3BIT,
			     28, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(29, "NFD6", UNIPHIER_PIN_IECTRL_EXIST,
			     29, UNIPHIER_PIN_DRV_3BIT,
			     29, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(30, "NFD7", UNIPHIER_PIN_IECTRL_EXIST,
			     30, UNIPHIER_PIN_DRV_3BIT,
			     30, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(31, "XERST", UNIPHIER_PIN_IECTRL_EXIST,
			     0, UNIPHIER_PIN_DRV_2BIT,
			     31, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(32, "MMCCLK", UNIPHIER_PIN_IECTRL_EXIST,
			     1, UNIPHIER_PIN_DRV_2BIT,
			     32, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(33, "MMCCMD", UNIPHIER_PIN_IECTRL_EXIST,
			     2, UNIPHIER_PIN_DRV_2BIT,
			     33, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(34, "MMCDS", UNIPHIER_PIN_IECTRL_EXIST,
			     3, UNIPHIER_PIN_DRV_2BIT,
			     34, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(35, "MMCDAT0", UNIPHIER_PIN_IECTRL_EXIST,
			     4, UNIPHIER_PIN_DRV_2BIT,
			     35, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(36, "MMCDAT1", UNIPHIER_PIN_IECTRL_EXIST,
			     5, UNIPHIER_PIN_DRV_2BIT,
			     36, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(37, "MMCDAT2", UNIPHIER_PIN_IECTRL_EXIST,
			     6, UNIPHIER_PIN_DRV_2BIT,
			     37, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(38, "MMCDAT3", UNIPHIER_PIN_IECTRL_EXIST,
			     7, UNIPHIER_PIN_DRV_2BIT,
			     38, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(39, "MMCDAT4", UNIPHIER_PIN_IECTRL_EXIST,
			     8, UNIPHIER_PIN_DRV_2BIT,
			     39, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(40, "MMCDAT5", UNIPHIER_PIN_IECTRL_EXIST,
			     9, UNIPHIER_PIN_DRV_2BIT,
			     40, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(41, "MMCDAT6", UNIPHIER_PIN_IECTRL_EXIST,
			     10, UNIPHIER_PIN_DRV_2BIT,
			     41, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(42, "MMCDAT7", UNIPHIER_PIN_IECTRL_EXIST,
			     11, UNIPHIER_PIN_DRV_2BIT,
			     42, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(43, "SDCLK", UNIPHIER_PIN_IECTRL_EXIST,
			     12, UNIPHIER_PIN_DRV_2BIT,
			     43, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(44, "SDCMD", UNIPHIER_PIN_IECTRL_EXIST,
			     13, UNIPHIER_PIN_DRV_2BIT,
			     44, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(45, "SDDAT0", UNIPHIER_PIN_IECTRL_EXIST,
			     14, UNIPHIER_PIN_DRV_2BIT,
			     45, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(46, "SDDAT1", UNIPHIER_PIN_IECTRL_EXIST,
			     15, UNIPHIER_PIN_DRV_2BIT,
			     46, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(47, "SDDAT2", UNIPHIER_PIN_IECTRL_EXIST,
			     16, UNIPHIER_PIN_DRV_2BIT,
			     47, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(48, "SDDAT3", UNIPHIER_PIN_IECTRL_EXIST,
			     17, UNIPHIER_PIN_DRV_2BIT,
			     48, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(49, "SDCD", UNIPHIER_PIN_IECTRL_EXIST,
			     31, UNIPHIER_PIN_DRV_3BIT,
			     49, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(50, "SDWP", UNIPHIER_PIN_IECTRL_EXIST,
			     32, UNIPHIER_PIN_DRV_3BIT,
			     50, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(51, "SDVOLC", UNIPHIER_PIN_IECTRL_EXIST,
			     33, UNIPHIER_PIN_DRV_3BIT,
			     51, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(52, "MDC0", UNIPHIER_PIN_IECTRL_EXIST,
			     18, UNIPHIER_PIN_DRV_2BIT,
			     52, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(53, "MDIO0", UNIPHIER_PIN_IECTRL_EXIST,
			     19, UNIPHIER_PIN_DRV_2BIT,
			     53, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(54, "MDIO0_INTL", UNIPHIER_PIN_IECTRL_EXIST,
			     20, UNIPHIER_PIN_DRV_2BIT,
			     54, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(55, "PHYRSTL0", UNIPHIER_PIN_IECTRL_EXIST,
			     21, UNIPHIER_PIN_DRV_2BIT,
			     55, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(56, "RGMII0_RXCLK", UNIPHIER_PIN_IECTRL_EXIST,
			     22, UNIPHIER_PIN_DRV_2BIT,
			     56, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(57, "RGMII0_RXD0", UNIPHIER_PIN_IECTRL_EXIST,
			     23, UNIPHIER_PIN_DRV_2BIT,
			     57, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(58, "RGMII0_RXD1", UNIPHIER_PIN_IECTRL_EXIST,
			     24, UNIPHIER_PIN_DRV_2BIT,
			     58, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(59, "RGMII0_RXD2", UNIPHIER_PIN_IECTRL_EXIST,
			     25, UNIPHIER_PIN_DRV_2BIT,
			     59, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(60, "RGMII0_RXD3", UNIPHIER_PIN_IECTRL_EXIST,
			     26, UNIPHIER_PIN_DRV_2BIT,
			     60, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(61, "RGMII0_RXCTL", UNIPHIER_PIN_IECTRL_EXIST,
			     27, UNIPHIER_PIN_DRV_2BIT,
			     61, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(62, "RGMII0_TXCLK", UNIPHIER_PIN_IECTRL_EXIST,
			     28, UNIPHIER_PIN_DRV_2BIT,
			     62, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(63, "RGMII0_TXD0", UNIPHIER_PIN_IECTRL_EXIST,
			     29, UNIPHIER_PIN_DRV_2BIT,
			     63, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(64, "RGMII0_TXD1", UNIPHIER_PIN_IECTRL_EXIST,
			     30, UNIPHIER_PIN_DRV_2BIT,
			     64, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(65, "RGMII0_TXD2", UNIPHIER_PIN_IECTRL_EXIST,
			     31, UNIPHIER_PIN_DRV_2BIT,
			     65, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(66, "RGMII0_TXD3", UNIPHIER_PIN_IECTRL_EXIST,
			     32, UNIPHIER_PIN_DRV_2BIT,
			     66, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(67, "RGMII0_TXCTL", UNIPHIER_PIN_IECTRL_EXIST,
			     33, UNIPHIER_PIN_DRV_2BIT,
			     67, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(68, "MDC1", UNIPHIER_PIN_IECTRL_EXIST,
			     34, UNIPHIER_PIN_DRV_2BIT,
			     68, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(69, "MDIO1", UNIPHIER_PIN_IECTRL_EXIST,
			     35, UNIPHIER_PIN_DRV_2BIT,
			     69, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(70, "MDIO1_INTL", UNIPHIER_PIN_IECTRL_EXIST,
			     36, UNIPHIER_PIN_DRV_2BIT,
			     70, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(71, "PHYRSTL1", UNIPHIER_PIN_IECTRL_EXIST,
			     37, UNIPHIER_PIN_DRV_2BIT,
			     71, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(72, "RGMII1_RXCLK", UNIPHIER_PIN_IECTRL_EXIST,
			     38, UNIPHIER_PIN_DRV_2BIT,
			     72, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(73, "RGMII1_RXD0", UNIPHIER_PIN_IECTRL_EXIST,
			     39, UNIPHIER_PIN_DRV_2BIT,
			     73, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(74, "RGMII1_RXD1", UNIPHIER_PIN_IECTRL_EXIST,
			     40, UNIPHIER_PIN_DRV_2BIT,
			     74, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(75, "RGMII1_RXD2", UNIPHIER_PIN_IECTRL_EXIST,
			     41, UNIPHIER_PIN_DRV_2BIT,
			     75, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(76, "RGMII1_RXD3", UNIPHIER_PIN_IECTRL_EXIST,
			     42, UNIPHIER_PIN_DRV_2BIT,
			     76, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(77, "RGMII1_RXCTL", UNIPHIER_PIN_IECTRL_EXIST,
			     43, UNIPHIER_PIN_DRV_2BIT,
			     77, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(78, "RGMII1_TXCLK", UNIPHIER_PIN_IECTRL_EXIST,
			     44, UNIPHIER_PIN_DRV_2BIT,
			     78, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(79, "RGMII1_TXD0", UNIPHIER_PIN_IECTRL_EXIST,
			     45, UNIPHIER_PIN_DRV_2BIT,
			     79, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(80, "RGMII1_TXD1", UNIPHIER_PIN_IECTRL_EXIST,
			     46, UNIPHIER_PIN_DRV_2BIT,
			     80, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(81, "RGMII1_TXD2", UNIPHIER_PIN_IECTRL_EXIST,
			     47, UNIPHIER_PIN_DRV_2BIT,
			     81, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(82, "RGMII1_TXD3", UNIPHIER_PIN_IECTRL_EXIST,
			     48, UNIPHIER_PIN_DRV_2BIT,
			     82, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(83, "RGMII1_TXCTL", UNIPHIER_PIN_IECTRL_EXIST,
			     49, UNIPHIER_PIN_DRV_2BIT,
			     83, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(84, "USB0VBUS", UNIPHIER_PIN_IECTRL_EXIST,
			     34, UNIPHIER_PIN_DRV_3BIT,
			     84, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(85, "USB0OD", UNIPHIER_PIN_IECTRL_EXIST,
			     35, UNIPHIER_PIN_DRV_3BIT,
			     85, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(86, "USB1VBUS", UNIPHIER_PIN_IECTRL_EXIST,
			     36, UNIPHIER_PIN_DRV_3BIT,
			     86, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(87, "USB1OD", UNIPHIER_PIN_IECTRL_EXIST,
			     37, UNIPHIER_PIN_DRV_3BIT,
			     87, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(88, "USB2VBUS", UNIPHIER_PIN_IECTRL_EXIST,
			     38, UNIPHIER_PIN_DRV_3BIT,
			     88, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(89, "USB2OD", UNIPHIER_PIN_IECTRL_EXIST,
			     39, UNIPHIER_PIN_DRV_3BIT,
			     89, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(90, "USB3VBUS", UNIPHIER_PIN_IECTRL_EXIST,
			     40, UNIPHIER_PIN_DRV_3BIT,
			     90, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(91, "USB3OD", UNIPHIER_PIN_IECTRL_EXIST,
			     41, UNIPHIER_PIN_DRV_3BIT,
			     91, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(92, "TXD0", UNIPHIER_PIN_IECTRL_EXIST,
			     42, UNIPHIER_PIN_DRV_3BIT,
			     92, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(93, "RXD0", UNIPHIER_PIN_IECTRL_EXIST,
			     43, UNIPHIER_PIN_DRV_3BIT,
			     93, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(94, "TXD1", UNIPHIER_PIN_IECTRL_EXIST,
			     44, UNIPHIER_PIN_DRV_3BIT,
			     94, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(95, "RXD1", UNIPHIER_PIN_IECTRL_EXIST,
			     45, UNIPHIER_PIN_DRV_3BIT,
			     95, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(96, "TXD2", UNIPHIER_PIN_IECTRL_EXIST,
			     46, UNIPHIER_PIN_DRV_3BIT,
			     96, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(97, "RXD2", UNIPHIER_PIN_IECTRL_EXIST,
			     47, UNIPHIER_PIN_DRV_3BIT,
			     97, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(98, "TXD3", UNIPHIER_PIN_IECTRL_EXIST,
			     48, UNIPHIER_PIN_DRV_3BIT,
			     98, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(99, "RXD3", UNIPHIER_PIN_IECTRL_EXIST,
			     49, UNIPHIER_PIN_DRV_3BIT,
			     99, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(100, "SPISYNC0", UNIPHIER_PIN_IECTRL_EXIST,
			     50, UNIPHIER_PIN_DRV_3BIT,
			     100, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(101, "SPISCLK0", UNIPHIER_PIN_IECTRL_EXIST,
			     51, UNIPHIER_PIN_DRV_3BIT,
			     101, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(102, "SPITXD0", UNIPHIER_PIN_IECTRL_EXIST,
			     52, UNIPHIER_PIN_DRV_3BIT,
			     102, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(103, "SPIRXD0", UNIPHIER_PIN_IECTRL_EXIST,
			     53, UNIPHIER_PIN_DRV_3BIT,
			     103, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(104, "SDA0", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(105, "SCL0", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(106, "SDA1", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(107, "SCL1", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(108, "SDA2", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(109, "SCL2", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(110, "SDA3", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(111, "SCL3", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(112, "SMTRST0", UNIPHIER_PIN_IECTRL_EXIST,
			     54, UNIPHIER_PIN_DRV_3BIT,
			     112, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(113, "SMTCMD0", UNIPHIER_PIN_IECTRL_EXIST,
			     55, UNIPHIER_PIN_DRV_3BIT,
			     113, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(114, "SMTD0", UNIPHIER_PIN_IECTRL_EXIST,
			     56, UNIPHIER_PIN_DRV_3BIT,
			     114, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(115, "SMTSEL0", UNIPHIER_PIN_IECTRL_EXIST,
			     57, UNIPHIER_PIN_DRV_3BIT,
			     115, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(116, "SMTCLK0CG", UNIPHIER_PIN_IECTRL_EXIST,
			     58, UNIPHIER_PIN_DRV_3BIT,
			     116, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(117, "SMTDET0", UNIPHIER_PIN_IECTRL_EXIST,
			     59, UNIPHIER_PIN_DRV_3BIT,
			     117, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(118, "SMTRST1", UNIPHIER_PIN_IECTRL_EXIST,
			     60, UNIPHIER_PIN_DRV_3BIT,
			     118, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(119, "SMTCMD1", UNIPHIER_PIN_IECTRL_EXIST,
			     61, UNIPHIER_PIN_DRV_3BIT,
			     119, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(120, "SMTD1", UNIPHIER_PIN_IECTRL_EXIST,
			     62, UNIPHIER_PIN_DRV_3BIT,
			     120, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(121, "SMTSEL1", UNIPHIER_PIN_IECTRL_EXIST,
			     63, UNIPHIER_PIN_DRV_3BIT,
			     121, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(122, "SMTCLK1CG", UNIPHIER_PIN_IECTRL_EXIST,
			     64, UNIPHIER_PIN_DRV_3BIT,
			     122, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(123, "SMTDET1", UNIPHIER_PIN_IECTRL_EXIST,
			     65, UNIPHIER_PIN_DRV_3BIT,
			     123, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(124, "SMTRST2", UNIPHIER_PIN_IECTRL_EXIST,
			     66, UNIPHIER_PIN_DRV_3BIT,
			     124, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(125, "SMTCMD2", UNIPHIER_PIN_IECTRL_EXIST,
			     67, UNIPHIER_PIN_DRV_3BIT,
			     125, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(126, "SMTD2", UNIPHIER_PIN_IECTRL_EXIST,
			     68, UNIPHIER_PIN_DRV_3BIT,
			     126, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(127, "SMTSEL2", UNIPHIER_PIN_IECTRL_EXIST,
			     69, UNIPHIER_PIN_DRV_3BIT,
			     127, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(128, "SMTCLK2CG", UNIPHIER_PIN_IECTRL_EXIST,
			     70, UNIPHIER_PIN_DRV_3BIT,
			     128, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(129, "SMTDET2", UNIPHIER_PIN_IECTRL_EXIST,
			     71, UNIPHIER_PIN_DRV_3BIT,
			     129, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(130, "CH0CLK", UNIPHIER_PIN_IECTRL_EXIST,
			     72, UNIPHIER_PIN_DRV_3BIT,
			     130, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(131, "CH0PSYNC", UNIPHIER_PIN_IECTRL_EXIST,
			     73, UNIPHIER_PIN_DRV_3BIT,
			     131, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(132, "CH0VAL", UNIPHIER_PIN_IECTRL_EXIST,
			     74, UNIPHIER_PIN_DRV_3BIT,
			     132, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(133, "CH0DATA", UNIPHIER_PIN_IECTRL_EXIST,
			     75, UNIPHIER_PIN_DRV_3BIT,
			     133, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(134, "CH1CLK", UNIPHIER_PIN_IECTRL_EXIST,
			     76, UNIPHIER_PIN_DRV_3BIT,
			     134, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(135, "CH1PSYNC", UNIPHIER_PIN_IECTRL_EXIST,
			     77, UNIPHIER_PIN_DRV_3BIT,
			     135, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(136, "CH1VAL", UNIPHIER_PIN_IECTRL_EXIST,
			     78, UNIPHIER_PIN_DRV_3BIT,
			     136, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(137, "CH1DATA", UNIPHIER_PIN_IECTRL_EXIST,
			     79, UNIPHIER_PIN_DRV_3BIT,
			     137, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(138, "CH2CLK", UNIPHIER_PIN_IECTRL_EXIST,
			     80, UNIPHIER_PIN_DRV_3BIT,
			     138, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(139, "CH2PSYNC", UNIPHIER_PIN_IECTRL_EXIST,
			     81, UNIPHIER_PIN_DRV_3BIT,
			     139, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(140, "CH2VAL", UNIPHIER_PIN_IECTRL_EXIST,
			     82, UNIPHIER_PIN_DRV_3BIT,
			     140, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(141, "CH2DATA", UNIPHIER_PIN_IECTRL_EXIST,
			     83, UNIPHIER_PIN_DRV_3BIT,
			     141, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(142, "HS0BCLKIN", UNIPHIER_PIN_IECTRL_EXIST,
			     84, UNIPHIER_PIN_DRV_3BIT,
			     142, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(143, "HS0SYNCIN", UNIPHIER_PIN_IECTRL_EXIST,
			     85, UNIPHIER_PIN_DRV_3BIT,
			     143, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(144, "HS0VALIN", UNIPHIER_PIN_IECTRL_EXIST,
			     86, UNIPHIER_PIN_DRV_3BIT,
			     144, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(145, "HS0DIN0", UNIPHIER_PIN_IECTRL_EXIST,
			     87, UNIPHIER_PIN_DRV_3BIT,
			     145, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(146, "HS0DIN1", UNIPHIER_PIN_IECTRL_EXIST,
			     88, UNIPHIER_PIN_DRV_3BIT,
			     146, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(147, "HS0DIN2", UNIPHIER_PIN_IECTRL_EXIST,
			     89, UNIPHIER_PIN_DRV_3BIT,
			     147, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(148, "HS0DIN3", UNIPHIER_PIN_IECTRL_EXIST,
			     90, UNIPHIER_PIN_DRV_3BIT,
			     148, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(149, "HS0DIN4", UNIPHIER_PIN_IECTRL_EXIST,
			     91, UNIPHIER_PIN_DRV_3BIT,
			     149, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(150, "HS0DIN5", UNIPHIER_PIN_IECTRL_EXIST,
			     92, UNIPHIER_PIN_DRV_3BIT,
			     150, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(151, "HS0DIN6", UNIPHIER_PIN_IECTRL_EXIST,
			     93, UNIPHIER_PIN_DRV_3BIT,
			     151, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(152, "HS0DIN7", UNIPHIER_PIN_IECTRL_EXIST,
			     94, UNIPHIER_PIN_DRV_3BIT,
			     152, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(153, "HS1BCLKIN", UNIPHIER_PIN_IECTRL_EXIST,
			     95, UNIPHIER_PIN_DRV_3BIT,
			     153, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(154, "HS1SYNCIN", UNIPHIER_PIN_IECTRL_EXIST,
			     96, UNIPHIER_PIN_DRV_3BIT,
			     154, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(155, "HS1VALIN", UNIPHIER_PIN_IECTRL_EXIST,
			     97, UNIPHIER_PIN_DRV_3BIT,
			     155, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(156, "HS1DIN0", UNIPHIER_PIN_IECTRL_EXIST,
			     98, UNIPHIER_PIN_DRV_3BIT,
			     156, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(157, "HS1DIN1", UNIPHIER_PIN_IECTRL_EXIST,
			     99, UNIPHIER_PIN_DRV_3BIT,
			     157, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(158, "HS1DIN2", UNIPHIER_PIN_IECTRL_EXIST,
			     100, UNIPHIER_PIN_DRV_3BIT,
			     158, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(159, "HS1DIN3", UNIPHIER_PIN_IECTRL_EXIST,
			     101, UNIPHIER_PIN_DRV_3BIT,
			     159, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(160, "HS1DIN4", UNIPHIER_PIN_IECTRL_EXIST,
			     102, UNIPHIER_PIN_DRV_3BIT,
			     160, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(161, "HS1DIN5", UNIPHIER_PIN_IECTRL_EXIST,
			     103, UNIPHIER_PIN_DRV_3BIT,
			     161, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(162, "HS1DIN6", UNIPHIER_PIN_IECTRL_EXIST,
			     104, UNIPHIER_PIN_DRV_3BIT,
			     162, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(163, "HS1DIN7", UNIPHIER_PIN_IECTRL_EXIST,
			     105, UNIPHIER_PIN_DRV_3BIT,
			     163, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(164, "LINKCLK", UNIPHIER_PIN_IECTRL_EXIST,
			     106, UNIPHIER_PIN_DRV_3BIT,
			     164, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(165, "LINKREQ", UNIPHIER_PIN_IECTRL_EXIST,
			     107, UNIPHIER_PIN_DRV_3BIT,
			     165, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(166, "LINKCTL0", UNIPHIER_PIN_IECTRL_EXIST,
			     108, UNIPHIER_PIN_DRV_3BIT,
			     166, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(167, "LINKCTL1", UNIPHIER_PIN_IECTRL_EXIST,
			     109, UNIPHIER_PIN_DRV_3BIT,
			     167, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(168, "LINKDT0", UNIPHIER_PIN_IECTRL_EXIST,
			     110, UNIPHIER_PIN_DRV_3BIT,
			     168, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(169, "LINKDT1", UNIPHIER_PIN_IECTRL_EXIST,
			     111, UNIPHIER_PIN_DRV_3BIT,
			     169, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(170, "LINKDT2", UNIPHIER_PIN_IECTRL_EXIST,
			     112, UNIPHIER_PIN_DRV_3BIT,
			     170, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(171, "LINKDT3", UNIPHIER_PIN_IECTRL_EXIST,
			     113, UNIPHIER_PIN_DRV_3BIT,
			     171, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(172, "LINKDT4", UNIPHIER_PIN_IECTRL_EXIST,
			     114, UNIPHIER_PIN_DRV_3BIT,
			     172, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(173, "LINKDT5", UNIPHIER_PIN_IECTRL_EXIST,
			     115, UNIPHIER_PIN_DRV_3BIT,
			     173, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(174, "LINKDT6", UNIPHIER_PIN_IECTRL_EXIST,
			     116, UNIPHIER_PIN_DRV_3BIT,
			     174, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(175, "LINKDT7", UNIPHIER_PIN_IECTRL_EXIST,
			     117, UNIPHIER_PIN_DRV_3BIT,
			     175, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(176, "H0RXDDCSDA", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(177, "H0RXDDCSCL", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(178, "H0RXHPDO", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(179, "H0RX5VDETI", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(180, "H0TXDDCSDA", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(181, "H0TXDDCSCL", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(182, "H0TXHPDI", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(183, "H1TXDDCSDA", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(184, "H1TXDDCSCL", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(185, "H1TXHPDI", UNIPHIER_PIN_IECTRL_EXIST,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     -1, UNIPHIER_PIN_PULL_NONE),
	UNIPHIER_PINCTRL_PIN(186, "AI1ADCCK", UNIPHIER_PIN_IECTRL_EXIST,
			     118, UNIPHIER_PIN_DRV_3BIT,
			     186, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(187, "AI1BCK", UNIPHIER_PIN_IECTRL_EXIST,
			     119, UNIPHIER_PIN_DRV_3BIT,
			     187, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(188, "AI1LRCK", UNIPHIER_PIN_IECTRL_EXIST,
			     120, UNIPHIER_PIN_DRV_3BIT,
			     188, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(189, "AI1D0", UNIPHIER_PIN_IECTRL_EXIST,
			     121, UNIPHIER_PIN_DRV_3BIT,
			     189, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(190, "AO1IEC", UNIPHIER_PIN_IECTRL_EXIST,
			     122, UNIPHIER_PIN_DRV_3BIT,
			     190, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(191, "AO2IEC", UNIPHIER_PIN_IECTRL_EXIST,
			     123, UNIPHIER_PIN_DRV_3BIT,
			     191, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(192, "AO2DACCK", UNIPHIER_PIN_IECTRL_EXIST,
			     124, UNIPHIER_PIN_DRV_3BIT,
			     192, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(193, "AO2BCK", UNIPHIER_PIN_IECTRL_EXIST,
			     125, UNIPHIER_PIN_DRV_3BIT,
			     193, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(194, "AO2LRCK", UNIPHIER_PIN_IECTRL_EXIST,
			     126, UNIPHIER_PIN_DRV_3BIT,
			     194, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(195, "AO2D0", UNIPHIER_PIN_IECTRL_EXIST,
			     127, UNIPHIER_PIN_DRV_3BIT,
			     195, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(196, "AO2D1", UNIPHIER_PIN_IECTRL_EXIST,
			     128, UNIPHIER_PIN_DRV_3BIT,
			     196, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(197, "AO2D2", UNIPHIER_PIN_IECTRL_EXIST,
			     129, UNIPHIER_PIN_DRV_3BIT,
			     197, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(198, "AO2D3", UNIPHIER_PIN_IECTRL_EXIST,
			     130, UNIPHIER_PIN_DRV_3BIT,
			     198, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(199, "AO3DACCK", UNIPHIER_PIN_IECTRL_EXIST,
			     131, UNIPHIER_PIN_DRV_3BIT,
			     199, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(200, "AO3BCK", UNIPHIER_PIN_IECTRL_EXIST,
			     132, UNIPHIER_PIN_DRV_3BIT,
			     200, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(201, "AO3LRCK", UNIPHIER_PIN_IECTRL_EXIST,
			     133, UNIPHIER_PIN_DRV_3BIT,
			     201, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(202, "AO3D0", UNIPHIER_PIN_IECTRL_EXIST,
			     134, UNIPHIER_PIN_DRV_3BIT,
			     202, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(203, "VI1CLK", UNIPHIER_PIN_IECTRL_EXIST,
			     135, UNIPHIER_PIN_DRV_3BIT,
			     203, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(204, "VI1G2", UNIPHIER_PIN_IECTRL_EXIST,
			     136, UNIPHIER_PIN_DRV_3BIT,
			     204, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(205, "VI1G3", UNIPHIER_PIN_IECTRL_EXIST,
			     137, UNIPHIER_PIN_DRV_3BIT,
			     205, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(206, "VI1G4", UNIPHIER_PIN_IECTRL_EXIST,
			     138, UNIPHIER_PIN_DRV_3BIT,
			     206, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(207, "VI1G5", UNIPHIER_PIN_IECTRL_EXIST,
			     139, UNIPHIER_PIN_DRV_3BIT,
			     207, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(208, "VI1G6", UNIPHIER_PIN_IECTRL_EXIST,
			     140, UNIPHIER_PIN_DRV_3BIT,
			     208, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(209, "VI1G7", UNIPHIER_PIN_IECTRL_EXIST,
			     141, UNIPHIER_PIN_DRV_3BIT,
			     209, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(210, "VI1G8", UNIPHIER_PIN_IECTRL_EXIST,
			     142, UNIPHIER_PIN_DRV_3BIT,
			     210, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(211, "VI1G9", UNIPHIER_PIN_IECTRL_EXIST,
			     143, UNIPHIER_PIN_DRV_3BIT,
			     211, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(212, "FANPWM", UNIPHIER_PIN_IECTRL_EXIST,
			     144, UNIPHIER_PIN_DRV_3BIT,
			     212, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(213, "CK27EXO", UNIPHIER_PIN_IECTRL_EXIST,
			     145, UNIPHIER_PIN_DRV_3BIT,
			     213, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(214, "CK27AO", UNIPHIER_PIN_IECTRL_EXIST,
			     146, UNIPHIER_PIN_DRV_3BIT,
			     214, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(215, "CK27EXI", UNIPHIER_PIN_IECTRL_EXIST,
			     147, UNIPHIER_PIN_DRV_3BIT,
			     215, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(216, "VEXCKA", UNIPHIER_PIN_IECTRL_EXIST,
			     148, UNIPHIER_PIN_DRV_3BIT,
			     216, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(217, "AEXCKA", UNIPHIER_PIN_IECTRL_EXIST,
			     149, UNIPHIER_PIN_DRV_3BIT,
			     217, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(218, "ASEL", UNIPHIER_PIN_IECTRL_EXIST,
			     150, UNIPHIER_PIN_DRV_3BIT,
			     218, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(219, "XIRQ0", UNIPHIER_PIN_IECTRL_EXIST,
			     151, UNIPHIER_PIN_DRV_3BIT,
			     219, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(220, "XIRQ1", UNIPHIER_PIN_IECTRL_EXIST,
			     152, UNIPHIER_PIN_DRV_3BIT,
			     220, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(221, "XIRQ2", UNIPHIER_PIN_IECTRL_EXIST,
			     153, UNIPHIER_PIN_DRV_3BIT,
			     221, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(222, "XIRQ3", UNIPHIER_PIN_IECTRL_EXIST,
			     154, UNIPHIER_PIN_DRV_3BIT,
			     222, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(223, "XIRQ4", UNIPHIER_PIN_IECTRL_EXIST,
			     155, UNIPHIER_PIN_DRV_3BIT,
			     223, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(224, "XIRQ5", UNIPHIER_PIN_IECTRL_EXIST,
			     156, UNIPHIER_PIN_DRV_3BIT,
			     224, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(225, "XIRQ6", UNIPHIER_PIN_IECTRL_EXIST,
			     157, UNIPHIER_PIN_DRV_3BIT,
			     225, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(226, "XIRQ7", UNIPHIER_PIN_IECTRL_EXIST,
			     158, UNIPHIER_PIN_DRV_3BIT,
			     226, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(227, "XIRQ8", UNIPHIER_PIN_IECTRL_EXIST,
			     159, UNIPHIER_PIN_DRV_3BIT,
			     227, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(228, "XIRQ9", UNIPHIER_PIN_IECTRL_EXIST,
			     160, UNIPHIER_PIN_DRV_3BIT,
			     228, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(229, "XIRQ10", UNIPHIER_PIN_IECTRL_EXIST,
			     161, UNIPHIER_PIN_DRV_3BIT,
			     229, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(230, "XIRQ11", UNIPHIER_PIN_IECTRL_EXIST,
			     162, UNIPHIER_PIN_DRV_3BIT,
			     230, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(231, "XIRQ12", UNIPHIER_PIN_IECTRL_EXIST,
			     163, UNIPHIER_PIN_DRV_3BIT,
			     231, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(232, "XIRQ13", UNIPHIER_PIN_IECTRL_EXIST,
			     164, UNIPHIER_PIN_DRV_3BIT,
			     232, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(233, "XIRQ14", UNIPHIER_PIN_IECTRL_EXIST,
			     165, UNIPHIER_PIN_DRV_3BIT,
			     233, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(234, "XIRQ15", UNIPHIER_PIN_IECTRL_EXIST,
			     166, UNIPHIER_PIN_DRV_3BIT,
			     234, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(235, "PORT00", UNIPHIER_PIN_IECTRL_EXIST,
			     167, UNIPHIER_PIN_DRV_3BIT,
			     235, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(236, "PORT01", UNIPHIER_PIN_IECTRL_EXIST,
			     168, UNIPHIER_PIN_DRV_3BIT,
			     236, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(237, "PORT02", UNIPHIER_PIN_IECTRL_EXIST,
			     169, UNIPHIER_PIN_DRV_3BIT,
			     237, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(238, "PORT03", UNIPHIER_PIN_IECTRL_EXIST,
			     170, UNIPHIER_PIN_DRV_3BIT,
			     238, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(239, "PORT04", UNIPHIER_PIN_IECTRL_EXIST,
			     171, UNIPHIER_PIN_DRV_3BIT,
			     239, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(240, "PORT05", UNIPHIER_PIN_IECTRL_EXIST,
			     172, UNIPHIER_PIN_DRV_3BIT,
			     240, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(241, "PORT06", UNIPHIER_PIN_IECTRL_EXIST,
			     173, UNIPHIER_PIN_DRV_3BIT,
			     241, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(242, "PORT07", UNIPHIER_PIN_IECTRL_EXIST,
			     174, UNIPHIER_PIN_DRV_3BIT,
			     242, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(243, "PORT10", UNIPHIER_PIN_IECTRL_EXIST,
			     175, UNIPHIER_PIN_DRV_3BIT,
			     243, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(244, "PORT11", UNIPHIER_PIN_IECTRL_EXIST,
			     176, UNIPHIER_PIN_DRV_3BIT,
			     244, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(245, "PORT12", UNIPHIER_PIN_IECTRL_EXIST,
			     177, UNIPHIER_PIN_DRV_3BIT,
			     245, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(246, "PORT13", UNIPHIER_PIN_IECTRL_EXIST,
			     178, UNIPHIER_PIN_DRV_3BIT,
			     246, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(247, "PORT14", UNIPHIER_PIN_IECTRL_EXIST,
			     179, UNIPHIER_PIN_DRV_3BIT,
			     247, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(248, "PORT15", UNIPHIER_PIN_IECTRL_EXIST,
			     180, UNIPHIER_PIN_DRV_3BIT,
			     248, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(249, "PORT16", UNIPHIER_PIN_IECTRL_EXIST,
			     181, UNIPHIER_PIN_DRV_3BIT,
			     249, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(250, "PORT17", UNIPHIER_PIN_IECTRL_EXIST,
			     182, UNIPHIER_PIN_DRV_3BIT,
			     250, UNIPHIER_PIN_PULL_DOWN),
};

static const unsigned int emmc_pins[] = {31, 32, 33, 34, 35, 36, 37, 38};
static const int emmc_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned int emmc_dat8_pins[] = {39, 40, 41, 42};
static const int emmc_dat8_muxvals[] = {0, 0, 0, 0};
static const unsigned int ether_rgmii_pins[] = {52, 53, 54, 55, 56, 57, 58, 59,
						60, 61, 62, 63, 64, 65, 66, 67};
static const int ether_rgmii_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					  0, 0, 0};
static const unsigned int ether_rmii_pins[] = {52, 53, 54, 55, 56, 57, 58, 59,
					       61, 63, 64, 67};
static const int ether_rmii_muxvals[] = {0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1};
static const unsigned int ether1_rgmii_pins[] = {68, 69, 70, 71, 72, 73, 74,
						 75, 76, 77, 78, 79, 80, 81,
						 82, 83};
static const int ether1_rgmii_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0};
static const unsigned int ether1_rmii_pins[] = {68, 69, 70, 71, 72, 73, 74, 75,
						77, 79, 80, 83};
static const int ether1_rmii_muxvals[] = {0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1};
static const unsigned int i2c0_pins[] = {104, 105};
static const int i2c0_muxvals[] = {0, 0};
static const unsigned int i2c1_pins[] = {106, 107};
static const int i2c1_muxvals[] = {0, 0};
static const unsigned int i2c2_pins[] = {108, 109};
static const int i2c2_muxvals[] = {0, 0};
static const unsigned int i2c3_pins[] = {110, 111};
static const int i2c3_muxvals[] = {0, 0};
static const unsigned int nand_pins[] = {16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
					 26, 27, 28, 29, 30};
static const int nand_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned int sd_pins[] = {43, 44, 45, 46, 47, 48, 49, 50, 51};
static const int sd_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned int system_bus_pins[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
					       11, 12, 13, 14};
static const int system_bus_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					 0};
static const unsigned int system_bus_cs1_pins[] = {15};
static const int system_bus_cs1_muxvals[] = {0};
static const unsigned int uart0_pins[] = {92, 93};
static const int uart0_muxvals[] = {0, 0};
static const unsigned int uart1_pins[] = {94, 95};
static const int uart1_muxvals[] = {0, 0};
static const unsigned int uart2_pins[] = {96, 97};
static const int uart2_muxvals[] = {0, 0};
static const unsigned int uart3_pins[] = {98, 99};
static const int uart3_muxvals[] = {0, 0};
static const unsigned int usb0_pins[] = {84, 85};
static const int usb0_muxvals[] = {0, 0};
static const unsigned int usb1_pins[] = {86, 87};
static const int usb1_muxvals[] = {0, 0};
static const unsigned int usb2_pins[] = {88, 89};
static const int usb2_muxvals[] = {0, 0};
static const unsigned int usb3_pins[] = {90, 91};
static const int usb3_muxvals[] = {0, 0};
static const unsigned int gpio_range0_pins[] = {
	235, 236, 237, 238, 239, 240, 241, 242,		/* PORT0x */
	243, 244, 245, 246, 247, 248, 249, 250,		/* PORT1x */
	0, 1, 2, 3, 4, 5, 6, 7,				/* PORT2x */
	8, 9, 10, 11, 12, 13, 14, 15,			/* PORT3x */
	16, 17, 18, 19, 20, 21, 22, 23,			/* PORT4x */
	24, 25, 26, 27, 28, 29, 30, 31,			/* PORT5x */
	43, 44, 45, 46, 47, 48, 49, 50,			/* PORT6x */
	51, 52, 53, 54, 55, 56, 57, 58,			/* PORT7x */
	59, 60, 61, 62, 63, 64, 65, 66,			/* PORT8x */
	67, 68, 69, 70, 71, 72, 73, 74,			/* PORT9x */
	75, 76, 77, 78, 79, 80, 81, 82,			/* PORT10x */
};
static const unsigned int gpio_range1_pins[] = {
	83, 84, 85, 86, 87, 88, 89, 90,			/* PORT13x */
	91, 92, 93, 94, 95, 96, 97, 98,			/* PORT14x */
	219, 220, 221, 222, 223, 224, 225, 226,		/* XIRQ0-7 */
	227, 228, 229, 230, 231, 232, 233, 234,		/* XIRQ8-15 */
	215, 216, 217, 218, 164, 165, 166, 167,		/* XIRQ16-23 */
	104, 105, 106, 107, 108, 109, 110, 111,		/* PORT18x */
	176, 177, 178, 179, 180, 181, 182, 183,		/* PORT19x */
	184, 185,					/* PORT200-201 */
};
static const unsigned int gpio_range2_pins[] = {
	99, 100, 101, 102, 103, 112, 113, 114,		/* PORT21x */
	115, 116, 117, 118, 119, 120, 121, 122,		/* PORT22x */
	123, 124, 125, 126, 127, 128, 129, 130,		/* PORT23x */
	131, 132, 133, 134, 135, 136, 137, 138,		/* PORT24x */
	139, 140, 141, 142, 143, 144, 145, 146,		/* PORT25x */
	147, 148, 149, 150, 151, 152, 153, 154,		/* PORT26x */
	155, 156, 157, 158, 159, 160, 161, 162,		/* PORT27x */
	163, 164, 165, 166, 167, 168, 169, 170,		/* PORT28x */
	171, 172, 173, 174, 175, 186, 187, 188,		/* PORT29x */
	189, 190, 191, 192, 193, 194, 195, 196,		/* PORT30x */
	197, 198, 199, 200, 201, 202, 203, 204,		/* PORT31x */
	205, 206, 207, 208, 209, 210, 211, 212,		/* PORT32x */
	213, 214, 215, 216, 217, 218, 219, 220,		/* PORT33x */
	221, 222, 223, 224, 225, 226, 227, 228,		/* PORT34x */
	229, 230, 231, 232, 233, 234,			/* PORT350-355 */
};

static const struct uniphier_pinctrl_group uniphier_pxs3_groups[] = {
	UNIPHIER_PINCTRL_GROUP(emmc),
	UNIPHIER_PINCTRL_GROUP(emmc_dat8),
	UNIPHIER_PINCTRL_GROUP(ether_rgmii),
	UNIPHIER_PINCTRL_GROUP(ether_rmii),
	UNIPHIER_PINCTRL_GROUP(ether1_rgmii),
	UNIPHIER_PINCTRL_GROUP(ether1_rmii),
	UNIPHIER_PINCTRL_GROUP(i2c0),
	UNIPHIER_PINCTRL_GROUP(i2c1),
	UNIPHIER_PINCTRL_GROUP(i2c2),
	UNIPHIER_PINCTRL_GROUP(i2c3),
	UNIPHIER_PINCTRL_GROUP(nand),
	UNIPHIER_PINCTRL_GROUP(sd),
	UNIPHIER_PINCTRL_GROUP(system_bus),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs1),
	UNIPHIER_PINCTRL_GROUP(uart0),
	UNIPHIER_PINCTRL_GROUP(uart1),
	UNIPHIER_PINCTRL_GROUP(uart2),
	UNIPHIER_PINCTRL_GROUP(uart3),
	UNIPHIER_PINCTRL_GROUP(usb0),
	UNIPHIER_PINCTRL_GROUP(usb1),
	UNIPHIER_PINCTRL_GROUP(usb2),
	UNIPHIER_PINCTRL_GROUP(usb3),
	UNIPHIER_PINCTRL_GROUP_GPIO(gpio_range0),
	UNIPHIER_PINCTRL_GROUP_GPIO(gpio_range1),
	UNIPHIER_PINCTRL_GROUP_GPIO(gpio_range2),
};

static const char * const emmc_groups[] = {"emmc", "emmc_dat8"};
static const char * const ether_rgmii_groups[] = {"ether_rgmii"};
static const char * const ether_rmii_groups[] = {"ether_rmii"};
static const char * const ether1_rgmii_groups[] = {"ether1_rgmii"};
static const char * const ether1_rmii_groups[] = {"ether1_rmii"};
static const char * const i2c0_groups[] = {"i2c0"};
static const char * const i2c1_groups[] = {"i2c1"};
static const char * const i2c2_groups[] = {"i2c2"};
static const char * const i2c3_groups[] = {"i2c3"};
static const char * const nand_groups[] = {"nand"};
static const char * const sd_groups[] = {"sd"};
static const char * const system_bus_groups[] = {"system_bus",
						 "system_bus_cs1"};
static const char * const uart0_groups[] = {"uart0"};
static const char * const uart1_groups[] = {"uart1"};
static const char * const uart2_groups[] = {"uart2"};
static const char * const uart3_groups[] = {"uart3"};
static const char * const usb0_groups[] = {"usb0"};
static const char * const usb1_groups[] = {"usb1"};
static const char * const usb2_groups[] = {"usb2"};
static const char * const usb3_groups[] = {"usb3"};

static const struct uniphier_pinmux_function uniphier_pxs3_functions[] = {
	UNIPHIER_PINMUX_FUNCTION(emmc),
	UNIPHIER_PINMUX_FUNCTION(ether_rgmii),
	UNIPHIER_PINMUX_FUNCTION(ether_rmii),
	UNIPHIER_PINMUX_FUNCTION(ether1_rgmii),
	UNIPHIER_PINMUX_FUNCTION(ether1_rmii),
	UNIPHIER_PINMUX_FUNCTION(i2c0),
	UNIPHIER_PINMUX_FUNCTION(i2c1),
	UNIPHIER_PINMUX_FUNCTION(i2c2),
	UNIPHIER_PINMUX_FUNCTION(i2c3),
	UNIPHIER_PINMUX_FUNCTION(nand),
	UNIPHIER_PINMUX_FUNCTION(sd),
	UNIPHIER_PINMUX_FUNCTION(system_bus),
	UNIPHIER_PINMUX_FUNCTION(uart0),
	UNIPHIER_PINMUX_FUNCTION(uart1),
	UNIPHIER_PINMUX_FUNCTION(uart2),
	UNIPHIER_PINMUX_FUNCTION(uart3),
	UNIPHIER_PINMUX_FUNCTION(usb0),
	UNIPHIER_PINMUX_FUNCTION(usb1),
	UNIPHIER_PINMUX_FUNCTION(usb2),
	UNIPHIER_PINMUX_FUNCTION(usb3),
};

static int uniphier_pxs3_get_gpio_muxval(unsigned int pin,
					 unsigned int gpio_offset)
{
	if (gpio_offset >= 120 && gpio_offset <= 143) {	/* XIRQx */
		if (pin >= 219 && pin <= 234)
			return 0;

		return 14;
	}

	return 15;
}

static struct uniphier_pinctrl_socdata uniphier_pxs3_pindata = {
	.pins = uniphier_pxs3_pins,
	.npins = ARRAY_SIZE(uniphier_pxs3_pins),
	.groups = uniphier_pxs3_groups,
	.groups_count = ARRAY_SIZE(uniphier_pxs3_groups),
	.functions = uniphier_pxs3_functions,
	.functions_count = ARRAY_SIZE(uniphier_pxs3_functions),
	.get_gpio_muxval = uniphier_pxs3_get_gpio_muxval,
	.caps = UNIPHIER_PINCTRL_CAPS_PERPIN_IECTRL,
};

static int uniphier_pxs3_pinctrl_probe(struct platform_device *pdev)
{
	return uniphier_pinctrl_probe(pdev, &uniphier_pxs3_pindata);
}

static const struct of_device_id uniphier_pxs3_pinctrl_match[] = {
	{ .compatible = "socionext,uniphier-pxs3-pinctrl" },
	{ /* sentinel */ }
};

static struct platform_driver uniphier_pxs3_pinctrl_driver = {
	.probe = uniphier_pxs3_pinctrl_probe,
	.driver = {
		.name = "uniphier-pxs3-pinctrl",
		.of_match_table = uniphier_pxs3_pinctrl_match,
		.pm = &uniphier_pinctrl_pm_ops,
	},
};
builtin_platform_driver(uniphier_pxs3_pinctrl_driver);
