/*
 * Autogenerated file by GPU Top : https://github.com/rib/gputop
 * DO NOT EDIT manually!
 *
 *
 * Copyright (c) 2015 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 */

#include <linux/sysfs.h>

#include "i915_drv.h"
#include "i915_oa_bdw.h"

enum metric_set_id {
	METRIC_SET_ID_RENDER_BASIC = 1,
	METRIC_SET_ID_COMPUTE_BASIC,
	METRIC_SET_ID_RENDER_PIPE_PROFILE,
	METRIC_SET_ID_MEMORY_READS,
	METRIC_SET_ID_MEMORY_WRITES,
	METRIC_SET_ID_COMPUTE_EXTENDED,
	METRIC_SET_ID_COMPUTE_L3_CACHE,
	METRIC_SET_ID_DATA_PORT_READS_COALESCING,
	METRIC_SET_ID_DATA_PORT_WRITES_COALESCING,
	METRIC_SET_ID_HDC_AND_SF,
	METRIC_SET_ID_L3_1,
	METRIC_SET_ID_L3_2,
	METRIC_SET_ID_L3_3,
	METRIC_SET_ID_L3_4,
	METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND,
	METRIC_SET_ID_SAMPLER_1,
	METRIC_SET_ID_SAMPLER_2,
	METRIC_SET_ID_TDL_1,
	METRIC_SET_ID_TDL_2,
	METRIC_SET_ID_COMPUTE_EXTRA,
	METRIC_SET_ID_VME_PIPE,
	METRIC_SET_ID_TEST_OA,
};

int i915_oa_n_builtin_metric_sets_bdw = 22;

static const struct i915_oa_reg b_counter_config_render_basic[] = {
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2740), 0x00000000 },
};

static const struct i915_oa_reg flex_eu_config_render_basic[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_render_basic_0_slices_0x01[] = {
	{ _MMIO(0x9888), 0x143f000f },
	{ _MMIO(0x9888), 0x14110014 },
	{ _MMIO(0x9888), 0x14310014 },
	{ _MMIO(0x9888), 0x14bf000f },
	{ _MMIO(0x9888), 0x118a0317 },
	{ _MMIO(0x9888), 0x13837be0 },
	{ _MMIO(0x9888), 0x3b800060 },
	{ _MMIO(0x9888), 0x3d800005 },
	{ _MMIO(0x9888), 0x005c4000 },
	{ _MMIO(0x9888), 0x065c8000 },
	{ _MMIO(0x9888), 0x085cc000 },
	{ _MMIO(0x9888), 0x003d8000 },
	{ _MMIO(0x9888), 0x183d0800 },
	{ _MMIO(0x9888), 0x0a3f0023 },
	{ _MMIO(0x9888), 0x103f0000 },
	{ _MMIO(0x9888), 0x00584000 },
	{ _MMIO(0x9888), 0x08584000 },
	{ _MMIO(0x9888), 0x0a5a4000 },
	{ _MMIO(0x9888), 0x005b4000 },
	{ _MMIO(0x9888), 0x0e5b8000 },
	{ _MMIO(0x9888), 0x185b2400 },
	{ _MMIO(0x9888), 0x0a1d4000 },
	{ _MMIO(0x9888), 0x0c1f0800 },
	{ _MMIO(0x9888), 0x0e1faa00 },
	{ _MMIO(0x9888), 0x00384000 },
	{ _MMIO(0x9888), 0x0e384000 },
	{ _MMIO(0x9888), 0x16384000 },
	{ _MMIO(0x9888), 0x18380001 },
	{ _MMIO(0x9888), 0x00392000 },
	{ _MMIO(0x9888), 0x06398000 },
	{ _MMIO(0x9888), 0x0839a000 },
	{ _MMIO(0x9888), 0x0a391000 },
	{ _MMIO(0x9888), 0x00104000 },
	{ _MMIO(0x9888), 0x08104000 },
	{ _MMIO(0x9888), 0x00110030 },
	{ _MMIO(0x9888), 0x08110031 },
	{ _MMIO(0x9888), 0x10110000 },
	{ _MMIO(0x9888), 0x00134000 },
	{ _MMIO(0x9888), 0x16130020 },
	{ _MMIO(0x9888), 0x06308000 },
	{ _MMIO(0x9888), 0x08308000 },
	{ _MMIO(0x9888), 0x06311800 },
	{ _MMIO(0x9888), 0x08311880 },
	{ _MMIO(0x9888), 0x10310000 },
	{ _MMIO(0x9888), 0x0e334000 },
	{ _MMIO(0x9888), 0x16330080 },
	{ _MMIO(0x9888), 0x0abf1180 },
	{ _MMIO(0x9888), 0x10bf0000 },
	{ _MMIO(0x9888), 0x0ada8000 },
	{ _MMIO(0x9888), 0x0a9d8000 },
	{ _MMIO(0x9888), 0x109f0002 },
	{ _MMIO(0x9888), 0x0ab94000 },
	{ _MMIO(0x9888), 0x0d888000 },
	{ _MMIO(0x9888), 0x038a0380 },
	{ _MMIO(0x9888), 0x058a000e },
	{ _MMIO(0x9888), 0x018a8000 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x198a8000 },
	{ _MMIO(0x9888), 0x1b8a00a0 },
	{ _MMIO(0x9888), 0x078a0000 },
	{ _MMIO(0x9888), 0x098a0000 },
	{ _MMIO(0x9888), 0x238b2820 },
	{ _MMIO(0x9888), 0x258b2550 },
	{ _MMIO(0x9888), 0x198c1000 },
	{ _MMIO(0x9888), 0x0b8d8000 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaa0 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x0d831021 },
	{ _MMIO(0x9888), 0x0f83572f },
	{ _MMIO(0x9888), 0x01835680 },
	{ _MMIO(0x9888), 0x0383002c },
	{ _MMIO(0x9888), 0x11830000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830001 },
	{ _MMIO(0x9888), 0x05830000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x05844000 },
	{ _MMIO(0x9888), 0x1b80c137 },
	{ _MMIO(0x9888), 0x1d80c147 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x17808000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x15804000 },
	{ _MMIO(0x9888), 0x4d801110 },
	{ _MMIO(0x9888), 0x4f800331 },
	{ _MMIO(0x9888), 0x43800802 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45801465 },
	{ _MMIO(0x9888), 0x53801111 },
	{ _MMIO(0x9888), 0x478014a5 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800ca5 },
	{ _MMIO(0x9888), 0x41800003 },
};

static const struct i915_oa_reg mux_config_render_basic_1_slices_0x02[] = {
	{ _MMIO(0x9888), 0x143f000f },
	{ _MMIO(0x9888), 0x14bf000f },
	{ _MMIO(0x9888), 0x14910014 },
	{ _MMIO(0x9888), 0x14b10014 },
	{ _MMIO(0x9888), 0x118a0317 },
	{ _MMIO(0x9888), 0x13837be0 },
	{ _MMIO(0x9888), 0x3b800060 },
	{ _MMIO(0x9888), 0x3d800005 },
	{ _MMIO(0x9888), 0x0a3f0023 },
	{ _MMIO(0x9888), 0x103f0000 },
	{ _MMIO(0x9888), 0x0a5a4000 },
	{ _MMIO(0x9888), 0x0a1d4000 },
	{ _MMIO(0x9888), 0x0e1f8000 },
	{ _MMIO(0x9888), 0x0a391000 },
	{ _MMIO(0x9888), 0x00dc4000 },
	{ _MMIO(0x9888), 0x06dc8000 },
	{ _MMIO(0x9888), 0x08dcc000 },
	{ _MMIO(0x9888), 0x00bd8000 },
	{ _MMIO(0x9888), 0x18bd0800 },
	{ _MMIO(0x9888), 0x0abf1180 },
	{ _MMIO(0x9888), 0x10bf0000 },
	{ _MMIO(0x9888), 0x00d84000 },
	{ _MMIO(0x9888), 0x08d84000 },
	{ _MMIO(0x9888), 0x0ada8000 },
	{ _MMIO(0x9888), 0x00db4000 },
	{ _MMIO(0x9888), 0x0edb8000 },
	{ _MMIO(0x9888), 0x18db2400 },
	{ _MMIO(0x9888), 0x0a9d8000 },
	{ _MMIO(0x9888), 0x0c9f0800 },
	{ _MMIO(0x9888), 0x0e9f2a00 },
	{ _MMIO(0x9888), 0x109f0002 },
	{ _MMIO(0x9888), 0x00b84000 },
	{ _MMIO(0x9888), 0x0eb84000 },
	{ _MMIO(0x9888), 0x16b84000 },
	{ _MMIO(0x9888), 0x18b80001 },
	{ _MMIO(0x9888), 0x00b92000 },
	{ _MMIO(0x9888), 0x06b98000 },
	{ _MMIO(0x9888), 0x08b9a000 },
	{ _MMIO(0x9888), 0x0ab94000 },
	{ _MMIO(0x9888), 0x00904000 },
	{ _MMIO(0x9888), 0x08904000 },
	{ _MMIO(0x9888), 0x00910030 },
	{ _MMIO(0x9888), 0x08910031 },
	{ _MMIO(0x9888), 0x10910000 },
	{ _MMIO(0x9888), 0x00934000 },
	{ _MMIO(0x9888), 0x16930020 },
	{ _MMIO(0x9888), 0x06b08000 },
	{ _MMIO(0x9888), 0x08b08000 },
	{ _MMIO(0x9888), 0x06b11800 },
	{ _MMIO(0x9888), 0x08b11880 },
	{ _MMIO(0x9888), 0x10b10000 },
	{ _MMIO(0x9888), 0x0eb34000 },
	{ _MMIO(0x9888), 0x16b30080 },
	{ _MMIO(0x9888), 0x01888000 },
	{ _MMIO(0x9888), 0x0d88b800 },
	{ _MMIO(0x9888), 0x038a0380 },
	{ _MMIO(0x9888), 0x058a000e },
	{ _MMIO(0x9888), 0x1b8a0080 },
	{ _MMIO(0x9888), 0x078a0000 },
	{ _MMIO(0x9888), 0x098a0000 },
	{ _MMIO(0x9888), 0x238b2840 },
	{ _MMIO(0x9888), 0x258b26a0 },
	{ _MMIO(0x9888), 0x018c4000 },
	{ _MMIO(0x9888), 0x0f8c4000 },
	{ _MMIO(0x9888), 0x178c2000 },
	{ _MMIO(0x9888), 0x198c1100 },
	{ _MMIO(0x9888), 0x018d2000 },
	{ _MMIO(0x9888), 0x078d8000 },
	{ _MMIO(0x9888), 0x098da000 },
	{ _MMIO(0x9888), 0x0b8d8000 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaa0 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x0d831021 },
	{ _MMIO(0x9888), 0x0f83572f },
	{ _MMIO(0x9888), 0x01835680 },
	{ _MMIO(0x9888), 0x0383002c },
	{ _MMIO(0x9888), 0x11830000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830001 },
	{ _MMIO(0x9888), 0x05830000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x05844000 },
	{ _MMIO(0x9888), 0x1b80c137 },
	{ _MMIO(0x9888), 0x1d80c147 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x17808000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x15804000 },
	{ _MMIO(0x9888), 0x4d801550 },
	{ _MMIO(0x9888), 0x4f800331 },
	{ _MMIO(0x9888), 0x43800802 },
	{ _MMIO(0x9888), 0x51800400 },
	{ _MMIO(0x9888), 0x458004a1 },
	{ _MMIO(0x9888), 0x53805555 },
	{ _MMIO(0x9888), 0x47800421 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f801421 },
	{ _MMIO(0x9888), 0x41800845 },
};

static int
get_render_basic_mux_config(struct drm_i915_private *dev_priv,
			    const struct i915_oa_reg **regs,
			    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 2);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 2);

	if (INTEL_INFO(dev_priv)->sseu.slice_mask & 0x01) {
		regs[n] = mux_config_render_basic_0_slices_0x01;
		lens[n] = ARRAY_SIZE(mux_config_render_basic_0_slices_0x01);
		n++;
	}
	if (INTEL_INFO(dev_priv)->sseu.slice_mask & 0x02) {
		regs[n] = mux_config_render_basic_1_slices_0x02;
		lens[n] = ARRAY_SIZE(mux_config_render_basic_1_slices_0x02);
		n++;
	}

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_basic[] = {
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2740), 0x00000000 },
};

static const struct i915_oa_reg flex_eu_config_compute_basic[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00778008 },
	{ _MMIO(0xe45c), 0x00088078 },
	{ _MMIO(0xe55c), 0x00808708 },
	{ _MMIO(0xe65c), 0x00a08908 },
};

static const struct i915_oa_reg mux_config_compute_basic_0_slices_0x01[] = {
	{ _MMIO(0x9888), 0x105c00e0 },
	{ _MMIO(0x9888), 0x105800e0 },
	{ _MMIO(0x9888), 0x103800e0 },
	{ _MMIO(0x9888), 0x3580001a },
	{ _MMIO(0x9888), 0x3b800060 },
	{ _MMIO(0x9888), 0x3d800005 },
	{ _MMIO(0x9888), 0x065c2100 },
	{ _MMIO(0x9888), 0x0a5c0041 },
	{ _MMIO(0x9888), 0x0c5c6600 },
	{ _MMIO(0x9888), 0x005c6580 },
	{ _MMIO(0x9888), 0x085c8000 },
	{ _MMIO(0x9888), 0x0e5c8000 },
	{ _MMIO(0x9888), 0x00580042 },
	{ _MMIO(0x9888), 0x08582080 },
	{ _MMIO(0x9888), 0x0c58004c },
	{ _MMIO(0x9888), 0x0e582580 },
	{ _MMIO(0x9888), 0x005b4000 },
	{ _MMIO(0x9888), 0x185b1000 },
	{ _MMIO(0x9888), 0x1a5b0104 },
	{ _MMIO(0x9888), 0x0c1fa800 },
	{ _MMIO(0x9888), 0x0e1faa00 },
	{ _MMIO(0x9888), 0x101f02aa },
	{ _MMIO(0x9888), 0x08380042 },
	{ _MMIO(0x9888), 0x0a382080 },
	{ _MMIO(0x9888), 0x0e38404c },
	{ _MMIO(0x9888), 0x0238404b },
	{ _MMIO(0x9888), 0x00384000 },
	{ _MMIO(0x9888), 0x16380000 },
	{ _MMIO(0x9888), 0x18381145 },
	{ _MMIO(0x9888), 0x04380000 },
	{ _MMIO(0x9888), 0x0039a000 },
	{ _MMIO(0x9888), 0x06398000 },
	{ _MMIO(0x9888), 0x0839a000 },
	{ _MMIO(0x9888), 0x0a39a000 },
	{ _MMIO(0x9888), 0x0c39a000 },
	{ _MMIO(0x9888), 0x0e39a000 },
	{ _MMIO(0x9888), 0x02392000 },
	{ _MMIO(0x9888), 0x018a8000 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x198a8000 },
	{ _MMIO(0x9888), 0x1b8aaaa0 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x238b02a0 },
	{ _MMIO(0x9888), 0x258b5550 },
	{ _MMIO(0x9888), 0x278b0015 },
	{ _MMIO(0x9888), 0x1f850a80 },
	{ _MMIO(0x9888), 0x2185aaa0 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x03844000 },
	{ _MMIO(0x9888), 0x17808137 },
	{ _MMIO(0x9888), 0x1980c147 },
	{ _MMIO(0x9888), 0x1b80c0e5 },
	{ _MMIO(0x9888), 0x1d80c0e3 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x13804000 },
	{ _MMIO(0x9888), 0x15800000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d801000 },
	{ _MMIO(0x9888), 0x4f800111 },
	{ _MMIO(0x9888), 0x43800062 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800062 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800062 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f801062 },
	{ _MMIO(0x9888), 0x41801084 },
};

static const struct i915_oa_reg mux_config_compute_basic_2_slices_0x02[] = {
	{ _MMIO(0x9888), 0x10dc00e0 },
	{ _MMIO(0x9888), 0x10d800e0 },
	{ _MMIO(0x9888), 0x10b800e0 },
	{ _MMIO(0x9888), 0x3580001a },
	{ _MMIO(0x9888), 0x3b800060 },
	{ _MMIO(0x9888), 0x3d800005 },
	{ _MMIO(0x9888), 0x06dc2100 },
	{ _MMIO(0x9888), 0x0adc0041 },
	{ _MMIO(0x9888), 0x0cdc6600 },
	{ _MMIO(0x9888), 0x00dc6580 },
	{ _MMIO(0x9888), 0x08dc8000 },
	{ _MMIO(0x9888), 0x0edc8000 },
	{ _MMIO(0x9888), 0x00d80042 },
	{ _MMIO(0x9888), 0x08d82080 },
	{ _MMIO(0x9888), 0x0cd8004c },
	{ _MMIO(0x9888), 0x0ed82580 },
	{ _MMIO(0x9888), 0x00db4000 },
	{ _MMIO(0x9888), 0x18db1000 },
	{ _MMIO(0x9888), 0x1adb0104 },
	{ _MMIO(0x9888), 0x0c9fa800 },
	{ _MMIO(0x9888), 0x0e9faa00 },
	{ _MMIO(0x9888), 0x109f02aa },
	{ _MMIO(0x9888), 0x08b80042 },
	{ _MMIO(0x9888), 0x0ab82080 },
	{ _MMIO(0x9888), 0x0eb8404c },
	{ _MMIO(0x9888), 0x02b8404b },
	{ _MMIO(0x9888), 0x00b84000 },
	{ _MMIO(0x9888), 0x16b80000 },
	{ _MMIO(0x9888), 0x18b81145 },
	{ _MMIO(0x9888), 0x04b80000 },
	{ _MMIO(0x9888), 0x00b9a000 },
	{ _MMIO(0x9888), 0x06b98000 },
	{ _MMIO(0x9888), 0x08b9a000 },
	{ _MMIO(0x9888), 0x0ab9a000 },
	{ _MMIO(0x9888), 0x0cb9a000 },
	{ _MMIO(0x9888), 0x0eb9a000 },
	{ _MMIO(0x9888), 0x02b92000 },
	{ _MMIO(0x9888), 0x01888000 },
	{ _MMIO(0x9888), 0x0d88f800 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x238b0540 },
	{ _MMIO(0x9888), 0x258baaa0 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x018c4000 },
	{ _MMIO(0x9888), 0x0f8c4000 },
	{ _MMIO(0x9888), 0x178c2000 },
	{ _MMIO(0x9888), 0x198c5500 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x018da000 },
	{ _MMIO(0x9888), 0x078d8000 },
	{ _MMIO(0x9888), 0x098da000 },
	{ _MMIO(0x9888), 0x0b8da000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x038d2000 },
	{ _MMIO(0x9888), 0x1f850a80 },
	{ _MMIO(0x9888), 0x2185aaa0 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x03844000 },
	{ _MMIO(0x9888), 0x17808137 },
	{ _MMIO(0x9888), 0x1980c147 },
	{ _MMIO(0x9888), 0x1b80c0e5 },
	{ _MMIO(0x9888), 0x1d80c0e3 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x13804000 },
	{ _MMIO(0x9888), 0x15800000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d805000 },
	{ _MMIO(0x9888), 0x4f800555 },
	{ _MMIO(0x9888), 0x43800062 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800062 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800062 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800062 },
	{ _MMIO(0x9888), 0x41800000 },
};

static int
get_compute_basic_mux_config(struct drm_i915_private *dev_priv,
			     const struct i915_oa_reg **regs,
			     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 2);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 2);

	if (INTEL_INFO(dev_priv)->sseu.slice_mask & 0x01) {
		regs[n] = mux_config_compute_basic_0_slices_0x01;
		lens[n] = ARRAY_SIZE(mux_config_compute_basic_0_slices_0x01);
		n++;
	}
	if (INTEL_INFO(dev_priv)->sseu.slice_mask & 0x02) {
		regs[n] = mux_config_compute_basic_2_slices_0x02;
		lens[n] = ARRAY_SIZE(mux_config_compute_basic_2_slices_0x02);
		n++;
	}

	return n;
}

static const struct i915_oa_reg b_counter_config_render_pipe_profile[] = {
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2770), 0x0007ffea },
	{ _MMIO(0x2774), 0x00007ffc },
	{ _MMIO(0x2778), 0x0007affa },
	{ _MMIO(0x277c), 0x0000f5fd },
	{ _MMIO(0x2780), 0x00079ffa },
	{ _MMIO(0x2784), 0x0000f3fb },
	{ _MMIO(0x2788), 0x0007bf7a },
	{ _MMIO(0x278c), 0x0000f7e7 },
	{ _MMIO(0x2790), 0x0007fefa },
	{ _MMIO(0x2794), 0x0000f7cf },
	{ _MMIO(0x2798), 0x00077ffa },
	{ _MMIO(0x279c), 0x0000efdf },
	{ _MMIO(0x27a0), 0x0006fffa },
	{ _MMIO(0x27a4), 0x0000cfbf },
	{ _MMIO(0x27a8), 0x0003fffa },
	{ _MMIO(0x27ac), 0x00005f7f },
};

static const struct i915_oa_reg flex_eu_config_render_pipe_profile[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00015014 },
	{ _MMIO(0xe658), 0x00025024 },
	{ _MMIO(0xe758), 0x00035034 },
	{ _MMIO(0xe45c), 0x00045044 },
	{ _MMIO(0xe55c), 0x00055054 },
	{ _MMIO(0xe65c), 0x00065064 },
};

static const struct i915_oa_reg mux_config_render_pipe_profile[] = {
	{ _MMIO(0x9888), 0x0a1e0000 },
	{ _MMIO(0x9888), 0x0c1f000f },
	{ _MMIO(0x9888), 0x10176800 },
	{ _MMIO(0x9888), 0x1191001f },
	{ _MMIO(0x9888), 0x0b880320 },
	{ _MMIO(0x9888), 0x01890c40 },
	{ _MMIO(0x9888), 0x118a1c00 },
	{ _MMIO(0x9888), 0x118d7c00 },
	{ _MMIO(0x9888), 0x118e0020 },
	{ _MMIO(0x9888), 0x118f4c00 },
	{ _MMIO(0x9888), 0x11900000 },
	{ _MMIO(0x9888), 0x13900001 },
	{ _MMIO(0x9888), 0x065c4000 },
	{ _MMIO(0x9888), 0x0c3d8000 },
	{ _MMIO(0x9888), 0x06584000 },
	{ _MMIO(0x9888), 0x0c5b4000 },
	{ _MMIO(0x9888), 0x081e0040 },
	{ _MMIO(0x9888), 0x0e1e0000 },
	{ _MMIO(0x9888), 0x021f5400 },
	{ _MMIO(0x9888), 0x001f0000 },
	{ _MMIO(0x9888), 0x101f0010 },
	{ _MMIO(0x9888), 0x0e1f0080 },
	{ _MMIO(0x9888), 0x0c384000 },
	{ _MMIO(0x9888), 0x06392000 },
	{ _MMIO(0x9888), 0x0c13c000 },
	{ _MMIO(0x9888), 0x06164000 },
	{ _MMIO(0x9888), 0x06170012 },
	{ _MMIO(0x9888), 0x00170000 },
	{ _MMIO(0x9888), 0x01910005 },
	{ _MMIO(0x9888), 0x07880002 },
	{ _MMIO(0x9888), 0x01880c00 },
	{ _MMIO(0x9888), 0x0f880000 },
	{ _MMIO(0x9888), 0x0d880000 },
	{ _MMIO(0x9888), 0x05880000 },
	{ _MMIO(0x9888), 0x09890032 },
	{ _MMIO(0x9888), 0x078a0800 },
	{ _MMIO(0x9888), 0x0f8a0a00 },
	{ _MMIO(0x9888), 0x198a4000 },
	{ _MMIO(0x9888), 0x1b8a2000 },
	{ _MMIO(0x9888), 0x1d8a0000 },
	{ _MMIO(0x9888), 0x038a4000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x238b54c0 },
	{ _MMIO(0x9888), 0x258baa55 },
	{ _MMIO(0x9888), 0x278b0019 },
	{ _MMIO(0x9888), 0x198c0100 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x0f8d0015 },
	{ _MMIO(0x9888), 0x018d1000 },
	{ _MMIO(0x9888), 0x098d8000 },
	{ _MMIO(0x9888), 0x0b8df000 },
	{ _MMIO(0x9888), 0x0d8d3000 },
	{ _MMIO(0x9888), 0x038de000 },
	{ _MMIO(0x9888), 0x058d3000 },
	{ _MMIO(0x9888), 0x0d8e0004 },
	{ _MMIO(0x9888), 0x058e000c },
	{ _MMIO(0x9888), 0x098e0000 },
	{ _MMIO(0x9888), 0x078e0000 },
	{ _MMIO(0x9888), 0x038e0000 },
	{ _MMIO(0x9888), 0x0b8f0020 },
	{ _MMIO(0x9888), 0x198f0c00 },
	{ _MMIO(0x9888), 0x078f8000 },
	{ _MMIO(0x9888), 0x098f4000 },
	{ _MMIO(0x9888), 0x0b900980 },
	{ _MMIO(0x9888), 0x03900d80 },
	{ _MMIO(0x9888), 0x01900000 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaaa },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x0784c000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x1780c000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d801111 },
	{ _MMIO(0x9888), 0x3d800800 },
	{ _MMIO(0x9888), 0x4f801011 },
	{ _MMIO(0x9888), 0x43800443 },
	{ _MMIO(0x9888), 0x51801111 },
	{ _MMIO(0x9888), 0x45800422 },
	{ _MMIO(0x9888), 0x53801111 },
	{ _MMIO(0x9888), 0x47800c60 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800422 },
	{ _MMIO(0x9888), 0x41800021 },
};

static int
get_render_pipe_profile_mux_config(struct drm_i915_private *dev_priv,
				   const struct i915_oa_reg **regs,
				   int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_render_pipe_profile;
	lens[n] = ARRAY_SIZE(mux_config_render_pipe_profile);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_memory_reads[] = {
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x274c), 0x86543210 },
	{ _MMIO(0x2748), 0x86543210 },
	{ _MMIO(0x2744), 0x00006667 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x275c), 0x86543210 },
	{ _MMIO(0x2758), 0x86543210 },
	{ _MMIO(0x2754), 0x00006465 },
	{ _MMIO(0x2750), 0x00000000 },
	{ _MMIO(0x2770), 0x0007f81a },
	{ _MMIO(0x2774), 0x0000fe00 },
	{ _MMIO(0x2778), 0x0007f82a },
	{ _MMIO(0x277c), 0x0000fe00 },
	{ _MMIO(0x2780), 0x0007f872 },
	{ _MMIO(0x2784), 0x0000fe00 },
	{ _MMIO(0x2788), 0x0007f8ba },
	{ _MMIO(0x278c), 0x0000fe00 },
	{ _MMIO(0x2790), 0x0007f87a },
	{ _MMIO(0x2794), 0x0000fe00 },
	{ _MMIO(0x2798), 0x0007f8ea },
	{ _MMIO(0x279c), 0x0000fe00 },
	{ _MMIO(0x27a0), 0x0007f8e2 },
	{ _MMIO(0x27a4), 0x0000fe00 },
	{ _MMIO(0x27a8), 0x0007f8f2 },
	{ _MMIO(0x27ac), 0x0000fe00 },
};

static const struct i915_oa_reg flex_eu_config_memory_reads[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00015014 },
	{ _MMIO(0xe658), 0x00025024 },
	{ _MMIO(0xe758), 0x00035034 },
	{ _MMIO(0xe45c), 0x00045044 },
	{ _MMIO(0xe55c), 0x00055054 },
	{ _MMIO(0xe65c), 0x00065064 },
};

static const struct i915_oa_reg mux_config_memory_reads[] = {
	{ _MMIO(0x9888), 0x198b0343 },
	{ _MMIO(0x9888), 0x13845800 },
	{ _MMIO(0x9888), 0x15840018 },
	{ _MMIO(0x9888), 0x3580001a },
	{ _MMIO(0x9888), 0x038b6300 },
	{ _MMIO(0x9888), 0x058b6b62 },
	{ _MMIO(0x9888), 0x078b006a },
	{ _MMIO(0x9888), 0x118b0000 },
	{ _MMIO(0x9888), 0x238b0000 },
	{ _MMIO(0x9888), 0x258b0000 },
	{ _MMIO(0x9888), 0x1f85a080 },
	{ _MMIO(0x9888), 0x2185aaaa },
	{ _MMIO(0x9888), 0x2385000a },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x01840018 },
	{ _MMIO(0x9888), 0x07844c80 },
	{ _MMIO(0x9888), 0x09840d9a },
	{ _MMIO(0x9888), 0x0b840e9c },
	{ _MMIO(0x9888), 0x0d840f9e },
	{ _MMIO(0x9888), 0x0f840010 },
	{ _MMIO(0x9888), 0x11840000 },
	{ _MMIO(0x9888), 0x03848000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x2f8000e5 },
	{ _MMIO(0x9888), 0x138080e3 },
	{ _MMIO(0x9888), 0x1580c0e1 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x11804000 },
	{ _MMIO(0x9888), 0x1780c000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f804000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3d800800 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800842 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800842 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47801042 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800084 },
	{ _MMIO(0x9888), 0x41800000 },
};

static int
get_memory_reads_mux_config(struct drm_i915_private *dev_priv,
			    const struct i915_oa_reg **regs,
			    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_memory_reads;
	lens[n] = ARRAY_SIZE(mux_config_memory_reads);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_memory_writes[] = {
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x274c), 0x86543210 },
	{ _MMIO(0x2748), 0x86543210 },
	{ _MMIO(0x2744), 0x00006667 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x275c), 0x86543210 },
	{ _MMIO(0x2758), 0x86543210 },
	{ _MMIO(0x2754), 0x00006465 },
	{ _MMIO(0x2750), 0x00000000 },
	{ _MMIO(0x2770), 0x0007f81a },
	{ _MMIO(0x2774), 0x0000fe00 },
	{ _MMIO(0x2778), 0x0007f82a },
	{ _MMIO(0x277c), 0x0000fe00 },
	{ _MMIO(0x2780), 0x0007f822 },
	{ _MMIO(0x2784), 0x0000fe00 },
	{ _MMIO(0x2788), 0x0007f8ba },
	{ _MMIO(0x278c), 0x0000fe00 },
	{ _MMIO(0x2790), 0x0007f87a },
	{ _MMIO(0x2794), 0x0000fe00 },
	{ _MMIO(0x2798), 0x0007f8ea },
	{ _MMIO(0x279c), 0x0000fe00 },
	{ _MMIO(0x27a0), 0x0007f8e2 },
	{ _MMIO(0x27a4), 0x0000fe00 },
	{ _MMIO(0x27a8), 0x0007f8f2 },
	{ _MMIO(0x27ac), 0x0000fe00 },
};

static const struct i915_oa_reg flex_eu_config_memory_writes[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00015014 },
	{ _MMIO(0xe658), 0x00025024 },
	{ _MMIO(0xe758), 0x00035034 },
	{ _MMIO(0xe45c), 0x00045044 },
	{ _MMIO(0xe55c), 0x00055054 },
	{ _MMIO(0xe65c), 0x00065064 },
};

static const struct i915_oa_reg mux_config_memory_writes[] = {
	{ _MMIO(0x9888), 0x198b0343 },
	{ _MMIO(0x9888), 0x13845400 },
	{ _MMIO(0x9888), 0x3580001a },
	{ _MMIO(0x9888), 0x3d800805 },
	{ _MMIO(0x9888), 0x038b6300 },
	{ _MMIO(0x9888), 0x058b6b62 },
	{ _MMIO(0x9888), 0x078b006a },
	{ _MMIO(0x9888), 0x118b0000 },
	{ _MMIO(0x9888), 0x238b0000 },
	{ _MMIO(0x9888), 0x258b0000 },
	{ _MMIO(0x9888), 0x1f85a080 },
	{ _MMIO(0x9888), 0x2185aaaa },
	{ _MMIO(0x9888), 0x23850002 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x01840010 },
	{ _MMIO(0x9888), 0x07844880 },
	{ _MMIO(0x9888), 0x09840992 },
	{ _MMIO(0x9888), 0x0b840a94 },
	{ _MMIO(0x9888), 0x0d840b96 },
	{ _MMIO(0x9888), 0x11840000 },
	{ _MMIO(0x9888), 0x03848000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x2d800147 },
	{ _MMIO(0x9888), 0x2f8000e5 },
	{ _MMIO(0x9888), 0x138080e3 },
	{ _MMIO(0x9888), 0x1580c0e1 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x11804000 },
	{ _MMIO(0x9888), 0x1780c000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f800000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800842 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800842 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47801082 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800084 },
	{ _MMIO(0x9888), 0x41800000 },
};

static int
get_memory_writes_mux_config(struct drm_i915_private *dev_priv,
			     const struct i915_oa_reg **regs,
			     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_memory_writes;
	lens[n] = ARRAY_SIZE(mux_config_memory_writes);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_extended[] = {
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2770), 0x0007fc2a },
	{ _MMIO(0x2774), 0x0000bf00 },
	{ _MMIO(0x2778), 0x0007fc6a },
	{ _MMIO(0x277c), 0x0000bf00 },
	{ _MMIO(0x2780), 0x0007fc92 },
	{ _MMIO(0x2784), 0x0000bf00 },
	{ _MMIO(0x2788), 0x0007fca2 },
	{ _MMIO(0x278c), 0x0000bf00 },
	{ _MMIO(0x2790), 0x0007fc32 },
	{ _MMIO(0x2794), 0x0000bf00 },
	{ _MMIO(0x2798), 0x0007fc9a },
	{ _MMIO(0x279c), 0x0000bf00 },
	{ _MMIO(0x27a0), 0x0007fe6a },
	{ _MMIO(0x27a4), 0x0000bf00 },
	{ _MMIO(0x27a8), 0x0007fe7a },
	{ _MMIO(0x27ac), 0x0000bf00 },
};

static const struct i915_oa_reg flex_eu_config_compute_extended[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00778008 },
	{ _MMIO(0xe45c), 0x00088078 },
	{ _MMIO(0xe55c), 0x00808708 },
	{ _MMIO(0xe65c), 0x00a08908 },
};

static const struct i915_oa_reg mux_config_compute_extended_0_subslices_0x01[] = {
	{ _MMIO(0x9888), 0x143d0160 },
	{ _MMIO(0x9888), 0x163d2800 },
	{ _MMIO(0x9888), 0x183d0120 },
	{ _MMIO(0x9888), 0x105800e0 },
	{ _MMIO(0x9888), 0x005cc000 },
	{ _MMIO(0x9888), 0x065c8000 },
	{ _MMIO(0x9888), 0x085cc000 },
	{ _MMIO(0x9888), 0x0a5cc000 },
	{ _MMIO(0x9888), 0x0c5cc000 },
	{ _MMIO(0x9888), 0x0e5cc000 },
	{ _MMIO(0x9888), 0x025cc000 },
	{ _MMIO(0x9888), 0x045cc000 },
	{ _MMIO(0x9888), 0x003d0011 },
	{ _MMIO(0x9888), 0x063d0900 },
	{ _MMIO(0x9888), 0x083d0a13 },
	{ _MMIO(0x9888), 0x0a3d0b15 },
	{ _MMIO(0x9888), 0x0c3d2317 },
	{ _MMIO(0x9888), 0x043d21b7 },
	{ _MMIO(0x9888), 0x103d0000 },
	{ _MMIO(0x9888), 0x0e3d0000 },
	{ _MMIO(0x9888), 0x1a3d0000 },
	{ _MMIO(0x9888), 0x0e5825c1 },
	{ _MMIO(0x9888), 0x00586100 },
	{ _MMIO(0x9888), 0x0258204c },
	{ _MMIO(0x9888), 0x06588000 },
	{ _MMIO(0x9888), 0x0858c000 },
	{ _MMIO(0x9888), 0x0a58c000 },
	{ _MMIO(0x9888), 0x0c58c000 },
	{ _MMIO(0x9888), 0x0458c000 },
	{ _MMIO(0x9888), 0x005b4000 },
	{ _MMIO(0x9888), 0x0e5b4000 },
	{ _MMIO(0x9888), 0x185b5400 },
	{ _MMIO(0x9888), 0x1a5b0155 },
	{ _MMIO(0x9888), 0x025b4000 },
	{ _MMIO(0x9888), 0x045b4000 },
	{ _MMIO(0x9888), 0x065b4000 },
	{ _MMIO(0x9888), 0x085b4000 },
	{ _MMIO(0x9888), 0x0a5b4000 },
	{ _MMIO(0x9888), 0x0c1fa800 },
	{ _MMIO(0x9888), 0x0e1faa2a },
	{ _MMIO(0x9888), 0x101f02aa },
	{ _MMIO(0x9888), 0x00384000 },
	{ _MMIO(0x9888), 0x0e384000 },
	{ _MMIO(0x9888), 0x16384000 },
	{ _MMIO(0x9888), 0x18381555 },
	{ _MMIO(0x9888), 0x02384000 },
	{ _MMIO(0x9888), 0x04384000 },
	{ _MMIO(0x9888), 0x06384000 },
	{ _MMIO(0x9888), 0x08384000 },
	{ _MMIO(0x9888), 0x0a384000 },
	{ _MMIO(0x9888), 0x0039a000 },
	{ _MMIO(0x9888), 0x06398000 },
	{ _MMIO(0x9888), 0x0839a000 },
	{ _MMIO(0x9888), 0x0a39a000 },
	{ _MMIO(0x9888), 0x0c39a000 },
	{ _MMIO(0x9888), 0x0e39a000 },
	{ _MMIO(0x9888), 0x0239a000 },
	{ _MMIO(0x9888), 0x0439a000 },
	{ _MMIO(0x9888), 0x018a8000 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x198a8000 },
	{ _MMIO(0x9888), 0x1b8aaaa0 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x238b2aa0 },
	{ _MMIO(0x9888), 0x258b5551 },
	{ _MMIO(0x9888), 0x278b0015 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaa2 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x17808000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3d800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800000 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800420 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800421 },
	{ _MMIO(0x9888), 0x41800000 },
};

static const struct i915_oa_reg mux_config_compute_extended_2_subslices_0x02[] = {
	{ _MMIO(0x9888), 0x105c00e0 },
	{ _MMIO(0x9888), 0x145b0160 },
	{ _MMIO(0x9888), 0x165b2800 },
	{ _MMIO(0x9888), 0x185b0120 },
	{ _MMIO(0x9888), 0x0e5c25c1 },
	{ _MMIO(0x9888), 0x005c6100 },
	{ _MMIO(0x9888), 0x025c204c },
	{ _MMIO(0x9888), 0x065c8000 },
	{ _MMIO(0x9888), 0x085cc000 },
	{ _MMIO(0x9888), 0x0a5cc000 },
	{ _MMIO(0x9888), 0x0c5cc000 },
	{ _MMIO(0x9888), 0x045cc000 },
	{ _MMIO(0x9888), 0x005b0011 },
	{ _MMIO(0x9888), 0x065b0900 },
	{ _MMIO(0x9888), 0x085b0a13 },
	{ _MMIO(0x9888), 0x0a5b0b15 },
	{ _MMIO(0x9888), 0x0c5b2317 },
	{ _MMIO(0x9888), 0x045b21b7 },
	{ _MMIO(0x9888), 0x105b0000 },
	{ _MMIO(0x9888), 0x0e5b0000 },
	{ _MMIO(0x9888), 0x1a5b0000 },
	{ _MMIO(0x9888), 0x0c1fa800 },
	{ _MMIO(0x9888), 0x0e1faa2a },
	{ _MMIO(0x9888), 0x101f02aa },
	{ _MMIO(0x9888), 0x00384000 },
	{ _MMIO(0x9888), 0x0e384000 },
	{ _MMIO(0x9888), 0x16384000 },
	{ _MMIO(0x9888), 0x18381555 },
	{ _MMIO(0x9888), 0x02384000 },
	{ _MMIO(0x9888), 0x04384000 },
	{ _MMIO(0x9888), 0x06384000 },
	{ _MMIO(0x9888), 0x08384000 },
	{ _MMIO(0x9888), 0x0a384000 },
	{ _MMIO(0x9888), 0x0039a000 },
	{ _MMIO(0x9888), 0x06398000 },
	{ _MMIO(0x9888), 0x0839a000 },
	{ _MMIO(0x9888), 0x0a39a000 },
	{ _MMIO(0x9888), 0x0c39a000 },
	{ _MMIO(0x9888), 0x0e39a000 },
	{ _MMIO(0x9888), 0x0239a000 },
	{ _MMIO(0x9888), 0x0439a000 },
	{ _MMIO(0x9888), 0x018a8000 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x198a8000 },
	{ _MMIO(0x9888), 0x1b8aaaa0 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x238b2aa0 },
	{ _MMIO(0x9888), 0x258b5551 },
	{ _MMIO(0x9888), 0x278b0015 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaa2 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x17808000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3d800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800000 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800420 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800421 },
	{ _MMIO(0x9888), 0x41800000 },
};

static const struct i915_oa_reg mux_config_compute_extended_4_subslices_0x04[] = {
	{ _MMIO(0x9888), 0x103800e0 },
	{ _MMIO(0x9888), 0x143a0160 },
	{ _MMIO(0x9888), 0x163a2800 },
	{ _MMIO(0x9888), 0x183a0120 },
	{ _MMIO(0x9888), 0x0c1fa800 },
	{ _MMIO(0x9888), 0x0e1faa2a },
	{ _MMIO(0x9888), 0x101f02aa },
	{ _MMIO(0x9888), 0x0e38a5c1 },
	{ _MMIO(0x9888), 0x0038a100 },
	{ _MMIO(0x9888), 0x0238204c },
	{ _MMIO(0x9888), 0x16388000 },
	{ _MMIO(0x9888), 0x183802aa },
	{ _MMIO(0x9888), 0x04380000 },
	{ _MMIO(0x9888), 0x06380000 },
	{ _MMIO(0x9888), 0x08388000 },
	{ _MMIO(0x9888), 0x0a388000 },
	{ _MMIO(0x9888), 0x0039a000 },
	{ _MMIO(0x9888), 0x06398000 },
	{ _MMIO(0x9888), 0x0839a000 },
	{ _MMIO(0x9888), 0x0a39a000 },
	{ _MMIO(0x9888), 0x0c39a000 },
	{ _MMIO(0x9888), 0x0e39a000 },
	{ _MMIO(0x9888), 0x0239a000 },
	{ _MMIO(0x9888), 0x0439a000 },
	{ _MMIO(0x9888), 0x003a0011 },
	{ _MMIO(0x9888), 0x063a0900 },
	{ _MMIO(0x9888), 0x083a0a13 },
	{ _MMIO(0x9888), 0x0a3a0b15 },
	{ _MMIO(0x9888), 0x0c3a2317 },
	{ _MMIO(0x9888), 0x043a21b7 },
	{ _MMIO(0x9888), 0x103a0000 },
	{ _MMIO(0x9888), 0x0e3a0000 },
	{ _MMIO(0x9888), 0x1a3a0000 },
	{ _MMIO(0x9888), 0x018a8000 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x198a8000 },
	{ _MMIO(0x9888), 0x1b8aaaa0 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x238b2aa0 },
	{ _MMIO(0x9888), 0x258b5551 },
	{ _MMIO(0x9888), 0x278b0015 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaa2 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x17808000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3d800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800000 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800420 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800421 },
	{ _MMIO(0x9888), 0x41800000 },
};

static const struct i915_oa_reg mux_config_compute_extended_1_subslices_0x08[] = {
	{ _MMIO(0x9888), 0x14bd0160 },
	{ _MMIO(0x9888), 0x16bd2800 },
	{ _MMIO(0x9888), 0x18bd0120 },
	{ _MMIO(0x9888), 0x10d800e0 },
	{ _MMIO(0x9888), 0x00dcc000 },
	{ _MMIO(0x9888), 0x06dc8000 },
	{ _MMIO(0x9888), 0x08dcc000 },
	{ _MMIO(0x9888), 0x0adcc000 },
	{ _MMIO(0x9888), 0x0cdcc000 },
	{ _MMIO(0x9888), 0x0edcc000 },
	{ _MMIO(0x9888), 0x02dcc000 },
	{ _MMIO(0x9888), 0x04dcc000 },
	{ _MMIO(0x9888), 0x00bd0011 },
	{ _MMIO(0x9888), 0x06bd0900 },
	{ _MMIO(0x9888), 0x08bd0a13 },
	{ _MMIO(0x9888), 0x0abd0b15 },
	{ _MMIO(0x9888), 0x0cbd2317 },
	{ _MMIO(0x9888), 0x04bd21b7 },
	{ _MMIO(0x9888), 0x10bd0000 },
	{ _MMIO(0x9888), 0x0ebd0000 },
	{ _MMIO(0x9888), 0x1abd0000 },
	{ _MMIO(0x9888), 0x0ed825c1 },
	{ _MMIO(0x9888), 0x00d86100 },
	{ _MMIO(0x9888), 0x02d8204c },
	{ _MMIO(0x9888), 0x06d88000 },
	{ _MMIO(0x9888), 0x08d8c000 },
	{ _MMIO(0x9888), 0x0ad8c000 },
	{ _MMIO(0x9888), 0x0cd8c000 },
	{ _MMIO(0x9888), 0x04d8c000 },
	{ _MMIO(0x9888), 0x00db4000 },
	{ _MMIO(0x9888), 0x0edb4000 },
	{ _MMIO(0x9888), 0x18db5400 },
	{ _MMIO(0x9888), 0x1adb0155 },
	{ _MMIO(0x9888), 0x02db4000 },
	{ _MMIO(0x9888), 0x04db4000 },
	{ _MMIO(0x9888), 0x06db4000 },
	{ _MMIO(0x9888), 0x08db4000 },
	{ _MMIO(0x9888), 0x0adb4000 },
	{ _MMIO(0x9888), 0x0c9fa800 },
	{ _MMIO(0x9888), 0x0e9faa2a },
	{ _MMIO(0x9888), 0x109f02aa },
	{ _MMIO(0x9888), 0x00b84000 },
	{ _MMIO(0x9888), 0x0eb84000 },
	{ _MMIO(0x9888), 0x16b84000 },
	{ _MMIO(0x9888), 0x18b81555 },
	{ _MMIO(0x9888), 0x02b84000 },
	{ _MMIO(0x9888), 0x04b84000 },
	{ _MMIO(0x9888), 0x06b84000 },
	{ _MMIO(0x9888), 0x08b84000 },
	{ _MMIO(0x9888), 0x0ab84000 },
	{ _MMIO(0x9888), 0x00b9a000 },
	{ _MMIO(0x9888), 0x06b98000 },
	{ _MMIO(0x9888), 0x08b9a000 },
	{ _MMIO(0x9888), 0x0ab9a000 },
	{ _MMIO(0x9888), 0x0cb9a000 },
	{ _MMIO(0x9888), 0x0eb9a000 },
	{ _MMIO(0x9888), 0x02b9a000 },
	{ _MMIO(0x9888), 0x04b9a000 },
	{ _MMIO(0x9888), 0x01888000 },
	{ _MMIO(0x9888), 0x0d88f800 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x09888000 },
	{ _MMIO(0x9888), 0x0b888000 },
	{ _MMIO(0x9888), 0x238b5540 },
	{ _MMIO(0x9888), 0x258baaa2 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x018c4000 },
	{ _MMIO(0x9888), 0x0f8c4000 },
	{ _MMIO(0x9888), 0x178c2000 },
	{ _MMIO(0x9888), 0x198c5500 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x098c4000 },
	{ _MMIO(0x9888), 0x0b8c4000 },
	{ _MMIO(0x9888), 0x018da000 },
	{ _MMIO(0x9888), 0x078d8000 },
	{ _MMIO(0x9888), 0x098da000 },
	{ _MMIO(0x9888), 0x0b8da000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x038da000 },
	{ _MMIO(0x9888), 0x058da000 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaa2 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x17808000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3d800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800000 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800420 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800421 },
	{ _MMIO(0x9888), 0x41800000 },
};

static const struct i915_oa_reg mux_config_compute_extended_3_subslices_0x10[] = {
	{ _MMIO(0x9888), 0x10dc00e0 },
	{ _MMIO(0x9888), 0x14db0160 },
	{ _MMIO(0x9888), 0x16db2800 },
	{ _MMIO(0x9888), 0x18db0120 },
	{ _MMIO(0x9888), 0x0edc25c1 },
	{ _MMIO(0x9888), 0x00dc6100 },
	{ _MMIO(0x9888), 0x02dc204c },
	{ _MMIO(0x9888), 0x06dc8000 },
	{ _MMIO(0x9888), 0x08dcc000 },
	{ _MMIO(0x9888), 0x0adcc000 },
	{ _MMIO(0x9888), 0x0cdcc000 },
	{ _MMIO(0x9888), 0x04dcc000 },
	{ _MMIO(0x9888), 0x00db0011 },
	{ _MMIO(0x9888), 0x06db0900 },
	{ _MMIO(0x9888), 0x08db0a13 },
	{ _MMIO(0x9888), 0x0adb0b15 },
	{ _MMIO(0x9888), 0x0cdb2317 },
	{ _MMIO(0x9888), 0x04db21b7 },
	{ _MMIO(0x9888), 0x10db0000 },
	{ _MMIO(0x9888), 0x0edb0000 },
	{ _MMIO(0x9888), 0x1adb0000 },
	{ _MMIO(0x9888), 0x0c9fa800 },
	{ _MMIO(0x9888), 0x0e9faa2a },
	{ _MMIO(0x9888), 0x109f02aa },
	{ _MMIO(0x9888), 0x00b84000 },
	{ _MMIO(0x9888), 0x0eb84000 },
	{ _MMIO(0x9888), 0x16b84000 },
	{ _MMIO(0x9888), 0x18b81555 },
	{ _MMIO(0x9888), 0x02b84000 },
	{ _MMIO(0x9888), 0x04b84000 },
	{ _MMIO(0x9888), 0x06b84000 },
	{ _MMIO(0x9888), 0x08b84000 },
	{ _MMIO(0x9888), 0x0ab84000 },
	{ _MMIO(0x9888), 0x00b9a000 },
	{ _MMIO(0x9888), 0x06b98000 },
	{ _MMIO(0x9888), 0x08b9a000 },
	{ _MMIO(0x9888), 0x0ab9a000 },
	{ _MMIO(0x9888), 0x0cb9a000 },
	{ _MMIO(0x9888), 0x0eb9a000 },
	{ _MMIO(0x9888), 0x02b9a000 },
	{ _MMIO(0x9888), 0x04b9a000 },
	{ _MMIO(0x9888), 0x01888000 },
	{ _MMIO(0x9888), 0x0d88f800 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x09888000 },
	{ _MMIO(0x9888), 0x0b888000 },
	{ _MMIO(0x9888), 0x238b5540 },
	{ _MMIO(0x9888), 0x258baaa2 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x018c4000 },
	{ _MMIO(0x9888), 0x0f8c4000 },
	{ _MMIO(0x9888), 0x178c2000 },
	{ _MMIO(0x9888), 0x198c5500 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x098c4000 },
	{ _MMIO(0x9888), 0x0b8c4000 },
	{ _MMIO(0x9888), 0x018da000 },
	{ _MMIO(0x9888), 0x078d8000 },
	{ _MMIO(0x9888), 0x098da000 },
	{ _MMIO(0x9888), 0x0b8da000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x038da000 },
	{ _MMIO(0x9888), 0x058da000 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaa2 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x17808000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3d800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800000 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800420 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800421 },
	{ _MMIO(0x9888), 0x41800000 },
};

static const struct i915_oa_reg mux_config_compute_extended_5_subslices_0x20[] = {
	{ _MMIO(0x9888), 0x10b800e0 },
	{ _MMIO(0x9888), 0x14ba0160 },
	{ _MMIO(0x9888), 0x16ba2800 },
	{ _MMIO(0x9888), 0x18ba0120 },
	{ _MMIO(0x9888), 0x0c9fa800 },
	{ _MMIO(0x9888), 0x0e9faa2a },
	{ _MMIO(0x9888), 0x109f02aa },
	{ _MMIO(0x9888), 0x0eb8a5c1 },
	{ _MMIO(0x9888), 0x00b8a100 },
	{ _MMIO(0x9888), 0x02b8204c },
	{ _MMIO(0x9888), 0x16b88000 },
	{ _MMIO(0x9888), 0x18b802aa },
	{ _MMIO(0x9888), 0x04b80000 },
	{ _MMIO(0x9888), 0x06b80000 },
	{ _MMIO(0x9888), 0x08b88000 },
	{ _MMIO(0x9888), 0x0ab88000 },
	{ _MMIO(0x9888), 0x00b9a000 },
	{ _MMIO(0x9888), 0x06b98000 },
	{ _MMIO(0x9888), 0x08b9a000 },
	{ _MMIO(0x9888), 0x0ab9a000 },
	{ _MMIO(0x9888), 0x0cb9a000 },
	{ _MMIO(0x9888), 0x0eb9a000 },
	{ _MMIO(0x9888), 0x02b9a000 },
	{ _MMIO(0x9888), 0x04b9a000 },
	{ _MMIO(0x9888), 0x00ba0011 },
	{ _MMIO(0x9888), 0x06ba0900 },
	{ _MMIO(0x9888), 0x08ba0a13 },
	{ _MMIO(0x9888), 0x0aba0b15 },
	{ _MMIO(0x9888), 0x0cba2317 },
	{ _MMIO(0x9888), 0x04ba21b7 },
	{ _MMIO(0x9888), 0x10ba0000 },
	{ _MMIO(0x9888), 0x0eba0000 },
	{ _MMIO(0x9888), 0x1aba0000 },
	{ _MMIO(0x9888), 0x01888000 },
	{ _MMIO(0x9888), 0x0d88f800 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x09888000 },
	{ _MMIO(0x9888), 0x0b888000 },
	{ _MMIO(0x9888), 0x238b5540 },
	{ _MMIO(0x9888), 0x258baaa2 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x018c4000 },
	{ _MMIO(0x9888), 0x0f8c4000 },
	{ _MMIO(0x9888), 0x178c2000 },
	{ _MMIO(0x9888), 0x198c5500 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x098c4000 },
	{ _MMIO(0x9888), 0x0b8c4000 },
	{ _MMIO(0x9888), 0x018da000 },
	{ _MMIO(0x9888), 0x078d8000 },
	{ _MMIO(0x9888), 0x098da000 },
	{ _MMIO(0x9888), 0x0b8da000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x038da000 },
	{ _MMIO(0x9888), 0x058da000 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaa2 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x17808000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3d800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800000 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800420 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800421 },
	{ _MMIO(0x9888), 0x41800000 },
};

static int
get_compute_extended_mux_config(struct drm_i915_private *dev_priv,
				const struct i915_oa_reg **regs,
				int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 6);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 6);

	if (INTEL_INFO(dev_priv)->sseu.subslice_mask & 0x01) {
		regs[n] = mux_config_compute_extended_0_subslices_0x01;
		lens[n] = ARRAY_SIZE(mux_config_compute_extended_0_subslices_0x01);
		n++;
	}
	if (INTEL_INFO(dev_priv)->sseu.subslice_mask & 0x08) {
		regs[n] = mux_config_compute_extended_1_subslices_0x08;
		lens[n] = ARRAY_SIZE(mux_config_compute_extended_1_subslices_0x08);
		n++;
	}
	if (INTEL_INFO(dev_priv)->sseu.subslice_mask & 0x02) {
		regs[n] = mux_config_compute_extended_2_subslices_0x02;
		lens[n] = ARRAY_SIZE(mux_config_compute_extended_2_subslices_0x02);
		n++;
	}
	if (INTEL_INFO(dev_priv)->sseu.subslice_mask & 0x10) {
		regs[n] = mux_config_compute_extended_3_subslices_0x10;
		lens[n] = ARRAY_SIZE(mux_config_compute_extended_3_subslices_0x10);
		n++;
	}
	if (INTEL_INFO(dev_priv)->sseu.subslice_mask & 0x04) {
		regs[n] = mux_config_compute_extended_4_subslices_0x04;
		lens[n] = ARRAY_SIZE(mux_config_compute_extended_4_subslices_0x04);
		n++;
	}
	if (INTEL_INFO(dev_priv)->sseu.subslice_mask & 0x20) {
		regs[n] = mux_config_compute_extended_5_subslices_0x20;
		lens[n] = ARRAY_SIZE(mux_config_compute_extended_5_subslices_0x20);
		n++;
	}

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_l3_cache[] = {
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x30800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2770), 0x0007fffa },
	{ _MMIO(0x2774), 0x0000fefe },
	{ _MMIO(0x2778), 0x0007fffa },
	{ _MMIO(0x277c), 0x0000fefd },
	{ _MMIO(0x2790), 0x0007fffa },
	{ _MMIO(0x2794), 0x0000fbef },
	{ _MMIO(0x2798), 0x0007fffa },
	{ _MMIO(0x279c), 0x0000fbdf },
};

static const struct i915_oa_reg flex_eu_config_compute_l3_cache[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00101100 },
	{ _MMIO(0xe45c), 0x00201200 },
	{ _MMIO(0xe55c), 0x00301300 },
	{ _MMIO(0xe65c), 0x00401400 },
};

static const struct i915_oa_reg mux_config_compute_l3_cache[] = {
	{ _MMIO(0x9888), 0x143f00b3 },
	{ _MMIO(0x9888), 0x14bf00b3 },
	{ _MMIO(0x9888), 0x138303c0 },
	{ _MMIO(0x9888), 0x3b800060 },
	{ _MMIO(0x9888), 0x3d800805 },
	{ _MMIO(0x9888), 0x003f0029 },
	{ _MMIO(0x9888), 0x063f1400 },
	{ _MMIO(0x9888), 0x083f1225 },
	{ _MMIO(0x9888), 0x0e3f1327 },
	{ _MMIO(0x9888), 0x103f0000 },
	{ _MMIO(0x9888), 0x005a4000 },
	{ _MMIO(0x9888), 0x065a8000 },
	{ _MMIO(0x9888), 0x085ac000 },
	{ _MMIO(0x9888), 0x0e5ac000 },
	{ _MMIO(0x9888), 0x001d4000 },
	{ _MMIO(0x9888), 0x061d8000 },
	{ _MMIO(0x9888), 0x081dc000 },
	{ _MMIO(0x9888), 0x0e1dc000 },
	{ _MMIO(0x9888), 0x0c1f0800 },
	{ _MMIO(0x9888), 0x0e1f2a00 },
	{ _MMIO(0x9888), 0x101f0280 },
	{ _MMIO(0x9888), 0x00391000 },
	{ _MMIO(0x9888), 0x06394000 },
	{ _MMIO(0x9888), 0x08395000 },
	{ _MMIO(0x9888), 0x0e395000 },
	{ _MMIO(0x9888), 0x0abf1429 },
	{ _MMIO(0x9888), 0x0cbf1225 },
	{ _MMIO(0x9888), 0x00bf1380 },
	{ _MMIO(0x9888), 0x02bf0026 },
	{ _MMIO(0x9888), 0x10bf0000 },
	{ _MMIO(0x9888), 0x0adac000 },
	{ _MMIO(0x9888), 0x0cdac000 },
	{ _MMIO(0x9888), 0x00da8000 },
	{ _MMIO(0x9888), 0x02da4000 },
	{ _MMIO(0x9888), 0x0a9dc000 },
	{ _MMIO(0x9888), 0x0c9dc000 },
	{ _MMIO(0x9888), 0x009d8000 },
	{ _MMIO(0x9888), 0x029d4000 },
	{ _MMIO(0x9888), 0x0e9f8000 },
	{ _MMIO(0x9888), 0x109f002a },
	{ _MMIO(0x9888), 0x0c9fa000 },
	{ _MMIO(0x9888), 0x0ab95000 },
	{ _MMIO(0x9888), 0x0cb95000 },
	{ _MMIO(0x9888), 0x00b94000 },
	{ _MMIO(0x9888), 0x02b91000 },
	{ _MMIO(0x9888), 0x0d88c000 },
	{ _MMIO(0x9888), 0x0f880003 },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x018a8000 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x198a8000 },
	{ _MMIO(0x9888), 0x1b8a8020 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x238b0520 },
	{ _MMIO(0x9888), 0x258ba950 },
	{ _MMIO(0x9888), 0x278b0016 },
	{ _MMIO(0x9888), 0x198c5400 },
	{ _MMIO(0x9888), 0x1b8c0001 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x0b8da000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x018d8000 },
	{ _MMIO(0x9888), 0x038d2000 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaa0 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x03835180 },
	{ _MMIO(0x9888), 0x05834022 },
	{ _MMIO(0x9888), 0x11830000 },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x07830000 },
	{ _MMIO(0x9888), 0x09830000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x05844000 },
	{ _MMIO(0x9888), 0x1b80c137 },
	{ _MMIO(0x9888), 0x1d80c147 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x17808000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x15804000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d801000 },
	{ _MMIO(0x9888), 0x4f800111 },
	{ _MMIO(0x9888), 0x43800842 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800840 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800800 },
	{ _MMIO(0x9888), 0x418014a2 },
};

static int
get_compute_l3_cache_mux_config(struct drm_i915_private *dev_priv,
				const struct i915_oa_reg **regs,
				int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_compute_l3_cache;
	lens[n] = ARRAY_SIZE(mux_config_compute_l3_cache);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_data_port_reads_coalescing[] = {
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x274c), 0xba98ba98 },
	{ _MMIO(0x2748), 0xba98ba98 },
	{ _MMIO(0x2744), 0x00003377 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2770), 0x0007fff2 },
	{ _MMIO(0x2774), 0x00007ff0 },
	{ _MMIO(0x2778), 0x0007ffe2 },
	{ _MMIO(0x277c), 0x00007ff0 },
	{ _MMIO(0x2780), 0x0007ffc2 },
	{ _MMIO(0x2784), 0x00007ff0 },
	{ _MMIO(0x2788), 0x0007ff82 },
	{ _MMIO(0x278c), 0x00007ff0 },
	{ _MMIO(0x2790), 0x0007fffa },
	{ _MMIO(0x2794), 0x0000bfef },
	{ _MMIO(0x2798), 0x0007fffa },
	{ _MMIO(0x279c), 0x0000bfdf },
	{ _MMIO(0x27a0), 0x0007fffa },
	{ _MMIO(0x27a4), 0x0000bfbf },
	{ _MMIO(0x27a8), 0x0007fffa },
	{ _MMIO(0x27ac), 0x0000bf7f },
};

static const struct i915_oa_reg flex_eu_config_data_port_reads_coalescing[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00778008 },
	{ _MMIO(0xe45c), 0x00088078 },
	{ _MMIO(0xe55c), 0x00808708 },
	{ _MMIO(0xe65c), 0x00a08908 },
};

static const struct i915_oa_reg mux_config_data_port_reads_coalescing_0_subslices_0x01[] = {
	{ _MMIO(0x9888), 0x103d0005 },
	{ _MMIO(0x9888), 0x163d240b },
	{ _MMIO(0x9888), 0x1058022f },
	{ _MMIO(0x9888), 0x185b5520 },
	{ _MMIO(0x9888), 0x198b0003 },
	{ _MMIO(0x9888), 0x005cc000 },
	{ _MMIO(0x9888), 0x065cc000 },
	{ _MMIO(0x9888), 0x085cc000 },
	{ _MMIO(0x9888), 0x0a5cc000 },
	{ _MMIO(0x9888), 0x0c5cc000 },
	{ _MMIO(0x9888), 0x0e5cc000 },
	{ _MMIO(0x9888), 0x025c4000 },
	{ _MMIO(0x9888), 0x045c8000 },
	{ _MMIO(0x9888), 0x003d0000 },
	{ _MMIO(0x9888), 0x063d00b0 },
	{ _MMIO(0x9888), 0x083d0182 },
	{ _MMIO(0x9888), 0x0a3d10a0 },
	{ _MMIO(0x9888), 0x0c3d11a2 },
	{ _MMIO(0x9888), 0x0e3d0000 },
	{ _MMIO(0x9888), 0x183d0000 },
	{ _MMIO(0x9888), 0x1a3d0000 },
	{ _MMIO(0x9888), 0x0e582242 },
	{ _MMIO(0x9888), 0x00586700 },
	{ _MMIO(0x9888), 0x0258004f },
	{ _MMIO(0x9888), 0x0658c000 },
	{ _MMIO(0x9888), 0x0858c000 },
	{ _MMIO(0x9888), 0x0a58c000 },
	{ _MMIO(0x9888), 0x0c58c000 },
	{ _MMIO(0x9888), 0x045b6300 },
	{ _MMIO(0x9888), 0x105b0000 },
	{ _MMIO(0x9888), 0x005b4000 },
	{ _MMIO(0x9888), 0x0e5b4000 },
	{ _MMIO(0x9888), 0x1a5b0155 },
	{ _MMIO(0x9888), 0x025b4000 },
	{ _MMIO(0x9888), 0x0a5b0000 },
	{ _MMIO(0x9888), 0x0c5b4000 },
	{ _MMIO(0x9888), 0x0c1fa800 },
	{ _MMIO(0x9888), 0x0e1faaa0 },
	{ _MMIO(0x9888), 0x101f02aa },
	{ _MMIO(0x9888), 0x00384000 },
	{ _MMIO(0x9888), 0x0e384000 },
	{ _MMIO(0x9888), 0x16384000 },
	{ _MMIO(0x9888), 0x18381555 },
	{ _MMIO(0x9888), 0x02384000 },
	{ _MMIO(0x9888), 0x04384000 },
	{ _MMIO(0x9888), 0x0a384000 },
	{ _MMIO(0x9888), 0x0c384000 },
	{ _MMIO(0x9888), 0x0039a000 },
	{ _MMIO(0x9888), 0x0639a000 },
	{ _MMIO(0x9888), 0x0839a000 },
	{ _MMIO(0x9888), 0x0a39a000 },
	{ _MMIO(0x9888), 0x0c39a000 },
	{ _MMIO(0x9888), 0x0e39a000 },
	{ _MMIO(0x9888), 0x02392000 },
	{ _MMIO(0x9888), 0x04398000 },
	{ _MMIO(0x9888), 0x018a8000 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x198a8000 },
	{ _MMIO(0x9888), 0x1b8aaaa0 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x038b6300 },
	{ _MMIO(0x9888), 0x058b0062 },
	{ _MMIO(0x9888), 0x118b0000 },
	{ _MMIO(0x9888), 0x238b02a0 },
	{ _MMIO(0x9888), 0x258b5555 },
	{ _MMIO(0x9888), 0x278b0015 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaaa },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x0784c000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x1780c000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d801000 },
	{ _MMIO(0x9888), 0x3d800000 },
	{ _MMIO(0x9888), 0x4f800001 },
	{ _MMIO(0x9888), 0x43800000 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800420 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800421 },
	{ _MMIO(0x9888), 0x41800041 },
};

static int
get_data_port_reads_coalescing_mux_config(struct drm_i915_private *dev_priv,
					  const struct i915_oa_reg **regs,
					  int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	if (INTEL_INFO(dev_priv)->sseu.subslice_mask & 0x01) {
		regs[n] = mux_config_data_port_reads_coalescing_0_subslices_0x01;
		lens[n] = ARRAY_SIZE(mux_config_data_port_reads_coalescing_0_subslices_0x01);
		n++;
	}

	return n;
}

static const struct i915_oa_reg b_counter_config_data_port_writes_coalescing[] = {
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x274c), 0xba98ba98 },
	{ _MMIO(0x2748), 0xba98ba98 },
	{ _MMIO(0x2744), 0x00003377 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2770), 0x0007ff72 },
	{ _MMIO(0x2774), 0x0000bfd0 },
	{ _MMIO(0x2778), 0x0007ff62 },
	{ _MMIO(0x277c), 0x0000bfd0 },
	{ _MMIO(0x2780), 0x0007ff42 },
	{ _MMIO(0x2784), 0x0000bfd0 },
	{ _MMIO(0x2788), 0x0007ff02 },
	{ _MMIO(0x278c), 0x0000bfd0 },
	{ _MMIO(0x2790), 0x0005fff2 },
	{ _MMIO(0x2794), 0x0000bfd0 },
	{ _MMIO(0x2798), 0x0005ffe2 },
	{ _MMIO(0x279c), 0x0000bfd0 },
	{ _MMIO(0x27a0), 0x0005ffc2 },
	{ _MMIO(0x27a4), 0x0000bfd0 },
	{ _MMIO(0x27a8), 0x0005ff82 },
	{ _MMIO(0x27ac), 0x0000bfd0 },
};

static const struct i915_oa_reg flex_eu_config_data_port_writes_coalescing[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00778008 },
	{ _MMIO(0xe45c), 0x00088078 },
	{ _MMIO(0xe55c), 0x00808708 },
	{ _MMIO(0xe65c), 0x00a08908 },
};

static const struct i915_oa_reg mux_config_data_port_writes_coalescing_0_subslices_0x01[] = {
	{ _MMIO(0x9888), 0x103d0005 },
	{ _MMIO(0x9888), 0x143d0120 },
	{ _MMIO(0x9888), 0x163d2400 },
	{ _MMIO(0x9888), 0x1058022f },
	{ _MMIO(0x9888), 0x105b0000 },
	{ _MMIO(0x9888), 0x198b0003 },
	{ _MMIO(0x9888), 0x005cc000 },
	{ _MMIO(0x9888), 0x065cc000 },
	{ _MMIO(0x9888), 0x085cc000 },
	{ _MMIO(0x9888), 0x0a5cc000 },
	{ _MMIO(0x9888), 0x0e5cc000 },
	{ _MMIO(0x9888), 0x025c4000 },
	{ _MMIO(0x9888), 0x045c8000 },
	{ _MMIO(0x9888), 0x003d0000 },
	{ _MMIO(0x9888), 0x063d0094 },
	{ _MMIO(0x9888), 0x083d0182 },
	{ _MMIO(0x9888), 0x0a3d1814 },
	{ _MMIO(0x9888), 0x0e3d0000 },
	{ _MMIO(0x9888), 0x183d0000 },
	{ _MMIO(0x9888), 0x1a3d0000 },
	{ _MMIO(0x9888), 0x0c3d0000 },
	{ _MMIO(0x9888), 0x0e582242 },
	{ _MMIO(0x9888), 0x00586700 },
	{ _MMIO(0x9888), 0x0258004f },
	{ _MMIO(0x9888), 0x0658c000 },
	{ _MMIO(0x9888), 0x0858c000 },
	{ _MMIO(0x9888), 0x0a58c000 },
	{ _MMIO(0x9888), 0x045b6a80 },
	{ _MMIO(0x9888), 0x005b4000 },
	{ _MMIO(0x9888), 0x0e5b4000 },
	{ _MMIO(0x9888), 0x185b5400 },
	{ _MMIO(0x9888), 0x1a5b0141 },
	{ _MMIO(0x9888), 0x025b4000 },
	{ _MMIO(0x9888), 0x0a5b0000 },
	{ _MMIO(0x9888), 0x0c5b4000 },
	{ _MMIO(0x9888), 0x0c1fa800 },
	{ _MMIO(0x9888), 0x0e1faaa0 },
	{ _MMIO(0x9888), 0x101f0282 },
	{ _MMIO(0x9888), 0x00384000 },
	{ _MMIO(0x9888), 0x0e384000 },
	{ _MMIO(0x9888), 0x16384000 },
	{ _MMIO(0x9888), 0x18381415 },
	{ _MMIO(0x9888), 0x02384000 },
	{ _MMIO(0x9888), 0x04384000 },
	{ _MMIO(0x9888), 0x0a384000 },
	{ _MMIO(0x9888), 0x0c384000 },
	{ _MMIO(0x9888), 0x0039a000 },
	{ _MMIO(0x9888), 0x0639a000 },
	{ _MMIO(0x9888), 0x0839a000 },
	{ _MMIO(0x9888), 0x0a39a000 },
	{ _MMIO(0x9888), 0x0e39a000 },
	{ _MMIO(0x9888), 0x02392000 },
	{ _MMIO(0x9888), 0x04398000 },
	{ _MMIO(0x9888), 0x018a8000 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x198a8000 },
	{ _MMIO(0x9888), 0x1b8a82a0 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x038b6300 },
	{ _MMIO(0x9888), 0x058b0062 },
	{ _MMIO(0x9888), 0x118b0000 },
	{ _MMIO(0x9888), 0x238b02a0 },
	{ _MMIO(0x9888), 0x258b1555 },
	{ _MMIO(0x9888), 0x278b0014 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x21852aaa },
	{ _MMIO(0x9888), 0x23850028 },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830141 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x0784c000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x1780c000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0xd24), 0x00000000 },
	{ _MMIO(0x9888), 0x4d801000 },
	{ _MMIO(0x9888), 0x3d800000 },
	{ _MMIO(0x9888), 0x4f800001 },
	{ _MMIO(0x9888), 0x43800000 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800420 },
	{ _MMIO(0x9888), 0x3f800421 },
	{ _MMIO(0x9888), 0x41800041 },
};

static int
get_data_port_writes_coalescing_mux_config(struct drm_i915_private *dev_priv,
					   const struct i915_oa_reg **regs,
					   int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	if (INTEL_INFO(dev_priv)->sseu.subslice_mask & 0x01) {
		regs[n] = mux_config_data_port_writes_coalescing_0_subslices_0x01;
		lens[n] = ARRAY_SIZE(mux_config_data_port_writes_coalescing_0_subslices_0x01);
		n++;
	}

	return n;
}

static const struct i915_oa_reg b_counter_config_hdc_and_sf[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x10800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x0000fff7 },
};

static const struct i915_oa_reg flex_eu_config_hdc_and_sf[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_hdc_and_sf[] = {
	{ _MMIO(0x9888), 0x105c0232 },
	{ _MMIO(0x9888), 0x10580232 },
	{ _MMIO(0x9888), 0x10380232 },
	{ _MMIO(0x9888), 0x10dc0232 },
	{ _MMIO(0x9888), 0x10d80232 },
	{ _MMIO(0x9888), 0x10b80232 },
	{ _MMIO(0x9888), 0x118e4400 },
	{ _MMIO(0x9888), 0x025c6080 },
	{ _MMIO(0x9888), 0x045c004b },
	{ _MMIO(0x9888), 0x005c8000 },
	{ _MMIO(0x9888), 0x00582080 },
	{ _MMIO(0x9888), 0x0258004b },
	{ _MMIO(0x9888), 0x025b4000 },
	{ _MMIO(0x9888), 0x045b4000 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f00aa },
	{ _MMIO(0x9888), 0x04386080 },
	{ _MMIO(0x9888), 0x0638404b },
	{ _MMIO(0x9888), 0x02384000 },
	{ _MMIO(0x9888), 0x08384000 },
	{ _MMIO(0x9888), 0x0a380000 },
	{ _MMIO(0x9888), 0x0c380000 },
	{ _MMIO(0x9888), 0x00398000 },
	{ _MMIO(0x9888), 0x0239a000 },
	{ _MMIO(0x9888), 0x0439a000 },
	{ _MMIO(0x9888), 0x06392000 },
	{ _MMIO(0x9888), 0x0cdc25c1 },
	{ _MMIO(0x9888), 0x0adcc000 },
	{ _MMIO(0x9888), 0x0ad825c1 },
	{ _MMIO(0x9888), 0x18db4000 },
	{ _MMIO(0x9888), 0x1adb0001 },
	{ _MMIO(0x9888), 0x0e9f8000 },
	{ _MMIO(0x9888), 0x109f02aa },
	{ _MMIO(0x9888), 0x0eb825c1 },
	{ _MMIO(0x9888), 0x18b80154 },
	{ _MMIO(0x9888), 0x0ab9a000 },
	{ _MMIO(0x9888), 0x0cb9a000 },
	{ _MMIO(0x9888), 0x0eb9a000 },
	{ _MMIO(0x9888), 0x0d88c000 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x258baa05 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x198c5400 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x098dc000 },
	{ _MMIO(0x9888), 0x0b8da000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x098e05c0 },
	{ _MMIO(0x9888), 0x058e0000 },
	{ _MMIO(0x9888), 0x198f0020 },
	{ _MMIO(0x9888), 0x2185aa0a },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x19835000 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x09848000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x19808000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x51800040 },
	{ _MMIO(0x9888), 0x43800400 },
	{ _MMIO(0x9888), 0x45800800 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800c62 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f801042 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x418014a4 },
};

static int
get_hdc_and_sf_mux_config(struct drm_i915_private *dev_priv,
			  const struct i915_oa_reg **regs,
			  int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_hdc_and_sf;
	lens[n] = ARRAY_SIZE(mux_config_hdc_and_sf);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_1[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00014002 },
	{ _MMIO(0x277c), 0x0000c3ff },
	{ _MMIO(0x2780), 0x00010002 },
	{ _MMIO(0x2784), 0x0000c7ff },
	{ _MMIO(0x2788), 0x00004002 },
	{ _MMIO(0x278c), 0x0000d3ff },
	{ _MMIO(0x2790), 0x00100700 },
	{ _MMIO(0x2794), 0x0000ff1f },
	{ _MMIO(0x2798), 0x00001402 },
	{ _MMIO(0x279c), 0x0000fc3f },
	{ _MMIO(0x27a0), 0x00001002 },
	{ _MMIO(0x27a4), 0x0000fc7f },
	{ _MMIO(0x27a8), 0x00000402 },
	{ _MMIO(0x27ac), 0x0000fd3f },
};

static const struct i915_oa_reg flex_eu_config_l3_1[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_1[] = {
	{ _MMIO(0x9888), 0x10bf03da },
	{ _MMIO(0x9888), 0x14bf0001 },
	{ _MMIO(0x9888), 0x12980340 },
	{ _MMIO(0x9888), 0x12990340 },
	{ _MMIO(0x9888), 0x0cbf1187 },
	{ _MMIO(0x9888), 0x0ebf1205 },
	{ _MMIO(0x9888), 0x00bf0500 },
	{ _MMIO(0x9888), 0x02bf042b },
	{ _MMIO(0x9888), 0x04bf002c },
	{ _MMIO(0x9888), 0x0cdac000 },
	{ _MMIO(0x9888), 0x0edac000 },
	{ _MMIO(0x9888), 0x00da8000 },
	{ _MMIO(0x9888), 0x02dac000 },
	{ _MMIO(0x9888), 0x04da4000 },
	{ _MMIO(0x9888), 0x04983400 },
	{ _MMIO(0x9888), 0x10980000 },
	{ _MMIO(0x9888), 0x06990034 },
	{ _MMIO(0x9888), 0x10990000 },
	{ _MMIO(0x9888), 0x0c9dc000 },
	{ _MMIO(0x9888), 0x0e9dc000 },
	{ _MMIO(0x9888), 0x009d8000 },
	{ _MMIO(0x9888), 0x029dc000 },
	{ _MMIO(0x9888), 0x049d4000 },
	{ _MMIO(0x9888), 0x109f02a8 },
	{ _MMIO(0x9888), 0x0c9fa000 },
	{ _MMIO(0x9888), 0x0e9f00ba },
	{ _MMIO(0x9888), 0x0cb88000 },
	{ _MMIO(0x9888), 0x0cb95000 },
	{ _MMIO(0x9888), 0x0eb95000 },
	{ _MMIO(0x9888), 0x00b94000 },
	{ _MMIO(0x9888), 0x02b95000 },
	{ _MMIO(0x9888), 0x04b91000 },
	{ _MMIO(0x9888), 0x06b92000 },
	{ _MMIO(0x9888), 0x0cba4000 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x09888000 },
	{ _MMIO(0x9888), 0x0b888000 },
	{ _MMIO(0x9888), 0x0d880400 },
	{ _MMIO(0x9888), 0x258b800a },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b5500 },
	{ _MMIO(0x9888), 0x198c4000 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x098c4000 },
	{ _MMIO(0x9888), 0x0b8c4000 },
	{ _MMIO(0x9888), 0x0d8c4000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x018d8000 },
	{ _MMIO(0x9888), 0x038da000 },
	{ _MMIO(0x9888), 0x058da000 },
	{ _MMIO(0x9888), 0x078d2000 },
	{ _MMIO(0x9888), 0x2185800a },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x1b830154 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x47800000 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800060 },
};

static int
get_l3_1_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_l3_1;
	lens[n] = ARRAY_SIZE(mux_config_l3_1);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_2[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00014002 },
	{ _MMIO(0x277c), 0x0000c3ff },
	{ _MMIO(0x2780), 0x00010002 },
	{ _MMIO(0x2784), 0x0000c7ff },
	{ _MMIO(0x2788), 0x00004002 },
	{ _MMIO(0x278c), 0x0000d3ff },
	{ _MMIO(0x2790), 0x00100700 },
	{ _MMIO(0x2794), 0x0000ff1f },
	{ _MMIO(0x2798), 0x00001402 },
	{ _MMIO(0x279c), 0x0000fc3f },
	{ _MMIO(0x27a0), 0x00001002 },
	{ _MMIO(0x27a4), 0x0000fc7f },
	{ _MMIO(0x27a8), 0x00000402 },
	{ _MMIO(0x27ac), 0x0000fd3f },
};

static const struct i915_oa_reg flex_eu_config_l3_2[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_2[] = {
	{ _MMIO(0x9888), 0x103f03da },
	{ _MMIO(0x9888), 0x143f0001 },
	{ _MMIO(0x9888), 0x12180340 },
	{ _MMIO(0x9888), 0x12190340 },
	{ _MMIO(0x9888), 0x0c3f1187 },
	{ _MMIO(0x9888), 0x0e3f1205 },
	{ _MMIO(0x9888), 0x003f0500 },
	{ _MMIO(0x9888), 0x023f042b },
	{ _MMIO(0x9888), 0x043f002c },
	{ _MMIO(0x9888), 0x0c5ac000 },
	{ _MMIO(0x9888), 0x0e5ac000 },
	{ _MMIO(0x9888), 0x005a8000 },
	{ _MMIO(0x9888), 0x025ac000 },
	{ _MMIO(0x9888), 0x045a4000 },
	{ _MMIO(0x9888), 0x04183400 },
	{ _MMIO(0x9888), 0x10180000 },
	{ _MMIO(0x9888), 0x06190034 },
	{ _MMIO(0x9888), 0x10190000 },
	{ _MMIO(0x9888), 0x0c1dc000 },
	{ _MMIO(0x9888), 0x0e1dc000 },
	{ _MMIO(0x9888), 0x001d8000 },
	{ _MMIO(0x9888), 0x021dc000 },
	{ _MMIO(0x9888), 0x041d4000 },
	{ _MMIO(0x9888), 0x101f02a8 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f00ba },
	{ _MMIO(0x9888), 0x0c388000 },
	{ _MMIO(0x9888), 0x0c395000 },
	{ _MMIO(0x9888), 0x0e395000 },
	{ _MMIO(0x9888), 0x00394000 },
	{ _MMIO(0x9888), 0x02395000 },
	{ _MMIO(0x9888), 0x04391000 },
	{ _MMIO(0x9888), 0x06392000 },
	{ _MMIO(0x9888), 0x0c3a4000 },
	{ _MMIO(0x9888), 0x1b8aa800 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x258b4005 },
	{ _MMIO(0x9888), 0x278b0015 },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x2185800a },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x1b830154 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x47800000 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800060 },
};

static int
get_l3_2_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_l3_2;
	lens[n] = ARRAY_SIZE(mux_config_l3_2);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_3[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00014002 },
	{ _MMIO(0x277c), 0x0000c3ff },
	{ _MMIO(0x2780), 0x00010002 },
	{ _MMIO(0x2784), 0x0000c7ff },
	{ _MMIO(0x2788), 0x00004002 },
	{ _MMIO(0x278c), 0x0000d3ff },
	{ _MMIO(0x2790), 0x00100700 },
	{ _MMIO(0x2794), 0x0000ff1f },
	{ _MMIO(0x2798), 0x00001402 },
	{ _MMIO(0x279c), 0x0000fc3f },
	{ _MMIO(0x27a0), 0x00001002 },
	{ _MMIO(0x27a4), 0x0000fc7f },
	{ _MMIO(0x27a8), 0x00000402 },
	{ _MMIO(0x27ac), 0x0000fd3f },
};

static const struct i915_oa_reg flex_eu_config_l3_3[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_3[] = {
	{ _MMIO(0x9888), 0x121b0340 },
	{ _MMIO(0x9888), 0x103f0274 },
	{ _MMIO(0x9888), 0x123f0000 },
	{ _MMIO(0x9888), 0x129b0340 },
	{ _MMIO(0x9888), 0x10bf0274 },
	{ _MMIO(0x9888), 0x12bf0000 },
	{ _MMIO(0x9888), 0x041b3400 },
	{ _MMIO(0x9888), 0x101b0000 },
	{ _MMIO(0x9888), 0x045c8000 },
	{ _MMIO(0x9888), 0x0a3d4000 },
	{ _MMIO(0x9888), 0x003f0080 },
	{ _MMIO(0x9888), 0x023f0793 },
	{ _MMIO(0x9888), 0x043f0014 },
	{ _MMIO(0x9888), 0x04588000 },
	{ _MMIO(0x9888), 0x005a8000 },
	{ _MMIO(0x9888), 0x025ac000 },
	{ _MMIO(0x9888), 0x045a4000 },
	{ _MMIO(0x9888), 0x0a5b4000 },
	{ _MMIO(0x9888), 0x001d8000 },
	{ _MMIO(0x9888), 0x021dc000 },
	{ _MMIO(0x9888), 0x041d4000 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f002a },
	{ _MMIO(0x9888), 0x0a384000 },
	{ _MMIO(0x9888), 0x00394000 },
	{ _MMIO(0x9888), 0x02395000 },
	{ _MMIO(0x9888), 0x04399000 },
	{ _MMIO(0x9888), 0x069b0034 },
	{ _MMIO(0x9888), 0x109b0000 },
	{ _MMIO(0x9888), 0x06dc4000 },
	{ _MMIO(0x9888), 0x0cbd4000 },
	{ _MMIO(0x9888), 0x0cbf0981 },
	{ _MMIO(0x9888), 0x0ebf0a0f },
	{ _MMIO(0x9888), 0x06d84000 },
	{ _MMIO(0x9888), 0x0cdac000 },
	{ _MMIO(0x9888), 0x0edac000 },
	{ _MMIO(0x9888), 0x0cdb4000 },
	{ _MMIO(0x9888), 0x0c9dc000 },
	{ _MMIO(0x9888), 0x0e9dc000 },
	{ _MMIO(0x9888), 0x109f02a8 },
	{ _MMIO(0x9888), 0x0e9f0080 },
	{ _MMIO(0x9888), 0x0cb84000 },
	{ _MMIO(0x9888), 0x0cb95000 },
	{ _MMIO(0x9888), 0x0eb95000 },
	{ _MMIO(0x9888), 0x06b92000 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x0d880400 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x258b8009 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x198c4000 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x0d8c4000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x078d2000 },
	{ _MMIO(0x9888), 0x2185800a },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x1b830154 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x45800c00 },
	{ _MMIO(0x9888), 0x47800c63 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f8014a5 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800045 },
};

static int
get_l3_3_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_l3_3;
	lens[n] = ARRAY_SIZE(mux_config_l3_3);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_4[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00014002 },
	{ _MMIO(0x277c), 0x0000c3ff },
	{ _MMIO(0x2780), 0x00010002 },
	{ _MMIO(0x2784), 0x0000c7ff },
	{ _MMIO(0x2788), 0x00004002 },
	{ _MMIO(0x278c), 0x0000d3ff },
	{ _MMIO(0x2790), 0x00100700 },
	{ _MMIO(0x2794), 0x0000ff1f },
	{ _MMIO(0x2798), 0x00001402 },
	{ _MMIO(0x279c), 0x0000fc3f },
	{ _MMIO(0x27a0), 0x00001002 },
	{ _MMIO(0x27a4), 0x0000fc7f },
	{ _MMIO(0x27a8), 0x00000402 },
	{ _MMIO(0x27ac), 0x0000fd3f },
};

static const struct i915_oa_reg flex_eu_config_l3_4[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_4[] = {
	{ _MMIO(0x9888), 0x121a0340 },
	{ _MMIO(0x9888), 0x103f0017 },
	{ _MMIO(0x9888), 0x123f0020 },
	{ _MMIO(0x9888), 0x129a0340 },
	{ _MMIO(0x9888), 0x10bf0017 },
	{ _MMIO(0x9888), 0x12bf0020 },
	{ _MMIO(0x9888), 0x041a3400 },
	{ _MMIO(0x9888), 0x101a0000 },
	{ _MMIO(0x9888), 0x043b8000 },
	{ _MMIO(0x9888), 0x0a3e0010 },
	{ _MMIO(0x9888), 0x003f0200 },
	{ _MMIO(0x9888), 0x023f0113 },
	{ _MMIO(0x9888), 0x043f0014 },
	{ _MMIO(0x9888), 0x02592000 },
	{ _MMIO(0x9888), 0x005a8000 },
	{ _MMIO(0x9888), 0x025ac000 },
	{ _MMIO(0x9888), 0x045a4000 },
	{ _MMIO(0x9888), 0x0a1c8000 },
	{ _MMIO(0x9888), 0x001d8000 },
	{ _MMIO(0x9888), 0x021dc000 },
	{ _MMIO(0x9888), 0x041d4000 },
	{ _MMIO(0x9888), 0x0a1e8000 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f001a },
	{ _MMIO(0x9888), 0x00394000 },
	{ _MMIO(0x9888), 0x02395000 },
	{ _MMIO(0x9888), 0x04391000 },
	{ _MMIO(0x9888), 0x069a0034 },
	{ _MMIO(0x9888), 0x109a0000 },
	{ _MMIO(0x9888), 0x06bb4000 },
	{ _MMIO(0x9888), 0x0abe0040 },
	{ _MMIO(0x9888), 0x0cbf0984 },
	{ _MMIO(0x9888), 0x0ebf0a02 },
	{ _MMIO(0x9888), 0x02d94000 },
	{ _MMIO(0x9888), 0x0cdac000 },
	{ _MMIO(0x9888), 0x0edac000 },
	{ _MMIO(0x9888), 0x0c9c0400 },
	{ _MMIO(0x9888), 0x0c9dc000 },
	{ _MMIO(0x9888), 0x0e9dc000 },
	{ _MMIO(0x9888), 0x0c9e0400 },
	{ _MMIO(0x9888), 0x109f02a8 },
	{ _MMIO(0x9888), 0x0e9f0040 },
	{ _MMIO(0x9888), 0x0cb95000 },
	{ _MMIO(0x9888), 0x0eb95000 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x0d880400 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x258b8009 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x198c4000 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x0d8c4000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x078d2000 },
	{ _MMIO(0x9888), 0x2185800a },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x1b830154 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x45800800 },
	{ _MMIO(0x9888), 0x47800842 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f801084 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800044 },
};

static int
get_l3_4_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_l3_4;
	lens[n] = ARRAY_SIZE(mux_config_l3_4);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2770), 0x00006000 },
	{ _MMIO(0x2774), 0x0000f3ff },
	{ _MMIO(0x2778), 0x00001800 },
	{ _MMIO(0x277c), 0x0000fcff },
	{ _MMIO(0x2780), 0x00000600 },
	{ _MMIO(0x2784), 0x0000ff3f },
	{ _MMIO(0x2788), 0x00000180 },
	{ _MMIO(0x278c), 0x0000ffcf },
	{ _MMIO(0x2790), 0x00000060 },
	{ _MMIO(0x2794), 0x0000fff3 },
	{ _MMIO(0x2798), 0x00000018 },
	{ _MMIO(0x279c), 0x0000fffc },
};

static const struct i915_oa_reg flex_eu_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0x9888), 0x143b000e },
	{ _MMIO(0x9888), 0x043c55c0 },
	{ _MMIO(0x9888), 0x0a1e0280 },
	{ _MMIO(0x9888), 0x0c1e0408 },
	{ _MMIO(0x9888), 0x10390000 },
	{ _MMIO(0x9888), 0x12397a1f },
	{ _MMIO(0x9888), 0x14bb000e },
	{ _MMIO(0x9888), 0x04bc5000 },
	{ _MMIO(0x9888), 0x0a9e0296 },
	{ _MMIO(0x9888), 0x0c9e0008 },
	{ _MMIO(0x9888), 0x10b90000 },
	{ _MMIO(0x9888), 0x12b97a1f },
	{ _MMIO(0x9888), 0x063b0042 },
	{ _MMIO(0x9888), 0x103b0000 },
	{ _MMIO(0x9888), 0x083c0000 },
	{ _MMIO(0x9888), 0x0a3e0040 },
	{ _MMIO(0x9888), 0x043f8000 },
	{ _MMIO(0x9888), 0x02594000 },
	{ _MMIO(0x9888), 0x045a8000 },
	{ _MMIO(0x9888), 0x0c1c0400 },
	{ _MMIO(0x9888), 0x041d8000 },
	{ _MMIO(0x9888), 0x081e02c0 },
	{ _MMIO(0x9888), 0x0e1e0000 },
	{ _MMIO(0x9888), 0x0c1fa800 },
	{ _MMIO(0x9888), 0x0e1f0260 },
	{ _MMIO(0x9888), 0x101f0014 },
	{ _MMIO(0x9888), 0x003905e0 },
	{ _MMIO(0x9888), 0x06390bc0 },
	{ _MMIO(0x9888), 0x02390018 },
	{ _MMIO(0x9888), 0x04394000 },
	{ _MMIO(0x9888), 0x04bb0042 },
	{ _MMIO(0x9888), 0x10bb0000 },
	{ _MMIO(0x9888), 0x02bc05c0 },
	{ _MMIO(0x9888), 0x08bc0000 },
	{ _MMIO(0x9888), 0x0abe0004 },
	{ _MMIO(0x9888), 0x02bf8000 },
	{ _MMIO(0x9888), 0x02d91000 },
	{ _MMIO(0x9888), 0x02da8000 },
	{ _MMIO(0x9888), 0x089c8000 },
	{ _MMIO(0x9888), 0x029d8000 },
	{ _MMIO(0x9888), 0x089e8000 },
	{ _MMIO(0x9888), 0x0e9e0000 },
	{ _MMIO(0x9888), 0x0e9fa806 },
	{ _MMIO(0x9888), 0x109f0142 },
	{ _MMIO(0x9888), 0x08b90617 },
	{ _MMIO(0x9888), 0x0ab90be0 },
	{ _MMIO(0x9888), 0x02b94000 },
	{ _MMIO(0x9888), 0x0d88f000 },
	{ _MMIO(0x9888), 0x0f88000c },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x09888000 },
	{ _MMIO(0x9888), 0x018a8000 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x1b8a2800 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x238b52a0 },
	{ _MMIO(0x9888), 0x258b6a95 },
	{ _MMIO(0x9888), 0x278b0029 },
	{ _MMIO(0x9888), 0x178c2000 },
	{ _MMIO(0x9888), 0x198c1500 },
	{ _MMIO(0x9888), 0x1b8c0014 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x098c4000 },
	{ _MMIO(0x9888), 0x098da000 },
	{ _MMIO(0x9888), 0x0b8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x038d8000 },
	{ _MMIO(0x9888), 0x058d2000 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaaa },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x0784c000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x1780c000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x4d800444 },
	{ _MMIO(0x9888), 0x3d800000 },
	{ _MMIO(0x9888), 0x4f804000 },
	{ _MMIO(0x9888), 0x43801080 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800084 },
	{ _MMIO(0x9888), 0x53800044 },
	{ _MMIO(0x9888), 0x47801080 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800000 },
	{ _MMIO(0x9888), 0x41800840 },
};

static int
get_rasterizer_and_pixel_backend_mux_config(struct drm_i915_private *dev_priv,
					    const struct i915_oa_reg **regs,
					    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_rasterizer_and_pixel_backend;
	lens[n] = ARRAY_SIZE(mux_config_rasterizer_and_pixel_backend);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_sampler_1[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x70800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x0000c000 },
	{ _MMIO(0x2774), 0x0000e7ff },
	{ _MMIO(0x2778), 0x00003000 },
	{ _MMIO(0x277c), 0x0000f9ff },
	{ _MMIO(0x2780), 0x00000c00 },
	{ _MMIO(0x2784), 0x0000fe7f },
};

static const struct i915_oa_reg flex_eu_config_sampler_1[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_sampler_1[] = {
	{ _MMIO(0x9888), 0x18921400 },
	{ _MMIO(0x9888), 0x149500ab },
	{ _MMIO(0x9888), 0x18b21400 },
	{ _MMIO(0x9888), 0x14b500ab },
	{ _MMIO(0x9888), 0x18d21400 },
	{ _MMIO(0x9888), 0x14d500ab },
	{ _MMIO(0x9888), 0x0cdc8000 },
	{ _MMIO(0x9888), 0x0edc4000 },
	{ _MMIO(0x9888), 0x02dcc000 },
	{ _MMIO(0x9888), 0x04dcc000 },
	{ _MMIO(0x9888), 0x1abd00a0 },
	{ _MMIO(0x9888), 0x0abd8000 },
	{ _MMIO(0x9888), 0x0cd88000 },
	{ _MMIO(0x9888), 0x0ed84000 },
	{ _MMIO(0x9888), 0x04d88000 },
	{ _MMIO(0x9888), 0x1adb0050 },
	{ _MMIO(0x9888), 0x04db8000 },
	{ _MMIO(0x9888), 0x06db8000 },
	{ _MMIO(0x9888), 0x08db8000 },
	{ _MMIO(0x9888), 0x0adb4000 },
	{ _MMIO(0x9888), 0x109f02a0 },
	{ _MMIO(0x9888), 0x0c9fa000 },
	{ _MMIO(0x9888), 0x0e9f00aa },
	{ _MMIO(0x9888), 0x18b82500 },
	{ _MMIO(0x9888), 0x02b88000 },
	{ _MMIO(0x9888), 0x04b84000 },
	{ _MMIO(0x9888), 0x06b84000 },
	{ _MMIO(0x9888), 0x08b84000 },
	{ _MMIO(0x9888), 0x0ab84000 },
	{ _MMIO(0x9888), 0x0cb88000 },
	{ _MMIO(0x9888), 0x0cb98000 },
	{ _MMIO(0x9888), 0x0eb9a000 },
	{ _MMIO(0x9888), 0x00b98000 },
	{ _MMIO(0x9888), 0x02b9a000 },
	{ _MMIO(0x9888), 0x04b9a000 },
	{ _MMIO(0x9888), 0x06b92000 },
	{ _MMIO(0x9888), 0x1aba0200 },
	{ _MMIO(0x9888), 0x02ba8000 },
	{ _MMIO(0x9888), 0x0cba8000 },
	{ _MMIO(0x9888), 0x04908000 },
	{ _MMIO(0x9888), 0x04918000 },
	{ _MMIO(0x9888), 0x04927300 },
	{ _MMIO(0x9888), 0x10920000 },
	{ _MMIO(0x9888), 0x1893000a },
	{ _MMIO(0x9888), 0x0a934000 },
	{ _MMIO(0x9888), 0x0a946000 },
	{ _MMIO(0x9888), 0x0c959000 },
	{ _MMIO(0x9888), 0x0e950098 },
	{ _MMIO(0x9888), 0x10950000 },
	{ _MMIO(0x9888), 0x04b04000 },
	{ _MMIO(0x9888), 0x04b14000 },
	{ _MMIO(0x9888), 0x04b20073 },
	{ _MMIO(0x9888), 0x10b20000 },
	{ _MMIO(0x9888), 0x04b38000 },
	{ _MMIO(0x9888), 0x06b38000 },
	{ _MMIO(0x9888), 0x08b34000 },
	{ _MMIO(0x9888), 0x04b4c000 },
	{ _MMIO(0x9888), 0x02b59890 },
	{ _MMIO(0x9888), 0x10b50000 },
	{ _MMIO(0x9888), 0x06d04000 },
	{ _MMIO(0x9888), 0x06d14000 },
	{ _MMIO(0x9888), 0x06d20073 },
	{ _MMIO(0x9888), 0x10d20000 },
	{ _MMIO(0x9888), 0x18d30020 },
	{ _MMIO(0x9888), 0x02d38000 },
	{ _MMIO(0x9888), 0x0cd34000 },
	{ _MMIO(0x9888), 0x0ad48000 },
	{ _MMIO(0x9888), 0x04d42000 },
	{ _MMIO(0x9888), 0x0ed59000 },
	{ _MMIO(0x9888), 0x00d59800 },
	{ _MMIO(0x9888), 0x10d50000 },
	{ _MMIO(0x9888), 0x0f88000e },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x09888000 },
	{ _MMIO(0x9888), 0x0b888000 },
	{ _MMIO(0x9888), 0x0d880400 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b5500 },
	{ _MMIO(0x9888), 0x258b000a },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x098c4000 },
	{ _MMIO(0x9888), 0x0b8c4000 },
	{ _MMIO(0x9888), 0x0d8c4000 },
	{ _MMIO(0x9888), 0x0d8d8000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x018d8000 },
	{ _MMIO(0x9888), 0x038da000 },
	{ _MMIO(0x9888), 0x058da000 },
	{ _MMIO(0x9888), 0x078d2000 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x2185000a },
	{ _MMIO(0x9888), 0x1b830150 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d848000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d808000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47801021 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f800c64 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800c02 },
};

static int
get_sampler_1_mux_config(struct drm_i915_private *dev_priv,
			 const struct i915_oa_reg **regs,
			 int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_sampler_1;
	lens[n] = ARRAY_SIZE(mux_config_sampler_1);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_sampler_2[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x70800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x0000c000 },
	{ _MMIO(0x2774), 0x0000e7ff },
	{ _MMIO(0x2778), 0x00003000 },
	{ _MMIO(0x277c), 0x0000f9ff },
	{ _MMIO(0x2780), 0x00000c00 },
	{ _MMIO(0x2784), 0x0000fe7f },
};

static const struct i915_oa_reg flex_eu_config_sampler_2[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_sampler_2[] = {
	{ _MMIO(0x9888), 0x18121400 },
	{ _MMIO(0x9888), 0x141500ab },
	{ _MMIO(0x9888), 0x18321400 },
	{ _MMIO(0x9888), 0x143500ab },
	{ _MMIO(0x9888), 0x18521400 },
	{ _MMIO(0x9888), 0x145500ab },
	{ _MMIO(0x9888), 0x0c5c8000 },
	{ _MMIO(0x9888), 0x0e5c4000 },
	{ _MMIO(0x9888), 0x025cc000 },
	{ _MMIO(0x9888), 0x045cc000 },
	{ _MMIO(0x9888), 0x1a3d00a0 },
	{ _MMIO(0x9888), 0x0a3d8000 },
	{ _MMIO(0x9888), 0x0c588000 },
	{ _MMIO(0x9888), 0x0e584000 },
	{ _MMIO(0x9888), 0x04588000 },
	{ _MMIO(0x9888), 0x1a5b0050 },
	{ _MMIO(0x9888), 0x045b8000 },
	{ _MMIO(0x9888), 0x065b8000 },
	{ _MMIO(0x9888), 0x085b8000 },
	{ _MMIO(0x9888), 0x0a5b4000 },
	{ _MMIO(0x9888), 0x101f02a0 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f00aa },
	{ _MMIO(0x9888), 0x18382500 },
	{ _MMIO(0x9888), 0x02388000 },
	{ _MMIO(0x9888), 0x04384000 },
	{ _MMIO(0x9888), 0x06384000 },
	{ _MMIO(0x9888), 0x08384000 },
	{ _MMIO(0x9888), 0x0a384000 },
	{ _MMIO(0x9888), 0x0c388000 },
	{ _MMIO(0x9888), 0x0c398000 },
	{ _MMIO(0x9888), 0x0e39a000 },
	{ _MMIO(0x9888), 0x00398000 },
	{ _MMIO(0x9888), 0x0239a000 },
	{ _MMIO(0x9888), 0x0439a000 },
	{ _MMIO(0x9888), 0x06392000 },
	{ _MMIO(0x9888), 0x1a3a0200 },
	{ _MMIO(0x9888), 0x023a8000 },
	{ _MMIO(0x9888), 0x0c3a8000 },
	{ _MMIO(0x9888), 0x04108000 },
	{ _MMIO(0x9888), 0x04118000 },
	{ _MMIO(0x9888), 0x04127300 },
	{ _MMIO(0x9888), 0x10120000 },
	{ _MMIO(0x9888), 0x1813000a },
	{ _MMIO(0x9888), 0x0a134000 },
	{ _MMIO(0x9888), 0x0a146000 },
	{ _MMIO(0x9888), 0x0c159000 },
	{ _MMIO(0x9888), 0x0e150098 },
	{ _MMIO(0x9888), 0x10150000 },
	{ _MMIO(0x9888), 0x04304000 },
	{ _MMIO(0x9888), 0x04314000 },
	{ _MMIO(0x9888), 0x04320073 },
	{ _MMIO(0x9888), 0x10320000 },
	{ _MMIO(0x9888), 0x04338000 },
	{ _MMIO(0x9888), 0x06338000 },
	{ _MMIO(0x9888), 0x08334000 },
	{ _MMIO(0x9888), 0x0434c000 },
	{ _MMIO(0x9888), 0x02359890 },
	{ _MMIO(0x9888), 0x10350000 },
	{ _MMIO(0x9888), 0x06504000 },
	{ _MMIO(0x9888), 0x06514000 },
	{ _MMIO(0x9888), 0x06520073 },
	{ _MMIO(0x9888), 0x10520000 },
	{ _MMIO(0x9888), 0x18530020 },
	{ _MMIO(0x9888), 0x02538000 },
	{ _MMIO(0x9888), 0x0c534000 },
	{ _MMIO(0x9888), 0x0a548000 },
	{ _MMIO(0x9888), 0x04542000 },
	{ _MMIO(0x9888), 0x0e559000 },
	{ _MMIO(0x9888), 0x00559800 },
	{ _MMIO(0x9888), 0x10550000 },
	{ _MMIO(0x9888), 0x1b8aa000 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x278b0015 },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x258b0005 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x2185000a },
	{ _MMIO(0x9888), 0x1b830150 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d848000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d808000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47801021 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f800c64 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800c02 },
};

static int
get_sampler_2_mux_config(struct drm_i915_private *dev_priv,
			 const struct i915_oa_reg **regs,
			 int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_sampler_2;
	lens[n] = ARRAY_SIZE(mux_config_sampler_2);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_tdl_1[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x0000fdff },
	{ _MMIO(0x2778), 0x00000000 },
	{ _MMIO(0x277c), 0x0000fe7f },
	{ _MMIO(0x2780), 0x00000002 },
	{ _MMIO(0x2784), 0x0000ffbf },
	{ _MMIO(0x2788), 0x00000000 },
	{ _MMIO(0x278c), 0x0000ffcf },
	{ _MMIO(0x2790), 0x00000002 },
	{ _MMIO(0x2794), 0x0000fff7 },
	{ _MMIO(0x2798), 0x00000000 },
	{ _MMIO(0x279c), 0x0000fff9 },
};

static const struct i915_oa_reg flex_eu_config_tdl_1[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_tdl_1[] = {
	{ _MMIO(0x9888), 0x16154d60 },
	{ _MMIO(0x9888), 0x16352e60 },
	{ _MMIO(0x9888), 0x16554d60 },
	{ _MMIO(0x9888), 0x16950000 },
	{ _MMIO(0x9888), 0x16b50000 },
	{ _MMIO(0x9888), 0x16d50000 },
	{ _MMIO(0x9888), 0x005c8000 },
	{ _MMIO(0x9888), 0x045cc000 },
	{ _MMIO(0x9888), 0x065c4000 },
	{ _MMIO(0x9888), 0x083d8000 },
	{ _MMIO(0x9888), 0x0a3d8000 },
	{ _MMIO(0x9888), 0x0458c000 },
	{ _MMIO(0x9888), 0x025b8000 },
	{ _MMIO(0x9888), 0x085b4000 },
	{ _MMIO(0x9888), 0x0a5b4000 },
	{ _MMIO(0x9888), 0x0c5b8000 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f00aa },
	{ _MMIO(0x9888), 0x02384000 },
	{ _MMIO(0x9888), 0x04388000 },
	{ _MMIO(0x9888), 0x06388000 },
	{ _MMIO(0x9888), 0x08384000 },
	{ _MMIO(0x9888), 0x0a384000 },
	{ _MMIO(0x9888), 0x0c384000 },
	{ _MMIO(0x9888), 0x00398000 },
	{ _MMIO(0x9888), 0x0239a000 },
	{ _MMIO(0x9888), 0x0439a000 },
	{ _MMIO(0x9888), 0x06392000 },
	{ _MMIO(0x9888), 0x043a8000 },
	{ _MMIO(0x9888), 0x063a8000 },
	{ _MMIO(0x9888), 0x08138000 },
	{ _MMIO(0x9888), 0x0a138000 },
	{ _MMIO(0x9888), 0x06143000 },
	{ _MMIO(0x9888), 0x0415cfc7 },
	{ _MMIO(0x9888), 0x10150000 },
	{ _MMIO(0x9888), 0x02338000 },
	{ _MMIO(0x9888), 0x0c338000 },
	{ _MMIO(0x9888), 0x04342000 },
	{ _MMIO(0x9888), 0x06344000 },
	{ _MMIO(0x9888), 0x0035c700 },
	{ _MMIO(0x9888), 0x063500cf },
	{ _MMIO(0x9888), 0x10350000 },
	{ _MMIO(0x9888), 0x04538000 },
	{ _MMIO(0x9888), 0x06538000 },
	{ _MMIO(0x9888), 0x0454c000 },
	{ _MMIO(0x9888), 0x0255cfc7 },
	{ _MMIO(0x9888), 0x10550000 },
	{ _MMIO(0x9888), 0x06dc8000 },
	{ _MMIO(0x9888), 0x08dc4000 },
	{ _MMIO(0x9888), 0x0cdcc000 },
	{ _MMIO(0x9888), 0x0edcc000 },
	{ _MMIO(0x9888), 0x1abd00a8 },
	{ _MMIO(0x9888), 0x0cd8c000 },
	{ _MMIO(0x9888), 0x0ed84000 },
	{ _MMIO(0x9888), 0x0edb8000 },
	{ _MMIO(0x9888), 0x18db0800 },
	{ _MMIO(0x9888), 0x1adb0254 },
	{ _MMIO(0x9888), 0x0e9faa00 },
	{ _MMIO(0x9888), 0x109f02aa },
	{ _MMIO(0x9888), 0x0eb84000 },
	{ _MMIO(0x9888), 0x16b84000 },
	{ _MMIO(0x9888), 0x18b8156a },
	{ _MMIO(0x9888), 0x06b98000 },
	{ _MMIO(0x9888), 0x08b9a000 },
	{ _MMIO(0x9888), 0x0ab9a000 },
	{ _MMIO(0x9888), 0x0cb9a000 },
	{ _MMIO(0x9888), 0x0eb9a000 },
	{ _MMIO(0x9888), 0x18baa000 },
	{ _MMIO(0x9888), 0x1aba0002 },
	{ _MMIO(0x9888), 0x16934000 },
	{ _MMIO(0x9888), 0x1893000a },
	{ _MMIO(0x9888), 0x0a947000 },
	{ _MMIO(0x9888), 0x0c95c5c1 },
	{ _MMIO(0x9888), 0x0e9500c3 },
	{ _MMIO(0x9888), 0x10950000 },
	{ _MMIO(0x9888), 0x0eb38000 },
	{ _MMIO(0x9888), 0x16b30040 },
	{ _MMIO(0x9888), 0x18b30020 },
	{ _MMIO(0x9888), 0x06b48000 },
	{ _MMIO(0x9888), 0x08b41000 },
	{ _MMIO(0x9888), 0x0ab48000 },
	{ _MMIO(0x9888), 0x06b5c500 },
	{ _MMIO(0x9888), 0x08b500c3 },
	{ _MMIO(0x9888), 0x0eb5c100 },
	{ _MMIO(0x9888), 0x10b50000 },
	{ _MMIO(0x9888), 0x16d31500 },
	{ _MMIO(0x9888), 0x08d4e000 },
	{ _MMIO(0x9888), 0x08d5c100 },
	{ _MMIO(0x9888), 0x0ad5c3c5 },
	{ _MMIO(0x9888), 0x10d50000 },
	{ _MMIO(0x9888), 0x0d88f800 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x258baaa5 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x0f8c4000 },
	{ _MMIO(0x9888), 0x178c2000 },
	{ _MMIO(0x9888), 0x198c5500 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x078d8000 },
	{ _MMIO(0x9888), 0x098da000 },
	{ _MMIO(0x9888), 0x0b8da000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x2185aaaa },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0784c000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1780c000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800c42 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800063 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800800 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f8014a4 },
	{ _MMIO(0x9888), 0x41801042 },
};

static int
get_tdl_1_mux_config(struct drm_i915_private *dev_priv,
		     const struct i915_oa_reg **regs,
		     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_tdl_1;
	lens[n] = ARRAY_SIZE(mux_config_tdl_1);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_tdl_2[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x0000fdff },
	{ _MMIO(0x2778), 0x00000000 },
	{ _MMIO(0x277c), 0x0000fe7f },
	{ _MMIO(0x2780), 0x00000000 },
	{ _MMIO(0x2784), 0x0000ff9f },
	{ _MMIO(0x2788), 0x00000000 },
	{ _MMIO(0x278c), 0x0000ffe7 },
	{ _MMIO(0x2790), 0x00000002 },
	{ _MMIO(0x2794), 0x0000fffb },
	{ _MMIO(0x2798), 0x00000002 },
	{ _MMIO(0x279c), 0x0000fffd },
};

static const struct i915_oa_reg flex_eu_config_tdl_2[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_tdl_2[] = {
	{ _MMIO(0x9888), 0x16150000 },
	{ _MMIO(0x9888), 0x16350000 },
	{ _MMIO(0x9888), 0x16550000 },
	{ _MMIO(0x9888), 0x16952e60 },
	{ _MMIO(0x9888), 0x16b54d60 },
	{ _MMIO(0x9888), 0x16d52e60 },
	{ _MMIO(0x9888), 0x065c8000 },
	{ _MMIO(0x9888), 0x085cc000 },
	{ _MMIO(0x9888), 0x0a5cc000 },
	{ _MMIO(0x9888), 0x0c5c4000 },
	{ _MMIO(0x9888), 0x0e3d8000 },
	{ _MMIO(0x9888), 0x183da000 },
	{ _MMIO(0x9888), 0x06588000 },
	{ _MMIO(0x9888), 0x08588000 },
	{ _MMIO(0x9888), 0x0a584000 },
	{ _MMIO(0x9888), 0x0e5b4000 },
	{ _MMIO(0x9888), 0x185b5800 },
	{ _MMIO(0x9888), 0x1a5b000a },
	{ _MMIO(0x9888), 0x0e1faa00 },
	{ _MMIO(0x9888), 0x101f02aa },
	{ _MMIO(0x9888), 0x0e384000 },
	{ _MMIO(0x9888), 0x16384000 },
	{ _MMIO(0x9888), 0x18382a55 },
	{ _MMIO(0x9888), 0x06398000 },
	{ _MMIO(0x9888), 0x0839a000 },
	{ _MMIO(0x9888), 0x0a39a000 },
	{ _MMIO(0x9888), 0x0c39a000 },
	{ _MMIO(0x9888), 0x0e39a000 },
	{ _MMIO(0x9888), 0x1a3a02a0 },
	{ _MMIO(0x9888), 0x0e138000 },
	{ _MMIO(0x9888), 0x16130500 },
	{ _MMIO(0x9888), 0x06148000 },
	{ _MMIO(0x9888), 0x08146000 },
	{ _MMIO(0x9888), 0x0615c100 },
	{ _MMIO(0x9888), 0x0815c500 },
	{ _MMIO(0x9888), 0x0a1500c3 },
	{ _MMIO(0x9888), 0x10150000 },
	{ _MMIO(0x9888), 0x16335040 },
	{ _MMIO(0x9888), 0x08349000 },
	{ _MMIO(0x9888), 0x0a341000 },
	{ _MMIO(0x9888), 0x083500c1 },
	{ _MMIO(0x9888), 0x0a35c500 },
	{ _MMIO(0x9888), 0x0c3500c3 },
	{ _MMIO(0x9888), 0x10350000 },
	{ _MMIO(0x9888), 0x1853002a },
	{ _MMIO(0x9888), 0x0a54e000 },
	{ _MMIO(0x9888), 0x0c55c500 },
	{ _MMIO(0x9888), 0x0e55c1c3 },
	{ _MMIO(0x9888), 0x10550000 },
	{ _MMIO(0x9888), 0x00dc8000 },
	{ _MMIO(0x9888), 0x02dcc000 },
	{ _MMIO(0x9888), 0x04dc4000 },
	{ _MMIO(0x9888), 0x04bd8000 },
	{ _MMIO(0x9888), 0x06bd8000 },
	{ _MMIO(0x9888), 0x02d8c000 },
	{ _MMIO(0x9888), 0x02db8000 },
	{ _MMIO(0x9888), 0x04db4000 },
	{ _MMIO(0x9888), 0x06db4000 },
	{ _MMIO(0x9888), 0x08db8000 },
	{ _MMIO(0x9888), 0x0c9fa000 },
	{ _MMIO(0x9888), 0x0e9f00aa },
	{ _MMIO(0x9888), 0x02b84000 },
	{ _MMIO(0x9888), 0x04b84000 },
	{ _MMIO(0x9888), 0x06b84000 },
	{ _MMIO(0x9888), 0x08b84000 },
	{ _MMIO(0x9888), 0x0ab88000 },
	{ _MMIO(0x9888), 0x0cb88000 },
	{ _MMIO(0x9888), 0x00b98000 },
	{ _MMIO(0x9888), 0x02b9a000 },
	{ _MMIO(0x9888), 0x04b9a000 },
	{ _MMIO(0x9888), 0x06b92000 },
	{ _MMIO(0x9888), 0x0aba8000 },
	{ _MMIO(0x9888), 0x0cba8000 },
	{ _MMIO(0x9888), 0x04938000 },
	{ _MMIO(0x9888), 0x06938000 },
	{ _MMIO(0x9888), 0x0494c000 },
	{ _MMIO(0x9888), 0x0295cfc7 },
	{ _MMIO(0x9888), 0x10950000 },
	{ _MMIO(0x9888), 0x02b38000 },
	{ _MMIO(0x9888), 0x08b38000 },
	{ _MMIO(0x9888), 0x04b42000 },
	{ _MMIO(0x9888), 0x06b41000 },
	{ _MMIO(0x9888), 0x00b5c700 },
	{ _MMIO(0x9888), 0x04b500cf },
	{ _MMIO(0x9888), 0x10b50000 },
	{ _MMIO(0x9888), 0x0ad38000 },
	{ _MMIO(0x9888), 0x0cd38000 },
	{ _MMIO(0x9888), 0x06d46000 },
	{ _MMIO(0x9888), 0x04d5c700 },
	{ _MMIO(0x9888), 0x06d500cf },
	{ _MMIO(0x9888), 0x10d50000 },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x09888000 },
	{ _MMIO(0x9888), 0x0b888000 },
	{ _MMIO(0x9888), 0x0d880400 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x198a8000 },
	{ _MMIO(0x9888), 0x1b8aaaa0 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x258b555a },
	{ _MMIO(0x9888), 0x278b0015 },
	{ _MMIO(0x9888), 0x238b5500 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x098c4000 },
	{ _MMIO(0x9888), 0x0b8c4000 },
	{ _MMIO(0x9888), 0x0d8c4000 },
	{ _MMIO(0x9888), 0x018d8000 },
	{ _MMIO(0x9888), 0x038da000 },
	{ _MMIO(0x9888), 0x058da000 },
	{ _MMIO(0x9888), 0x078d2000 },
	{ _MMIO(0x9888), 0x2185aaaa },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0784c000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1780c000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800882 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45801082 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x478014a5 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f800002 },
	{ _MMIO(0x9888), 0x41800c62 },
};

static int
get_tdl_2_mux_config(struct drm_i915_private *dev_priv,
		     const struct i915_oa_reg **regs,
		     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_tdl_2;
	lens[n] = ARRAY_SIZE(mux_config_tdl_2);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_extra[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
};

static const struct i915_oa_reg flex_eu_config_compute_extra[] = {
	{ _MMIO(0xe458), 0x00001000 },
	{ _MMIO(0xe558), 0x00003002 },
	{ _MMIO(0xe658), 0x00005004 },
	{ _MMIO(0xe758), 0x00011010 },
	{ _MMIO(0xe45c), 0x00050012 },
	{ _MMIO(0xe55c), 0x00052051 },
	{ _MMIO(0xe65c), 0x00000008 },
};

static const struct i915_oa_reg mux_config_compute_extra[] = {
	{ _MMIO(0x9888), 0x161503e0 },
	{ _MMIO(0x9888), 0x163503e0 },
	{ _MMIO(0x9888), 0x165503e0 },
	{ _MMIO(0x9888), 0x169503e0 },
	{ _MMIO(0x9888), 0x16b503e0 },
	{ _MMIO(0x9888), 0x16d503e0 },
	{ _MMIO(0x9888), 0x045cc000 },
	{ _MMIO(0x9888), 0x083d8000 },
	{ _MMIO(0x9888), 0x04584000 },
	{ _MMIO(0x9888), 0x085b4000 },
	{ _MMIO(0x9888), 0x0a5b8000 },
	{ _MMIO(0x9888), 0x0e1f00a8 },
	{ _MMIO(0x9888), 0x08384000 },
	{ _MMIO(0x9888), 0x0a384000 },
	{ _MMIO(0x9888), 0x0c388000 },
	{ _MMIO(0x9888), 0x0439a000 },
	{ _MMIO(0x9888), 0x06392000 },
	{ _MMIO(0x9888), 0x0c3a8000 },
	{ _MMIO(0x9888), 0x08138000 },
	{ _MMIO(0x9888), 0x06141000 },
	{ _MMIO(0x9888), 0x041500c3 },
	{ _MMIO(0x9888), 0x10150000 },
	{ _MMIO(0x9888), 0x0a338000 },
	{ _MMIO(0x9888), 0x06342000 },
	{ _MMIO(0x9888), 0x0435c300 },
	{ _MMIO(0x9888), 0x10350000 },
	{ _MMIO(0x9888), 0x0c538000 },
	{ _MMIO(0x9888), 0x06544000 },
	{ _MMIO(0x9888), 0x065500c3 },
	{ _MMIO(0x9888), 0x10550000 },
	{ _MMIO(0x9888), 0x00dc8000 },
	{ _MMIO(0x9888), 0x02dc4000 },
	{ _MMIO(0x9888), 0x02bd8000 },
	{ _MMIO(0x9888), 0x00d88000 },
	{ _MMIO(0x9888), 0x02db4000 },
	{ _MMIO(0x9888), 0x04db8000 },
	{ _MMIO(0x9888), 0x0c9fa000 },
	{ _MMIO(0x9888), 0x0e9f0002 },
	{ _MMIO(0x9888), 0x02b84000 },
	{ _MMIO(0x9888), 0x04b84000 },
	{ _MMIO(0x9888), 0x06b88000 },
	{ _MMIO(0x9888), 0x00b98000 },
	{ _MMIO(0x9888), 0x02b9a000 },
	{ _MMIO(0x9888), 0x06ba8000 },
	{ _MMIO(0x9888), 0x02938000 },
	{ _MMIO(0x9888), 0x04942000 },
	{ _MMIO(0x9888), 0x0095c300 },
	{ _MMIO(0x9888), 0x10950000 },
	{ _MMIO(0x9888), 0x04b38000 },
	{ _MMIO(0x9888), 0x04b44000 },
	{ _MMIO(0x9888), 0x02b500c3 },
	{ _MMIO(0x9888), 0x10b50000 },
	{ _MMIO(0x9888), 0x06d38000 },
	{ _MMIO(0x9888), 0x04d48000 },
	{ _MMIO(0x9888), 0x02d5c300 },
	{ _MMIO(0x9888), 0x10d50000 },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x238b3500 },
	{ _MMIO(0x9888), 0x258b0005 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x018d8000 },
	{ _MMIO(0x9888), 0x038da000 },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x2185000a },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f800c40 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41801482 },
	{ _MMIO(0x9888), 0x31800000 },
};

static int
get_compute_extra_mux_config(struct drm_i915_private *dev_priv,
			     const struct i915_oa_reg **regs,
			     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_compute_extra;
	lens[n] = ARRAY_SIZE(mux_config_compute_extra);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_vme_pipe[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2770), 0x00100030 },
	{ _MMIO(0x2774), 0x0000fff9 },
	{ _MMIO(0x2778), 0x00000002 },
	{ _MMIO(0x277c), 0x0000fffc },
	{ _MMIO(0x2780), 0x00000002 },
	{ _MMIO(0x2784), 0x0000fff3 },
	{ _MMIO(0x2788), 0x00100180 },
	{ _MMIO(0x278c), 0x0000ffcf },
	{ _MMIO(0x2790), 0x00000002 },
	{ _MMIO(0x2794), 0x0000ffcf },
	{ _MMIO(0x2798), 0x00000002 },
	{ _MMIO(0x279c), 0x0000ff3f },
};

static const struct i915_oa_reg flex_eu_config_vme_pipe[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00008003 },
};

static const struct i915_oa_reg mux_config_vme_pipe[] = {
	{ _MMIO(0x9888), 0x14100812 },
	{ _MMIO(0x9888), 0x14125800 },
	{ _MMIO(0x9888), 0x161200c0 },
	{ _MMIO(0x9888), 0x14300812 },
	{ _MMIO(0x9888), 0x14325800 },
	{ _MMIO(0x9888), 0x163200c0 },
	{ _MMIO(0x9888), 0x005c4000 },
	{ _MMIO(0x9888), 0x065c8000 },
	{ _MMIO(0x9888), 0x085cc000 },
	{ _MMIO(0x9888), 0x0a5cc000 },
	{ _MMIO(0x9888), 0x0c5cc000 },
	{ _MMIO(0x9888), 0x003d8000 },
	{ _MMIO(0x9888), 0x0e3d8000 },
	{ _MMIO(0x9888), 0x183d2800 },
	{ _MMIO(0x9888), 0x00584000 },
	{ _MMIO(0x9888), 0x06588000 },
	{ _MMIO(0x9888), 0x0858c000 },
	{ _MMIO(0x9888), 0x005b4000 },
	{ _MMIO(0x9888), 0x0e5b4000 },
	{ _MMIO(0x9888), 0x185b9400 },
	{ _MMIO(0x9888), 0x1a5b002a },
	{ _MMIO(0x9888), 0x0c1f0800 },
	{ _MMIO(0x9888), 0x0e1faa00 },
	{ _MMIO(0x9888), 0x101f002a },
	{ _MMIO(0x9888), 0x00384000 },
	{ _MMIO(0x9888), 0x0e384000 },
	{ _MMIO(0x9888), 0x16384000 },
	{ _MMIO(0x9888), 0x18380155 },
	{ _MMIO(0x9888), 0x00392000 },
	{ _MMIO(0x9888), 0x06398000 },
	{ _MMIO(0x9888), 0x0839a000 },
	{ _MMIO(0x9888), 0x0a39a000 },
	{ _MMIO(0x9888), 0x0c39a000 },
	{ _MMIO(0x9888), 0x00100047 },
	{ _MMIO(0x9888), 0x06101a80 },
	{ _MMIO(0x9888), 0x10100000 },
	{ _MMIO(0x9888), 0x0810c000 },
	{ _MMIO(0x9888), 0x0811c000 },
	{ _MMIO(0x9888), 0x08126151 },
	{ _MMIO(0x9888), 0x10120000 },
	{ _MMIO(0x9888), 0x00134000 },
	{ _MMIO(0x9888), 0x0e134000 },
	{ _MMIO(0x9888), 0x161300a0 },
	{ _MMIO(0x9888), 0x0a301ac7 },
	{ _MMIO(0x9888), 0x10300000 },
	{ _MMIO(0x9888), 0x0c30c000 },
	{ _MMIO(0x9888), 0x0c31c000 },
	{ _MMIO(0x9888), 0x0c326151 },
	{ _MMIO(0x9888), 0x10320000 },
	{ _MMIO(0x9888), 0x16332a00 },
	{ _MMIO(0x9888), 0x18330001 },
	{ _MMIO(0x9888), 0x018a8000 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x198a8000 },
	{ _MMIO(0x9888), 0x1b8a2aa0 },
	{ _MMIO(0x9888), 0x238b0020 },
	{ _MMIO(0x9888), 0x258b5550 },
	{ _MMIO(0x9888), 0x278b0001 },
	{ _MMIO(0x9888), 0x1f850080 },
	{ _MMIO(0x9888), 0x2185aaa0 },
	{ _MMIO(0x9888), 0x23850002 },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830015 },
	{ _MMIO(0x9888), 0x01844000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x11804000 },
	{ _MMIO(0x9888), 0x17808000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3d800800 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800002 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800884 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800002 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
};

static int
get_vme_pipe_mux_config(struct drm_i915_private *dev_priv,
			const struct i915_oa_reg **regs,
			int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_vme_pipe;
	lens[n] = ARRAY_SIZE(mux_config_vme_pipe);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_test_oa[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2770), 0x00000004 },
	{ _MMIO(0x2774), 0x00000000 },
	{ _MMIO(0x2778), 0x00000003 },
	{ _MMIO(0x277c), 0x00000000 },
	{ _MMIO(0x2780), 0x00000007 },
	{ _MMIO(0x2784), 0x00000000 },
	{ _MMIO(0x2788), 0x00100002 },
	{ _MMIO(0x278c), 0x0000fff7 },
	{ _MMIO(0x2790), 0x00100002 },
	{ _MMIO(0x2794), 0x0000ffcf },
	{ _MMIO(0x2798), 0x00100082 },
	{ _MMIO(0x279c), 0x0000ffef },
	{ _MMIO(0x27a0), 0x001000c2 },
	{ _MMIO(0x27a4), 0x0000ffe7 },
	{ _MMIO(0x27a8), 0x00100001 },
	{ _MMIO(0x27ac), 0x0000ffe7 },
};

static const struct i915_oa_reg flex_eu_config_test_oa[] = {
};

static const struct i915_oa_reg mux_config_test_oa[] = {
	{ _MMIO(0x9888), 0x198b0000 },
	{ _MMIO(0x9888), 0x078b0066 },
	{ _MMIO(0x9888), 0x118b0000 },
	{ _MMIO(0x9888), 0x258b0000 },
	{ _MMIO(0x9888), 0x21850008 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800000 },
	{ _MMIO(0x9888), 0x31800000 },
};

static int
get_test_oa_mux_config(struct drm_i915_private *dev_priv,
		       const struct i915_oa_reg **regs,
		       int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_test_oa;
	lens[n] = ARRAY_SIZE(mux_config_test_oa);
	n++;

	return n;
}

int i915_oa_select_metric_set_bdw(struct drm_i915_private *dev_priv)
{
	dev_priv->perf.oa.n_mux_configs = 0;
	dev_priv->perf.oa.b_counter_regs = NULL;
	dev_priv->perf.oa.b_counter_regs_len = 0;
	dev_priv->perf.oa.flex_regs = NULL;
	dev_priv->perf.oa.flex_regs_len = 0;

	switch (dev_priv->perf.oa.metrics_set) {
	case METRIC_SET_ID_RENDER_BASIC:
		dev_priv->perf.oa.n_mux_configs =
			get_render_basic_mux_config(dev_priv,
						    dev_priv->perf.oa.mux_regs,
						    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RENDER_BASIC\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_render_basic;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_render_basic);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_render_basic;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_render_basic);

		return 0;
	case METRIC_SET_ID_COMPUTE_BASIC:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_basic_mux_config(dev_priv,
						     dev_priv->perf.oa.mux_regs,
						     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_BASIC\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_basic;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_basic);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_basic;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_basic);

		return 0;
	case METRIC_SET_ID_RENDER_PIPE_PROFILE:
		dev_priv->perf.oa.n_mux_configs =
			get_render_pipe_profile_mux_config(dev_priv,
							   dev_priv->perf.oa.mux_regs,
							   dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RENDER_PIPE_PROFILE\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_render_pipe_profile;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_render_pipe_profile);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_render_pipe_profile;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_render_pipe_profile);

		return 0;
	case METRIC_SET_ID_MEMORY_READS:
		dev_priv->perf.oa.n_mux_configs =
			get_memory_reads_mux_config(dev_priv,
						    dev_priv->perf.oa.mux_regs,
						    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"MEMORY_READS\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_memory_reads;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_memory_reads);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_memory_reads;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_memory_reads);

		return 0;
	case METRIC_SET_ID_MEMORY_WRITES:
		dev_priv->perf.oa.n_mux_configs =
			get_memory_writes_mux_config(dev_priv,
						     dev_priv->perf.oa.mux_regs,
						     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"MEMORY_WRITES\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_memory_writes;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_memory_writes);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_memory_writes;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_memory_writes);

		return 0;
	case METRIC_SET_ID_COMPUTE_EXTENDED:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_extended_mux_config(dev_priv,
							dev_priv->perf.oa.mux_regs,
							dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_EXTENDED\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_extended;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_extended);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_extended;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_extended);

		return 0;
	case METRIC_SET_ID_COMPUTE_L3_CACHE:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_l3_cache_mux_config(dev_priv,
							dev_priv->perf.oa.mux_regs,
							dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_L3_CACHE\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_l3_cache;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_l3_cache);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_l3_cache;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_l3_cache);

		return 0;
	case METRIC_SET_ID_DATA_PORT_READS_COALESCING:
		dev_priv->perf.oa.n_mux_configs =
			get_data_port_reads_coalescing_mux_config(dev_priv,
								  dev_priv->perf.oa.mux_regs,
								  dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"DATA_PORT_READS_COALESCING\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_data_port_reads_coalescing;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_data_port_reads_coalescing);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_data_port_reads_coalescing;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_data_port_reads_coalescing);

		return 0;
	case METRIC_SET_ID_DATA_PORT_WRITES_COALESCING:
		dev_priv->perf.oa.n_mux_configs =
			get_data_port_writes_coalescing_mux_config(dev_priv,
								   dev_priv->perf.oa.mux_regs,
								   dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"DATA_PORT_WRITES_COALESCING\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_data_port_writes_coalescing;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_data_port_writes_coalescing);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_data_port_writes_coalescing;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_data_port_writes_coalescing);

		return 0;
	case METRIC_SET_ID_HDC_AND_SF:
		dev_priv->perf.oa.n_mux_configs =
			get_hdc_and_sf_mux_config(dev_priv,
						  dev_priv->perf.oa.mux_regs,
						  dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"HDC_AND_SF\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_hdc_and_sf;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_hdc_and_sf);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_hdc_and_sf;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_hdc_and_sf);

		return 0;
	case METRIC_SET_ID_L3_1:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_1_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_1\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_1;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_1);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_1;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_1);

		return 0;
	case METRIC_SET_ID_L3_2:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_2_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_2\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_2;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_2);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_2;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_2);

		return 0;
	case METRIC_SET_ID_L3_3:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_3_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_3\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_3;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_3);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_3;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_3);

		return 0;
	case METRIC_SET_ID_L3_4:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_4_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_4\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_4;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_4);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_4;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_4);

		return 0;
	case METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND:
		dev_priv->perf.oa.n_mux_configs =
			get_rasterizer_and_pixel_backend_mux_config(dev_priv,
								    dev_priv->perf.oa.mux_regs,
								    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RASTERIZER_AND_PIXEL_BACKEND\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_rasterizer_and_pixel_backend;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_rasterizer_and_pixel_backend);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_rasterizer_and_pixel_backend;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_rasterizer_and_pixel_backend);

		return 0;
	case METRIC_SET_ID_SAMPLER_1:
		dev_priv->perf.oa.n_mux_configs =
			get_sampler_1_mux_config(dev_priv,
						 dev_priv->perf.oa.mux_regs,
						 dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"SAMPLER_1\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_sampler_1;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_sampler_1);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_sampler_1;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_sampler_1);

		return 0;
	case METRIC_SET_ID_SAMPLER_2:
		dev_priv->perf.oa.n_mux_configs =
			get_sampler_2_mux_config(dev_priv,
						 dev_priv->perf.oa.mux_regs,
						 dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"SAMPLER_2\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_sampler_2;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_sampler_2);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_sampler_2;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_sampler_2);

		return 0;
	case METRIC_SET_ID_TDL_1:
		dev_priv->perf.oa.n_mux_configs =
			get_tdl_1_mux_config(dev_priv,
					     dev_priv->perf.oa.mux_regs,
					     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TDL_1\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_tdl_1;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_tdl_1);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_tdl_1;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_tdl_1);

		return 0;
	case METRIC_SET_ID_TDL_2:
		dev_priv->perf.oa.n_mux_configs =
			get_tdl_2_mux_config(dev_priv,
					     dev_priv->perf.oa.mux_regs,
					     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TDL_2\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_tdl_2;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_tdl_2);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_tdl_2;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_tdl_2);

		return 0;
	case METRIC_SET_ID_COMPUTE_EXTRA:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_extra_mux_config(dev_priv,
						     dev_priv->perf.oa.mux_regs,
						     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_EXTRA\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_extra;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_extra);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_extra;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_extra);

		return 0;
	case METRIC_SET_ID_VME_PIPE:
		dev_priv->perf.oa.n_mux_configs =
			get_vme_pipe_mux_config(dev_priv,
						dev_priv->perf.oa.mux_regs,
						dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"VME_PIPE\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_vme_pipe;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_vme_pipe);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_vme_pipe;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_vme_pipe);

		return 0;
	case METRIC_SET_ID_TEST_OA:
		dev_priv->perf.oa.n_mux_configs =
			get_test_oa_mux_config(dev_priv,
					       dev_priv->perf.oa.mux_regs,
					       dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TEST_OA\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_test_oa;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_test_oa);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_test_oa;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_test_oa);

		return 0;
	default:
		return -ENODEV;
	}
}

static ssize_t
show_render_basic_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RENDER_BASIC);
}

static struct device_attribute dev_attr_render_basic_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_render_basic_id,
	.store = NULL,
};

static struct attribute *attrs_render_basic[] = {
	&dev_attr_render_basic_id.attr,
	NULL,
};

static struct attribute_group group_render_basic = {
	.name = "b541bd57-0e0f-4154-b4c0-5858010a2bf7",
	.attrs =  attrs_render_basic,
};

static ssize_t
show_compute_basic_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_BASIC);
}

static struct device_attribute dev_attr_compute_basic_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_basic_id,
	.store = NULL,
};

static struct attribute *attrs_compute_basic[] = {
	&dev_attr_compute_basic_id.attr,
	NULL,
};

static struct attribute_group group_compute_basic = {
	.name = "35fbc9b2-a891-40a6-a38d-022bb7057552",
	.attrs =  attrs_compute_basic,
};

static ssize_t
show_render_pipe_profile_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RENDER_PIPE_PROFILE);
}

static struct device_attribute dev_attr_render_pipe_profile_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_render_pipe_profile_id,
	.store = NULL,
};

static struct attribute *attrs_render_pipe_profile[] = {
	&dev_attr_render_pipe_profile_id.attr,
	NULL,
};

static struct attribute_group group_render_pipe_profile = {
	.name = "233d0544-fff7-4281-8291-e02f222aff72",
	.attrs =  attrs_render_pipe_profile,
};

static ssize_t
show_memory_reads_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_MEMORY_READS);
}

static struct device_attribute dev_attr_memory_reads_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_memory_reads_id,
	.store = NULL,
};

static struct attribute *attrs_memory_reads[] = {
	&dev_attr_memory_reads_id.attr,
	NULL,
};

static struct attribute_group group_memory_reads = {
	.name = "2b255d48-2117-4fef-a8f7-f151e1d25a2c",
	.attrs =  attrs_memory_reads,
};

static ssize_t
show_memory_writes_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_MEMORY_WRITES);
}

static struct device_attribute dev_attr_memory_writes_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_memory_writes_id,
	.store = NULL,
};

static struct attribute *attrs_memory_writes[] = {
	&dev_attr_memory_writes_id.attr,
	NULL,
};

static struct attribute_group group_memory_writes = {
	.name = "f7fd3220-b466-4a4d-9f98-b0caf3f2394c",
	.attrs =  attrs_memory_writes,
};

static ssize_t
show_compute_extended_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_EXTENDED);
}

static struct device_attribute dev_attr_compute_extended_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_extended_id,
	.store = NULL,
};

static struct attribute *attrs_compute_extended[] = {
	&dev_attr_compute_extended_id.attr,
	NULL,
};

static struct attribute_group group_compute_extended = {
	.name = "e99ccaca-821c-4df9-97a7-96bdb7204e43",
	.attrs =  attrs_compute_extended,
};

static ssize_t
show_compute_l3_cache_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_L3_CACHE);
}

static struct device_attribute dev_attr_compute_l3_cache_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_l3_cache_id,
	.store = NULL,
};

static struct attribute *attrs_compute_l3_cache[] = {
	&dev_attr_compute_l3_cache_id.attr,
	NULL,
};

static struct attribute_group group_compute_l3_cache = {
	.name = "27a364dc-8225-4ecb-b607-d6f1925598d9",
	.attrs =  attrs_compute_l3_cache,
};

static ssize_t
show_data_port_reads_coalescing_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_DATA_PORT_READS_COALESCING);
}

static struct device_attribute dev_attr_data_port_reads_coalescing_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_data_port_reads_coalescing_id,
	.store = NULL,
};

static struct attribute *attrs_data_port_reads_coalescing[] = {
	&dev_attr_data_port_reads_coalescing_id.attr,
	NULL,
};

static struct attribute_group group_data_port_reads_coalescing = {
	.name = "857fc630-2f09-4804-85f1-084adfadd5ab",
	.attrs =  attrs_data_port_reads_coalescing,
};

static ssize_t
show_data_port_writes_coalescing_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_DATA_PORT_WRITES_COALESCING);
}

static struct device_attribute dev_attr_data_port_writes_coalescing_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_data_port_writes_coalescing_id,
	.store = NULL,
};

static struct attribute *attrs_data_port_writes_coalescing[] = {
	&dev_attr_data_port_writes_coalescing_id.attr,
	NULL,
};

static struct attribute_group group_data_port_writes_coalescing = {
	.name = "343ebc99-4a55-414c-8c17-d8e259cf5e20",
	.attrs =  attrs_data_port_writes_coalescing,
};

static ssize_t
show_hdc_and_sf_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_HDC_AND_SF);
}

static struct device_attribute dev_attr_hdc_and_sf_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_hdc_and_sf_id,
	.store = NULL,
};

static struct attribute *attrs_hdc_and_sf[] = {
	&dev_attr_hdc_and_sf_id.attr,
	NULL,
};

static struct attribute_group group_hdc_and_sf = {
	.name = "7bdafd88-a4fa-4ed5-bc09-1a977aa5be3e",
	.attrs =  attrs_hdc_and_sf,
};

static ssize_t
show_l3_1_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_1);
}

static struct device_attribute dev_attr_l3_1_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_1_id,
	.store = NULL,
};

static struct attribute *attrs_l3_1[] = {
	&dev_attr_l3_1_id.attr,
	NULL,
};

static struct attribute_group group_l3_1 = {
	.name = "9385ebb2-f34f-4aa5-aec5-7e9cbbea0f0b",
	.attrs =  attrs_l3_1,
};

static ssize_t
show_l3_2_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_2);
}

static struct device_attribute dev_attr_l3_2_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_2_id,
	.store = NULL,
};

static struct attribute *attrs_l3_2[] = {
	&dev_attr_l3_2_id.attr,
	NULL,
};

static struct attribute_group group_l3_2 = {
	.name = "446ae59b-ff2e-41c9-b49e-0184a54bf00a",
	.attrs =  attrs_l3_2,
};

static ssize_t
show_l3_3_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_3);
}

static struct device_attribute dev_attr_l3_3_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_3_id,
	.store = NULL,
};

static struct attribute *attrs_l3_3[] = {
	&dev_attr_l3_3_id.attr,
	NULL,
};

static struct attribute_group group_l3_3 = {
	.name = "84a7956f-1ea4-4d0d-837f-e39a0376e38c",
	.attrs =  attrs_l3_3,
};

static ssize_t
show_l3_4_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_4);
}

static struct device_attribute dev_attr_l3_4_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_4_id,
	.store = NULL,
};

static struct attribute *attrs_l3_4[] = {
	&dev_attr_l3_4_id.attr,
	NULL,
};

static struct attribute_group group_l3_4 = {
	.name = "92b493d9-df18-4bed-be06-5cac6f2a6f5f",
	.attrs =  attrs_l3_4,
};

static ssize_t
show_rasterizer_and_pixel_backend_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND);
}

static struct device_attribute dev_attr_rasterizer_and_pixel_backend_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_rasterizer_and_pixel_backend_id,
	.store = NULL,
};

static struct attribute *attrs_rasterizer_and_pixel_backend[] = {
	&dev_attr_rasterizer_and_pixel_backend_id.attr,
	NULL,
};

static struct attribute_group group_rasterizer_and_pixel_backend = {
	.name = "14345c35-cc46-40d0-bb04-6ed1fbb43679",
	.attrs =  attrs_rasterizer_and_pixel_backend,
};

static ssize_t
show_sampler_1_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_SAMPLER_1);
}

static struct device_attribute dev_attr_sampler_1_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_sampler_1_id,
	.store = NULL,
};

static struct attribute *attrs_sampler_1[] = {
	&dev_attr_sampler_1_id.attr,
	NULL,
};

static struct attribute_group group_sampler_1 = {
	.name = "f0c6ba37-d3d3-4211-91b5-226730312a54",
	.attrs =  attrs_sampler_1,
};

static ssize_t
show_sampler_2_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_SAMPLER_2);
}

static struct device_attribute dev_attr_sampler_2_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_sampler_2_id,
	.store = NULL,
};

static struct attribute *attrs_sampler_2[] = {
	&dev_attr_sampler_2_id.attr,
	NULL,
};

static struct attribute_group group_sampler_2 = {
	.name = "30bf3702-48cf-4bca-b412-7cf50bb2f564",
	.attrs =  attrs_sampler_2,
};

static ssize_t
show_tdl_1_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TDL_1);
}

static struct device_attribute dev_attr_tdl_1_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_tdl_1_id,
	.store = NULL,
};

static struct attribute *attrs_tdl_1[] = {
	&dev_attr_tdl_1_id.attr,
	NULL,
};

static struct attribute_group group_tdl_1 = {
	.name = "238bec85-df05-44f3-b905-d166712f2451",
	.attrs =  attrs_tdl_1,
};

static ssize_t
show_tdl_2_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TDL_2);
}

static struct device_attribute dev_attr_tdl_2_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_tdl_2_id,
	.store = NULL,
};

static struct attribute *attrs_tdl_2[] = {
	&dev_attr_tdl_2_id.attr,
	NULL,
};

static struct attribute_group group_tdl_2 = {
	.name = "24bf02cd-8693-4583-981c-c4165b33da01",
	.attrs =  attrs_tdl_2,
};

static ssize_t
show_compute_extra_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_EXTRA);
}

static struct device_attribute dev_attr_compute_extra_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_extra_id,
	.store = NULL,
};

static struct attribute *attrs_compute_extra[] = {
	&dev_attr_compute_extra_id.attr,
	NULL,
};

static struct attribute_group group_compute_extra = {
	.name = "8fb61ba2-2fbb-454c-a136-2dec5a8a595e",
	.attrs =  attrs_compute_extra,
};

static ssize_t
show_vme_pipe_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_VME_PIPE);
}

static struct device_attribute dev_attr_vme_pipe_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_vme_pipe_id,
	.store = NULL,
};

static struct attribute *attrs_vme_pipe[] = {
	&dev_attr_vme_pipe_id.attr,
	NULL,
};

static struct attribute_group group_vme_pipe = {
	.name = "e1743ca0-7fc8-410b-a066-de7bbb9280b7",
	.attrs =  attrs_vme_pipe,
};

static ssize_t
show_test_oa_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TEST_OA);
}

static struct device_attribute dev_attr_test_oa_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_test_oa_id,
	.store = NULL,
};

static struct attribute *attrs_test_oa[] = {
	&dev_attr_test_oa_id.attr,
	NULL,
};

static struct attribute_group group_test_oa = {
	.name = "d6de6f55-e526-4f79-a6a6-d7315c09044e",
	.attrs =  attrs_test_oa,
};

int
i915_perf_register_sysfs_bdw(struct drm_i915_private *dev_priv)
{
	const struct i915_oa_reg *mux_regs[ARRAY_SIZE(dev_priv->perf.oa.mux_regs)];
	int mux_lens[ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens)];
	int ret = 0;

	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_render_basic);
		if (ret)
			goto error_render_basic;
	}
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
		if (ret)
			goto error_compute_basic;
	}
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
		if (ret)
			goto error_render_pipe_profile;
	}
	if (get_memory_reads_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_memory_reads);
		if (ret)
			goto error_memory_reads;
	}
	if (get_memory_writes_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_memory_writes);
		if (ret)
			goto error_memory_writes;
	}
	if (get_compute_extended_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_extended);
		if (ret)
			goto error_compute_extended;
	}
	if (get_compute_l3_cache_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_l3_cache);
		if (ret)
			goto error_compute_l3_cache;
	}
	if (get_data_port_reads_coalescing_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_data_port_reads_coalescing);
		if (ret)
			goto error_data_port_reads_coalescing;
	}
	if (get_data_port_writes_coalescing_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_data_port_writes_coalescing);
		if (ret)
			goto error_data_port_writes_coalescing;
	}
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
		if (ret)
			goto error_hdc_and_sf;
	}
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_1);
		if (ret)
			goto error_l3_1;
	}
	if (get_l3_2_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_2);
		if (ret)
			goto error_l3_2;
	}
	if (get_l3_3_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_3);
		if (ret)
			goto error_l3_3;
	}
	if (get_l3_4_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_4);
		if (ret)
			goto error_l3_4;
	}
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
		if (ret)
			goto error_rasterizer_and_pixel_backend;
	}
	if (get_sampler_1_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_sampler_1);
		if (ret)
			goto error_sampler_1;
	}
	if (get_sampler_2_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_sampler_2);
		if (ret)
			goto error_sampler_2;
	}
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
		if (ret)
			goto error_tdl_1;
	}
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
		if (ret)
			goto error_tdl_2;
	}
	if (get_compute_extra_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_extra);
		if (ret)
			goto error_compute_extra;
	}
	if (get_vme_pipe_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_vme_pipe);
		if (ret)
			goto error_vme_pipe;
	}
	if (get_test_oa_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_test_oa);
		if (ret)
			goto error_test_oa;
	}

	return 0;

error_test_oa:
	if (get_vme_pipe_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_vme_pipe);
error_vme_pipe:
	if (get_compute_extra_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extra);
error_compute_extra:
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
error_tdl_2:
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
error_tdl_1:
	if (get_sampler_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler_2);
error_sampler_2:
	if (get_sampler_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler_1);
error_sampler_1:
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
error_rasterizer_and_pixel_backend:
	if (get_l3_4_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_4);
error_l3_4:
	if (get_l3_3_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_3);
error_l3_3:
	if (get_l3_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_2);
error_l3_2:
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_1);
error_l3_1:
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
error_hdc_and_sf:
	if (get_data_port_writes_coalescing_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_data_port_writes_coalescing);
error_data_port_writes_coalescing:
	if (get_data_port_reads_coalescing_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_data_port_reads_coalescing);
error_data_port_reads_coalescing:
	if (get_compute_l3_cache_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_l3_cache);
error_compute_l3_cache:
	if (get_compute_extended_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extended);
error_compute_extended:
	if (get_memory_writes_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_writes);
error_memory_writes:
	if (get_memory_reads_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_reads);
error_memory_reads:
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
error_render_pipe_profile:
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
error_compute_basic:
	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_basic);
error_render_basic:
	return ret;
}

void
i915_perf_unregister_sysfs_bdw(struct drm_i915_private *dev_priv)
{
	const struct i915_oa_reg *mux_regs[ARRAY_SIZE(dev_priv->perf.oa.mux_regs)];
	int mux_lens[ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens)];

	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_basic);
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
	if (get_memory_reads_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_reads);
	if (get_memory_writes_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_writes);
	if (get_compute_extended_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extended);
	if (get_compute_l3_cache_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_l3_cache);
	if (get_data_port_reads_coalescing_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_data_port_reads_coalescing);
	if (get_data_port_writes_coalescing_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_data_port_writes_coalescing);
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_1);
	if (get_l3_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_2);
	if (get_l3_3_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_3);
	if (get_l3_4_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_4);
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
	if (get_sampler_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler_1);
	if (get_sampler_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler_2);
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
	if (get_compute_extra_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extra);
	if (get_vme_pipe_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_vme_pipe);
	if (get_test_oa_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_test_oa);
}
