/*
 * Autogenerated file by GPU Top : https://github.com/rib/gputop
 * DO NOT EDIT manually!
 *
 *
 * Copyright (c) 2015 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 */

#include <linux/sysfs.h>

#include "i915_drv.h"
#include "i915_oa_chv.h"

enum metric_set_id {
	METRIC_SET_ID_RENDER_BASIC = 1,
	METRIC_SET_ID_COMPUTE_BASIC,
	METRIC_SET_ID_RENDER_PIPE_PROFILE,
	METRIC_SET_ID_HDC_AND_SF,
	METRIC_SET_ID_L3_1,
	METRIC_SET_ID_L3_2,
	METRIC_SET_ID_L3_3,
	METRIC_SET_ID_L3_4,
	METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND,
	METRIC_SET_ID_SAMPLER_1,
	METRIC_SET_ID_SAMPLER_2,
	METRIC_SET_ID_TDL_1,
	METRIC_SET_ID_TDL_2,
	METRIC_SET_ID_TEST_OA,
};

int i915_oa_n_builtin_metric_sets_chv = 14;

static const struct i915_oa_reg b_counter_config_render_basic[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
};

static const struct i915_oa_reg flex_eu_config_render_basic[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_render_basic[] = {
	{ _MMIO(0x9888), 0x59800000 },
	{ _MMIO(0x9888), 0x59800001 },
	{ _MMIO(0x9888), 0x285a0006 },
	{ _MMIO(0x9888), 0x2c110014 },
	{ _MMIO(0x9888), 0x2e110000 },
	{ _MMIO(0x9888), 0x2c310014 },
	{ _MMIO(0x9888), 0x2e310000 },
	{ _MMIO(0x9888), 0x2b8303df },
	{ _MMIO(0x9888), 0x3580024f },
	{ _MMIO(0x9888), 0x00580888 },
	{ _MMIO(0x9888), 0x1e5a0015 },
	{ _MMIO(0x9888), 0x205a0014 },
	{ _MMIO(0x9888), 0x045a0000 },
	{ _MMIO(0x9888), 0x025a0000 },
	{ _MMIO(0x9888), 0x02180500 },
	{ _MMIO(0x9888), 0x00190555 },
	{ _MMIO(0x9888), 0x021d0500 },
	{ _MMIO(0x9888), 0x021f0a00 },
	{ _MMIO(0x9888), 0x00380444 },
	{ _MMIO(0x9888), 0x02390500 },
	{ _MMIO(0x9888), 0x003a0666 },
	{ _MMIO(0x9888), 0x00100111 },
	{ _MMIO(0x9888), 0x06110030 },
	{ _MMIO(0x9888), 0x0a110031 },
	{ _MMIO(0x9888), 0x0e110046 },
	{ _MMIO(0x9888), 0x04110000 },
	{ _MMIO(0x9888), 0x00110000 },
	{ _MMIO(0x9888), 0x00130111 },
	{ _MMIO(0x9888), 0x00300444 },
	{ _MMIO(0x9888), 0x08310030 },
	{ _MMIO(0x9888), 0x0c310031 },
	{ _MMIO(0x9888), 0x10310046 },
	{ _MMIO(0x9888), 0x04310000 },
	{ _MMIO(0x9888), 0x00310000 },
	{ _MMIO(0x9888), 0x00330444 },
	{ _MMIO(0x9888), 0x038a0a00 },
	{ _MMIO(0x9888), 0x018b0fff },
	{ _MMIO(0x9888), 0x038b0a00 },
	{ _MMIO(0x9888), 0x01855000 },
	{ _MMIO(0x9888), 0x03850055 },
	{ _MMIO(0x9888), 0x13830021 },
	{ _MMIO(0x9888), 0x15830020 },
	{ _MMIO(0x9888), 0x1783002f },
	{ _MMIO(0x9888), 0x1983002e },
	{ _MMIO(0x9888), 0x1b83002d },
	{ _MMIO(0x9888), 0x1d83002c },
	{ _MMIO(0x9888), 0x05830000 },
	{ _MMIO(0x9888), 0x01840555 },
	{ _MMIO(0x9888), 0x03840500 },
	{ _MMIO(0x9888), 0x23800074 },
	{ _MMIO(0x9888), 0x2580007d },
	{ _MMIO(0x9888), 0x05800000 },
	{ _MMIO(0x9888), 0x01805000 },
	{ _MMIO(0x9888), 0x03800055 },
	{ _MMIO(0x9888), 0x01865000 },
	{ _MMIO(0x9888), 0x03860055 },
	{ _MMIO(0x9888), 0x01875000 },
	{ _MMIO(0x9888), 0x03870055 },
	{ _MMIO(0x9888), 0x418000aa },
	{ _MMIO(0x9888), 0x4380000a },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x4780000a },
	{ _MMIO(0x9888), 0x49800000 },
	{ _MMIO(0x9888), 0x4b800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x55800000 },
	{ _MMIO(0x9888), 0x57800000 },
	{ _MMIO(0x9888), 0x59800000 },
};

static int
get_render_basic_mux_config(struct drm_i915_private *dev_priv,
			    const struct i915_oa_reg **regs,
			    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_render_basic;
	lens[n] = ARRAY_SIZE(mux_config_render_basic);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_basic[] = {
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
};

static const struct i915_oa_reg flex_eu_config_compute_basic[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00778008 },
	{ _MMIO(0xe45c), 0x00088078 },
	{ _MMIO(0xe55c), 0x00808708 },
	{ _MMIO(0xe65c), 0x00a08908 },
};

static const struct i915_oa_reg mux_config_compute_basic[] = {
	{ _MMIO(0x9888), 0x59800000 },
	{ _MMIO(0x9888), 0x59800001 },
	{ _MMIO(0x9888), 0x2e5800e0 },
	{ _MMIO(0x9888), 0x2e3800e0 },
	{ _MMIO(0x9888), 0x3580024f },
	{ _MMIO(0x9888), 0x3d800140 },
	{ _MMIO(0x9888), 0x08580042 },
	{ _MMIO(0x9888), 0x0c580040 },
	{ _MMIO(0x9888), 0x1058004c },
	{ _MMIO(0x9888), 0x1458004b },
	{ _MMIO(0x9888), 0x04580000 },
	{ _MMIO(0x9888), 0x00580000 },
	{ _MMIO(0x9888), 0x00195555 },
	{ _MMIO(0x9888), 0x06380042 },
	{ _MMIO(0x9888), 0x0a380040 },
	{ _MMIO(0x9888), 0x0e38004c },
	{ _MMIO(0x9888), 0x1238004b },
	{ _MMIO(0x9888), 0x04380000 },
	{ _MMIO(0x9888), 0x00384444 },
	{ _MMIO(0x9888), 0x003a5555 },
	{ _MMIO(0x9888), 0x018bffff },
	{ _MMIO(0x9888), 0x01845555 },
	{ _MMIO(0x9888), 0x17800074 },
	{ _MMIO(0x9888), 0x1980007d },
	{ _MMIO(0x9888), 0x1b80007c },
	{ _MMIO(0x9888), 0x1d8000b6 },
	{ _MMIO(0x9888), 0x1f8000b7 },
	{ _MMIO(0x9888), 0x05800000 },
	{ _MMIO(0x9888), 0x03800000 },
	{ _MMIO(0x9888), 0x418000aa },
	{ _MMIO(0x9888), 0x438000aa },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x47800000 },
	{ _MMIO(0x9888), 0x4980012a },
	{ _MMIO(0x9888), 0x4b80012a },
	{ _MMIO(0x9888), 0x4d80012a },
	{ _MMIO(0x9888), 0x4f80012a },
	{ _MMIO(0x9888), 0x518001ce },
	{ _MMIO(0x9888), 0x538001ce },
	{ _MMIO(0x9888), 0x5580000e },
	{ _MMIO(0x9888), 0x59800000 },
};

static int
get_compute_basic_mux_config(struct drm_i915_private *dev_priv,
			     const struct i915_oa_reg **regs,
			     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_compute_basic;
	lens[n] = ARRAY_SIZE(mux_config_compute_basic);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_render_pipe_profile[] = {
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2770), 0x0007ffea },
	{ _MMIO(0x2774), 0x00007ffc },
	{ _MMIO(0x2778), 0x0007affa },
	{ _MMIO(0x277c), 0x0000f5fd },
	{ _MMIO(0x2780), 0x00079ffa },
	{ _MMIO(0x2784), 0x0000f3fb },
	{ _MMIO(0x2788), 0x0007bf7a },
	{ _MMIO(0x278c), 0x0000f7e7 },
	{ _MMIO(0x2790), 0x0007fefa },
	{ _MMIO(0x2794), 0x0000f7cf },
	{ _MMIO(0x2798), 0x00077ffa },
	{ _MMIO(0x279c), 0x0000efdf },
	{ _MMIO(0x27a0), 0x0006fffa },
	{ _MMIO(0x27a4), 0x0000cfbf },
	{ _MMIO(0x27a8), 0x0003fffa },
	{ _MMIO(0x27ac), 0x00005f7f },
};

static const struct i915_oa_reg flex_eu_config_render_pipe_profile[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00015014 },
	{ _MMIO(0xe658), 0x00025024 },
	{ _MMIO(0xe758), 0x00035034 },
	{ _MMIO(0xe45c), 0x00045044 },
	{ _MMIO(0xe55c), 0x00055054 },
	{ _MMIO(0xe65c), 0x00065064 },
};

static const struct i915_oa_reg mux_config_render_pipe_profile[] = {
	{ _MMIO(0x9888), 0x59800000 },
	{ _MMIO(0x9888), 0x59800001 },
	{ _MMIO(0x9888), 0x261e0000 },
	{ _MMIO(0x9888), 0x281f000f },
	{ _MMIO(0x9888), 0x2817001a },
	{ _MMIO(0x9888), 0x2791001f },
	{ _MMIO(0x9888), 0x27880019 },
	{ _MMIO(0x9888), 0x2d890000 },
	{ _MMIO(0x9888), 0x278a0007 },
	{ _MMIO(0x9888), 0x298d001f },
	{ _MMIO(0x9888), 0x278e0020 },
	{ _MMIO(0x9888), 0x2b8f0012 },
	{ _MMIO(0x9888), 0x29900000 },
	{ _MMIO(0x9888), 0x00184000 },
	{ _MMIO(0x9888), 0x02181000 },
	{ _MMIO(0x9888), 0x02194000 },
	{ _MMIO(0x9888), 0x141e0002 },
	{ _MMIO(0x9888), 0x041e0000 },
	{ _MMIO(0x9888), 0x001e0000 },
	{ _MMIO(0x9888), 0x221f0015 },
	{ _MMIO(0x9888), 0x041f0000 },
	{ _MMIO(0x9888), 0x001f4000 },
	{ _MMIO(0x9888), 0x021f0000 },
	{ _MMIO(0x9888), 0x023a8000 },
	{ _MMIO(0x9888), 0x0213c000 },
	{ _MMIO(0x9888), 0x02164000 },
	{ _MMIO(0x9888), 0x24170012 },
	{ _MMIO(0x9888), 0x04170000 },
	{ _MMIO(0x9888), 0x07910005 },
	{ _MMIO(0x9888), 0x05910000 },
	{ _MMIO(0x9888), 0x01911500 },
	{ _MMIO(0x9888), 0x03910501 },
	{ _MMIO(0x9888), 0x0d880002 },
	{ _MMIO(0x9888), 0x1d880003 },
	{ _MMIO(0x9888), 0x05880000 },
	{ _MMIO(0x9888), 0x0b890032 },
	{ _MMIO(0x9888), 0x1b890031 },
	{ _MMIO(0x9888), 0x05890000 },
	{ _MMIO(0x9888), 0x01890040 },
	{ _MMIO(0x9888), 0x03890040 },
	{ _MMIO(0x9888), 0x098a0000 },
	{ _MMIO(0x9888), 0x198a0004 },
	{ _MMIO(0x9888), 0x058a0000 },
	{ _MMIO(0x9888), 0x018a8050 },
	{ _MMIO(0x9888), 0x038a2050 },
	{ _MMIO(0x9888), 0x018b95a9 },
	{ _MMIO(0x9888), 0x038be5a9 },
	{ _MMIO(0x9888), 0x018c1500 },
	{ _MMIO(0x9888), 0x038c0501 },
	{ _MMIO(0x9888), 0x178d0015 },
	{ _MMIO(0x9888), 0x058d0000 },
	{ _MMIO(0x9888), 0x138e0004 },
	{ _MMIO(0x9888), 0x218e000c },
	{ _MMIO(0x9888), 0x058e0000 },
	{ _MMIO(0x9888), 0x018e0500 },
	{ _MMIO(0x9888), 0x038e0101 },
	{ _MMIO(0x9888), 0x0f8f0027 },
	{ _MMIO(0x9888), 0x058f0000 },
	{ _MMIO(0x9888), 0x018f0000 },
	{ _MMIO(0x9888), 0x038f0001 },
	{ _MMIO(0x9888), 0x11900013 },
	{ _MMIO(0x9888), 0x1f900017 },
	{ _MMIO(0x9888), 0x05900000 },
	{ _MMIO(0x9888), 0x01900100 },
	{ _MMIO(0x9888), 0x03900001 },
	{ _MMIO(0x9888), 0x01845555 },
	{ _MMIO(0x9888), 0x03845555 },
	{ _MMIO(0x9888), 0x418000aa },
	{ _MMIO(0x9888), 0x438000aa },
	{ _MMIO(0x9888), 0x458000aa },
	{ _MMIO(0x9888), 0x478000aa },
	{ _MMIO(0x9888), 0x4980018c },
	{ _MMIO(0x9888), 0x4b80014b },
	{ _MMIO(0x9888), 0x4d800128 },
	{ _MMIO(0x9888), 0x4f80012a },
	{ _MMIO(0x9888), 0x51800187 },
	{ _MMIO(0x9888), 0x5380014b },
	{ _MMIO(0x9888), 0x55800149 },
	{ _MMIO(0x9888), 0x5780010a },
	{ _MMIO(0x9888), 0x59800000 },
};

static int
get_render_pipe_profile_mux_config(struct drm_i915_private *dev_priv,
				   const struct i915_oa_reg **regs,
				   int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_render_pipe_profile;
	lens[n] = ARRAY_SIZE(mux_config_render_pipe_profile);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_hdc_and_sf[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x10800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x0000fff7 },
};

static const struct i915_oa_reg flex_eu_config_hdc_and_sf[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_hdc_and_sf[] = {
	{ _MMIO(0x9888), 0x105c0232 },
	{ _MMIO(0x9888), 0x10580232 },
	{ _MMIO(0x9888), 0x10380232 },
	{ _MMIO(0x9888), 0x10dc0232 },
	{ _MMIO(0x9888), 0x10d80232 },
	{ _MMIO(0x9888), 0x10b80232 },
	{ _MMIO(0x9888), 0x118e4400 },
	{ _MMIO(0x9888), 0x025c6080 },
	{ _MMIO(0x9888), 0x045c004b },
	{ _MMIO(0x9888), 0x005c8000 },
	{ _MMIO(0x9888), 0x00582080 },
	{ _MMIO(0x9888), 0x0258004b },
	{ _MMIO(0x9888), 0x025b4000 },
	{ _MMIO(0x9888), 0x045b4000 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f00aa },
	{ _MMIO(0x9888), 0x04386080 },
	{ _MMIO(0x9888), 0x0638404b },
	{ _MMIO(0x9888), 0x02384000 },
	{ _MMIO(0x9888), 0x08384000 },
	{ _MMIO(0x9888), 0x0a380000 },
	{ _MMIO(0x9888), 0x0c380000 },
	{ _MMIO(0x9888), 0x00398000 },
	{ _MMIO(0x9888), 0x0239a000 },
	{ _MMIO(0x9888), 0x0439a000 },
	{ _MMIO(0x9888), 0x06392000 },
	{ _MMIO(0x9888), 0x0cdc25c1 },
	{ _MMIO(0x9888), 0x0adcc000 },
	{ _MMIO(0x9888), 0x0ad825c1 },
	{ _MMIO(0x9888), 0x18db4000 },
	{ _MMIO(0x9888), 0x1adb0001 },
	{ _MMIO(0x9888), 0x0e9f8000 },
	{ _MMIO(0x9888), 0x109f02aa },
	{ _MMIO(0x9888), 0x0eb825c1 },
	{ _MMIO(0x9888), 0x18b80154 },
	{ _MMIO(0x9888), 0x0ab9a000 },
	{ _MMIO(0x9888), 0x0cb9a000 },
	{ _MMIO(0x9888), 0x0eb9a000 },
	{ _MMIO(0x9888), 0x0d88c000 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x258baa05 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x198c5400 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x098dc000 },
	{ _MMIO(0x9888), 0x0b8da000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x098e05c0 },
	{ _MMIO(0x9888), 0x058e0000 },
	{ _MMIO(0x9888), 0x198f0020 },
	{ _MMIO(0x9888), 0x2185aa0a },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x19835000 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x09848000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x19808000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x51800040 },
	{ _MMIO(0x9888), 0x43800400 },
	{ _MMIO(0x9888), 0x45800800 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800c62 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f801042 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x418014a4 },
};

static int
get_hdc_and_sf_mux_config(struct drm_i915_private *dev_priv,
			  const struct i915_oa_reg **regs,
			  int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_hdc_and_sf;
	lens[n] = ARRAY_SIZE(mux_config_hdc_and_sf);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_1[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00014002 },
	{ _MMIO(0x277c), 0x0000c3ff },
	{ _MMIO(0x2780), 0x00010002 },
	{ _MMIO(0x2784), 0x0000c7ff },
	{ _MMIO(0x2788), 0x00004002 },
	{ _MMIO(0x278c), 0x0000d3ff },
	{ _MMIO(0x2790), 0x00100700 },
	{ _MMIO(0x2794), 0x0000ff1f },
	{ _MMIO(0x2798), 0x00001402 },
	{ _MMIO(0x279c), 0x0000fc3f },
	{ _MMIO(0x27a0), 0x00001002 },
	{ _MMIO(0x27a4), 0x0000fc7f },
	{ _MMIO(0x27a8), 0x00000402 },
	{ _MMIO(0x27ac), 0x0000fd3f },
};

static const struct i915_oa_reg flex_eu_config_l3_1[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_1[] = {
	{ _MMIO(0x9888), 0x10bf03da },
	{ _MMIO(0x9888), 0x14bf0001 },
	{ _MMIO(0x9888), 0x12980340 },
	{ _MMIO(0x9888), 0x12990340 },
	{ _MMIO(0x9888), 0x0cbf1187 },
	{ _MMIO(0x9888), 0x0ebf1205 },
	{ _MMIO(0x9888), 0x00bf0500 },
	{ _MMIO(0x9888), 0x02bf042b },
	{ _MMIO(0x9888), 0x04bf002c },
	{ _MMIO(0x9888), 0x0cdac000 },
	{ _MMIO(0x9888), 0x0edac000 },
	{ _MMIO(0x9888), 0x00da8000 },
	{ _MMIO(0x9888), 0x02dac000 },
	{ _MMIO(0x9888), 0x04da4000 },
	{ _MMIO(0x9888), 0x04983400 },
	{ _MMIO(0x9888), 0x10980000 },
	{ _MMIO(0x9888), 0x06990034 },
	{ _MMIO(0x9888), 0x10990000 },
	{ _MMIO(0x9888), 0x0c9dc000 },
	{ _MMIO(0x9888), 0x0e9dc000 },
	{ _MMIO(0x9888), 0x009d8000 },
	{ _MMIO(0x9888), 0x029dc000 },
	{ _MMIO(0x9888), 0x049d4000 },
	{ _MMIO(0x9888), 0x109f02a8 },
	{ _MMIO(0x9888), 0x0c9fa000 },
	{ _MMIO(0x9888), 0x0e9f00ba },
	{ _MMIO(0x9888), 0x0cb88000 },
	{ _MMIO(0x9888), 0x0cb95000 },
	{ _MMIO(0x9888), 0x0eb95000 },
	{ _MMIO(0x9888), 0x00b94000 },
	{ _MMIO(0x9888), 0x02b95000 },
	{ _MMIO(0x9888), 0x04b91000 },
	{ _MMIO(0x9888), 0x06b92000 },
	{ _MMIO(0x9888), 0x0cba4000 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x09888000 },
	{ _MMIO(0x9888), 0x0b888000 },
	{ _MMIO(0x9888), 0x0d880400 },
	{ _MMIO(0x9888), 0x258b800a },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b5500 },
	{ _MMIO(0x9888), 0x198c4000 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x098c4000 },
	{ _MMIO(0x9888), 0x0b8c4000 },
	{ _MMIO(0x9888), 0x0d8c4000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x018d8000 },
	{ _MMIO(0x9888), 0x038da000 },
	{ _MMIO(0x9888), 0x058da000 },
	{ _MMIO(0x9888), 0x078d2000 },
	{ _MMIO(0x9888), 0x2185800a },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x1b830154 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x47800000 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800060 },
};

static int
get_l3_1_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_l3_1;
	lens[n] = ARRAY_SIZE(mux_config_l3_1);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_2[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00014002 },
	{ _MMIO(0x277c), 0x0000c3ff },
	{ _MMIO(0x2780), 0x00010002 },
	{ _MMIO(0x2784), 0x0000c7ff },
	{ _MMIO(0x2788), 0x00004002 },
	{ _MMIO(0x278c), 0x0000d3ff },
	{ _MMIO(0x2790), 0x00100700 },
	{ _MMIO(0x2794), 0x0000ff1f },
	{ _MMIO(0x2798), 0x00001402 },
	{ _MMIO(0x279c), 0x0000fc3f },
	{ _MMIO(0x27a0), 0x00001002 },
	{ _MMIO(0x27a4), 0x0000fc7f },
	{ _MMIO(0x27a8), 0x00000402 },
	{ _MMIO(0x27ac), 0x0000fd3f },
};

static const struct i915_oa_reg flex_eu_config_l3_2[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_2[] = {
	{ _MMIO(0x9888), 0x103f03da },
	{ _MMIO(0x9888), 0x143f0001 },
	{ _MMIO(0x9888), 0x12180340 },
	{ _MMIO(0x9888), 0x12190340 },
	{ _MMIO(0x9888), 0x0c3f1187 },
	{ _MMIO(0x9888), 0x0e3f1205 },
	{ _MMIO(0x9888), 0x003f0500 },
	{ _MMIO(0x9888), 0x023f042b },
	{ _MMIO(0x9888), 0x043f002c },
	{ _MMIO(0x9888), 0x0c5ac000 },
	{ _MMIO(0x9888), 0x0e5ac000 },
	{ _MMIO(0x9888), 0x005a8000 },
	{ _MMIO(0x9888), 0x025ac000 },
	{ _MMIO(0x9888), 0x045a4000 },
	{ _MMIO(0x9888), 0x04183400 },
	{ _MMIO(0x9888), 0x10180000 },
	{ _MMIO(0x9888), 0x06190034 },
	{ _MMIO(0x9888), 0x10190000 },
	{ _MMIO(0x9888), 0x0c1dc000 },
	{ _MMIO(0x9888), 0x0e1dc000 },
	{ _MMIO(0x9888), 0x001d8000 },
	{ _MMIO(0x9888), 0x021dc000 },
	{ _MMIO(0x9888), 0x041d4000 },
	{ _MMIO(0x9888), 0x101f02a8 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f00ba },
	{ _MMIO(0x9888), 0x0c388000 },
	{ _MMIO(0x9888), 0x0c395000 },
	{ _MMIO(0x9888), 0x0e395000 },
	{ _MMIO(0x9888), 0x00394000 },
	{ _MMIO(0x9888), 0x02395000 },
	{ _MMIO(0x9888), 0x04391000 },
	{ _MMIO(0x9888), 0x06392000 },
	{ _MMIO(0x9888), 0x0c3a4000 },
	{ _MMIO(0x9888), 0x1b8aa800 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x258b4005 },
	{ _MMIO(0x9888), 0x278b0015 },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x2185800a },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x1b830154 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x45800000 },
	{ _MMIO(0x9888), 0x47800000 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f800000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800060 },
};

static int
get_l3_2_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_l3_2;
	lens[n] = ARRAY_SIZE(mux_config_l3_2);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_3[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00014002 },
	{ _MMIO(0x277c), 0x0000c3ff },
	{ _MMIO(0x2780), 0x00010002 },
	{ _MMIO(0x2784), 0x0000c7ff },
	{ _MMIO(0x2788), 0x00004002 },
	{ _MMIO(0x278c), 0x0000d3ff },
	{ _MMIO(0x2790), 0x00100700 },
	{ _MMIO(0x2794), 0x0000ff1f },
	{ _MMIO(0x2798), 0x00001402 },
	{ _MMIO(0x279c), 0x0000fc3f },
	{ _MMIO(0x27a0), 0x00001002 },
	{ _MMIO(0x27a4), 0x0000fc7f },
	{ _MMIO(0x27a8), 0x00000402 },
	{ _MMIO(0x27ac), 0x0000fd3f },
};

static const struct i915_oa_reg flex_eu_config_l3_3[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_3[] = {
	{ _MMIO(0x9888), 0x121b0340 },
	{ _MMIO(0x9888), 0x103f0274 },
	{ _MMIO(0x9888), 0x123f0000 },
	{ _MMIO(0x9888), 0x129b0340 },
	{ _MMIO(0x9888), 0x10bf0274 },
	{ _MMIO(0x9888), 0x12bf0000 },
	{ _MMIO(0x9888), 0x041b3400 },
	{ _MMIO(0x9888), 0x101b0000 },
	{ _MMIO(0x9888), 0x045c8000 },
	{ _MMIO(0x9888), 0x0a3d4000 },
	{ _MMIO(0x9888), 0x003f0080 },
	{ _MMIO(0x9888), 0x023f0793 },
	{ _MMIO(0x9888), 0x043f0014 },
	{ _MMIO(0x9888), 0x04588000 },
	{ _MMIO(0x9888), 0x005a8000 },
	{ _MMIO(0x9888), 0x025ac000 },
	{ _MMIO(0x9888), 0x045a4000 },
	{ _MMIO(0x9888), 0x0a5b4000 },
	{ _MMIO(0x9888), 0x001d8000 },
	{ _MMIO(0x9888), 0x021dc000 },
	{ _MMIO(0x9888), 0x041d4000 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f002a },
	{ _MMIO(0x9888), 0x0a384000 },
	{ _MMIO(0x9888), 0x00394000 },
	{ _MMIO(0x9888), 0x02395000 },
	{ _MMIO(0x9888), 0x04399000 },
	{ _MMIO(0x9888), 0x069b0034 },
	{ _MMIO(0x9888), 0x109b0000 },
	{ _MMIO(0x9888), 0x06dc4000 },
	{ _MMIO(0x9888), 0x0cbd4000 },
	{ _MMIO(0x9888), 0x0cbf0981 },
	{ _MMIO(0x9888), 0x0ebf0a0f },
	{ _MMIO(0x9888), 0x06d84000 },
	{ _MMIO(0x9888), 0x0cdac000 },
	{ _MMIO(0x9888), 0x0edac000 },
	{ _MMIO(0x9888), 0x0cdb4000 },
	{ _MMIO(0x9888), 0x0c9dc000 },
	{ _MMIO(0x9888), 0x0e9dc000 },
	{ _MMIO(0x9888), 0x109f02a8 },
	{ _MMIO(0x9888), 0x0e9f0080 },
	{ _MMIO(0x9888), 0x0cb84000 },
	{ _MMIO(0x9888), 0x0cb95000 },
	{ _MMIO(0x9888), 0x0eb95000 },
	{ _MMIO(0x9888), 0x06b92000 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x0d880400 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x258b8009 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x198c4000 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x0d8c4000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x078d2000 },
	{ _MMIO(0x9888), 0x2185800a },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x1b830154 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x45800c00 },
	{ _MMIO(0x9888), 0x47800c63 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f8014a5 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800045 },
};

static int
get_l3_3_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_l3_3;
	lens[n] = ARRAY_SIZE(mux_config_l3_3);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_4[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00014002 },
	{ _MMIO(0x277c), 0x0000c3ff },
	{ _MMIO(0x2780), 0x00010002 },
	{ _MMIO(0x2784), 0x0000c7ff },
	{ _MMIO(0x2788), 0x00004002 },
	{ _MMIO(0x278c), 0x0000d3ff },
	{ _MMIO(0x2790), 0x00100700 },
	{ _MMIO(0x2794), 0x0000ff1f },
	{ _MMIO(0x2798), 0x00001402 },
	{ _MMIO(0x279c), 0x0000fc3f },
	{ _MMIO(0x27a0), 0x00001002 },
	{ _MMIO(0x27a4), 0x0000fc7f },
	{ _MMIO(0x27a8), 0x00000402 },
	{ _MMIO(0x27ac), 0x0000fd3f },
};

static const struct i915_oa_reg flex_eu_config_l3_4[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_4[] = {
	{ _MMIO(0x9888), 0x121a0340 },
	{ _MMIO(0x9888), 0x103f0017 },
	{ _MMIO(0x9888), 0x123f0020 },
	{ _MMIO(0x9888), 0x129a0340 },
	{ _MMIO(0x9888), 0x10bf0017 },
	{ _MMIO(0x9888), 0x12bf0020 },
	{ _MMIO(0x9888), 0x041a3400 },
	{ _MMIO(0x9888), 0x101a0000 },
	{ _MMIO(0x9888), 0x043b8000 },
	{ _MMIO(0x9888), 0x0a3e0010 },
	{ _MMIO(0x9888), 0x003f0200 },
	{ _MMIO(0x9888), 0x023f0113 },
	{ _MMIO(0x9888), 0x043f0014 },
	{ _MMIO(0x9888), 0x02592000 },
	{ _MMIO(0x9888), 0x005a8000 },
	{ _MMIO(0x9888), 0x025ac000 },
	{ _MMIO(0x9888), 0x045a4000 },
	{ _MMIO(0x9888), 0x0a1c8000 },
	{ _MMIO(0x9888), 0x001d8000 },
	{ _MMIO(0x9888), 0x021dc000 },
	{ _MMIO(0x9888), 0x041d4000 },
	{ _MMIO(0x9888), 0x0a1e8000 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f001a },
	{ _MMIO(0x9888), 0x00394000 },
	{ _MMIO(0x9888), 0x02395000 },
	{ _MMIO(0x9888), 0x04391000 },
	{ _MMIO(0x9888), 0x069a0034 },
	{ _MMIO(0x9888), 0x109a0000 },
	{ _MMIO(0x9888), 0x06bb4000 },
	{ _MMIO(0x9888), 0x0abe0040 },
	{ _MMIO(0x9888), 0x0cbf0984 },
	{ _MMIO(0x9888), 0x0ebf0a02 },
	{ _MMIO(0x9888), 0x02d94000 },
	{ _MMIO(0x9888), 0x0cdac000 },
	{ _MMIO(0x9888), 0x0edac000 },
	{ _MMIO(0x9888), 0x0c9c0400 },
	{ _MMIO(0x9888), 0x0c9dc000 },
	{ _MMIO(0x9888), 0x0e9dc000 },
	{ _MMIO(0x9888), 0x0c9e0400 },
	{ _MMIO(0x9888), 0x109f02a8 },
	{ _MMIO(0x9888), 0x0e9f0040 },
	{ _MMIO(0x9888), 0x0cb95000 },
	{ _MMIO(0x9888), 0x0eb95000 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x0d880400 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x258b8009 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x198c4000 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x0d8c4000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x078d2000 },
	{ _MMIO(0x9888), 0x2185800a },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x1b830154 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x45800800 },
	{ _MMIO(0x9888), 0x47800842 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f801084 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800044 },
};

static int
get_l3_4_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_l3_4;
	lens[n] = ARRAY_SIZE(mux_config_l3_4);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2770), 0x00006000 },
	{ _MMIO(0x2774), 0x0000f3ff },
	{ _MMIO(0x2778), 0x00001800 },
	{ _MMIO(0x277c), 0x0000fcff },
	{ _MMIO(0x2780), 0x00000600 },
	{ _MMIO(0x2784), 0x0000ff3f },
	{ _MMIO(0x2788), 0x00000180 },
	{ _MMIO(0x278c), 0x0000ffcf },
	{ _MMIO(0x2790), 0x00000060 },
	{ _MMIO(0x2794), 0x0000fff3 },
	{ _MMIO(0x2798), 0x00000018 },
	{ _MMIO(0x279c), 0x0000fffc },
};

static const struct i915_oa_reg flex_eu_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0x9888), 0x143b000e },
	{ _MMIO(0x9888), 0x043c55c0 },
	{ _MMIO(0x9888), 0x0a1e0280 },
	{ _MMIO(0x9888), 0x0c1e0408 },
	{ _MMIO(0x9888), 0x10390000 },
	{ _MMIO(0x9888), 0x12397a1f },
	{ _MMIO(0x9888), 0x14bb000e },
	{ _MMIO(0x9888), 0x04bc5000 },
	{ _MMIO(0x9888), 0x0a9e0296 },
	{ _MMIO(0x9888), 0x0c9e0008 },
	{ _MMIO(0x9888), 0x10b90000 },
	{ _MMIO(0x9888), 0x12b97a1f },
	{ _MMIO(0x9888), 0x063b0042 },
	{ _MMIO(0x9888), 0x103b0000 },
	{ _MMIO(0x9888), 0x083c0000 },
	{ _MMIO(0x9888), 0x0a3e0040 },
	{ _MMIO(0x9888), 0x043f8000 },
	{ _MMIO(0x9888), 0x02594000 },
	{ _MMIO(0x9888), 0x045a8000 },
	{ _MMIO(0x9888), 0x0c1c0400 },
	{ _MMIO(0x9888), 0x041d8000 },
	{ _MMIO(0x9888), 0x081e02c0 },
	{ _MMIO(0x9888), 0x0e1e0000 },
	{ _MMIO(0x9888), 0x0c1fa800 },
	{ _MMIO(0x9888), 0x0e1f0260 },
	{ _MMIO(0x9888), 0x101f0014 },
	{ _MMIO(0x9888), 0x003905e0 },
	{ _MMIO(0x9888), 0x06390bc0 },
	{ _MMIO(0x9888), 0x02390018 },
	{ _MMIO(0x9888), 0x04394000 },
	{ _MMIO(0x9888), 0x04bb0042 },
	{ _MMIO(0x9888), 0x10bb0000 },
	{ _MMIO(0x9888), 0x02bc05c0 },
	{ _MMIO(0x9888), 0x08bc0000 },
	{ _MMIO(0x9888), 0x0abe0004 },
	{ _MMIO(0x9888), 0x02bf8000 },
	{ _MMIO(0x9888), 0x02d91000 },
	{ _MMIO(0x9888), 0x02da8000 },
	{ _MMIO(0x9888), 0x089c8000 },
	{ _MMIO(0x9888), 0x029d8000 },
	{ _MMIO(0x9888), 0x089e8000 },
	{ _MMIO(0x9888), 0x0e9e0000 },
	{ _MMIO(0x9888), 0x0e9fa806 },
	{ _MMIO(0x9888), 0x109f0142 },
	{ _MMIO(0x9888), 0x08b90617 },
	{ _MMIO(0x9888), 0x0ab90be0 },
	{ _MMIO(0x9888), 0x02b94000 },
	{ _MMIO(0x9888), 0x0d88f000 },
	{ _MMIO(0x9888), 0x0f88000c },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x09888000 },
	{ _MMIO(0x9888), 0x018a8000 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x1b8a2800 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x238b52a0 },
	{ _MMIO(0x9888), 0x258b6a95 },
	{ _MMIO(0x9888), 0x278b0029 },
	{ _MMIO(0x9888), 0x178c2000 },
	{ _MMIO(0x9888), 0x198c1500 },
	{ _MMIO(0x9888), 0x1b8c0014 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x098c4000 },
	{ _MMIO(0x9888), 0x098da000 },
	{ _MMIO(0x9888), 0x0b8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x038d8000 },
	{ _MMIO(0x9888), 0x058d2000 },
	{ _MMIO(0x9888), 0x1f85aa80 },
	{ _MMIO(0x9888), 0x2185aaaa },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x01834000 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0184c000 },
	{ _MMIO(0x9888), 0x0784c000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1180c000 },
	{ _MMIO(0x9888), 0x1780c000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x4d800444 },
	{ _MMIO(0x9888), 0x3d800000 },
	{ _MMIO(0x9888), 0x4f804000 },
	{ _MMIO(0x9888), 0x43801080 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800084 },
	{ _MMIO(0x9888), 0x53800044 },
	{ _MMIO(0x9888), 0x47801080 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x3f800000 },
	{ _MMIO(0x9888), 0x41800840 },
};

static int
get_rasterizer_and_pixel_backend_mux_config(struct drm_i915_private *dev_priv,
					    const struct i915_oa_reg **regs,
					    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_rasterizer_and_pixel_backend;
	lens[n] = ARRAY_SIZE(mux_config_rasterizer_and_pixel_backend);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_sampler_1[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x70800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x0000c000 },
	{ _MMIO(0x2774), 0x0000e7ff },
	{ _MMIO(0x2778), 0x00003000 },
	{ _MMIO(0x277c), 0x0000f9ff },
	{ _MMIO(0x2780), 0x00000c00 },
	{ _MMIO(0x2784), 0x0000fe7f },
};

static const struct i915_oa_reg flex_eu_config_sampler_1[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_sampler_1[] = {
	{ _MMIO(0x9888), 0x18921400 },
	{ _MMIO(0x9888), 0x149500ab },
	{ _MMIO(0x9888), 0x18b21400 },
	{ _MMIO(0x9888), 0x14b500ab },
	{ _MMIO(0x9888), 0x18d21400 },
	{ _MMIO(0x9888), 0x14d500ab },
	{ _MMIO(0x9888), 0x0cdc8000 },
	{ _MMIO(0x9888), 0x0edc4000 },
	{ _MMIO(0x9888), 0x02dcc000 },
	{ _MMIO(0x9888), 0x04dcc000 },
	{ _MMIO(0x9888), 0x1abd00a0 },
	{ _MMIO(0x9888), 0x0abd8000 },
	{ _MMIO(0x9888), 0x0cd88000 },
	{ _MMIO(0x9888), 0x0ed84000 },
	{ _MMIO(0x9888), 0x04d88000 },
	{ _MMIO(0x9888), 0x1adb0050 },
	{ _MMIO(0x9888), 0x04db8000 },
	{ _MMIO(0x9888), 0x06db8000 },
	{ _MMIO(0x9888), 0x08db8000 },
	{ _MMIO(0x9888), 0x0adb4000 },
	{ _MMIO(0x9888), 0x109f02a0 },
	{ _MMIO(0x9888), 0x0c9fa000 },
	{ _MMIO(0x9888), 0x0e9f00aa },
	{ _MMIO(0x9888), 0x18b82500 },
	{ _MMIO(0x9888), 0x02b88000 },
	{ _MMIO(0x9888), 0x04b84000 },
	{ _MMIO(0x9888), 0x06b84000 },
	{ _MMIO(0x9888), 0x08b84000 },
	{ _MMIO(0x9888), 0x0ab84000 },
	{ _MMIO(0x9888), 0x0cb88000 },
	{ _MMIO(0x9888), 0x0cb98000 },
	{ _MMIO(0x9888), 0x0eb9a000 },
	{ _MMIO(0x9888), 0x00b98000 },
	{ _MMIO(0x9888), 0x02b9a000 },
	{ _MMIO(0x9888), 0x04b9a000 },
	{ _MMIO(0x9888), 0x06b92000 },
	{ _MMIO(0x9888), 0x1aba0200 },
	{ _MMIO(0x9888), 0x02ba8000 },
	{ _MMIO(0x9888), 0x0cba8000 },
	{ _MMIO(0x9888), 0x04908000 },
	{ _MMIO(0x9888), 0x04918000 },
	{ _MMIO(0x9888), 0x04927300 },
	{ _MMIO(0x9888), 0x10920000 },
	{ _MMIO(0x9888), 0x1893000a },
	{ _MMIO(0x9888), 0x0a934000 },
	{ _MMIO(0x9888), 0x0a946000 },
	{ _MMIO(0x9888), 0x0c959000 },
	{ _MMIO(0x9888), 0x0e950098 },
	{ _MMIO(0x9888), 0x10950000 },
	{ _MMIO(0x9888), 0x04b04000 },
	{ _MMIO(0x9888), 0x04b14000 },
	{ _MMIO(0x9888), 0x04b20073 },
	{ _MMIO(0x9888), 0x10b20000 },
	{ _MMIO(0x9888), 0x04b38000 },
	{ _MMIO(0x9888), 0x06b38000 },
	{ _MMIO(0x9888), 0x08b34000 },
	{ _MMIO(0x9888), 0x04b4c000 },
	{ _MMIO(0x9888), 0x02b59890 },
	{ _MMIO(0x9888), 0x10b50000 },
	{ _MMIO(0x9888), 0x06d04000 },
	{ _MMIO(0x9888), 0x06d14000 },
	{ _MMIO(0x9888), 0x06d20073 },
	{ _MMIO(0x9888), 0x10d20000 },
	{ _MMIO(0x9888), 0x18d30020 },
	{ _MMIO(0x9888), 0x02d38000 },
	{ _MMIO(0x9888), 0x0cd34000 },
	{ _MMIO(0x9888), 0x0ad48000 },
	{ _MMIO(0x9888), 0x04d42000 },
	{ _MMIO(0x9888), 0x0ed59000 },
	{ _MMIO(0x9888), 0x00d59800 },
	{ _MMIO(0x9888), 0x10d50000 },
	{ _MMIO(0x9888), 0x0f88000e },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x09888000 },
	{ _MMIO(0x9888), 0x0b888000 },
	{ _MMIO(0x9888), 0x0d880400 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b5500 },
	{ _MMIO(0x9888), 0x258b000a },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x098c4000 },
	{ _MMIO(0x9888), 0x0b8c4000 },
	{ _MMIO(0x9888), 0x0d8c4000 },
	{ _MMIO(0x9888), 0x0d8d8000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x018d8000 },
	{ _MMIO(0x9888), 0x038da000 },
	{ _MMIO(0x9888), 0x058da000 },
	{ _MMIO(0x9888), 0x078d2000 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x2185000a },
	{ _MMIO(0x9888), 0x1b830150 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d848000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d808000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47801021 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f800c64 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800c02 },
};

static int
get_sampler_1_mux_config(struct drm_i915_private *dev_priv,
			 const struct i915_oa_reg **regs,
			 int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_sampler_1;
	lens[n] = ARRAY_SIZE(mux_config_sampler_1);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_sampler_2[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x70800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x0000c000 },
	{ _MMIO(0x2774), 0x0000e7ff },
	{ _MMIO(0x2778), 0x00003000 },
	{ _MMIO(0x277c), 0x0000f9ff },
	{ _MMIO(0x2780), 0x00000c00 },
	{ _MMIO(0x2784), 0x0000fe7f },
};

static const struct i915_oa_reg flex_eu_config_sampler_2[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_sampler_2[] = {
	{ _MMIO(0x9888), 0x18121400 },
	{ _MMIO(0x9888), 0x141500ab },
	{ _MMIO(0x9888), 0x18321400 },
	{ _MMIO(0x9888), 0x143500ab },
	{ _MMIO(0x9888), 0x18521400 },
	{ _MMIO(0x9888), 0x145500ab },
	{ _MMIO(0x9888), 0x0c5c8000 },
	{ _MMIO(0x9888), 0x0e5c4000 },
	{ _MMIO(0x9888), 0x025cc000 },
	{ _MMIO(0x9888), 0x045cc000 },
	{ _MMIO(0x9888), 0x1a3d00a0 },
	{ _MMIO(0x9888), 0x0a3d8000 },
	{ _MMIO(0x9888), 0x0c588000 },
	{ _MMIO(0x9888), 0x0e584000 },
	{ _MMIO(0x9888), 0x04588000 },
	{ _MMIO(0x9888), 0x1a5b0050 },
	{ _MMIO(0x9888), 0x045b8000 },
	{ _MMIO(0x9888), 0x065b8000 },
	{ _MMIO(0x9888), 0x085b8000 },
	{ _MMIO(0x9888), 0x0a5b4000 },
	{ _MMIO(0x9888), 0x101f02a0 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f00aa },
	{ _MMIO(0x9888), 0x18382500 },
	{ _MMIO(0x9888), 0x02388000 },
	{ _MMIO(0x9888), 0x04384000 },
	{ _MMIO(0x9888), 0x06384000 },
	{ _MMIO(0x9888), 0x08384000 },
	{ _MMIO(0x9888), 0x0a384000 },
	{ _MMIO(0x9888), 0x0c388000 },
	{ _MMIO(0x9888), 0x0c398000 },
	{ _MMIO(0x9888), 0x0e39a000 },
	{ _MMIO(0x9888), 0x00398000 },
	{ _MMIO(0x9888), 0x0239a000 },
	{ _MMIO(0x9888), 0x0439a000 },
	{ _MMIO(0x9888), 0x06392000 },
	{ _MMIO(0x9888), 0x1a3a0200 },
	{ _MMIO(0x9888), 0x023a8000 },
	{ _MMIO(0x9888), 0x0c3a8000 },
	{ _MMIO(0x9888), 0x04108000 },
	{ _MMIO(0x9888), 0x04118000 },
	{ _MMIO(0x9888), 0x04127300 },
	{ _MMIO(0x9888), 0x10120000 },
	{ _MMIO(0x9888), 0x1813000a },
	{ _MMIO(0x9888), 0x0a134000 },
	{ _MMIO(0x9888), 0x0a146000 },
	{ _MMIO(0x9888), 0x0c159000 },
	{ _MMIO(0x9888), 0x0e150098 },
	{ _MMIO(0x9888), 0x10150000 },
	{ _MMIO(0x9888), 0x04304000 },
	{ _MMIO(0x9888), 0x04314000 },
	{ _MMIO(0x9888), 0x04320073 },
	{ _MMIO(0x9888), 0x10320000 },
	{ _MMIO(0x9888), 0x04338000 },
	{ _MMIO(0x9888), 0x06338000 },
	{ _MMIO(0x9888), 0x08334000 },
	{ _MMIO(0x9888), 0x0434c000 },
	{ _MMIO(0x9888), 0x02359890 },
	{ _MMIO(0x9888), 0x10350000 },
	{ _MMIO(0x9888), 0x06504000 },
	{ _MMIO(0x9888), 0x06514000 },
	{ _MMIO(0x9888), 0x06520073 },
	{ _MMIO(0x9888), 0x10520000 },
	{ _MMIO(0x9888), 0x18530020 },
	{ _MMIO(0x9888), 0x02538000 },
	{ _MMIO(0x9888), 0x0c534000 },
	{ _MMIO(0x9888), 0x0a548000 },
	{ _MMIO(0x9888), 0x04542000 },
	{ _MMIO(0x9888), 0x0e559000 },
	{ _MMIO(0x9888), 0x00559800 },
	{ _MMIO(0x9888), 0x10550000 },
	{ _MMIO(0x9888), 0x1b8aa000 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x278b0015 },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x258b0005 },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x2185000a },
	{ _MMIO(0x9888), 0x1b830150 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0d848000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x07844000 },
	{ _MMIO(0x9888), 0x1d808000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x17804000 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47801021 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f800c64 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x41800c02 },
};

static int
get_sampler_2_mux_config(struct drm_i915_private *dev_priv,
			 const struct i915_oa_reg **regs,
			 int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_sampler_2;
	lens[n] = ARRAY_SIZE(mux_config_sampler_2);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_tdl_1[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x0000fdff },
	{ _MMIO(0x2778), 0x00000000 },
	{ _MMIO(0x277c), 0x0000fe7f },
	{ _MMIO(0x2780), 0x00000002 },
	{ _MMIO(0x2784), 0x0000ffbf },
	{ _MMIO(0x2788), 0x00000000 },
	{ _MMIO(0x278c), 0x0000ffcf },
	{ _MMIO(0x2790), 0x00000002 },
	{ _MMIO(0x2794), 0x0000fff7 },
	{ _MMIO(0x2798), 0x00000000 },
	{ _MMIO(0x279c), 0x0000fff9 },
};

static const struct i915_oa_reg flex_eu_config_tdl_1[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_tdl_1[] = {
	{ _MMIO(0x9888), 0x16154d60 },
	{ _MMIO(0x9888), 0x16352e60 },
	{ _MMIO(0x9888), 0x16554d60 },
	{ _MMIO(0x9888), 0x16950000 },
	{ _MMIO(0x9888), 0x16b50000 },
	{ _MMIO(0x9888), 0x16d50000 },
	{ _MMIO(0x9888), 0x005c8000 },
	{ _MMIO(0x9888), 0x045cc000 },
	{ _MMIO(0x9888), 0x065c4000 },
	{ _MMIO(0x9888), 0x083d8000 },
	{ _MMIO(0x9888), 0x0a3d8000 },
	{ _MMIO(0x9888), 0x0458c000 },
	{ _MMIO(0x9888), 0x025b8000 },
	{ _MMIO(0x9888), 0x085b4000 },
	{ _MMIO(0x9888), 0x0a5b4000 },
	{ _MMIO(0x9888), 0x0c5b8000 },
	{ _MMIO(0x9888), 0x0c1fa000 },
	{ _MMIO(0x9888), 0x0e1f00aa },
	{ _MMIO(0x9888), 0x02384000 },
	{ _MMIO(0x9888), 0x04388000 },
	{ _MMIO(0x9888), 0x06388000 },
	{ _MMIO(0x9888), 0x08384000 },
	{ _MMIO(0x9888), 0x0a384000 },
	{ _MMIO(0x9888), 0x0c384000 },
	{ _MMIO(0x9888), 0x00398000 },
	{ _MMIO(0x9888), 0x0239a000 },
	{ _MMIO(0x9888), 0x0439a000 },
	{ _MMIO(0x9888), 0x06392000 },
	{ _MMIO(0x9888), 0x043a8000 },
	{ _MMIO(0x9888), 0x063a8000 },
	{ _MMIO(0x9888), 0x08138000 },
	{ _MMIO(0x9888), 0x0a138000 },
	{ _MMIO(0x9888), 0x06143000 },
	{ _MMIO(0x9888), 0x0415cfc7 },
	{ _MMIO(0x9888), 0x10150000 },
	{ _MMIO(0x9888), 0x02338000 },
	{ _MMIO(0x9888), 0x0c338000 },
	{ _MMIO(0x9888), 0x04342000 },
	{ _MMIO(0x9888), 0x06344000 },
	{ _MMIO(0x9888), 0x0035c700 },
	{ _MMIO(0x9888), 0x063500cf },
	{ _MMIO(0x9888), 0x10350000 },
	{ _MMIO(0x9888), 0x04538000 },
	{ _MMIO(0x9888), 0x06538000 },
	{ _MMIO(0x9888), 0x0454c000 },
	{ _MMIO(0x9888), 0x0255cfc7 },
	{ _MMIO(0x9888), 0x10550000 },
	{ _MMIO(0x9888), 0x06dc8000 },
	{ _MMIO(0x9888), 0x08dc4000 },
	{ _MMIO(0x9888), 0x0cdcc000 },
	{ _MMIO(0x9888), 0x0edcc000 },
	{ _MMIO(0x9888), 0x1abd00a8 },
	{ _MMIO(0x9888), 0x0cd8c000 },
	{ _MMIO(0x9888), 0x0ed84000 },
	{ _MMIO(0x9888), 0x0edb8000 },
	{ _MMIO(0x9888), 0x18db0800 },
	{ _MMIO(0x9888), 0x1adb0254 },
	{ _MMIO(0x9888), 0x0e9faa00 },
	{ _MMIO(0x9888), 0x109f02aa },
	{ _MMIO(0x9888), 0x0eb84000 },
	{ _MMIO(0x9888), 0x16b84000 },
	{ _MMIO(0x9888), 0x18b8156a },
	{ _MMIO(0x9888), 0x06b98000 },
	{ _MMIO(0x9888), 0x08b9a000 },
	{ _MMIO(0x9888), 0x0ab9a000 },
	{ _MMIO(0x9888), 0x0cb9a000 },
	{ _MMIO(0x9888), 0x0eb9a000 },
	{ _MMIO(0x9888), 0x18baa000 },
	{ _MMIO(0x9888), 0x1aba0002 },
	{ _MMIO(0x9888), 0x16934000 },
	{ _MMIO(0x9888), 0x1893000a },
	{ _MMIO(0x9888), 0x0a947000 },
	{ _MMIO(0x9888), 0x0c95c5c1 },
	{ _MMIO(0x9888), 0x0e9500c3 },
	{ _MMIO(0x9888), 0x10950000 },
	{ _MMIO(0x9888), 0x0eb38000 },
	{ _MMIO(0x9888), 0x16b30040 },
	{ _MMIO(0x9888), 0x18b30020 },
	{ _MMIO(0x9888), 0x06b48000 },
	{ _MMIO(0x9888), 0x08b41000 },
	{ _MMIO(0x9888), 0x0ab48000 },
	{ _MMIO(0x9888), 0x06b5c500 },
	{ _MMIO(0x9888), 0x08b500c3 },
	{ _MMIO(0x9888), 0x0eb5c100 },
	{ _MMIO(0x9888), 0x10b50000 },
	{ _MMIO(0x9888), 0x16d31500 },
	{ _MMIO(0x9888), 0x08d4e000 },
	{ _MMIO(0x9888), 0x08d5c100 },
	{ _MMIO(0x9888), 0x0ad5c3c5 },
	{ _MMIO(0x9888), 0x10d50000 },
	{ _MMIO(0x9888), 0x0d88f800 },
	{ _MMIO(0x9888), 0x0f88000f },
	{ _MMIO(0x9888), 0x038a8000 },
	{ _MMIO(0x9888), 0x058a8000 },
	{ _MMIO(0x9888), 0x078a8000 },
	{ _MMIO(0x9888), 0x098a8000 },
	{ _MMIO(0x9888), 0x0b8a8000 },
	{ _MMIO(0x9888), 0x0d8a8000 },
	{ _MMIO(0x9888), 0x258baaa5 },
	{ _MMIO(0x9888), 0x278b002a },
	{ _MMIO(0x9888), 0x238b2a80 },
	{ _MMIO(0x9888), 0x0f8c4000 },
	{ _MMIO(0x9888), 0x178c2000 },
	{ _MMIO(0x9888), 0x198c5500 },
	{ _MMIO(0x9888), 0x1b8c0015 },
	{ _MMIO(0x9888), 0x078d8000 },
	{ _MMIO(0x9888), 0x098da000 },
	{ _MMIO(0x9888), 0x0b8da000 },
	{ _MMIO(0x9888), 0x0d8da000 },
	{ _MMIO(0x9888), 0x0f8da000 },
	{ _MMIO(0x9888), 0x2185aaaa },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0784c000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1780c000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800c42 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45800063 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x47800800 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f8014a4 },
	{ _MMIO(0x9888), 0x41801042 },
};

static int
get_tdl_1_mux_config(struct drm_i915_private *dev_priv,
		     const struct i915_oa_reg **regs,
		     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_tdl_1;
	lens[n] = ARRAY_SIZE(mux_config_tdl_1);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_tdl_2[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x0000fdff },
	{ _MMIO(0x2778), 0x00000000 },
	{ _MMIO(0x277c), 0x0000fe7f },
	{ _MMIO(0x2780), 0x00000000 },
	{ _MMIO(0x2784), 0x0000ff9f },
	{ _MMIO(0x2788), 0x00000000 },
	{ _MMIO(0x278c), 0x0000ffe7 },
	{ _MMIO(0x2790), 0x00000002 },
	{ _MMIO(0x2794), 0x0000fffb },
	{ _MMIO(0x2798), 0x00000002 },
	{ _MMIO(0x279c), 0x0000fffd },
};

static const struct i915_oa_reg flex_eu_config_tdl_2[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_tdl_2[] = {
	{ _MMIO(0x9888), 0x16150000 },
	{ _MMIO(0x9888), 0x16350000 },
	{ _MMIO(0x9888), 0x16550000 },
	{ _MMIO(0x9888), 0x16952e60 },
	{ _MMIO(0x9888), 0x16b54d60 },
	{ _MMIO(0x9888), 0x16d52e60 },
	{ _MMIO(0x9888), 0x065c8000 },
	{ _MMIO(0x9888), 0x085cc000 },
	{ _MMIO(0x9888), 0x0a5cc000 },
	{ _MMIO(0x9888), 0x0c5c4000 },
	{ _MMIO(0x9888), 0x0e3d8000 },
	{ _MMIO(0x9888), 0x183da000 },
	{ _MMIO(0x9888), 0x06588000 },
	{ _MMIO(0x9888), 0x08588000 },
	{ _MMIO(0x9888), 0x0a584000 },
	{ _MMIO(0x9888), 0x0e5b4000 },
	{ _MMIO(0x9888), 0x185b5800 },
	{ _MMIO(0x9888), 0x1a5b000a },
	{ _MMIO(0x9888), 0x0e1faa00 },
	{ _MMIO(0x9888), 0x101f02aa },
	{ _MMIO(0x9888), 0x0e384000 },
	{ _MMIO(0x9888), 0x16384000 },
	{ _MMIO(0x9888), 0x18382a55 },
	{ _MMIO(0x9888), 0x06398000 },
	{ _MMIO(0x9888), 0x0839a000 },
	{ _MMIO(0x9888), 0x0a39a000 },
	{ _MMIO(0x9888), 0x0c39a000 },
	{ _MMIO(0x9888), 0x0e39a000 },
	{ _MMIO(0x9888), 0x1a3a02a0 },
	{ _MMIO(0x9888), 0x0e138000 },
	{ _MMIO(0x9888), 0x16130500 },
	{ _MMIO(0x9888), 0x06148000 },
	{ _MMIO(0x9888), 0x08146000 },
	{ _MMIO(0x9888), 0x0615c100 },
	{ _MMIO(0x9888), 0x0815c500 },
	{ _MMIO(0x9888), 0x0a1500c3 },
	{ _MMIO(0x9888), 0x10150000 },
	{ _MMIO(0x9888), 0x16335040 },
	{ _MMIO(0x9888), 0x08349000 },
	{ _MMIO(0x9888), 0x0a341000 },
	{ _MMIO(0x9888), 0x083500c1 },
	{ _MMIO(0x9888), 0x0a35c500 },
	{ _MMIO(0x9888), 0x0c3500c3 },
	{ _MMIO(0x9888), 0x10350000 },
	{ _MMIO(0x9888), 0x1853002a },
	{ _MMIO(0x9888), 0x0a54e000 },
	{ _MMIO(0x9888), 0x0c55c500 },
	{ _MMIO(0x9888), 0x0e55c1c3 },
	{ _MMIO(0x9888), 0x10550000 },
	{ _MMIO(0x9888), 0x00dc8000 },
	{ _MMIO(0x9888), 0x02dcc000 },
	{ _MMIO(0x9888), 0x04dc4000 },
	{ _MMIO(0x9888), 0x04bd8000 },
	{ _MMIO(0x9888), 0x06bd8000 },
	{ _MMIO(0x9888), 0x02d8c000 },
	{ _MMIO(0x9888), 0x02db8000 },
	{ _MMIO(0x9888), 0x04db4000 },
	{ _MMIO(0x9888), 0x06db4000 },
	{ _MMIO(0x9888), 0x08db8000 },
	{ _MMIO(0x9888), 0x0c9fa000 },
	{ _MMIO(0x9888), 0x0e9f00aa },
	{ _MMIO(0x9888), 0x02b84000 },
	{ _MMIO(0x9888), 0x04b84000 },
	{ _MMIO(0x9888), 0x06b84000 },
	{ _MMIO(0x9888), 0x08b84000 },
	{ _MMIO(0x9888), 0x0ab88000 },
	{ _MMIO(0x9888), 0x0cb88000 },
	{ _MMIO(0x9888), 0x00b98000 },
	{ _MMIO(0x9888), 0x02b9a000 },
	{ _MMIO(0x9888), 0x04b9a000 },
	{ _MMIO(0x9888), 0x06b92000 },
	{ _MMIO(0x9888), 0x0aba8000 },
	{ _MMIO(0x9888), 0x0cba8000 },
	{ _MMIO(0x9888), 0x04938000 },
	{ _MMIO(0x9888), 0x06938000 },
	{ _MMIO(0x9888), 0x0494c000 },
	{ _MMIO(0x9888), 0x0295cfc7 },
	{ _MMIO(0x9888), 0x10950000 },
	{ _MMIO(0x9888), 0x02b38000 },
	{ _MMIO(0x9888), 0x08b38000 },
	{ _MMIO(0x9888), 0x04b42000 },
	{ _MMIO(0x9888), 0x06b41000 },
	{ _MMIO(0x9888), 0x00b5c700 },
	{ _MMIO(0x9888), 0x04b500cf },
	{ _MMIO(0x9888), 0x10b50000 },
	{ _MMIO(0x9888), 0x0ad38000 },
	{ _MMIO(0x9888), 0x0cd38000 },
	{ _MMIO(0x9888), 0x06d46000 },
	{ _MMIO(0x9888), 0x04d5c700 },
	{ _MMIO(0x9888), 0x06d500cf },
	{ _MMIO(0x9888), 0x10d50000 },
	{ _MMIO(0x9888), 0x03888000 },
	{ _MMIO(0x9888), 0x05888000 },
	{ _MMIO(0x9888), 0x07888000 },
	{ _MMIO(0x9888), 0x09888000 },
	{ _MMIO(0x9888), 0x0b888000 },
	{ _MMIO(0x9888), 0x0d880400 },
	{ _MMIO(0x9888), 0x0f8a8000 },
	{ _MMIO(0x9888), 0x198a8000 },
	{ _MMIO(0x9888), 0x1b8aaaa0 },
	{ _MMIO(0x9888), 0x1d8a0002 },
	{ _MMIO(0x9888), 0x258b555a },
	{ _MMIO(0x9888), 0x278b0015 },
	{ _MMIO(0x9888), 0x238b5500 },
	{ _MMIO(0x9888), 0x038c4000 },
	{ _MMIO(0x9888), 0x058c4000 },
	{ _MMIO(0x9888), 0x078c4000 },
	{ _MMIO(0x9888), 0x098c4000 },
	{ _MMIO(0x9888), 0x0b8c4000 },
	{ _MMIO(0x9888), 0x0d8c4000 },
	{ _MMIO(0x9888), 0x018d8000 },
	{ _MMIO(0x9888), 0x038da000 },
	{ _MMIO(0x9888), 0x058da000 },
	{ _MMIO(0x9888), 0x078d2000 },
	{ _MMIO(0x9888), 0x2185aaaa },
	{ _MMIO(0x9888), 0x2385002a },
	{ _MMIO(0x9888), 0x1f85aa00 },
	{ _MMIO(0x9888), 0x0f834000 },
	{ _MMIO(0x9888), 0x19835400 },
	{ _MMIO(0x9888), 0x1b830155 },
	{ _MMIO(0x9888), 0x03834000 },
	{ _MMIO(0x9888), 0x05834000 },
	{ _MMIO(0x9888), 0x07834000 },
	{ _MMIO(0x9888), 0x09834000 },
	{ _MMIO(0x9888), 0x0b834000 },
	{ _MMIO(0x9888), 0x0d834000 },
	{ _MMIO(0x9888), 0x0784c000 },
	{ _MMIO(0x9888), 0x0984c000 },
	{ _MMIO(0x9888), 0x0b84c000 },
	{ _MMIO(0x9888), 0x0d84c000 },
	{ _MMIO(0x9888), 0x0f84c000 },
	{ _MMIO(0x9888), 0x01848000 },
	{ _MMIO(0x9888), 0x0384c000 },
	{ _MMIO(0x9888), 0x0584c000 },
	{ _MMIO(0x9888), 0x1780c000 },
	{ _MMIO(0x9888), 0x1980c000 },
	{ _MMIO(0x9888), 0x1b80c000 },
	{ _MMIO(0x9888), 0x1d80c000 },
	{ _MMIO(0x9888), 0x1f80c000 },
	{ _MMIO(0x9888), 0x11808000 },
	{ _MMIO(0x9888), 0x1380c000 },
	{ _MMIO(0x9888), 0x1580c000 },
	{ _MMIO(0x9888), 0x4f800000 },
	{ _MMIO(0x9888), 0x43800882 },
	{ _MMIO(0x9888), 0x51800000 },
	{ _MMIO(0x9888), 0x45801082 },
	{ _MMIO(0x9888), 0x53800000 },
	{ _MMIO(0x9888), 0x478014a5 },
	{ _MMIO(0x9888), 0x21800000 },
	{ _MMIO(0x9888), 0x31800000 },
	{ _MMIO(0x9888), 0x4d800000 },
	{ _MMIO(0x9888), 0x3f800002 },
	{ _MMIO(0x9888), 0x41800c62 },
};

static int
get_tdl_2_mux_config(struct drm_i915_private *dev_priv,
		     const struct i915_oa_reg **regs,
		     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_tdl_2;
	lens[n] = ARRAY_SIZE(mux_config_tdl_2);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_test_oa[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2770), 0x00000004 },
	{ _MMIO(0x2774), 0x00000000 },
	{ _MMIO(0x2778), 0x00000003 },
	{ _MMIO(0x277c), 0x00000000 },
	{ _MMIO(0x2780), 0x00000007 },
	{ _MMIO(0x2784), 0x00000000 },
	{ _MMIO(0x2788), 0x00100002 },
	{ _MMIO(0x278c), 0x0000fff7 },
	{ _MMIO(0x2790), 0x00100002 },
	{ _MMIO(0x2794), 0x0000ffcf },
	{ _MMIO(0x2798), 0x00100082 },
	{ _MMIO(0x279c), 0x0000ffef },
	{ _MMIO(0x27a0), 0x001000c2 },
	{ _MMIO(0x27a4), 0x0000ffe7 },
	{ _MMIO(0x27a8), 0x00100001 },
	{ _MMIO(0x27ac), 0x0000ffe7 },
};

static const struct i915_oa_reg flex_eu_config_test_oa[] = {
};

static const struct i915_oa_reg mux_config_test_oa[] = {
	{ _MMIO(0x9888), 0x59800000 },
	{ _MMIO(0x9888), 0x59800001 },
	{ _MMIO(0x9888), 0x338b0000 },
	{ _MMIO(0x9888), 0x258b0066 },
	{ _MMIO(0x9888), 0x058b0000 },
	{ _MMIO(0x9888), 0x038b0000 },
	{ _MMIO(0x9888), 0x03844000 },
	{ _MMIO(0x9888), 0x47800080 },
	{ _MMIO(0x9888), 0x57800000 },
	{ _MMIO(0x1823a4), 0x00000000 },
	{ _MMIO(0x9888), 0x59800000 },
};

static int
get_test_oa_mux_config(struct drm_i915_private *dev_priv,
		       const struct i915_oa_reg **regs,
		       int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_test_oa;
	lens[n] = ARRAY_SIZE(mux_config_test_oa);
	n++;

	return n;
}

int i915_oa_select_metric_set_chv(struct drm_i915_private *dev_priv)
{
	dev_priv->perf.oa.n_mux_configs = 0;
	dev_priv->perf.oa.b_counter_regs = NULL;
	dev_priv->perf.oa.b_counter_regs_len = 0;
	dev_priv->perf.oa.flex_regs = NULL;
	dev_priv->perf.oa.flex_regs_len = 0;

	switch (dev_priv->perf.oa.metrics_set) {
	case METRIC_SET_ID_RENDER_BASIC:
		dev_priv->perf.oa.n_mux_configs =
			get_render_basic_mux_config(dev_priv,
						    dev_priv->perf.oa.mux_regs,
						    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RENDER_BASIC\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_render_basic;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_render_basic);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_render_basic;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_render_basic);

		return 0;
	case METRIC_SET_ID_COMPUTE_BASIC:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_basic_mux_config(dev_priv,
						     dev_priv->perf.oa.mux_regs,
						     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_BASIC\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_basic;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_basic);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_basic;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_basic);

		return 0;
	case METRIC_SET_ID_RENDER_PIPE_PROFILE:
		dev_priv->perf.oa.n_mux_configs =
			get_render_pipe_profile_mux_config(dev_priv,
							   dev_priv->perf.oa.mux_regs,
							   dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RENDER_PIPE_PROFILE\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_render_pipe_profile;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_render_pipe_profile);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_render_pipe_profile;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_render_pipe_profile);

		return 0;
	case METRIC_SET_ID_HDC_AND_SF:
		dev_priv->perf.oa.n_mux_configs =
			get_hdc_and_sf_mux_config(dev_priv,
						  dev_priv->perf.oa.mux_regs,
						  dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"HDC_AND_SF\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_hdc_and_sf;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_hdc_and_sf);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_hdc_and_sf;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_hdc_and_sf);

		return 0;
	case METRIC_SET_ID_L3_1:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_1_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_1\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_1;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_1);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_1;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_1);

		return 0;
	case METRIC_SET_ID_L3_2:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_2_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_2\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_2;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_2);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_2;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_2);

		return 0;
	case METRIC_SET_ID_L3_3:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_3_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_3\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_3;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_3);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_3;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_3);

		return 0;
	case METRIC_SET_ID_L3_4:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_4_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_4\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_4;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_4);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_4;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_4);

		return 0;
	case METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND:
		dev_priv->perf.oa.n_mux_configs =
			get_rasterizer_and_pixel_backend_mux_config(dev_priv,
								    dev_priv->perf.oa.mux_regs,
								    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RASTERIZER_AND_PIXEL_BACKEND\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_rasterizer_and_pixel_backend;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_rasterizer_and_pixel_backend);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_rasterizer_and_pixel_backend;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_rasterizer_and_pixel_backend);

		return 0;
	case METRIC_SET_ID_SAMPLER_1:
		dev_priv->perf.oa.n_mux_configs =
			get_sampler_1_mux_config(dev_priv,
						 dev_priv->perf.oa.mux_regs,
						 dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"SAMPLER_1\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_sampler_1;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_sampler_1);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_sampler_1;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_sampler_1);

		return 0;
	case METRIC_SET_ID_SAMPLER_2:
		dev_priv->perf.oa.n_mux_configs =
			get_sampler_2_mux_config(dev_priv,
						 dev_priv->perf.oa.mux_regs,
						 dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"SAMPLER_2\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_sampler_2;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_sampler_2);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_sampler_2;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_sampler_2);

		return 0;
	case METRIC_SET_ID_TDL_1:
		dev_priv->perf.oa.n_mux_configs =
			get_tdl_1_mux_config(dev_priv,
					     dev_priv->perf.oa.mux_regs,
					     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TDL_1\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_tdl_1;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_tdl_1);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_tdl_1;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_tdl_1);

		return 0;
	case METRIC_SET_ID_TDL_2:
		dev_priv->perf.oa.n_mux_configs =
			get_tdl_2_mux_config(dev_priv,
					     dev_priv->perf.oa.mux_regs,
					     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TDL_2\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_tdl_2;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_tdl_2);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_tdl_2;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_tdl_2);

		return 0;
	case METRIC_SET_ID_TEST_OA:
		dev_priv->perf.oa.n_mux_configs =
			get_test_oa_mux_config(dev_priv,
					       dev_priv->perf.oa.mux_regs,
					       dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TEST_OA\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_test_oa;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_test_oa);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_test_oa;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_test_oa);

		return 0;
	default:
		return -ENODEV;
	}
}

static ssize_t
show_render_basic_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RENDER_BASIC);
}

static struct device_attribute dev_attr_render_basic_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_render_basic_id,
	.store = NULL,
};

static struct attribute *attrs_render_basic[] = {
	&dev_attr_render_basic_id.attr,
	NULL,
};

static struct attribute_group group_render_basic = {
	.name = "9d8a3af5-c02c-4a4a-b947-f1672469e0fb",
	.attrs =  attrs_render_basic,
};

static ssize_t
show_compute_basic_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_BASIC);
}

static struct device_attribute dev_attr_compute_basic_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_basic_id,
	.store = NULL,
};

static struct attribute *attrs_compute_basic[] = {
	&dev_attr_compute_basic_id.attr,
	NULL,
};

static struct attribute_group group_compute_basic = {
	.name = "f522a89c-ecd1-4522-8331-3383c54af5f5",
	.attrs =  attrs_compute_basic,
};

static ssize_t
show_render_pipe_profile_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RENDER_PIPE_PROFILE);
}

static struct device_attribute dev_attr_render_pipe_profile_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_render_pipe_profile_id,
	.store = NULL,
};

static struct attribute *attrs_render_pipe_profile[] = {
	&dev_attr_render_pipe_profile_id.attr,
	NULL,
};

static struct attribute_group group_render_pipe_profile = {
	.name = "a9ccc03d-a943-4e6b-9cd6-13e063075927",
	.attrs =  attrs_render_pipe_profile,
};

static ssize_t
show_hdc_and_sf_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_HDC_AND_SF);
}

static struct device_attribute dev_attr_hdc_and_sf_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_hdc_and_sf_id,
	.store = NULL,
};

static struct attribute *attrs_hdc_and_sf[] = {
	&dev_attr_hdc_and_sf_id.attr,
	NULL,
};

static struct attribute_group group_hdc_and_sf = {
	.name = "2cf0c064-68df-4fac-9b3f-57f51ca8a069",
	.attrs =  attrs_hdc_and_sf,
};

static ssize_t
show_l3_1_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_1);
}

static struct device_attribute dev_attr_l3_1_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_1_id,
	.store = NULL,
};

static struct attribute *attrs_l3_1[] = {
	&dev_attr_l3_1_id.attr,
	NULL,
};

static struct attribute_group group_l3_1 = {
	.name = "78a87ff9-543a-49ce-95ea-26d86071ea93",
	.attrs =  attrs_l3_1,
};

static ssize_t
show_l3_2_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_2);
}

static struct device_attribute dev_attr_l3_2_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_2_id,
	.store = NULL,
};

static struct attribute *attrs_l3_2[] = {
	&dev_attr_l3_2_id.attr,
	NULL,
};

static struct attribute_group group_l3_2 = {
	.name = "9f2cece5-7bfe-4320-ad66-8c7cc526bec5",
	.attrs =  attrs_l3_2,
};

static ssize_t
show_l3_3_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_3);
}

static struct device_attribute dev_attr_l3_3_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_3_id,
	.store = NULL,
};

static struct attribute *attrs_l3_3[] = {
	&dev_attr_l3_3_id.attr,
	NULL,
};

static struct attribute_group group_l3_3 = {
	.name = "d890ef38-d309-47e4-b8b5-aa779bb19ab0",
	.attrs =  attrs_l3_3,
};

static ssize_t
show_l3_4_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_4);
}

static struct device_attribute dev_attr_l3_4_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_4_id,
	.store = NULL,
};

static struct attribute *attrs_l3_4[] = {
	&dev_attr_l3_4_id.attr,
	NULL,
};

static struct attribute_group group_l3_4 = {
	.name = "5fdff4a6-9dc8-45e1-bfda-ef54869fbdd4",
	.attrs =  attrs_l3_4,
};

static ssize_t
show_rasterizer_and_pixel_backend_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND);
}

static struct device_attribute dev_attr_rasterizer_and_pixel_backend_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_rasterizer_and_pixel_backend_id,
	.store = NULL,
};

static struct attribute *attrs_rasterizer_and_pixel_backend[] = {
	&dev_attr_rasterizer_and_pixel_backend_id.attr,
	NULL,
};

static struct attribute_group group_rasterizer_and_pixel_backend = {
	.name = "2c0e45e1-7e2c-4a14-ae00-0b7ec868b8aa",
	.attrs =  attrs_rasterizer_and_pixel_backend,
};

static ssize_t
show_sampler_1_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_SAMPLER_1);
}

static struct device_attribute dev_attr_sampler_1_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_sampler_1_id,
	.store = NULL,
};

static struct attribute *attrs_sampler_1[] = {
	&dev_attr_sampler_1_id.attr,
	NULL,
};

static struct attribute_group group_sampler_1 = {
	.name = "71148d78-baf5-474f-878a-e23158d0265d",
	.attrs =  attrs_sampler_1,
};

static ssize_t
show_sampler_2_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_SAMPLER_2);
}

static struct device_attribute dev_attr_sampler_2_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_sampler_2_id,
	.store = NULL,
};

static struct attribute *attrs_sampler_2[] = {
	&dev_attr_sampler_2_id.attr,
	NULL,
};

static struct attribute_group group_sampler_2 = {
	.name = "b996a2b7-c59c-492d-877a-8cd54fd6df84",
	.attrs =  attrs_sampler_2,
};

static ssize_t
show_tdl_1_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TDL_1);
}

static struct device_attribute dev_attr_tdl_1_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_tdl_1_id,
	.store = NULL,
};

static struct attribute *attrs_tdl_1[] = {
	&dev_attr_tdl_1_id.attr,
	NULL,
};

static struct attribute_group group_tdl_1 = {
	.name = "eb2fecba-b431-42e7-8261-fe9429a6e67a",
	.attrs =  attrs_tdl_1,
};

static ssize_t
show_tdl_2_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TDL_2);
}

static struct device_attribute dev_attr_tdl_2_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_tdl_2_id,
	.store = NULL,
};

static struct attribute *attrs_tdl_2[] = {
	&dev_attr_tdl_2_id.attr,
	NULL,
};

static struct attribute_group group_tdl_2 = {
	.name = "60749470-a648-4a4b-9f10-dbfe1e36e44d",
	.attrs =  attrs_tdl_2,
};

static ssize_t
show_test_oa_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TEST_OA);
}

static struct device_attribute dev_attr_test_oa_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_test_oa_id,
	.store = NULL,
};

static struct attribute *attrs_test_oa[] = {
	&dev_attr_test_oa_id.attr,
	NULL,
};

static struct attribute_group group_test_oa = {
	.name = "4a534b07-cba3-414d-8d60-874830e883aa",
	.attrs =  attrs_test_oa,
};

int
i915_perf_register_sysfs_chv(struct drm_i915_private *dev_priv)
{
	const struct i915_oa_reg *mux_regs[ARRAY_SIZE(dev_priv->perf.oa.mux_regs)];
	int mux_lens[ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens)];
	int ret = 0;

	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_render_basic);
		if (ret)
			goto error_render_basic;
	}
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
		if (ret)
			goto error_compute_basic;
	}
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
		if (ret)
			goto error_render_pipe_profile;
	}
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
		if (ret)
			goto error_hdc_and_sf;
	}
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_1);
		if (ret)
			goto error_l3_1;
	}
	if (get_l3_2_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_2);
		if (ret)
			goto error_l3_2;
	}
	if (get_l3_3_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_3);
		if (ret)
			goto error_l3_3;
	}
	if (get_l3_4_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_4);
		if (ret)
			goto error_l3_4;
	}
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
		if (ret)
			goto error_rasterizer_and_pixel_backend;
	}
	if (get_sampler_1_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_sampler_1);
		if (ret)
			goto error_sampler_1;
	}
	if (get_sampler_2_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_sampler_2);
		if (ret)
			goto error_sampler_2;
	}
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
		if (ret)
			goto error_tdl_1;
	}
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
		if (ret)
			goto error_tdl_2;
	}
	if (get_test_oa_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_test_oa);
		if (ret)
			goto error_test_oa;
	}

	return 0;

error_test_oa:
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
error_tdl_2:
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
error_tdl_1:
	if (get_sampler_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler_2);
error_sampler_2:
	if (get_sampler_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler_1);
error_sampler_1:
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
error_rasterizer_and_pixel_backend:
	if (get_l3_4_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_4);
error_l3_4:
	if (get_l3_3_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_3);
error_l3_3:
	if (get_l3_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_2);
error_l3_2:
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_1);
error_l3_1:
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
error_hdc_and_sf:
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
error_render_pipe_profile:
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
error_compute_basic:
	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_basic);
error_render_basic:
	return ret;
}

void
i915_perf_unregister_sysfs_chv(struct drm_i915_private *dev_priv)
{
	const struct i915_oa_reg *mux_regs[ARRAY_SIZE(dev_priv->perf.oa.mux_regs)];
	int mux_lens[ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens)];

	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_basic);
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_1);
	if (get_l3_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_2);
	if (get_l3_3_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_3);
	if (get_l3_4_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_4);
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
	if (get_sampler_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler_1);
	if (get_sampler_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler_2);
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
	if (get_test_oa_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_test_oa);
}
