/*
    Conexant cx24117/cx24132 - Dual DVBS/S2 Satellite demod/tuner driver

    Copyright (C) 2013 Luis Alves <ljalvs@gmail.com>
	(based on cx24116.h by Steven Toth)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CX24117_H
#define CX24117_H

#include <linux/kconfig.h>
#include <linux/dvb/frontend.h>

struct cx24117_config {
	/* the demodulator's i2c address */
	u8 demod_address;
};

#if IS_ENABLED(CONFIG_DVB_CX24117)
extern struct dvb_frontend *cx24117_attach(
	const struct cx24117_config *config,
	struct i2c_adapter *i2c);
#else
static inline struct dvb_frontend *cx24117_attach(
	const struct cx24117_config *config,
	struct i2c_adapter *i2c)
{
	dev_warn(&i2c->dev, "%s: driver disabled by Kconfig\n", __func__);
	return NULL;
}
#endif

#endif /* CX24117_H */
